/*
 * Decompiled with CFR 0.152.
 */
package java.awt.print;

import java.awt.AWTError;
import java.awt.HeadlessException;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;

public abstract class PrinterJob {
    public static PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return (PrinterJob)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("java.awt.printerjob", null);
                try {
                    return (PrinterJob)Class.forName(string).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AWTError("PrinterJob not found: " + string);
                }
                catch (InstantiationException instantiationException) {
                    throw new AWTError("Could not instantiate PrinterJob: " + string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AWTError("Could not access PrinterJob: " + string);
                }
            }
        });
    }

    public static PrintService[] lookupPrintServices() {
        return PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
    }

    public static StreamPrintServiceFactory[] lookupStreamPrintServices(String string) {
        return StreamPrintServiceFactory.lookupStreamPrintServiceFactories(DocFlavor.SERVICE_FORMATTED.PAGEABLE, string);
    }

    public PrintService getPrintService() {
        return null;
    }

    public void setPrintService(PrintService printService) throws PrinterException {
        throw new PrinterException("Setting a service is not supported on this class");
    }

    public abstract void setPrintable(Printable var1);

    public abstract void setPrintable(Printable var1, PageFormat var2);

    public abstract void setPageable(Pageable var1) throws NullPointerException;

    public abstract boolean printDialog() throws HeadlessException;

    public boolean printDialog(PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        if (printRequestAttributeSet == null) {
            throw new NullPointerException("attributes");
        }
        return this.printDialog();
    }

    public abstract PageFormat pageDialog(PageFormat var1) throws HeadlessException;

    public PageFormat pageDialog(PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        if (printRequestAttributeSet == null) {
            throw new NullPointerException("attributes");
        }
        return this.pageDialog(this.defaultPage());
    }

    public abstract PageFormat defaultPage(PageFormat var1);

    public PageFormat defaultPage() {
        return this.defaultPage(new PageFormat());
    }

    public PageFormat getPageFormat(PrintRequestAttributeSet printRequestAttributeSet) {
        MediaSize mediaSize;
        Object object;
        PrintService printService = this.getPrintService();
        PageFormat pageFormat = this.defaultPage();
        if (printService == null || printRequestAttributeSet == null) {
            return pageFormat;
        }
        Media media = (Media)printRequestAttributeSet.get(Media.class);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
        OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
        if (media == null && mediaPrintableArea == null && orientationRequested == null) {
            return pageFormat;
        }
        Paper paper = pageFormat.getPaper();
        if (mediaPrintableArea == null && media != null && printService.isAttributeCategorySupported(MediaPrintableArea.class) && (object = printService.getSupportedAttributeValues(MediaPrintableArea.class, null, printRequestAttributeSet)) instanceof MediaPrintableArea[] && ((MediaPrintableArea[])object).length > 0) {
            mediaPrintableArea = ((MediaPrintableArea[])object)[0];
        }
        if (media != null && printService.isAttributeValueSupported(media, null, printRequestAttributeSet) && media instanceof MediaSizeName && (mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)(object = (MediaSizeName)media))) != null) {
            double d = 72.0;
            double d2 = (double)mediaSize.getX(25400) * d;
            double d3 = (double)mediaSize.getY(25400) * d;
            paper.setSize(d2, d3);
            if (mediaPrintableArea == null) {
                paper.setImageableArea(d, d, d2 - 2.0 * d, d3 - 2.0 * d);
            }
        }
        if (mediaPrintableArea != null && printService.isAttributeValueSupported(mediaPrintableArea, null, printRequestAttributeSet)) {
            object = mediaPrintableArea.getPrintableArea(25400);
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = object[i] * 72.0f;
            }
            paper.setImageableArea((double)object[0], (double)object[1], (double)object[2], (double)object[3]);
        }
        if (orientationRequested != null && printService.isAttributeValueSupported(orientationRequested, null, printRequestAttributeSet)) {
            int n = orientationRequested.equals(OrientationRequested.REVERSE_LANDSCAPE) ? 2 : (orientationRequested.equals(OrientationRequested.LANDSCAPE) ? 0 : 1);
            pageFormat.setOrientation(n);
        }
        pageFormat.setPaper(paper);
        pageFormat = this.validatePage(pageFormat);
        return pageFormat;
    }

    public abstract PageFormat validatePage(PageFormat var1);

    public abstract void print() throws PrinterException;

    public void print(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        this.print();
    }

    public abstract void setCopies(int var1);

    public abstract int getCopies();

    public abstract String getUserName();

    public abstract void setJobName(String var1);

    public abstract String getJobName();

    public abstract void cancel();

    public abstract boolean isCancelled();
}

