/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.wisp.engine;

import com.alibaba.rcm.ResourceContainer;
import com.alibaba.rcm.internal.AbstractResourceContainer;
import com.alibaba.wisp.engine.StealAwareRunnable;
import com.alibaba.wisp.engine.ThreadAsWisp;
import com.alibaba.wisp.engine.TimeOut;
import com.alibaba.wisp.engine.WispCarrier;
import com.alibaba.wisp.engine.WispConfiguration;
import com.alibaba.wisp.engine.WispControlGroup;
import com.alibaba.wisp.engine.WispEngine;
import com.alibaba.wisp.engine.WispThreadWrapper;
import java.dyn.Coroutine;
import java.dyn.CoroutineExitException;
import java.nio.channels.SelectableChannel;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.SharedSecrets;
import sun.misc.UnsafeAccess;

public class WispTask
implements Comparable<WispTask> {
    private static final AtomicInteger idGenerator = new AtomicInteger();
    static final Map<Integer, WispTask> id2Task = new ConcurrentHashMap<Integer, WispTask>(360);
    private final int id;
    private Runnable runnable;
    volatile WispCarrier carrier;
    private String name;
    final Coroutine ctx;
    boolean shutdownPending;
    SelectableChannel ch;
    TimeOut timeOut;
    ClassLoader ctxClassLoader;
    private final boolean isThreadTask;
    private boolean isThreadAsWisp;
    private Thread threadWrapper;
    private volatile int interrupted;
    private volatile int alreadyCheckNativeInterrupt;
    private volatile int jdkParkStatus;
    private volatile int jvmParkStatus;
    volatile int stealLock;
    private WispTask from;
    final StealAwareRunnable resumeEntry;
    private int activeCount;
    int stealCount;
    int stealFailureCount;
    private int preemptCount;
    long ttr;
    private long enqueueTime;
    private long parkTime;
    private long blockingTime;
    private long registerEventTime;
    long enterTs;
    long totalTs;
    private volatile long epollArray;
    private volatile int epollEventNum;
    int epollArraySize;
    WispControlGroup controlGroup;
    final long stackSize;
    private static final int WAITING = -1;
    private static final int FREE = 0;
    private static final int PERMITTED = 1;
    static final String SHUTDOWN_TASK_NAME = "SHUTDOWN_TASK";
    private static final AtomicReferenceFieldUpdater<WispTask, WispCarrier> CARRIER_UPDATER;
    private static final AtomicIntegerFieldUpdater<WispTask> JVM_PARK_UPDATER;
    private static final AtomicIntegerFieldUpdater<WispTask> JDK_PARK_UPDATER;
    private static final AtomicIntegerFieldUpdater<WispTask> INTERRUPTED_UPDATER;
    private static final AtomicIntegerFieldUpdater<WispTask> NATIVE_INTERRUPTED_UPDATER;
    private static final AtomicIntegerFieldUpdater<WispTask> STEAL_LOCK_UPDATER;
    private static final AtomicLongFieldUpdater<WispTask> EPOLL_ARRAY_UPDATER;
    private static final AtomicIntegerFieldUpdater<WispTask> EPOLL_EVENT_NUM_UPDATER;
    private static final UnsafeAccess UA;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WispTask fromId(int n) {
        WispCarrier wispCarrier = WispCarrier.current();
        boolean bl = wispCarrier.isInCritical;
        wispCarrier.isInCritical = true;
        try {
            WispTask wispTask = id2Task.get(n);
            return wispTask;
        }
        finally {
            wispCarrier.isInCritical = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanExitedTasks(List<WispTask> list) {
        if (!list.isEmpty()) {
            WispCarrier wispCarrier = list.get((int)0).carrier;
            boolean bl = wispCarrier.isInCritical;
            wispCarrier.isInCritical = true;
            try {
                for (WispTask wispTask : list) {
                    id2Task.remove(wispTask.id);
                    wispTask.cleanup();
                }
            }
            finally {
                wispCarrier.isInCritical = bl;
            }
        }
    }

    static void cleanExitedTask(WispTask wispTask) {
        WispCarrier wispCarrier = WispCarrier.current();
        boolean bl = wispCarrier.isInCritical;
        wispCarrier.isInCritical = true;
        try {
            id2Task.remove(wispTask.id);
        }
        finally {
            wispCarrier.isInCritical = bl;
        }
    }

    static void trackTask(WispTask wispTask) {
        WispCarrier wispCarrier = WispCarrier.current();
        boolean bl = wispCarrier.isInCritical;
        wispCarrier.isInCritical = true;
        try {
            id2Task.put(wispTask.id, wispTask);
        }
        finally {
            wispCarrier.isInCritical = bl;
        }
    }

    WispTask(WispCarrier wispCarrier, Coroutine coroutine, boolean bl, boolean bl2) {
        this(wispCarrier, coroutine, bl, bl2, WispConfiguration.STACK_SIZE);
    }

    WispTask(WispCarrier wispCarrier, Coroutine coroutine, boolean bl, boolean bl2, long l) {
        this.isThreadTask = bl2;
        this.id = bl ? idGenerator.addAndGet(1) : -1;
        this.stackSize = l;
        this.setCarrier(wispCarrier);
        if (bl) {
            this.ctx = coroutine != null ? coroutine : new CacheableCoroutine(this.stackSize);
            this.ctx.setWispTask(this.id, this, wispCarrier);
        } else {
            this.ctx = null;
        }
        this.resumeEntry = bl2 ? null : wispCarrier.createResumeEntry(this);
    }

    void reset(Runnable runnable, String string, Thread thread, ClassLoader classLoader) {
        assert (this.ctx != null);
        assert (!this.shutdownPending);
        this.runnable = runnable;
        this.name = string;
        this.controlGroup = null;
        this.interrupted = 0;
        this.ctxClassLoader = classLoader;
        this.ch = null;
        this.enqueueTime = 0L;
        this.parkTime = 0L;
        this.blockingTime = 0L;
        this.registerEventTime = 0L;
        this.activeCount = 0;
        this.stealCount = 0;
        this.stealFailureCount = 0;
        this.preemptCount = 0;
        this.totalTs = 0L;
        this.enterTs = 0L;
        if (thread != null) {
            NATIVE_INTERRUPTED_UPDATER.lazySet(this, 1);
            this.isThreadAsWisp = true;
            WispEngine.JLA.setWispTask(thread, this);
            this.threadWrapper = thread;
        } else {
            NATIVE_INTERRUPTED_UPDATER.lazySet(this, 0);
            this.isThreadAsWisp = false;
            if (this.threadWrapper == null) {
                this.threadWrapper = new WispThreadWrapper(this);
            }
            WispEngine.JLA.setWispAlive(this.threadWrapper, true);
        }
        assert (WispEngine.JLA.getWispTask(this.threadWrapper) == this);
        if (!this.isThreadTask() && string != null && !this.threadWrapper.getName().equals(string)) {
            this.threadWrapper.setName(string);
        }
    }

    void setCarrier(WispCarrier wispCarrier) {
        CARRIER_UPDATER.lazySet(this, wispCarrier);
    }

    private void cleanup() {
        this.setCarrier(null);
        this.threadWrapper = null;
        this.ctxClassLoader = null;
    }

    private void runCommand() {
        AbstractResourceContainer abstractResourceContainer = WispEngine.JLA.getInheritedResourceContainer(this.threadWrapper);
        if (abstractResourceContainer != ResourceContainer.root()) {
            abstractResourceContainer.run(WispTask.wrapRunOutsideWisp(this.runnable));
        } else {
            WispTask.runOutsideWisp(this.runnable);
        }
    }

    private void dispatchUncaughtException(Throwable throwable) {
        try {
            this.threadWrapper.getUncaughtExceptionHandler().uncaughtException(this.threadWrapper, throwable);
        }
        catch (Throwable throwable2) {
            String string = String.format("\nException: %s thrown from the UncaughtExceptionHandler in thread \"%s\"", throwable2.getClass().getName(), this.threadWrapper.getName());
            System.err.println(string);
        }
    }

    static void runOutsideWisp(Runnable runnable) {
        runnable.run();
    }

    static Runnable wrapRunOutsideWisp(Runnable runnable) {
        return () -> WispTask.runOutsideWisp(runnable);
    }

    static boolean switchTo(WispTask wispTask, WispTask wispTask2, boolean bl) {
        assert (wispTask2.ctx != null);
        assert (WispCarrier.current() == wispTask.carrier);
        assert (wispTask.carrier == wispTask2.carrier);
        ++wispTask2.activeCount;
        assert (wispTask.isThreadTask() || wispTask2.isThreadTask());
        wispTask2.from = wispTask;
        STEAL_LOCK_UPDATER.lazySet(wispTask2, 1);
        assert (wispTask.carrier.thread == WispEngine.JLA.currentThread0());
        boolean bl2 = false;
        if (bl) {
            WispEngine.JLA.getCoroutineSupport(wispTask.carrier.thread).terminateCoroutine(wispTask2.ctx);
            assert (false) : "should not reach here";
        } else {
            bl2 = WispEngine.JLA.getCoroutineSupport(wispTask.carrier.thread).unsafeSymmetricYieldTo(wispTask2.ctx);
        }
        assert (wispTask.stealLock != 0);
        STEAL_LOCK_UPDATER.lazySet(wispTask.from, 0);
        assert (WispCarrier.current() == wispTask.carrier);
        assert (wispTask.carrier.current == wispTask);
        return bl2;
    }

    boolean isThreadTask() {
        return this.isThreadTask;
    }

    static void sleep(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l == 0L) {
            WispCarrier.current().yield();
        } else {
            WispCarrier.current().unregisterEvent();
            WispTask.jdkPark(TimeUnit.MILLISECONDS.toNanos(l));
        }
    }

    public String toString() {
        return "WispTask" + this.id + "(name=" + this.name + ')' + "{status=" + (this.isAlive() ? "ALIVE" : "CACHED") + "/" + this.jdkParkStatus + '}';
    }

    public String getName() {
        return this.name;
    }

    boolean isAlive() {
        return this.isThreadTask || this.runnable != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parkInternal(long l, boolean bl) {
        if (l > 0L && l < (long)WispConfiguration.MIN_PARK_NANOS) {
            this.carrier.yield();
            return;
        }
        AtomicIntegerFieldUpdater<WispTask> atomicIntegerFieldUpdater = bl ? JVM_PARK_UPDATER : JDK_PARK_UPDATER;
        boolean bl2 = this.carrier.isInCritical;
        this.carrier.isInCritical = true;
        try {
            int n;
            this.carrier.getCounter().incrementParkCount();
            do {
                n = atomicIntegerFieldUpdater.get(this);
                assert (n != -1);
                if (n != 0 || !atomicIntegerFieldUpdater.compareAndSet(this, 0, -1)) continue;
                if (WispEngine.runningAsCoroutine(this.threadWrapper) && l > 0L) {
                    this.carrier.addTimer(l + System.nanoTime(), bl ? TimeOut.Action.JVM_UNPARK : TimeOut.Action.JDK_UNPARK);
                }
                this.carrier.isInCritical = bl2;
                try {
                    if (WispEngine.runningAsCoroutine(this.threadWrapper)) {
                        this.setParkTime();
                        this.carrier.schedule(false);
                    } else {
                        UA.park0(false, l < 0L ? 0L : l);
                        atomicIntegerFieldUpdater.set(this, 0);
                    }
                    break;
                }
                finally {
                    this.carrier.isInCritical = true;
                    if (l > 0L) {
                        this.carrier.cancelTimer();
                    }
                }
            } while (n != 1 || !atomicIntegerFieldUpdater.compareAndSet(this, 1, 0));
        }
        finally {
            this.carrier.isInCritical = bl2;
        }
    }

    private void unparkInternal(boolean bl) {
        int n;
        AtomicIntegerFieldUpdater<WispTask> atomicIntegerFieldUpdater;
        AtomicIntegerFieldUpdater<WispTask> atomicIntegerFieldUpdater2 = atomicIntegerFieldUpdater = bl ? JVM_PARK_UPDATER : JDK_PARK_UPDATER;
        do {
            if ((n = atomicIntegerFieldUpdater.get(this)) != -1 || !atomicIntegerFieldUpdater.compareAndSet(this, -1, 0)) continue;
            if (WispEngine.runningAsCoroutine(this.threadWrapper)) {
                this.recordOnUnpark(bl);
                this.carrier.wakeupTask(this);
            } else {
                UA.unpark0(this.threadWrapper);
            }
            break;
        } while (n != 1 && (n != 0 || !atomicIntegerFieldUpdater.compareAndSet(this, 0, 1)));
    }

    static void jdkPark(long l) {
        WispCarrier.current().getCurrentTask().parkInternal(l, false);
    }

    void jdkUnpark() {
        this.unparkInternal(false);
    }

    private static void park(long l) {
        WispCarrier.current().getCurrentTask().parkInternal(l, true);
    }

    void unpark() {
        this.unparkInternal(true);
    }

    static void unparkById(int n) {
        WispTask wispTask = WispTask.fromId(n);
        if (wispTask != null) {
            wispTask.unpark();
        }
    }

    void interrupt() {
        this.interrupted = 1;
        this.unpark();
        this.jdkUnpark();
    }

    private static void interruptById(int n) {
        WispTask wispTask = WispTask.fromId(n);
        if (wispTask != null) {
            wispTask.interrupt();
        }
    }

    boolean isInterrupted() {
        return this.interrupted != 0;
    }

    boolean inDestoryedGroup() {
        return this.controlGroup != null && this.controlGroup.destroyed != false;
    }

    boolean inheritedFromNonRootContainer() {
        return WispEngine.JLA.getInheritedResourceContainer(this.threadWrapper) != ResourceContainer.root();
    }

    boolean testInterruptedAndClear(boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        if (this.alreadyCheckNativeInterrupt == 0 && NATIVE_INTERRUPTED_UPDATER.compareAndSet(this, 0, 1) && !this.isInterrupted()) {
            bl3 = WispTask.checkAndClearNativeInterruptForWisp(this.threadWrapper);
        }
        boolean bl4 = bl2 = this.interrupted != 0 || bl3;
        if (bl2 && bl) {
            INTERRUPTED_UPDATER.lazySet(this, 0);
        }
        return bl2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WispTask wispTask = (WispTask)object;
        return Objects.equals(this.id, wispTask.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Thread getThreadWrapper() {
        return this.threadWrapper;
    }

    void setThreadWrapper(Thread thread) {
        this.threadWrapper = thread;
        WispEngine.JLA.setWispTask(thread, this);
    }

    void resetThreadWrapper() {
        if (this.isThreadAsWisp) {
            this.threadWrapper = null;
        }
    }

    @Override
    public int compareTo(WispTask wispTask) {
        return Integer.compare(this.id, wispTask.id);
    }

    long getEpollArray() {
        return this.epollArray;
    }

    void setEpollArray(long l) {
        EPOLL_ARRAY_UPDATER.lazySet(this, l);
    }

    int getEpollEventNum() {
        return this.epollEventNum;
    }

    void setEpollEventNum(int n) {
        EPOLL_EVENT_NUM_UPDATER.lazySet(this, n);
    }

    void updateEnqueueTime() {
        if (!WispConfiguration.WISP_PROFILE) {
            return;
        }
        if (this.enqueueTime != 0L) {
            return;
        }
        this.enqueueTime = System.nanoTime();
    }

    long getEnqueueTime() {
        return this.enqueueTime;
    }

    void resetEnqueueTime() {
        this.enqueueTime = 0L;
    }

    void setRegisterEventTime() {
        this.registerEventTime = !WispConfiguration.WISP_PROFILE || this.isThreadTask ? 0L : System.nanoTime();
    }

    void resetRegisterEventTime() {
        this.registerEventTime = 0L;
    }

    void countWaitSocketIOTime() {
        if (this.registerEventTime != 0L) {
            this.carrier.counter.incrementTotalWaitSocketIOTime(System.nanoTime() - this.registerEventTime);
            this.registerEventTime = 0L;
        }
    }

    private void setParkTime() {
        this.parkTime = !WispConfiguration.WISP_PROFILE || this.isThreadTask ? 0L : System.nanoTime();
    }

    private void recordOnUnpark(boolean bl) {
        if (!WispConfiguration.WISP_PROFILE) {
            return;
        }
        if (this.parkTime != 0L) {
            this.blockingTime = System.nanoTime() - this.parkTime;
            if (this.blockingTime < 0L) {
                this.blockingTime = 0L;
            }
            this.parkTime = 0L;
        }
        if (bl) {
            this.carrier.counter.incrementUnparkFromJvmCount();
        }
    }

    void countExecutionTime(long l) {
        if (!WispConfiguration.WISP_PROFILE || l == 0L) {
            return;
        }
        this.carrier.counter.incrementTotalExecutionTime(System.nanoTime() - l);
        if (this.blockingTime != 0L) {
            this.carrier.counter.incrementTotalBlockingTime(this.blockingTime);
            this.blockingTime = 0L;
        }
    }

    StackTraceElement[] getStackTrace() {
        return this.ctx.getCoroutineStack();
    }

    long getCpuTime() {
        long l = this.enterTs;
        return this.totalTs + (l == 0L ? 0L : System.nanoTime() - l);
    }

    private static native void registerNatives();

    private static native boolean checkAndClearNativeInterruptForWisp(Thread var0);

    static {
        UA = SharedSecrets.getUnsafeAccess();
        CARRIER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(WispTask.class, WispCarrier.class, "carrier");
        JVM_PARK_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WispTask.class, "jvmParkStatus");
        JDK_PARK_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WispTask.class, "jdkParkStatus");
        INTERRUPTED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WispTask.class, "interrupted");
        NATIVE_INTERRUPTED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WispTask.class, "alreadyCheckNativeInterrupt");
        STEAL_LOCK_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WispTask.class, "stealLock");
        EPOLL_ARRAY_UPDATER = AtomicLongFieldUpdater.newUpdater(WispTask.class, "epollArray");
        EPOLL_EVENT_NUM_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WispTask.class, "epollEventNum");
        WispTask.registerNatives();
    }

    class CacheableCoroutine
    extends Coroutine {
        CacheableCoroutine(long l) {
            super(l);
        }

        @Override
        protected void run() {
            while (true) {
                assert (WispCarrier.current() == WispTask.this.carrier);
                assert (WispTask.this.carrier.current == WispTask.this);
                if (WispTask.this.runnable != null) {
                    Throwable throwable = null;
                    try {
                        WispTask.this.runCommand();
                    }
                    catch (Throwable throwable2) {
                        WispTask.this.dispatchUncaughtException(throwable2);
                        throwable = throwable2;
                    }
                    finally {
                        assert (WispTask.this.timeOut == null);
                        assert (WispTask.this.controlGroup == null);
                        WispEngine.JLA.setWispAlive(WispTask.this.threadWrapper, false);
                        if (WispTask.this.isThreadAsWisp) {
                            ThreadAsWisp.exit(WispTask.this.threadWrapper);
                        }
                        WispTask.this.runnable = null;
                        if (throwable instanceof CoroutineExitException) {
                            throw (CoroutineExitException)throwable;
                        }
                        WispTask.this.carrier.taskExit();
                    }
                    continue;
                }
                WispTask.this.carrier.schedule(false);
            }
        }
    }
}

