/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the DebAptPublication type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DebAptPublication{}

// DebAptPublication A Serializer for AptPublication.
type DebAptPublication struct {
	RepositoryVersion *string `json:"repository_version,omitempty"`
	// A URI of the repository to be published.
	Repository *string `json:"repository,omitempty"`
	// Activate simple publishing mode (all packages in one release component).
	Simple *bool `json:"simple,omitempty"`
	// Activate structured publishing mode.
	Structured *bool `json:"structured,omitempty"`
	// Sign Release files with this signing key
	SigningService *string `json:"signing_service,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _DebAptPublication DebAptPublication

// NewDebAptPublication instantiates a new DebAptPublication object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDebAptPublication() *DebAptPublication {
	this := DebAptPublication{}
	var simple bool = false
	this.Simple = &simple
	var structured bool = false
	this.Structured = &structured
	return &this
}

// NewDebAptPublicationWithDefaults instantiates a new DebAptPublication object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDebAptPublicationWithDefaults() *DebAptPublication {
	this := DebAptPublication{}
	var simple bool = false
	this.Simple = &simple
	var structured bool = false
	this.Structured = &structured
	return &this
}

// GetRepositoryVersion returns the RepositoryVersion field value if set, zero value otherwise.
func (o *DebAptPublication) GetRepositoryVersion() string {
	if o == nil || IsNil(o.RepositoryVersion) {
		var ret string
		return ret
	}
	return *o.RepositoryVersion
}

// GetRepositoryVersionOk returns a tuple with the RepositoryVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptPublication) GetRepositoryVersionOk() (*string, bool) {
	if o == nil || IsNil(o.RepositoryVersion) {
		return nil, false
	}
	return o.RepositoryVersion, true
}

// HasRepositoryVersion returns a boolean if a field has been set.
func (o *DebAptPublication) HasRepositoryVersion() bool {
	if o != nil && !IsNil(o.RepositoryVersion) {
		return true
	}

	return false
}

// SetRepositoryVersion gets a reference to the given string and assigns it to the RepositoryVersion field.
func (o *DebAptPublication) SetRepositoryVersion(v string) {
	o.RepositoryVersion = &v
}

// GetRepository returns the Repository field value if set, zero value otherwise.
func (o *DebAptPublication) GetRepository() string {
	if o == nil || IsNil(o.Repository) {
		var ret string
		return ret
	}
	return *o.Repository
}

// GetRepositoryOk returns a tuple with the Repository field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptPublication) GetRepositoryOk() (*string, bool) {
	if o == nil || IsNil(o.Repository) {
		return nil, false
	}
	return o.Repository, true
}

// HasRepository returns a boolean if a field has been set.
func (o *DebAptPublication) HasRepository() bool {
	if o != nil && !IsNil(o.Repository) {
		return true
	}

	return false
}

// SetRepository gets a reference to the given string and assigns it to the Repository field.
func (o *DebAptPublication) SetRepository(v string) {
	o.Repository = &v
}

// GetSimple returns the Simple field value if set, zero value otherwise.
func (o *DebAptPublication) GetSimple() bool {
	if o == nil || IsNil(o.Simple) {
		var ret bool
		return ret
	}
	return *o.Simple
}

// GetSimpleOk returns a tuple with the Simple field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptPublication) GetSimpleOk() (*bool, bool) {
	if o == nil || IsNil(o.Simple) {
		return nil, false
	}
	return o.Simple, true
}

// HasSimple returns a boolean if a field has been set.
func (o *DebAptPublication) HasSimple() bool {
	if o != nil && !IsNil(o.Simple) {
		return true
	}

	return false
}

// SetSimple gets a reference to the given bool and assigns it to the Simple field.
func (o *DebAptPublication) SetSimple(v bool) {
	o.Simple = &v
}

// GetStructured returns the Structured field value if set, zero value otherwise.
func (o *DebAptPublication) GetStructured() bool {
	if o == nil || IsNil(o.Structured) {
		var ret bool
		return ret
	}
	return *o.Structured
}

// GetStructuredOk returns a tuple with the Structured field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptPublication) GetStructuredOk() (*bool, bool) {
	if o == nil || IsNil(o.Structured) {
		return nil, false
	}
	return o.Structured, true
}

// HasStructured returns a boolean if a field has been set.
func (o *DebAptPublication) HasStructured() bool {
	if o != nil && !IsNil(o.Structured) {
		return true
	}

	return false
}

// SetStructured gets a reference to the given bool and assigns it to the Structured field.
func (o *DebAptPublication) SetStructured(v bool) {
	o.Structured = &v
}

// GetSigningService returns the SigningService field value if set, zero value otherwise.
func (o *DebAptPublication) GetSigningService() string {
	if o == nil || IsNil(o.SigningService) {
		var ret string
		return ret
	}
	return *o.SigningService
}

// GetSigningServiceOk returns a tuple with the SigningService field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptPublication) GetSigningServiceOk() (*string, bool) {
	if o == nil || IsNil(o.SigningService) {
		return nil, false
	}
	return o.SigningService, true
}

// HasSigningService returns a boolean if a field has been set.
func (o *DebAptPublication) HasSigningService() bool {
	if o != nil && !IsNil(o.SigningService) {
		return true
	}

	return false
}

// SetSigningService gets a reference to the given string and assigns it to the SigningService field.
func (o *DebAptPublication) SetSigningService(v string) {
	o.SigningService = &v
}

func (o DebAptPublication) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DebAptPublication) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.RepositoryVersion) {
		toSerialize["repository_version"] = o.RepositoryVersion
	}
	if !IsNil(o.Repository) {
		toSerialize["repository"] = o.Repository
	}
	if !IsNil(o.Simple) {
		toSerialize["simple"] = o.Simple
	}
	if !IsNil(o.Structured) {
		toSerialize["structured"] = o.Structured
	}
	if !IsNil(o.SigningService) {
		toSerialize["signing_service"] = o.SigningService
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *DebAptPublication) UnmarshalJSON(bytes []byte) (err error) {
	varDebAptPublication := _DebAptPublication{}

	if err = json.Unmarshal(bytes, &varDebAptPublication); err == nil {
		*o = DebAptPublication(varDebAptPublication)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "repository_version")
		delete(additionalProperties, "repository")
		delete(additionalProperties, "simple")
		delete(additionalProperties, "structured")
		delete(additionalProperties, "signing_service")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableDebAptPublication struct {
	value *DebAptPublication
	isSet bool
}

func (v NullableDebAptPublication) Get() *DebAptPublication {
	return v.value
}

func (v *NullableDebAptPublication) Set(val *DebAptPublication) {
	v.value = val
	v.isSet = true
}

func (v NullableDebAptPublication) IsSet() bool {
	return v.isSet
}

func (v *NullableDebAptPublication) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDebAptPublication(val *DebAptPublication) *NullableDebAptPublication {
	return &NullableDebAptPublication{value: val, isSet: true}
}

func (v NullableDebAptPublication) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDebAptPublication) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


