// Copyright 2020 The TensorFlow Runtime Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// RUN: env CUDNN_LOGINFO_DBG=1 bef_executor --test_init_function=register_op_handlers_gpu %s.bef | FileCheck %s

func.func @register_op_handlers_gpu() {
  %null = "corert.create_null_op_handler"() : () -> !corert.ophandler
  %gpu_ordinal = tfrt.constant.i32 0
  %gpu = "corert.create_gpu_op_handler" (%gpu_ordinal, %null) : (i32, !corert.ophandler) -> !corert.ophandler
  corert.register_op_handler %gpu "gpu"
  tfrt.return
}

// CHECK: --- Running 'maxpool_f32'
func.func @maxpool_f32() -> !tfrt.chain {
  %ch_epoch = tfrt.new.chain
  %gpu = corert.get_op_handler %ch_epoch "gpu"

  %gpu_handle_input = corert.executeop(%gpu)
    "tfrt_test.create_dense_tensor"() { shape = [1, 1, 3, 3], values = [0.0 : f32, 1.0 : f32, 2.0 : f32,  3.0 : f32,  4.0 : f32,  5.0 : f32,  6.0 : f32,  7.0 : f32,  8.0 : f32] } : 1

  %gpu_handle_result = corert.executeop(%gpu) "tf.MaxPool"(%gpu_handle_input) {ksize = [1, 1, 3, 3], padding = "VALID", strides = [1, 1, 2, 2], data_format="NCHW"} : 1

  %cpu_handle_result = corert.executeop(%gpu) "tfrt_test.gpu_tensor_to_host_tensor"(%gpu_handle_result) : 1
  // CHECK: DenseHostTensor dtype = f32, shape = [1, 1, 1, 1], values = [8]
  %ch_print_cpu = corert.executeop.seq(%gpu, %ch_epoch) "tfrt_test.print"(%cpu_handle_result) : 0
  tfrt.return %ch_print_cpu : !tfrt.chain
}

// CHECK: --- Running 'maxpool'
func.func @maxpool() -> !tfrt.chain {
  %ch_epoch = tfrt.new.chain
  %gpu = corert.get_op_handler %ch_epoch "gpu"

  %maxpool_in_th = corert.executeop(%gpu) "tf.Const"()
      { dtype = f32, value = dense<1.0> : tensor<1x1x3x3xf32> } : 1
  %maxpool_th = corert.executeop(%gpu) "tf.MaxPool"(%maxpool_in_th) { T = f32, data_format = "NCHW",  ksize = [1, 1, 3, 3], padding = "SAME", strides = [1, 1, 2, 2]} : 1

  %cpu_handle_result = corert.executeop(%gpu) "tfrt_test.gpu_tensor_to_host_tensor"(%maxpool_th) : 1
  // CHECK: DenseHostTensor dtype = f32, shape = [1, 1, 2, 2], values = [1, 1, 1, 1]
  %ch_print_cpu = corert.executeop.seq(%gpu, %ch_epoch) "tfrt_test.print"(%cpu_handle_result) : 0
  tfrt.return %ch_print_cpu : !tfrt.chain
}
