/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"time"
	"reflect"
)


// RemotesCollectionAPIService RemotesCollectionAPI service
type RemotesCollectionAPIService service

type RemotesCollectionAPIRemotesAnsibleCollectionAddRoleRequest struct {
	ctx context.Context
	ApiService *RemotesCollectionAPIService
	ansibleCollectionRemoteHref string
	nestedRole *NestedRole
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionAddRoleRequest) NestedRole(nestedRole NestedRole) RemotesCollectionAPIRemotesAnsibleCollectionAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleCollectionAddRoleExecute(r)
}

/*
RemotesAnsibleCollectionAddRole Method for RemotesAnsibleCollectionAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleCollectionRemoteHref
 @return RemotesCollectionAPIRemotesAnsibleCollectionAddRoleRequest
*/
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionAddRole(ctx context.Context, ansibleCollectionRemoteHref string) RemotesCollectionAPIRemotesAnsibleCollectionAddRoleRequest {
	return RemotesCollectionAPIRemotesAnsibleCollectionAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		ansibleCollectionRemoteHref: ansibleCollectionRemoteHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionAddRoleExecute(r RemotesCollectionAPIRemotesAnsibleCollectionAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesCollectionAPIService.RemotesAnsibleCollectionAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_collection_remote_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_collection_remote_href"+"}", parameterValueToString(r.ansibleCollectionRemoteHref, "ansibleCollectionRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesCollectionAPIRemotesAnsibleCollectionCreateRequest struct {
	ctx context.Context
	ApiService *RemotesCollectionAPIService
	ansibleCollectionRemote *AnsibleCollectionRemote
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionCreateRequest) AnsibleCollectionRemote(ansibleCollectionRemote AnsibleCollectionRemote) RemotesCollectionAPIRemotesAnsibleCollectionCreateRequest {
	r.ansibleCollectionRemote = &ansibleCollectionRemote
	return r
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionCreateRequest) Execute() (*AnsibleCollectionRemoteResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleCollectionCreateExecute(r)
}

/*
RemotesAnsibleCollectionCreate Create a collection remote

ViewSet for Collection Remotes.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RemotesCollectionAPIRemotesAnsibleCollectionCreateRequest
*/
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionCreate(ctx context.Context) RemotesCollectionAPIRemotesAnsibleCollectionCreateRequest {
	return RemotesCollectionAPIRemotesAnsibleCollectionCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AnsibleCollectionRemoteResponse
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionCreateExecute(r RemotesCollectionAPIRemotesAnsibleCollectionCreateRequest) (*AnsibleCollectionRemoteResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AnsibleCollectionRemoteResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesCollectionAPIService.RemotesAnsibleCollectionCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/remotes/ansible/collection/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleCollectionRemote == nil {
		return localVarReturnValue, nil, reportError("ansibleCollectionRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleCollectionRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesCollectionAPIRemotesAnsibleCollectionDeleteRequest struct {
	ctx context.Context
	ApiService *RemotesCollectionAPIService
	ansibleCollectionRemoteHref string
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleCollectionDeleteExecute(r)
}

/*
RemotesAnsibleCollectionDelete Delete a collection remote

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleCollectionRemoteHref
 @return RemotesCollectionAPIRemotesAnsibleCollectionDeleteRequest
*/
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionDelete(ctx context.Context, ansibleCollectionRemoteHref string) RemotesCollectionAPIRemotesAnsibleCollectionDeleteRequest {
	return RemotesCollectionAPIRemotesAnsibleCollectionDeleteRequest{
		ApiService: a,
		ctx: ctx,
		ansibleCollectionRemoteHref: ansibleCollectionRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionDeleteExecute(r RemotesCollectionAPIRemotesAnsibleCollectionDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesCollectionAPIService.RemotesAnsibleCollectionDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_collection_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_collection_remote_href"+"}", parameterValueToString(r.ansibleCollectionRemoteHref, "ansibleCollectionRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesCollectionAPIRemotesAnsibleCollectionListRequest struct {
	ctx context.Context
	ApiService *RemotesCollectionAPIService
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	pulpLastUpdated *time.Time
	pulpLastUpdatedGt *time.Time
	pulpLastUpdatedGte *time.Time
	pulpLastUpdatedLt *time.Time
	pulpLastUpdatedLte *time.Time
	pulpLastUpdatedRange *[]time.Time
	url *string
	urlContains *string
	urlIcontains *string
	urlIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) Limit(limit int32) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) Name(name string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) NameContains(nameContains string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) NameIcontains(nameIcontains string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) NameIn(nameIn []string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) NameStartswith(nameStartswith string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) Offset(offset int32) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;url&#x60; - Url * &#x60;-url&#x60; - Url (descending) * &#x60;ca_cert&#x60; - Ca cert * &#x60;-ca_cert&#x60; - Ca cert (descending) * &#x60;client_cert&#x60; - Client cert * &#x60;-client_cert&#x60; - Client cert (descending) * &#x60;client_key&#x60; - Client key * &#x60;-client_key&#x60; - Client key (descending) * &#x60;tls_validation&#x60; - Tls validation * &#x60;-tls_validation&#x60; - Tls validation (descending) * &#x60;username&#x60; - Username * &#x60;-username&#x60; - Username (descending) * &#x60;password&#x60; - Password * &#x60;-password&#x60; - Password (descending) * &#x60;proxy_url&#x60; - Proxy url * &#x60;-proxy_url&#x60; - Proxy url (descending) * &#x60;proxy_username&#x60; - Proxy username * &#x60;-proxy_username&#x60; - Proxy username (descending) * &#x60;proxy_password&#x60; - Proxy password * &#x60;-proxy_password&#x60; - Proxy password (descending) * &#x60;download_concurrency&#x60; - Download concurrency * &#x60;-download_concurrency&#x60; - Download concurrency (descending) * &#x60;max_retries&#x60; - Max retries * &#x60;-max_retries&#x60; - Max retries (descending) * &#x60;policy&#x60; - Policy * &#x60;-policy&#x60; - Policy (descending) * &#x60;total_timeout&#x60; - Total timeout * &#x60;-total_timeout&#x60; - Total timeout (descending) * &#x60;connect_timeout&#x60; - Connect timeout * &#x60;-connect_timeout&#x60; - Connect timeout (descending) * &#x60;sock_connect_timeout&#x60; - Sock connect timeout * &#x60;-sock_connect_timeout&#x60; - Sock connect timeout (descending) * &#x60;sock_read_timeout&#x60; - Sock read timeout * &#x60;-sock_read_timeout&#x60; - Sock read timeout (descending) * &#x60;headers&#x60; - Headers * &#x60;-headers&#x60; - Headers (descending) * &#x60;rate_limit&#x60; - Rate limit * &#x60;-rate_limit&#x60; - Rate limit (descending) * &#x60;requirements_file&#x60; - Requirements file * &#x60;-requirements_file&#x60; - Requirements file (descending) * &#x60;auth_url&#x60; - Auth url * &#x60;-auth_url&#x60; - Auth url (descending) * &#x60;token&#x60; - Token * &#x60;-token&#x60; - Token (descending) * &#x60;sync_dependencies&#x60; - Sync dependencies * &#x60;-sync_dependencies&#x60; - Sync dependencies (descending) * &#x60;signed_only&#x60; - Signed only * &#x60;-signed_only&#x60; - Signed only (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) Ordering(ordering []string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) PulpHrefIn(pulpHrefIn []string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) PulpIdIn(pulpIdIn []string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) PulpLabelSelect(pulpLabelSelect string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Filter results where pulp_last_updated matches value
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) PulpLastUpdated(pulpLastUpdated time.Time) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.pulpLastUpdated = &pulpLastUpdated
	return r
}

// Filter results where pulp_last_updated is greater than value
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) PulpLastUpdatedGt(pulpLastUpdatedGt time.Time) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.pulpLastUpdatedGt = &pulpLastUpdatedGt
	return r
}

// Filter results where pulp_last_updated is greater than or equal to value
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) PulpLastUpdatedGte(pulpLastUpdatedGte time.Time) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.pulpLastUpdatedGte = &pulpLastUpdatedGte
	return r
}

// Filter results where pulp_last_updated is less than value
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) PulpLastUpdatedLt(pulpLastUpdatedLt time.Time) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.pulpLastUpdatedLt = &pulpLastUpdatedLt
	return r
}

// Filter results where pulp_last_updated is less than or equal to value
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) PulpLastUpdatedLte(pulpLastUpdatedLte time.Time) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.pulpLastUpdatedLte = &pulpLastUpdatedLte
	return r
}

// Filter results where pulp_last_updated is between two comma separated values
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) PulpLastUpdatedRange(pulpLastUpdatedRange []time.Time) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.pulpLastUpdatedRange = &pulpLastUpdatedRange
	return r
}

// Filter results where url matches value
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) Url(url string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.url = &url
	return r
}

// Filter results where url contains value
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) UrlContains(urlContains string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.urlContains = &urlContains
	return r
}

// Filter results where url contains value
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) UrlIcontains(urlIcontains string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.urlIcontains = &urlIcontains
	return r
}

// Filter results where url is in a comma-separated list of values
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) UrlIn(urlIn []string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.urlIn = &urlIn
	return r
}

// A list of fields to include in the response.
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) Fields(fields []string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) ExcludeFields(excludeFields []string) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) Execute() (*PaginatedansibleCollectionRemoteResponseList, *http.Response, error) {
	return r.ApiService.RemotesAnsibleCollectionListExecute(r)
}

/*
RemotesAnsibleCollectionList List collection remotes

ViewSet for Collection Remotes.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RemotesCollectionAPIRemotesAnsibleCollectionListRequest
*/
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionList(ctx context.Context) RemotesCollectionAPIRemotesAnsibleCollectionListRequest {
	return RemotesCollectionAPIRemotesAnsibleCollectionListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedansibleCollectionRemoteResponseList
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionListExecute(r RemotesCollectionAPIRemotesAnsibleCollectionListRequest) (*PaginatedansibleCollectionRemoteResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedansibleCollectionRemoteResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesCollectionAPIService.RemotesAnsibleCollectionList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/remotes/ansible/collection/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.pulpLastUpdated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated", r.pulpLastUpdated, "")
	}
	if r.pulpLastUpdatedGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__gt", r.pulpLastUpdatedGt, "")
	}
	if r.pulpLastUpdatedGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__gte", r.pulpLastUpdatedGte, "")
	}
	if r.pulpLastUpdatedLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__lt", r.pulpLastUpdatedLt, "")
	}
	if r.pulpLastUpdatedLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__lte", r.pulpLastUpdatedLte, "")
	}
	if r.pulpLastUpdatedRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__range", r.pulpLastUpdatedRange, "csv")
	}
	if r.url != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "url", r.url, "")
	}
	if r.urlContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "url__contains", r.urlContains, "")
	}
	if r.urlIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "url__icontains", r.urlIcontains, "")
	}
	if r.urlIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "url__in", r.urlIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesCollectionAPIRemotesAnsibleCollectionListRolesRequest struct {
	ctx context.Context
	ApiService *RemotesCollectionAPIService
	ansibleCollectionRemoteHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRolesRequest) Fields(fields []string) RemotesCollectionAPIRemotesAnsibleCollectionListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesCollectionAPIRemotesAnsibleCollectionListRolesRequest) ExcludeFields(excludeFields []string) RemotesCollectionAPIRemotesAnsibleCollectionListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleCollectionListRolesExecute(r)
}

/*
RemotesAnsibleCollectionListRoles Method for RemotesAnsibleCollectionListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleCollectionRemoteHref
 @return RemotesCollectionAPIRemotesAnsibleCollectionListRolesRequest
*/
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionListRoles(ctx context.Context, ansibleCollectionRemoteHref string) RemotesCollectionAPIRemotesAnsibleCollectionListRolesRequest {
	return RemotesCollectionAPIRemotesAnsibleCollectionListRolesRequest{
		ApiService: a,
		ctx: ctx,
		ansibleCollectionRemoteHref: ansibleCollectionRemoteHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionListRolesExecute(r RemotesCollectionAPIRemotesAnsibleCollectionListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesCollectionAPIService.RemotesAnsibleCollectionListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_collection_remote_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_collection_remote_href"+"}", parameterValueToString(r.ansibleCollectionRemoteHref, "ansibleCollectionRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesCollectionAPIRemotesAnsibleCollectionMyPermissionsRequest struct {
	ctx context.Context
	ApiService *RemotesCollectionAPIService
	ansibleCollectionRemoteHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RemotesCollectionAPIRemotesAnsibleCollectionMyPermissionsRequest) Fields(fields []string) RemotesCollectionAPIRemotesAnsibleCollectionMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesCollectionAPIRemotesAnsibleCollectionMyPermissionsRequest) ExcludeFields(excludeFields []string) RemotesCollectionAPIRemotesAnsibleCollectionMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleCollectionMyPermissionsExecute(r)
}

/*
RemotesAnsibleCollectionMyPermissions Method for RemotesAnsibleCollectionMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleCollectionRemoteHref
 @return RemotesCollectionAPIRemotesAnsibleCollectionMyPermissionsRequest
*/
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionMyPermissions(ctx context.Context, ansibleCollectionRemoteHref string) RemotesCollectionAPIRemotesAnsibleCollectionMyPermissionsRequest {
	return RemotesCollectionAPIRemotesAnsibleCollectionMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		ansibleCollectionRemoteHref: ansibleCollectionRemoteHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionMyPermissionsExecute(r RemotesCollectionAPIRemotesAnsibleCollectionMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesCollectionAPIService.RemotesAnsibleCollectionMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_collection_remote_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_collection_remote_href"+"}", parameterValueToString(r.ansibleCollectionRemoteHref, "ansibleCollectionRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesCollectionAPIRemotesAnsibleCollectionPartialUpdateRequest struct {
	ctx context.Context
	ApiService *RemotesCollectionAPIService
	ansibleCollectionRemoteHref string
	patchedansibleCollectionRemote *PatchedansibleCollectionRemote
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionPartialUpdateRequest) PatchedansibleCollectionRemote(patchedansibleCollectionRemote PatchedansibleCollectionRemote) RemotesCollectionAPIRemotesAnsibleCollectionPartialUpdateRequest {
	r.patchedansibleCollectionRemote = &patchedansibleCollectionRemote
	return r
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleCollectionPartialUpdateExecute(r)
}

/*
RemotesAnsibleCollectionPartialUpdate Update a collection remote

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleCollectionRemoteHref
 @return RemotesCollectionAPIRemotesAnsibleCollectionPartialUpdateRequest
*/
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionPartialUpdate(ctx context.Context, ansibleCollectionRemoteHref string) RemotesCollectionAPIRemotesAnsibleCollectionPartialUpdateRequest {
	return RemotesCollectionAPIRemotesAnsibleCollectionPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		ansibleCollectionRemoteHref: ansibleCollectionRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionPartialUpdateExecute(r RemotesCollectionAPIRemotesAnsibleCollectionPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesCollectionAPIService.RemotesAnsibleCollectionPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_collection_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_collection_remote_href"+"}", parameterValueToString(r.ansibleCollectionRemoteHref, "ansibleCollectionRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedansibleCollectionRemote == nil {
		return localVarReturnValue, nil, reportError("patchedansibleCollectionRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedansibleCollectionRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesCollectionAPIRemotesAnsibleCollectionReadRequest struct {
	ctx context.Context
	ApiService *RemotesCollectionAPIService
	ansibleCollectionRemoteHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RemotesCollectionAPIRemotesAnsibleCollectionReadRequest) Fields(fields []string) RemotesCollectionAPIRemotesAnsibleCollectionReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesCollectionAPIRemotesAnsibleCollectionReadRequest) ExcludeFields(excludeFields []string) RemotesCollectionAPIRemotesAnsibleCollectionReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionReadRequest) Execute() (*AnsibleCollectionRemoteResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleCollectionReadExecute(r)
}

/*
RemotesAnsibleCollectionRead Inspect a collection remote

ViewSet for Collection Remotes.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleCollectionRemoteHref
 @return RemotesCollectionAPIRemotesAnsibleCollectionReadRequest
*/
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionRead(ctx context.Context, ansibleCollectionRemoteHref string) RemotesCollectionAPIRemotesAnsibleCollectionReadRequest {
	return RemotesCollectionAPIRemotesAnsibleCollectionReadRequest{
		ApiService: a,
		ctx: ctx,
		ansibleCollectionRemoteHref: ansibleCollectionRemoteHref,
	}
}

// Execute executes the request
//  @return AnsibleCollectionRemoteResponse
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionReadExecute(r RemotesCollectionAPIRemotesAnsibleCollectionReadRequest) (*AnsibleCollectionRemoteResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AnsibleCollectionRemoteResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesCollectionAPIService.RemotesAnsibleCollectionRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_collection_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_collection_remote_href"+"}", parameterValueToString(r.ansibleCollectionRemoteHref, "ansibleCollectionRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesCollectionAPIRemotesAnsibleCollectionRemoveRoleRequest struct {
	ctx context.Context
	ApiService *RemotesCollectionAPIService
	ansibleCollectionRemoteHref string
	nestedRole *NestedRole
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionRemoveRoleRequest) NestedRole(nestedRole NestedRole) RemotesCollectionAPIRemotesAnsibleCollectionRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleCollectionRemoveRoleExecute(r)
}

/*
RemotesAnsibleCollectionRemoveRole Method for RemotesAnsibleCollectionRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleCollectionRemoteHref
 @return RemotesCollectionAPIRemotesAnsibleCollectionRemoveRoleRequest
*/
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionRemoveRole(ctx context.Context, ansibleCollectionRemoteHref string) RemotesCollectionAPIRemotesAnsibleCollectionRemoveRoleRequest {
	return RemotesCollectionAPIRemotesAnsibleCollectionRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		ansibleCollectionRemoteHref: ansibleCollectionRemoteHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionRemoveRoleExecute(r RemotesCollectionAPIRemotesAnsibleCollectionRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesCollectionAPIService.RemotesAnsibleCollectionRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_collection_remote_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_collection_remote_href"+"}", parameterValueToString(r.ansibleCollectionRemoteHref, "ansibleCollectionRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesCollectionAPIRemotesAnsibleCollectionUpdateRequest struct {
	ctx context.Context
	ApiService *RemotesCollectionAPIService
	ansibleCollectionRemoteHref string
	ansibleCollectionRemote *AnsibleCollectionRemote
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionUpdateRequest) AnsibleCollectionRemote(ansibleCollectionRemote AnsibleCollectionRemote) RemotesCollectionAPIRemotesAnsibleCollectionUpdateRequest {
	r.ansibleCollectionRemote = &ansibleCollectionRemote
	return r
}

func (r RemotesCollectionAPIRemotesAnsibleCollectionUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleCollectionUpdateExecute(r)
}

/*
RemotesAnsibleCollectionUpdate Update a collection remote

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleCollectionRemoteHref
 @return RemotesCollectionAPIRemotesAnsibleCollectionUpdateRequest
*/
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionUpdate(ctx context.Context, ansibleCollectionRemoteHref string) RemotesCollectionAPIRemotesAnsibleCollectionUpdateRequest {
	return RemotesCollectionAPIRemotesAnsibleCollectionUpdateRequest{
		ApiService: a,
		ctx: ctx,
		ansibleCollectionRemoteHref: ansibleCollectionRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesCollectionAPIService) RemotesAnsibleCollectionUpdateExecute(r RemotesCollectionAPIRemotesAnsibleCollectionUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesCollectionAPIService.RemotesAnsibleCollectionUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_collection_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_collection_remote_href"+"}", parameterValueToString(r.ansibleCollectionRemoteHref, "ansibleCollectionRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleCollectionRemote == nil {
		return localVarReturnValue, nil, reportError("ansibleCollectionRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleCollectionRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
