; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx908 -atomic-expand %s | FileCheck -check-prefix=GFX908 %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx90a -atomic-expand %s | FileCheck -check-prefix=GFX90A %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx940 -atomic-expand %s | FileCheck -check-prefix=GFX940 %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 -atomic-expand %s | FileCheck -check-prefix=GFX1100 %s

define float @syncscope_system(ptr %addr, float %val) #0 {
; GFX908-LABEL: @syncscope_system(
; GFX908-NEXT:    [[TMP1:%.*]] = load float, ptr [[ADDR:%.*]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VAL:%.*]]
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast float [[NEW]] to i32
; GFX908-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; GFX908-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[ADDR]], i32 [[TMP4]], i32 [[TMP3]] seq_cst seq_cst, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; GFX908-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret float [[TMP6]]
;
; GFX90A-LABEL: @syncscope_system(
; GFX90A-NEXT:    [[TMP1:%.*]] = load float, ptr [[ADDR:%.*]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VAL:%.*]]
; GFX90A-NEXT:    [[TMP3:%.*]] = bitcast float [[NEW]] to i32
; GFX90A-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; GFX90A-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[ADDR]], i32 [[TMP4]], i32 [[TMP3]] seq_cst seq_cst, align 4
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; GFX90A-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; GFX90A-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    ret float [[TMP6]]
;
; GFX940-LABEL: @syncscope_system(
; GFX940-NEXT:    [[TMP1:%.*]] = load float, ptr [[ADDR:%.*]], align 4
; GFX940-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX940:       atomicrmw.start:
; GFX940-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; GFX940-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VAL:%.*]]
; GFX940-NEXT:    [[TMP3:%.*]] = bitcast float [[NEW]] to i32
; GFX940-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; GFX940-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[ADDR]], i32 [[TMP4]], i32 [[TMP3]] seq_cst seq_cst, align 4
; GFX940-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; GFX940-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; GFX940-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; GFX940-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX940:       atomicrmw.end:
; GFX940-NEXT:    ret float [[TMP6]]
;
; GFX1100-LABEL: @syncscope_system(
; GFX1100-NEXT:    [[TMP1:%.*]] = load float, ptr [[ADDR:%.*]], align 4
; GFX1100-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX1100:       atomicrmw.start:
; GFX1100-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; GFX1100-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VAL:%.*]]
; GFX1100-NEXT:    [[TMP3:%.*]] = bitcast float [[NEW]] to i32
; GFX1100-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; GFX1100-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[ADDR]], i32 [[TMP4]], i32 [[TMP3]] seq_cst seq_cst, align 4
; GFX1100-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; GFX1100-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; GFX1100-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; GFX1100-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX1100:       atomicrmw.end:
; GFX1100-NEXT:    ret float [[TMP6]]
;
; GFX11-LABEL: @syncscope_system(
; GFX11-NEXT:    [[TMP1:%.*]] = load float, ptr [[ADDR:%.*]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VAL:%.*]]
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast float [[NEW]] to i32
; GFX11-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; GFX11-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[ADDR]], i32 [[TMP4]], i32 [[TMP3]] seq_cst seq_cst, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; GFX11-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret float [[TMP6]]
  %res = atomicrmw fadd ptr %addr, float %val seq_cst
  ret float %res
}

define float @syncscope_workgroup_rtn(ptr %addr, float %val) #0 {
; GFX908-LABEL: @syncscope_workgroup_rtn(
; GFX908-NEXT:    [[TMP1:%.*]] = load float, ptr [[ADDR:%.*]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VAL:%.*]]
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast float [[NEW]] to i32
; GFX908-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; GFX908-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[ADDR]], i32 [[TMP4]], i32 [[TMP3]] syncscope("workgroup") seq_cst seq_cst, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; GFX908-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret float [[TMP6]]
;
; GFX90A-LABEL: @syncscope_workgroup_rtn(
; GFX90A-NEXT:    br label [[ATOMICRMW_CHECK_SHARED:%.*]]
; GFX90A:       atomicrmw.check.shared:
; GFX90A-NEXT:    [[IS_SHARED:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[ADDR:%.*]])
; GFX90A-NEXT:    br i1 [[IS_SHARED]], label [[ATOMICRMW_SHARED:%.*]], label [[ATOMICRMW_CHECK_PRIVATE:%.*]]
; GFX90A:       atomicrmw.shared:
; GFX90A-NEXT:    [[TMP2:%.*]] = addrspacecast ptr [[ADDR]] to ptr addrspace(3)
; GFX90A-NEXT:    [[TMP3:%.*]] = atomicrmw fadd ptr addrspace(3) [[TMP2]], float [[VAL:%.*]] syncscope("workgroup") seq_cst, align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_PHI:%.*]]
; GFX90A:       atomicrmw.check.private:
; GFX90A-NEXT:    [[IS_PRIVATE:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[ADDR]])
; GFX90A-NEXT:    br i1 [[IS_PRIVATE]], label [[ATOMICRMW_PRIVATE:%.*]], label [[ATOMICRMW_GLOBAL:%.*]]
; GFX90A:       atomicrmw.private:
; GFX90A-NEXT:    [[TMP4:%.*]] = addrspacecast ptr [[ADDR]] to ptr addrspace(5)
; GFX90A-NEXT:    [[LOADED_PRIVATE:%.*]] = load float, ptr addrspace(5) [[TMP4]], align 4
; GFX90A-NEXT:    [[VAL_NEW:%.*]] = fadd float [[LOADED_PRIVATE]], [[VAL]]
; GFX90A-NEXT:    store float [[VAL_NEW]], ptr addrspace(5) [[TMP4]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_PHI]]
; GFX90A:       atomicrmw.global:
; GFX90A-NEXT:    [[TMP5:%.*]] = addrspacecast ptr [[ADDR]] to ptr addrspace(1)
; GFX90A-NEXT:    [[TMP6:%.*]] = atomicrmw fadd ptr addrspace(1) [[TMP5]], float [[VAL]] syncscope("workgroup") seq_cst, align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_PHI]]
; GFX90A:       atomicrmw.phi:
; GFX90A-NEXT:    [[LOADED_PHI:%.*]] = phi float [ [[TMP3]], [[ATOMICRMW_SHARED]] ], [ [[LOADED_PRIVATE]], [[ATOMICRMW_PRIVATE]] ], [ [[TMP6]], [[ATOMICRMW_GLOBAL]] ]
; GFX90A-NEXT:    br label [[ATOMICRMW_END:%.*]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    ret float [[LOADED_PHI]]
;
; GFX940-LABEL: @syncscope_workgroup_rtn(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr [[ADDR:%.*]], float [[VAL:%.*]] syncscope("workgroup") seq_cst, align 4
; GFX940-NEXT:    ret float [[RES]]
;
; GFX1100-LABEL: @syncscope_workgroup_rtn(
; GFX1100-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr [[ADDR:%.*]], float [[VAL:%.*]] syncscope("workgroup") seq_cst, align 4
; GFX1100-NEXT:    ret float [[RES]]
;
; GFX11-LABEL: @syncscope_workgroup_rtn(
; GFX11-NEXT:    [[TMP1:%.*]] = load float, ptr [[ADDR:%.*]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VAL:%.*]]
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast float [[NEW]] to i32
; GFX11-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; GFX11-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[ADDR]], i32 [[TMP4]], i32 [[TMP3]] syncscope("workgroup") seq_cst seq_cst, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; GFX11-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret float [[TMP6]]
  %res = atomicrmw fadd ptr %addr, float %val syncscope("workgroup") seq_cst
  ret float %res
}

define void @syncscope_workgroup_nortn(ptr %addr, float %val) #0 {
; GFX908-LABEL: @syncscope_workgroup_nortn(
; GFX908-NEXT:    br label [[ATOMICRMW_CHECK_SHARED:%.*]]
; GFX908:       atomicrmw.check.shared:
; GFX908-NEXT:    [[IS_SHARED:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[ADDR:%.*]])
; GFX908-NEXT:    br i1 [[IS_SHARED]], label [[ATOMICRMW_SHARED:%.*]], label [[ATOMICRMW_CHECK_PRIVATE:%.*]]
; GFX908:       atomicrmw.shared:
; GFX908-NEXT:    [[TMP2:%.*]] = addrspacecast ptr [[ADDR]] to ptr addrspace(3)
; GFX908-NEXT:    [[TMP3:%.*]] = atomicrmw fadd ptr addrspace(3) [[TMP2]], float [[VAL:%.*]] syncscope("workgroup") seq_cst, align 4
; GFX908-NEXT:    br label [[ATOMICRMW_PHI:%.*]]
; GFX908:       atomicrmw.check.private:
; GFX908-NEXT:    [[IS_PRIVATE:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[ADDR]])
; GFX908-NEXT:    br i1 [[IS_PRIVATE]], label [[ATOMICRMW_PRIVATE:%.*]], label [[ATOMICRMW_GLOBAL:%.*]]
; GFX908:       atomicrmw.private:
; GFX908-NEXT:    [[TMP4:%.*]] = addrspacecast ptr [[ADDR]] to ptr addrspace(5)
; GFX908-NEXT:    [[LOADED_PRIVATE:%.*]] = load float, ptr addrspace(5) [[TMP4]], align 4
; GFX908-NEXT:    [[VAL_NEW:%.*]] = fadd float [[LOADED_PRIVATE]], [[VAL]]
; GFX908-NEXT:    store float [[VAL_NEW]], ptr addrspace(5) [[TMP4]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_PHI]]
; GFX908:       atomicrmw.global:
; GFX908-NEXT:    [[TMP5:%.*]] = addrspacecast ptr [[ADDR]] to ptr addrspace(1)
; GFX908-NEXT:    [[TMP6:%.*]] = atomicrmw fadd ptr addrspace(1) [[TMP5]], float [[VAL]] syncscope("workgroup") seq_cst, align 4
; GFX908-NEXT:    br label [[ATOMICRMW_PHI]]
; GFX908:       atomicrmw.phi:
; GFX908-NEXT:    [[LOADED_PHI:%.*]] = phi float [ [[TMP3]], [[ATOMICRMW_SHARED]] ], [ [[LOADED_PRIVATE]], [[ATOMICRMW_PRIVATE]] ], [ [[TMP6]], [[ATOMICRMW_GLOBAL]] ]
; GFX908-NEXT:    br label [[ATOMICRMW_END:%.*]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret void
;
; GFX90A-LABEL: @syncscope_workgroup_nortn(
; GFX90A-NEXT:    br label [[ATOMICRMW_CHECK_SHARED:%.*]]
; GFX90A:       atomicrmw.check.shared:
; GFX90A-NEXT:    [[IS_SHARED:%.*]] = call i1 @llvm.amdgcn.is.shared(ptr [[ADDR:%.*]])
; GFX90A-NEXT:    br i1 [[IS_SHARED]], label [[ATOMICRMW_SHARED:%.*]], label [[ATOMICRMW_CHECK_PRIVATE:%.*]]
; GFX90A:       atomicrmw.shared:
; GFX90A-NEXT:    [[TMP2:%.*]] = addrspacecast ptr [[ADDR]] to ptr addrspace(3)
; GFX90A-NEXT:    [[TMP3:%.*]] = atomicrmw fadd ptr addrspace(3) [[TMP2]], float [[VAL:%.*]] syncscope("workgroup") seq_cst, align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_PHI:%.*]]
; GFX90A:       atomicrmw.check.private:
; GFX90A-NEXT:    [[IS_PRIVATE:%.*]] = call i1 @llvm.amdgcn.is.private(ptr [[ADDR]])
; GFX90A-NEXT:    br i1 [[IS_PRIVATE]], label [[ATOMICRMW_PRIVATE:%.*]], label [[ATOMICRMW_GLOBAL:%.*]]
; GFX90A:       atomicrmw.private:
; GFX90A-NEXT:    [[TMP4:%.*]] = addrspacecast ptr [[ADDR]] to ptr addrspace(5)
; GFX90A-NEXT:    [[LOADED_PRIVATE:%.*]] = load float, ptr addrspace(5) [[TMP4]], align 4
; GFX90A-NEXT:    [[VAL_NEW:%.*]] = fadd float [[LOADED_PRIVATE]], [[VAL]]
; GFX90A-NEXT:    store float [[VAL_NEW]], ptr addrspace(5) [[TMP4]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_PHI]]
; GFX90A:       atomicrmw.global:
; GFX90A-NEXT:    [[TMP5:%.*]] = addrspacecast ptr [[ADDR]] to ptr addrspace(1)
; GFX90A-NEXT:    [[TMP6:%.*]] = atomicrmw fadd ptr addrspace(1) [[TMP5]], float [[VAL]] syncscope("workgroup") seq_cst, align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_PHI]]
; GFX90A:       atomicrmw.phi:
; GFX90A-NEXT:    [[LOADED_PHI:%.*]] = phi float [ [[TMP3]], [[ATOMICRMW_SHARED]] ], [ [[LOADED_PRIVATE]], [[ATOMICRMW_PRIVATE]] ], [ [[TMP6]], [[ATOMICRMW_GLOBAL]] ]
; GFX90A-NEXT:    br label [[ATOMICRMW_END:%.*]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    ret void
;
; GFX940-LABEL: @syncscope_workgroup_nortn(
; GFX940-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr [[ADDR:%.*]], float [[VAL:%.*]] syncscope("workgroup") seq_cst, align 4
; GFX940-NEXT:    ret void
;
; GFX1100-LABEL: @syncscope_workgroup_nortn(
; GFX1100-NEXT:    [[RES:%.*]] = atomicrmw fadd ptr [[ADDR:%.*]], float [[VAL:%.*]] syncscope("workgroup") seq_cst, align 4
; GFX1100-NEXT:    ret void
;
; GFX11-LABEL: @syncscope_workgroup_nortn(
; GFX11-NEXT:    [[TMP1:%.*]] = load float, ptr [[ADDR:%.*]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VAL:%.*]]
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast float [[NEW]] to i32
; GFX11-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; GFX11-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[ADDR]], i32 [[TMP4]], i32 [[TMP3]] syncscope("workgroup") seq_cst seq_cst, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; GFX11-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret void
  %res = atomicrmw fadd ptr %addr, float %val syncscope("workgroup") seq_cst
  ret void
}

define float @no_unsafe(ptr %addr, float %val) {
; GFX908-LABEL: @no_unsafe(
; GFX908-NEXT:    [[TMP1:%.*]] = load float, ptr [[ADDR:%.*]], align 4
; GFX908-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX908:       atomicrmw.start:
; GFX908-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; GFX908-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VAL:%.*]]
; GFX908-NEXT:    [[TMP3:%.*]] = bitcast float [[NEW]] to i32
; GFX908-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; GFX908-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[ADDR]], i32 [[TMP4]], i32 [[TMP3]] syncscope("workgroup") seq_cst seq_cst, align 4
; GFX908-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; GFX908-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; GFX908-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; GFX908-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX908:       atomicrmw.end:
; GFX908-NEXT:    ret float [[TMP6]]
;
; GFX90A-LABEL: @no_unsafe(
; GFX90A-NEXT:    [[TMP1:%.*]] = load float, ptr [[ADDR:%.*]], align 4
; GFX90A-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX90A:       atomicrmw.start:
; GFX90A-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; GFX90A-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VAL:%.*]]
; GFX90A-NEXT:    [[TMP3:%.*]] = bitcast float [[NEW]] to i32
; GFX90A-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; GFX90A-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[ADDR]], i32 [[TMP4]], i32 [[TMP3]] syncscope("workgroup") seq_cst seq_cst, align 4
; GFX90A-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; GFX90A-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; GFX90A-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; GFX90A-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX90A:       atomicrmw.end:
; GFX90A-NEXT:    ret float [[TMP6]]
;
; GFX940-LABEL: @no_unsafe(
; GFX940-NEXT:    [[TMP1:%.*]] = load float, ptr [[ADDR:%.*]], align 4
; GFX940-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX940:       atomicrmw.start:
; GFX940-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; GFX940-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VAL:%.*]]
; GFX940-NEXT:    [[TMP3:%.*]] = bitcast float [[NEW]] to i32
; GFX940-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; GFX940-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[ADDR]], i32 [[TMP4]], i32 [[TMP3]] syncscope("workgroup") seq_cst seq_cst, align 4
; GFX940-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; GFX940-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; GFX940-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; GFX940-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX940:       atomicrmw.end:
; GFX940-NEXT:    ret float [[TMP6]]
;
; GFX1100-LABEL: @no_unsafe(
; GFX1100-NEXT:    [[TMP1:%.*]] = load float, ptr [[ADDR:%.*]], align 4
; GFX1100-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX1100:       atomicrmw.start:
; GFX1100-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; GFX1100-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VAL:%.*]]
; GFX1100-NEXT:    [[TMP3:%.*]] = bitcast float [[NEW]] to i32
; GFX1100-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; GFX1100-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[ADDR]], i32 [[TMP4]], i32 [[TMP3]] syncscope("workgroup") seq_cst seq_cst, align 4
; GFX1100-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; GFX1100-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; GFX1100-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; GFX1100-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX1100:       atomicrmw.end:
; GFX1100-NEXT:    ret float [[TMP6]]
;
; GFX11-LABEL: @no_unsafe(
; GFX11-NEXT:    [[TMP1:%.*]] = load float, ptr [[ADDR:%.*]], align 4
; GFX11-NEXT:    br label [[ATOMICRMW_START:%.*]]
; GFX11:       atomicrmw.start:
; GFX11-NEXT:    [[LOADED:%.*]] = phi float [ [[TMP1]], [[TMP0:%.*]] ], [ [[TMP6:%.*]], [[ATOMICRMW_START]] ]
; GFX11-NEXT:    [[NEW:%.*]] = fadd float [[LOADED]], [[VAL:%.*]]
; GFX11-NEXT:    [[TMP3:%.*]] = bitcast float [[NEW]] to i32
; GFX11-NEXT:    [[TMP4:%.*]] = bitcast float [[LOADED]] to i32
; GFX11-NEXT:    [[TMP5:%.*]] = cmpxchg ptr [[ADDR]], i32 [[TMP4]], i32 [[TMP3]] syncscope("workgroup") seq_cst seq_cst, align 4
; GFX11-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP5]], 1
; GFX11-NEXT:    [[NEWLOADED:%.*]] = extractvalue { i32, i1 } [[TMP5]], 0
; GFX11-NEXT:    [[TMP6]] = bitcast i32 [[NEWLOADED]] to float
; GFX11-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; GFX11:       atomicrmw.end:
; GFX11-NEXT:    ret float [[TMP6]]
  %res = atomicrmw fadd ptr %addr, float %val syncscope("workgroup") seq_cst
  ret float %res
}

attributes #0 = { "amdgpu-unsafe-fp-atomics"="true" }
