; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -disable-output "-passes=print<scalar-evolution>" < %s 2>&1 | FileCheck %s

declare i1 @cond()

define i32 @test_simple_case(i32 %start, i32 %len) {
; CHECK-LABEL: 'test_simple_case'
; CHECK-NEXT:  Classifying expressions for: @test_simple_case
; CHECK-NEXT:    %iv = phi i32 [ %start, %entry ], [ %iv.next, %backedge ]
; CHECK-NEXT:    --> {%start,+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.minus.1 = add i32 %iv, -1
; CHECK-NEXT:    --> {(-1 + %start),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.next = add i32 %iv, -1
; CHECK-NEXT:    --> {(-1 + %start),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %loop_cond = call i1 @cond()
; CHECK-NEXT:    --> %loop_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_simple_case
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: %start
; CHECK-NEXT:    exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is %start
; CHECK-NEXT:    symbolic max exit count for loop: %start
; CHECK-NEXT:    symbolic max exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    symbolic max exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next, %backedge]
  %zero_check = icmp ne i32 %iv, 0
  br i1 %zero_check, label %range_check_block, label %failed_1

range_check_block:
  %iv.minus.1 = add i32 %iv, -1
  %range_check = icmp ult i32 %iv.minus.1, %len
  br i1 %range_check, label %backedge, label %failed_2

backedge:
  %iv.next = add i32 %iv, -1
  %loop_cond = call i1 @cond()
  br i1 %loop_cond, label %done, label %loop

done:
  ret i32 %iv

failed_1:
  ret i32 -1

failed_2:
  ret i32 -2
}

define i32 @test_litter_conditions(i32 %start, i32 %len) {
; CHECK-LABEL: 'test_litter_conditions'
; CHECK-NEXT:  Classifying expressions for: @test_litter_conditions
; CHECK-NEXT:    %iv = phi i32 [ %start, %entry ], [ %iv.next, %backedge ]
; CHECK-NEXT:    --> {%start,+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %fake_1 = call i1 @cond()
; CHECK-NEXT:    --> %fake_1 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %and_1 = and i1 %zero_check, %fake_1
; CHECK-NEXT:    --> (%zero_check umin %fake_1) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.minus.1 = add i32 %iv, -1
; CHECK-NEXT:    --> {(-1 + %start),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %fake_2 = call i1 @cond()
; CHECK-NEXT:    --> %fake_2 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %and_2 = and i1 %range_check, %fake_2
; CHECK-NEXT:    --> (%range_check umin %fake_2) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.next = add i32 %iv, -1
; CHECK-NEXT:    --> {(-1 + %start),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %loop_cond = call i1 @cond()
; CHECK-NEXT:    --> %loop_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_litter_conditions
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is %start
; CHECK-NEXT:    symbolic max exit count for loop: %start
; CHECK-NEXT:    symbolic max exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    symbolic max exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next, %backedge]
  %zero_check = icmp ne i32 %iv, 0
  %fake_1 = call i1 @cond()
  %and_1 = and i1 %zero_check, %fake_1
  br i1 %and_1, label %range_check_block, label %failed_1

range_check_block:
  %iv.minus.1 = add i32 %iv, -1
  %range_check = icmp ult i32 %iv.minus.1, %len
  %fake_2 = call i1 @cond()
  %and_2 = and i1 %range_check, %fake_2
  br i1 %and_2, label %backedge, label %failed_2

backedge:
  %iv.next = add i32 %iv, -1
  %loop_cond = call i1 @cond()
  br i1 %loop_cond, label %done, label %loop

done:
  ret i32 %iv

failed_1:
  ret i32 -1

failed_2:
  ret i32 -2
}

define i32 @test_litter_conditions_bad_context(i32 %start, i32 %len) {
; CHECK-LABEL: 'test_litter_conditions_bad_context'
; CHECK-NEXT:  Classifying expressions for: @test_litter_conditions_bad_context
; CHECK-NEXT:    %iv = phi i32 [ %start, %entry ], [ %iv.next, %backedge ]
; CHECK-NEXT:    --> {%start,+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %fake_1 = call i1 @cond()
; CHECK-NEXT:    --> %fake_1 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %and_1 = and i1 %zero_check, %fake_1
; CHECK-NEXT:    --> (%zero_check umin %fake_1) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.minus.1 = add i32 %iv, -1
; CHECK-NEXT:    --> {(-1 + %start),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %fake_2 = call i1 @cond()
; CHECK-NEXT:    --> %fake_2 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %and_2 = and i1 %range_check, %fake_2
; CHECK-NEXT:    --> (%range_check umin %fake_2) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.next = add i32 %iv, -1
; CHECK-NEXT:    --> {(-1 + %start),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %loop_cond = call i1 @cond()
; CHECK-NEXT:    --> %loop_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_litter_conditions_bad_context
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is %start
; CHECK-NEXT:    symbolic max exit count for loop: %start
; CHECK-NEXT:    symbolic max exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    symbolic max exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next, %backedge]
  %zero_check = icmp ne i32 %iv, 0
  %fake_1 = call i1 @cond()
  %and_1 = and i1 %zero_check, %fake_1
  %iv.minus.1 = add i32 %iv, -1
  %range_check = icmp ult i32 %iv.minus.1, %len
  %fake_2 = call i1 @cond()
  %and_2 = and i1 %range_check, %fake_2
  br i1 %and_1, label %range_check_block, label %failed_1

range_check_block:
  br i1 %and_2, label %backedge, label %failed_2

backedge:
  %iv.next = add i32 %iv, -1
  %loop_cond = call i1 @cond()
  br i1 %loop_cond, label %done, label %loop

done:
  ret i32 %iv

failed_1:
  ret i32 -1

failed_2:
  ret i32 -2
}

define i32 @test_and_conditions(i32 %start, i32 %len) {
; CHECK-LABEL: 'test_and_conditions'
; CHECK-NEXT:  Classifying expressions for: @test_and_conditions
; CHECK-NEXT:    %iv = phi i32 [ %start, %entry ], [ %iv.next, %backedge ]
; CHECK-NEXT:    --> {%start,+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.minus.1 = add i32 %iv, -1
; CHECK-NEXT:    --> {(-1 + %start),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %both_checks = and i1 %zero_check, %range_check
; CHECK-NEXT:    --> (%range_check umin %zero_check) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.next = add i32 %iv, -1
; CHECK-NEXT:    --> {(-1 + %start),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %loop_cond = call i1 @cond()
; CHECK-NEXT:    --> %loop_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_and_conditions
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is %start
; CHECK-NEXT:    symbolic max exit count for loop: %start
; CHECK-NEXT:    symbolic max exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next, %backedge]
  %zero_check = icmp ne i32 %iv, 0
  %iv.minus.1 = add i32 %iv, -1
  %range_check = icmp ult i32 %iv.minus.1, %len
  %both_checks = and i1 %zero_check, %range_check
  br i1 %both_checks, label %backedge, label %failed

backedge:
  %iv.next = add i32 %iv, -1
  %loop_cond = call i1 @cond()
  br i1 %loop_cond, label %done, label %loop

done:
  ret i32 %iv

failed:
  ret i32 -3
}

define i32 @test_mixup_constant_symbolic(i32 %end, i32 %len) {
; CHECK-LABEL: 'test_mixup_constant_symbolic'
; CHECK-NEXT:  Classifying expressions for: @test_mixup_constant_symbolic
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.next, %backedge ]
; CHECK-NEXT:    --> {0,+,1}<%loop> U: [0,1001) S: [0,1001) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.next = add i32 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<%loop> U: [1,1002) S: [1,1002) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %loop_cond = call i1 @cond()
; CHECK-NEXT:    --> %loop_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_mixup_constant_symbolic
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: %end
; CHECK-NEXT:    exit count for range_check_block: 1000
; CHECK-NEXT:    exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 1000
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (1000 umin %end)
; CHECK-NEXT:    symbolic max exit count for loop: %end
; CHECK-NEXT:    symbolic max exit count for range_check_block: 1000
; CHECK-NEXT:    symbolic max exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [0, %entry], [%iv.next, %backedge]
  %zero_check = icmp ne i32 %iv, %end
  br i1 %zero_check, label %range_check_block, label %failed_1

range_check_block:
  %range_check = icmp ult i32 %iv, 1000
  br i1 %range_check, label %backedge, label %failed_2

backedge:
  %iv.next = add i32 %iv, 1
  %loop_cond = call i1 @cond()
  br i1 %loop_cond, label %done, label %loop

done:
  ret i32 %iv

failed_1:
  ret i32 -1

failed_2:
  ret i32 -2
}

define i32 @test_mixup_constant_symbolic_merged(i32 %end, i32 %len) {
; CHECK-LABEL: 'test_mixup_constant_symbolic_merged'
; CHECK-NEXT:  Classifying expressions for: @test_mixup_constant_symbolic_merged
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.next, %backedge ]
; CHECK-NEXT:    --> {0,+,1}<%loop> U: [0,1001) S: [0,1001) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %and = and i1 %zero_check, %range_check
; CHECK-NEXT:    --> (%range_check umin %zero_check) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.next = add i32 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<%loop> U: [1,1002) S: [1,1002) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %loop_cond = call i1 @cond()
; CHECK-NEXT:    --> %loop_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_mixup_constant_symbolic_merged
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: (1000 umin %end)
; CHECK-NEXT:    exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 1000
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (1000 umin %end)
; CHECK-NEXT:    symbolic max exit count for loop: (1000 umin %end)
; CHECK-NEXT:    symbolic max exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [0, %entry], [%iv.next, %backedge]
  %zero_check = icmp ne i32 %iv, %end
  %range_check = icmp ult i32 %iv, 1000
  %and = and i1 %zero_check, %range_check
  br i1 %and, label %backedge, label %failed_1

backedge:
  %iv.next = add i32 %iv, 1
  %loop_cond = call i1 @cond()
  br i1 %loop_cond, label %done, label %loop

done:
  ret i32 %iv

failed_1:
  ret i32 -1
}

define i32 @test_two_phis(i32 %start_1, i32 %start_2, i32 %len) {
; CHECK-LABEL: 'test_two_phis'
; CHECK-NEXT:  Classifying expressions for: @test_two_phis
; CHECK-NEXT:    %iv_1 = phi i32 [ %start_1, %entry ], [ %iv_1.next, %backedge ]
; CHECK-NEXT:    --> {%start_1,+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_2 = phi i32 [ %start_2, %entry ], [ %iv_2.next, %backedge ]
; CHECK-NEXT:    --> {%start_2,+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %scam_1 = call i1 @cond()
; CHECK-NEXT:    --> %scam_1 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %c1 = and i1 %zero_check_1, %scam_1
; CHECK-NEXT:    --> (%zero_check_1 umin %scam_1) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %scam_2 = call i1 @cond()
; CHECK-NEXT:    --> %scam_2 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %c2 = and i1 %zero_check_2, %scam_2
; CHECK-NEXT:    --> (%zero_check_2 umin %scam_2) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.minus.1 = add i32 %iv_1, -1
; CHECK-NEXT:    --> {(-1 + %start_1),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_1.next = add i32 %iv_1, -1
; CHECK-NEXT:    --> {(-1 + %start_1),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_2.next = add i32 %iv_2, -1
; CHECK-NEXT:    --> {(-1 + %start_2),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %loop_cond = call i1 @cond()
; CHECK-NEXT:    --> %loop_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_two_phis
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for zero_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (%start_1 umin_seq %start_2)
; CHECK-NEXT:    symbolic max exit count for loop: %start_1
; CHECK-NEXT:    symbolic max exit count for zero_check_block: %start_2
; CHECK-NEXT:    symbolic max exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    symbolic max exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv_1 = phi i32 [%start_1, %entry], [%iv_1.next, %backedge]
  %iv_2 = phi i32 [%start_2, %entry], [%iv_2.next, %backedge]
  %scam_1 = call i1 @cond()
  %zero_check_1 = icmp ne i32 %iv_1, 0
  %c1 = and i1 %zero_check_1, %scam_1
  br i1 %c1, label %zero_check_block, label %failed_1

zero_check_block:
  %scam_2 = call i1 @cond()
  %zero_check_2 = icmp ne i32 %iv_2, 0
  %c2 = and i1 %zero_check_2, %scam_2
  br i1 %c2, label %range_check_block, label %failed_1

range_check_block:
  %iv.minus.1 = add i32 %iv_1, -1
  %range_check = icmp ult i32 %iv.minus.1, %len
  br i1 %range_check, label %backedge, label %failed_2

backedge:
  %iv_1.next = add i32 %iv_1, -1
  %iv_2.next = add i32 %iv_2, -1
  %loop_cond = call i1 @cond()
  br i1 %loop_cond, label %done, label %loop

done:
  ret i32 %iv_2

failed_1:
  ret i32 -1

failed_2:
  ret i32 -2
}

define i32 @test_two_phis_simple(i32 %start_1, i32 %start_2, i32 %len) {
; CHECK-LABEL: 'test_two_phis_simple'
; CHECK-NEXT:  Classifying expressions for: @test_two_phis_simple
; CHECK-NEXT:    %iv_1 = phi i32 [ %start_1, %entry ], [ %iv_1.next, %backedge ]
; CHECK-NEXT:    --> {%start_1,+,-1}<%loop> U: full-set S: full-set Exits: ((-1 * (%start_1 umin_seq %start_2)) + %start_1) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_2 = phi i32 [ %start_2, %entry ], [ %iv_2.next, %backedge ]
; CHECK-NEXT:    --> {%start_2,+,-1}<%loop> U: full-set S: full-set Exits: ((-1 * (%start_1 umin_seq %start_2)) + %start_2) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_1.next = add i32 %iv_1, -1
; CHECK-NEXT:    --> {(-1 + %start_1),+,-1}<%loop> U: full-set S: full-set Exits: (-1 + (-1 * (%start_1 umin_seq %start_2)) + %start_1) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_2.next = add i32 %iv_2, -1
; CHECK-NEXT:    --> {(-1 + %start_2),+,-1}<%loop> U: full-set S: full-set Exits: (-1 + (-1 * (%start_1 umin_seq %start_2)) + %start_2) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_two_phis_simple
; CHECK-NEXT:  Loop %loop: <multiple exits> backedge-taken count is (%start_1 umin_seq %start_2)
; CHECK-NEXT:    exit count for loop: %start_1
; CHECK-NEXT:    exit count for backedge: %start_2
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (%start_1 umin_seq %start_2)
; CHECK-NEXT:    symbolic max exit count for loop: %start_1
; CHECK-NEXT:    symbolic max exit count for backedge: %start_2
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is (%start_1 umin_seq %start_2)
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %loop: Trip multiple is 1
;
entry:
  br label %loop

loop:
  %iv_1 = phi i32 [%start_1, %entry], [%iv_1.next, %backedge]
  %iv_2 = phi i32 [%start_2, %entry], [%iv_2.next, %backedge]
  %zero_check_1 = icmp ne i32 %iv_1, 0
  br i1 %zero_check_1, label %backedge, label %exit

backedge:
  %zero_check_2 = icmp ne i32 %iv_2, 0
  %iv_1.next = add i32 %iv_1, -1
  %iv_2.next = add i32 %iv_2, -1
  br i1 %zero_check_2, label %loop, label %exit

exit:
  ret i32 0
}

define i32 @test_two_phis_arithmetic_and(i32 %start_1, i32 %start_2, i32 %len) {
; CHECK-LABEL: 'test_two_phis_arithmetic_and'
; CHECK-NEXT:  Classifying expressions for: @test_two_phis_arithmetic_and
; CHECK-NEXT:    %iv_1 = phi i32 [ %start_1, %entry ], [ %iv_1.next, %backedge ]
; CHECK-NEXT:    --> {%start_1,+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_2 = phi i32 [ %start_2, %entry ], [ %iv_2.next, %backedge ]
; CHECK-NEXT:    --> {%start_2,+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %scam_1 = call i1 @cond()
; CHECK-NEXT:    --> %scam_1 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %c1 = and i1 %zero_check_1, %scam_1
; CHECK-NEXT:    --> (%zero_check_1 umin %scam_1) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %scam_2 = call i1 @cond()
; CHECK-NEXT:    --> %scam_2 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %c2 = and i1 %zero_check_2, %scam_2
; CHECK-NEXT:    --> (%zero_check_2 umin %scam_2) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %merged_cond = and i1 %c1, %c2
; CHECK-NEXT:    --> (%zero_check_1 umin %zero_check_2 umin %scam_1 umin %scam_2) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.minus.1 = add i32 %iv_1, -1
; CHECK-NEXT:    --> {(-1 + %start_1),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_1.next = add i32 %iv_1, -1
; CHECK-NEXT:    --> {(-1 + %start_1),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_2.next = add i32 %iv_2, -1
; CHECK-NEXT:    --> {(-1 + %start_2),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %loop_cond = call i1 @cond()
; CHECK-NEXT:    --> %loop_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_two_phis_arithmetic_and
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (%start_1 umin %start_2)
; CHECK-NEXT:    symbolic max exit count for loop: (%start_1 umin %start_2)
; CHECK-NEXT:    symbolic max exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    symbolic max exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv_1 = phi i32 [%start_1, %entry], [%iv_1.next, %backedge]
  %iv_2 = phi i32 [%start_2, %entry], [%iv_2.next, %backedge]
  %scam_1 = call i1 @cond()
  %zero_check_1 = icmp ne i32 %iv_1, 0
  %c1 = and i1 %zero_check_1, %scam_1
  %scam_2 = call i1 @cond()
  %zero_check_2 = icmp ne i32 %iv_2, 0
  %c2 = and i1 %zero_check_2, %scam_2
  %merged_cond = and i1 %c1, %c2
  br i1 %merged_cond, label %range_check_block, label %failed_1

range_check_block:
  %iv.minus.1 = add i32 %iv_1, -1
  %range_check = icmp ult i32 %iv.minus.1, %len
  br i1 %range_check, label %backedge, label %failed_2

backedge:
  %iv_1.next = add i32 %iv_1, -1
  %iv_2.next = add i32 %iv_2, -1
  %loop_cond = call i1 @cond()
  br i1 %loop_cond, label %done, label %loop

done:
  ret i32 %iv_2

failed_1:
  ret i32 -1

failed_2:
  ret i32 -2
}

; TODO: Symbolic max can be start1 umax_seq start2
define i32 @test_two_phis_logical_or(i32 %start_1, i32 %start_2, i32 %len) {
; CHECK-LABEL: 'test_two_phis_logical_or'
; CHECK-NEXT:  Classifying expressions for: @test_two_phis_logical_or
; CHECK-NEXT:    %iv_1 = phi i32 [ %start_1, %entry ], [ %iv_1.next, %backedge ]
; CHECK-NEXT:    --> {%start_1,+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_2 = phi i32 [ %start_2, %entry ], [ %iv_2.next, %backedge ]
; CHECK-NEXT:    --> {%start_2,+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %scam_1 = call i1 @cond()
; CHECK-NEXT:    --> %scam_1 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %c1 = and i1 %zero_check_1, %scam_1
; CHECK-NEXT:    --> (%zero_check_1 umin %scam_1) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %scam_2 = call i1 @cond()
; CHECK-NEXT:    --> %scam_2 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %c2 = and i1 %zero_check_2, %scam_2
; CHECK-NEXT:    --> (%zero_check_2 umin %scam_2) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %merged_cond = select i1 %c1, i1 true, i1 %c2
; CHECK-NEXT:    --> (true + ((true + (%zero_check_1 umin %scam_1)) umin_seq (true + (%zero_check_2 umin %scam_2)))) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.minus.1 = add i32 %iv_1, -1
; CHECK-NEXT:    --> {(-1 + %start_1),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_1.next = add i32 %iv_1, -1
; CHECK-NEXT:    --> {(-1 + %start_1),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_2.next = add i32 %iv_2, -1
; CHECK-NEXT:    --> {(-1 + %start_2),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %loop_cond = call i1 @cond()
; CHECK-NEXT:    --> %loop_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_two_phis_logical_or
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:    symbolic max exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    symbolic max exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    symbolic max exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv_1 = phi i32 [%start_1, %entry], [%iv_1.next, %backedge]
  %iv_2 = phi i32 [%start_2, %entry], [%iv_2.next, %backedge]
  %scam_1 = call i1 @cond()
  %zero_check_1 = icmp ne i32 %iv_1, 0
  %c1 = and i1 %zero_check_1, %scam_1
  %scam_2 = call i1 @cond()
  %zero_check_2 = icmp ne i32 %iv_2, 0
  %c2 = and i1 %zero_check_2, %scam_2
  %merged_cond = select i1 %c1, i1 true, i1 %c2
  br i1 %merged_cond, label %range_check_block, label %failed_1

range_check_block:
  %iv.minus.1 = add i32 %iv_1, -1
  %range_check = icmp ult i32 %iv.minus.1, %len
  br i1 %range_check, label %backedge, label %failed_2

backedge:
  %iv_1.next = add i32 %iv_1, -1
  %iv_2.next = add i32 %iv_2, -1
  %loop_cond = call i1 @cond()
  br i1 %loop_cond, label %done, label %loop

done:
  ret i32 %iv_2

failed_1:
  ret i32 -1

failed_2:
  ret i32 -2
}

define i32 @test_two_phis_logical_and(i32 %start_1, i32 %start_2, i32 %len) {
; CHECK-LABEL: 'test_two_phis_logical_and'
; CHECK-NEXT:  Classifying expressions for: @test_two_phis_logical_and
; CHECK-NEXT:    %iv_1 = phi i32 [ %start_1, %entry ], [ %iv_1.next, %backedge ]
; CHECK-NEXT:    --> {%start_1,+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_2 = phi i32 [ %start_2, %entry ], [ %iv_2.next, %backedge ]
; CHECK-NEXT:    --> {%start_2,+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %scam_1 = call i1 @cond()
; CHECK-NEXT:    --> %scam_1 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %c1 = and i1 %zero_check_1, %scam_1
; CHECK-NEXT:    --> (%zero_check_1 umin %scam_1) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %scam_2 = call i1 @cond()
; CHECK-NEXT:    --> %scam_2 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %c2 = and i1 %zero_check_2, %scam_2
; CHECK-NEXT:    --> (%zero_check_2 umin %scam_2) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %merged_cond = select i1 %c1, i1 %c2, i1 false
; CHECK-NEXT:    --> ((%zero_check_1 umin %scam_1) umin_seq (%zero_check_2 umin %scam_2)) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.minus.1 = add i32 %iv_1, -1
; CHECK-NEXT:    --> {(-1 + %start_1),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_1.next = add i32 %iv_1, -1
; CHECK-NEXT:    --> {(-1 + %start_1),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv_2.next = add i32 %iv_2, -1
; CHECK-NEXT:    --> {(-1 + %start_2),+,-1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %loop_cond = call i1 @cond()
; CHECK-NEXT:    --> %loop_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_two_phis_logical_and
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for loop: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (%start_1 umin_seq %start_2)
; CHECK-NEXT:    symbolic max exit count for loop: (%start_1 umin_seq %start_2)
; CHECK-NEXT:    symbolic max exit count for range_check_block: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    symbolic max exit count for backedge: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv_1 = phi i32 [%start_1, %entry], [%iv_1.next, %backedge]
  %iv_2 = phi i32 [%start_2, %entry], [%iv_2.next, %backedge]
  %scam_1 = call i1 @cond()
  %zero_check_1 = icmp ne i32 %iv_1, 0
  %c1 = and i1 %zero_check_1, %scam_1
  %scam_2 = call i1 @cond()
  %zero_check_2 = icmp ne i32 %iv_2, 0
  %c2 = and i1 %zero_check_2, %scam_2
  %merged_cond = select i1 %c1, i1 %c2, i1 false
  br i1 %merged_cond, label %range_check_block, label %failed_1

range_check_block:
  %iv.minus.1 = add i32 %iv_1, -1
  %range_check = icmp ult i32 %iv.minus.1, %len
  br i1 %range_check, label %backedge, label %failed_2

backedge:
  %iv_1.next = add i32 %iv_1, -1
  %iv_2.next = add i32 %iv_2, -1
  %loop_cond = call i1 @cond()
  br i1 %loop_cond, label %done, label %loop

done:
  ret i32 %iv_2

failed_1:
  ret i32 -1

failed_2:
  ret i32 -2
}
