/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright(c) 2021 3snic Technologies Co., Ltd */

#ifndef SSS_CSR_H
#define SSS_CSR_H

#define SSS_CSR_CFG_FLAG			0x40000000

#define SSS_MGMT_FLAG			0xC0000000

#define SSS_CSR_FLAG_MASK			0x3FFFFFFF

#define SSS_VF_CFG_REG_OFFSET		0x2000

#define SSS_HOST_CSR_BASE_ADDR		(SSS_MGMT_FLAG + 0x6000)
#define SSS_CSR_GLOBAL_BASE_ADDR	(SSS_MGMT_FLAG + 0x6400)

/* HW interface registers */
#define SSS_CSR_HW_ATTR0_ADDR		(SSS_CSR_CFG_FLAG + 0x0)
#define SSS_CSR_HW_ATTR1_ADDR		(SSS_CSR_CFG_FLAG + 0x4)
#define SSS_CSR_HW_ATTR2_ADDR		(SSS_CSR_CFG_FLAG + 0x8)
#define SSS_CSR_HW_ATTR3_ADDR		(SSS_CSR_CFG_FLAG + 0xC)
#define SSS_CSR_HW_ATTR4_ADDR		(SSS_CSR_CFG_FLAG + 0x10)
#define SSS_CSR_HW_ATTR5_ADDR		(SSS_CSR_CFG_FLAG + 0x14)
#define SSS_CSR_HW_ATTR6_ADDR		(SSS_CSR_CFG_FLAG + 0x18)

#define SSS_HW_CSR_MBX_DATA_OFF		0x80
#define SSS_HW_CSR_MBX_CTRL_OFF	(SSS_CSR_CFG_FLAG + 0x0100)
#define SSS_HW_CSR_MBX_INT_OFFSET_OFF	(SSS_CSR_CFG_FLAG + 0x0104)
#define SSS_HW_CSR_MBX_RES_H_OFF	(SSS_CSR_CFG_FLAG + 0x0108)
#define SSS_HW_CSR_MBX_RES_L_OFF	(SSS_CSR_CFG_FLAG + 0x010C)

#define SSS_PPF_ELECT_OFF		0x0
#define SSS_MPF_ELECT_OFF		0x20

#define SSS_CSR_PPF_ELECT_ADDR			\
			(SSS_HOST_CSR_BASE_ADDR + SSS_PPF_ELECT_OFF)

#define SSS_CSR_GLOBAL_MPF_ELECT_ADDR	\
			(SSS_HOST_CSR_BASE_ADDR + SSS_MPF_ELECT_OFF)

#define SSS_CSR_HW_PPF_ELECT_BASE_ADDR	(SSS_CSR_CFG_FLAG + 0x60)
#define SSS_CSR_HW_PPF_ELECT_PORT_STRIDE	0x4

#define SSS_CSR_FUNC_PPF_ELECT(host_id)	\
	(SSS_CSR_HW_PPF_ELECT_BASE_ADDR +	\
	(host_id) * SSS_CSR_HW_PPF_ELECT_PORT_STRIDE)

#define SSS_CSR_DMA_ATTR_TBL_ADDR		(SSS_CSR_CFG_FLAG + 0x380)
#define SSS_CSR_DMA_ATTR_INDIR_ID_ADDR	(SSS_CSR_CFG_FLAG + 0x390)

/* MSI-X registers */
#define SSS_CSR_MSIX_INDIR_ID_ADDR		(SSS_CSR_CFG_FLAG + 0x310)
#define SSS_CSR_MSIX_CTRL_ADDR			(SSS_CSR_CFG_FLAG + 0x300)
#define SSS_CSR_MSIX_CNT_ADDR			(SSS_CSR_CFG_FLAG +	0x304)
#define SSS_CSR_FUNC_MSI_CLR_WR_ADDR	(SSS_CSR_CFG_FLAG + 0x58)

#define SSS_MSI_CLR_INDIR_RESEND_TIMER_CLR_SHIFT	0
#define SSS_MSI_CLR_INDIR_INT_MSK_SET_SHIFT			1
#define SSS_MSI_CLR_INDIR_INT_MSK_CLR_SHIFT			2
#define SSS_MSI_CLR_INDIR_AUTO_MSK_SET_SHIFT		3
#define SSS_MSI_CLR_INDIR_AUTO_MSK_CLR_SHIFT		4
#define SSS_MSI_CLR_INDIR_SIMPLE_INDIR_ID_SHIFT		22

#define SSS_MSI_CLR_INDIR_RESEND_TIMER_CLR_MASK		0x1U
#define SSS_MSI_CLR_INDIR_INT_MSK_SET_MASK			0x1U
#define SSS_MSI_CLR_INDIR_INT_MSK_CLR_MASK			0x1U
#define SSS_MSI_CLR_INDIR_AUTO_MSK_SET_MASK			0x1U
#define SSS_MSI_CLR_INDIR_AUTO_MSK_CLR_MASK			0x1U
#define SSS_MSI_CLR_INDIR_SIMPLE_INDIR_ID_MASK		0x3FFU

#define SSS_SET_MSI_CLR_INDIR(val, member)			\
		(((val) & SSS_MSI_CLR_INDIR_##member##_MASK) << \
		SSS_MSI_CLR_INDIR_##member##_SHIFT)

/* EQ registers */
#define SSS_AEQ_INDIR_ID_ADDR		(SSS_CSR_CFG_FLAG + 0x210)
#define SSS_CEQ_INDIR_ID_ADDR		(SSS_CSR_CFG_FLAG + 0x290)

#define SSS_EQ_INDIR_ID_ADDR(type) \
		((type == SSS_AEQ) ? SSS_AEQ_INDIR_ID_ADDR : SSS_CEQ_INDIR_ID_ADDR)

#define SSS_AEQ_MTT_OFF_BASE_ADDR			(SSS_CSR_CFG_FLAG + 0x240)
#define SSS_CEQ_MTT_OFF_BASE_ADDR			(SSS_CSR_CFG_FLAG + 0x2C0)

#define SSS_CSR_EQ_PAGE_OFF_STRIDE			8

#define SSS_AEQ_PHY_HI_ADDR_REG(pg_num)	\
		(SSS_AEQ_MTT_OFF_BASE_ADDR + (pg_num) * SSS_CSR_EQ_PAGE_OFF_STRIDE)

#define SSS_AEQ_PHY_LO_ADDR_REG(pg_num)	\
		(SSS_AEQ_MTT_OFF_BASE_ADDR + (pg_num) * SSS_CSR_EQ_PAGE_OFF_STRIDE + 4)

#define SSS_CEQ_PHY_HI_ADDR_REG(pg_num)	\
		(SSS_CEQ_MTT_OFF_BASE_ADDR + (pg_num) * SSS_CSR_EQ_PAGE_OFF_STRIDE)

#define SSS_CEQ_PHY_LO_ADDR_REG(pg_num)	\
		(SSS_CEQ_MTT_OFF_BASE_ADDR + \
		(pg_num) * SSS_CSR_EQ_PAGE_OFF_STRIDE + 4)

#define SSS_CSR_AEQ_CTRL_0_ADDR				(SSS_CSR_CFG_FLAG + 0x200)
#define SSS_CSR_AEQ_CTRL_1_ADDR				(SSS_CSR_CFG_FLAG + 0x204)
#define SSS_CSR_AEQ_CI_ADDR					(SSS_CSR_CFG_FLAG + 0x208)
#define SSS_CSR_AEQ_PI_ADDR					(SSS_CSR_CFG_FLAG + 0x20C)
#define SSS_CSR_AEQ_CI_SIMPLE_INDIR_ADDR	(SSS_CSR_CFG_FLAG + 0x50)

#define SSS_CSR_CEQ_CTRL_0_ADDR				(SSS_CSR_CFG_FLAG + 0x280)
#define SSS_CSR_CEQ_CTRL_1_ADDR				(SSS_CSR_CFG_FLAG + 0x284)
#define SSS_CSR_CEQ_CI_ADDR					(SSS_CSR_CFG_FLAG + 0x288)
#define SSS_CSR_CEQ_PI_ADDR					(SSS_CSR_CFG_FLAG + 0x28c)
#define SSS_CSR_CEQ_CI_SIMPLE_INDIR_ADDR	(SSS_CSR_CFG_FLAG + 0x54)

/* ADM MSG registers */
#define SSS_CSR_ADM_MSG_BASE				(SSS_MGMT_FLAG + 0x2000)

#define SSS_CSR_ADM_MSG_STRIDE				0x80

#define SSS_CSR_ADM_MSG_HEAD_HI_ADDR(id)	\
	(SSS_CSR_ADM_MSG_BASE + 0x0 + (id) * SSS_CSR_ADM_MSG_STRIDE)

#define SSS_CSR_ADM_MSG_HEAD_LO_ADDR(id)	\
	(SSS_CSR_ADM_MSG_BASE + 0x4 + (id) * SSS_CSR_ADM_MSG_STRIDE)

#define SSS_CSR_ADM_MSG_STATE_HI_ADDR(id)		\
	(SSS_CSR_ADM_MSG_BASE + 0x8 + (id) * SSS_CSR_ADM_MSG_STRIDE)

#define SSS_CSR_ADM_MSG_STATE_LO_ADDR(id)		\
	(SSS_CSR_ADM_MSG_BASE + 0xC + (id) * SSS_CSR_ADM_MSG_STRIDE)

#define SSS_CSR_ADM_MSG_NUM_ELEM_ADDR(id)	\
	(SSS_CSR_ADM_MSG_BASE + 0x10 + (id) * SSS_CSR_ADM_MSG_STRIDE)

#define SSS_CSR_ADM_MSG_CTRL_ADDR(id)		\
	(SSS_CSR_ADM_MSG_BASE + 0x14 + (id) * SSS_CSR_ADM_MSG_STRIDE)

#define SSS_CSR_ADM_MSG_PI_ADDR(id)		\
	(SSS_CSR_ADM_MSG_BASE + 0x1C + (id) * SSS_CSR_ADM_MSG_STRIDE)

#define SSS_CSR_ADM_MSG_REQ_ADDR(id)		\
	(SSS_CSR_ADM_MSG_BASE + 0x20 + (id) * SSS_CSR_ADM_MSG_STRIDE)

#define SSS_CSR_ADM_MSG_STATE_0_ADDR(id)		\
	(SSS_CSR_ADM_MSG_BASE + 0x30 + (id) * SSS_CSR_ADM_MSG_STRIDE)

/* self test register */
#define SSS_MGMT_HEALTH_STATUS_ADDR		(SSS_MGMT_FLAG + 0x983c)

#define SSS_CHIP_BASE_INFO_ADDR			(SSS_MGMT_FLAG + 0xB02C)

#define SSS_CHIP_ERR_STATUS0_ADDR		(SSS_MGMT_FLAG + 0xC0EC)
#define SSS_CHIP_ERR_STATUS1_ADDR		(SSS_MGMT_FLAG + 0xC0F0)

#define SSS_ERR_INFO0_ADDR		(SSS_MGMT_FLAG + 0xC0F4)
#define SSS_ERR_INFO1_ADDR		(SSS_MGMT_FLAG + 0xC0F8)
#define SSS_ERR_INFO2_ADDR		(SSS_MGMT_FLAG + 0xC0FC)

#endif
