/*
 * Copyright (c) 2024 OceanBase.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package utils

import "strings"

func ContainsString(list []string, item string) bool {
	for _, v := range list {
		if v == item {
			return true
		}
	}
	return false
}

func SliceEqual(list1, list2 []string) bool {
	if len(list1) != len(list2) {
		return false
	}
	for _, v := range list1 {
		if !ContainsString(list2, v) {
			return false
		}
	}
	return true
}

func ContainsPrefix(prefix []string, s string) bool {
	for _, pre := range prefix {
		if strings.HasPrefix(s, pre) {
			return true
		}
	}
	return false
}
