; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

define <vscale x 8 x half> @fadd_h_immhalf(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fadd_h_immhalf:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fadd.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}


define <vscale x 8 x half> @fadd_h_immhalf_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fadd_h_immhalf_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fadd.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a_z,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fadd_h_immone(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fadd_h_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fadd.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fadd_h_immone_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fadd_h_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fadd.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a_z,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 4 x float> @fadd_s_immhalf(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fadd_s_immhalf:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fadd.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fadd_s_immhalf_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fadd_s_immhalf_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fadd.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a_z,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fadd_s_immone(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fadd_s_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fadd.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fadd_s_immone_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fadd_s_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fadd.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a_z,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 2 x double> @fadd_d_immhalf(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fadd_d_immhalf:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fadd.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fadd_d_immhalf_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fadd_d_immhalf_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fadd.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a_z,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fadd_d_immone(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fadd_d_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fadd.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fadd_d_immone_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fadd_d_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fadd.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a_z,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 8 x half> @fmax_h_immzero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fmax_h_immzero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmax z0.h, p0/m, z0.h, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmax.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fmax_h_immzero_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fmax_h_immzero_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fmax z0.h, p0/m, z0.h, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmax.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a_z,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fmax_h_immone(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fmax_h_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmax z0.h, p0/m, z0.h, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmax.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fmax_h_immone_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fmax_h_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fmax z0.h, p0/m, z0.h, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmax.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a_z,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 4 x float> @fmax_s_immzero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fmax_s_immzero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmax z0.s, p0/m, z0.s, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmax.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fmax_s_immzero_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fmax_s_immzero_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fmax z0.s, p0/m, z0.s, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmax.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a_z,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fmax_s_immone(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fmax_s_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmax z0.s, p0/m, z0.s, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmax.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fmax_s_immone_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fmax_s_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fmax z0.s, p0/m, z0.s, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmax.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a_z,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 2 x double> @fmax_d_immzero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fmax_d_immzero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmax z0.d, p0/m, z0.d, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmax.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fmax_d_immzero_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fmax_d_immzero_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fmax z0.d, p0/m, z0.d, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmax.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a_z,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fmax_d_immone(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fmax_d_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmax z0.d, p0/m, z0.d, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmax.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fmax_d_immone_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fmax_d_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fmax z0.d, p0/m, z0.d, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmax.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a_z,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 8 x half> @fmaxnm_h_immzero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fmaxnm_h_immzero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmaxnm z0.h, p0/m, z0.h, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmaxnm.nxv8f16(<vscale x 8 x i1> %pg,
                                                              <vscale x 8 x half> %a,
                                                              <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fmaxnm_h_immzero_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fmaxnm_h_immzero_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fmaxnm z0.h, p0/m, z0.h, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmaxnm.nxv8f16(<vscale x 8 x i1> %pg,
                                                              <vscale x 8 x half> %a_z,
                                                              <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fmaxnm_h_immone(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fmaxnm_h_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmaxnm z0.h, p0/m, z0.h, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmaxnm.nxv8f16(<vscale x 8 x i1> %pg,
                                                              <vscale x 8 x half> %a,
                                                              <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fmaxnm_h_immone_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fmaxnm_h_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fmaxnm z0.h, p0/m, z0.h, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmaxnm.nxv8f16(<vscale x 8 x i1> %pg,
                                                              <vscale x 8 x half> %a_z,
                                                              <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 4 x float> @fmaxnm_s_immzero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fmaxnm_s_immzero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmaxnm z0.s, p0/m, z0.s, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmaxnm.nxv4f32(<vscale x 4 x i1> %pg,
                                                               <vscale x 4 x float> %a,
                                                               <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fmaxnm_s_immzero_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fmaxnm_s_immzero_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fmaxnm z0.s, p0/m, z0.s, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmaxnm.nxv4f32(<vscale x 4 x i1> %pg,
                                                               <vscale x 4 x float> %a_z,
                                                               <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fmaxnm_s_immone(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fmaxnm_s_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmaxnm z0.s, p0/m, z0.s, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmaxnm.nxv4f32(<vscale x 4 x i1> %pg,
                                                               <vscale x 4 x float> %a,
                                                               <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fmaxnm_s_immone_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fmaxnm_s_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fmaxnm z0.s, p0/m, z0.s, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmaxnm.nxv4f32(<vscale x 4 x i1> %pg,
                                                               <vscale x 4 x float> %a_z,
                                                               <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 2 x double> @fmaxnm_d_immzero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fmaxnm_d_immzero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmaxnm z0.d, p0/m, z0.d, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmaxnm.nxv2f64(<vscale x 2 x i1> %pg,
                                                                <vscale x 2 x double> %a,
                                                                <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fmaxnm_d_immzero_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fmaxnm_d_immzero_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fmaxnm z0.d, p0/m, z0.d, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmaxnm.nxv2f64(<vscale x 2 x i1> %pg,
                                                                <vscale x 2 x double> %a_z,
                                                                <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fmaxnm_d_immone(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fmaxnm_d_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmaxnm z0.d, p0/m, z0.d, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmaxnm.nxv2f64(<vscale x 2 x i1> %pg,
                                                                <vscale x 2 x double> %a,
                                                                <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fmaxnm_d_immone_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fmaxnm_d_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fmaxnm z0.d, p0/m, z0.d, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmaxnm.nxv2f64(<vscale x 2 x i1> %pg,
                                                                <vscale x 2 x double> %a_z,
                                                                <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 8 x half> @fmin_h_immzero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fmin_h_immzero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmin z0.h, p0/m, z0.h, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmin.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fmin_h_immzero_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fmin_h_immzero_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fmin z0.h, p0/m, z0.h, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmin.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a_z,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fmin_h_immone(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fmin_h_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmin z0.h, p0/m, z0.h, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmin.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fmin_h_immone_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fmin_h_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fmin z0.h, p0/m, z0.h, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmin.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a_z,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 4 x float> @fmin_s_immzero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fmin_s_immzero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmin z0.s, p0/m, z0.s, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmin.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fmin_s_immzero_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fmin_s_immzero_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fmin z0.s, p0/m, z0.s, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmin.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a_z,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fmin_s_immone(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fmin_s_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmin z0.s, p0/m, z0.s, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmin.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fmin_s_immone_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fmin_s_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fmin z0.s, p0/m, z0.s, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmin.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a_z,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 2 x double> @fmin_d_immzero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fmin_d_immzero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmin z0.d, p0/m, z0.d, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmin.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fmin_d_immzero_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fmin_d_immzero_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fmin z0.d, p0/m, z0.d, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmin.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a_z,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fmin_d_immone(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fmin_d_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmin z0.d, p0/m, z0.d, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmin.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fmin_d_immone_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fmin_d_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fmin z0.d, p0/m, z0.d, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmin.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a_z,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 8 x half> @fminnm_h_immzero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fminnm_h_immzero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fminnm z0.h, p0/m, z0.h, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fminnm.nxv8f16(<vscale x 8 x i1> %pg,
                                                              <vscale x 8 x half> %a,
                                                              <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fminnm_h_immzero_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fminnm_h_immzero_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fminnm z0.h, p0/m, z0.h, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fminnm.nxv8f16(<vscale x 8 x i1> %pg,
                                                              <vscale x 8 x half> %a_z,
                                                              <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fminnm_h_immone(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fminnm_h_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fminnm z0.h, p0/m, z0.h, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fminnm.nxv8f16(<vscale x 8 x i1> %pg,
                                                              <vscale x 8 x half> %a,
                                                              <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fminnm_h_immone_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fminnm_h_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fminnm z0.h, p0/m, z0.h, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fminnm.nxv8f16(<vscale x 8 x i1> %pg,
                                                              <vscale x 8 x half> %a_z,
                                                              <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 4 x float> @fminnm_s_immzero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fminnm_s_immzero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fminnm z0.s, p0/m, z0.s, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fminnm.nxv4f32(<vscale x 4 x i1> %pg,
                                                               <vscale x 4 x float> %a,
                                                               <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fminnm_s_immzero_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fminnm_s_immzero_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fminnm z0.s, p0/m, z0.s, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fminnm.nxv4f32(<vscale x 4 x i1> %pg,
                                                               <vscale x 4 x float> %a_z,
                                                               <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fminnm_s_immone(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fminnm_s_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fminnm z0.s, p0/m, z0.s, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fminnm.nxv4f32(<vscale x 4 x i1> %pg,
                                                               <vscale x 4 x float> %a,
                                                               <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fminnm_s_immone_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fminnm_s_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fminnm z0.s, p0/m, z0.s, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fminnm.nxv4f32(<vscale x 4 x i1> %pg,
                                                               <vscale x 4 x float> %a_z,
                                                               <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 2 x double> @fminnm_d_immzero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fminnm_d_immzero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fminnm z0.d, p0/m, z0.d, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fminnm.nxv2f64(<vscale x 2 x i1> %pg,
                                                                <vscale x 2 x double> %a,
                                                                <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fminnm_d_immzero_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fminnm_d_immzero_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fminnm z0.d, p0/m, z0.d, #0.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fminnm.nxv2f64(<vscale x 2 x i1> %pg,
                                                                <vscale x 2 x double> %a_z,
                                                                <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fminnm_d_immone(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fminnm_d_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fminnm z0.d, p0/m, z0.d, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fminnm.nxv2f64(<vscale x 2 x i1> %pg,
                                                                <vscale x 2 x double> %a,
                                                                <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fminnm_d_immone_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fminnm_d_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fminnm z0.d, p0/m, z0.d, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fminnm.nxv2f64(<vscale x 2 x i1> %pg,
                                                                <vscale x 2 x double> %a_z,
                                                                <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 8 x half> @fmul_h_immhalf(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fmul_h_immhalf:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmul.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fmul_h_immhalf_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fmul_h_immhalf_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmul.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a_z,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fmul_h_immtwo(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fmul_h_immtwo:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, #2.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 2.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmul.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fmul_h_immtwo_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fmul_h_immtwo_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, #2.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 2.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fmul.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a_z,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 4 x float> @fmul_s_immhalf(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fmul_s_immhalf:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul z0.s, p0/m, z0.s, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmul.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fmul_s_immhalf_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fmul_s_immhalf_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fmul z0.s, p0/m, z0.s, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmul.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a_z,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fmul_s_immtwo(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fmul_s_immtwo:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul z0.s, p0/m, z0.s, #2.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 2.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmul.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fmul_s_immtwo_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fmul_s_immtwo_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fmul z0.s, p0/m, z0.s, #2.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 2.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fmul.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a_z,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 2 x double> @fmul_d_immhalf(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fmul_d_immhalf:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul z0.d, p0/m, z0.d, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmul.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fmul_d_immhalf_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fmul_d_immhalf_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fmul z0.d, p0/m, z0.d, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmul.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a_z,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fmul_d_immtwo(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fmul_d_immtwo:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul z0.d, p0/m, z0.d, #2.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 2.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmul.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fmul_d_immtwo_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fmul_d_immtwo_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fmul z0.d, p0/m, z0.d, #2.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 2.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fmul.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a_z,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 8 x half> @fsub_h_immhalf(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fsub_h_immhalf:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsub z0.h, p0/m, z0.h, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fsub.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fsub_h_immhalf_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fsub_h_immhalf_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fsub z0.h, p0/m, z0.h, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fsub.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a_z,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fsub_h_immone(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fsub_h_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsub z0.h, p0/m, z0.h, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fsub.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fsub_h_immone_zero(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fsub_h_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fsub z0.h, p0/m, z0.h, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fsub.nxv8f16(<vscale x 8 x i1> %pg,
                                                            <vscale x 8 x half> %a_z,
                                                            <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 4 x float> @fsub_s_immhalf(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fsub_s_immhalf:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsub z0.s, p0/m, z0.s, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fsub.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fsub_s_immhalf_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fsub_s_immhalf_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fsub z0.s, p0/m, z0.s, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fsub.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a_z,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fsub_s_immone(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fsub_s_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsub z0.s, p0/m, z0.s, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fsub.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fsub_s_immone_zero(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fsub_s_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fsub z0.s, p0/m, z0.s, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fsub.nxv4f32(<vscale x 4 x i1> %pg,
                                                             <vscale x 4 x float> %a_z,
                                                             <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 2 x double> @fsub_d_immhalf(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fsub_d_immhalf:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsub z0.d, p0/m, z0.d, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fsub.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fsub_d_immhalf_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fsub_d_immhalf_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fsub z0.d, p0/m, z0.d, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fsub.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a_z,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fsub_d_immone(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fsub_d_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fsub z0.d, p0/m, z0.d, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fsub.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fsub_d_immone_zero(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fsub_d_immone_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fsub z0.d, p0/m, z0.d, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fsub.nxv2f64(<vscale x 2 x i1> %pg,
                                                              <vscale x 2 x double> %a_z,
                                                              <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 8 x half> @fsubr_h_immhalf(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fsubr_h_immhalf:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fsubr z0.h, p0/m, z0.h, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fsubr.nxv8f16(<vscale x 8 x i1> %pg,
                                                             <vscale x 8 x half> %a_z,
                                                             <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 8 x half> @fsubr_h_immone(<vscale x 8 x i1> %pg, <vscale x 8 x half> %a) #1 {
; CHECK-LABEL: fsubr_h_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.h, p0/z, z0.h
; CHECK-NEXT:    fsubr z0.h, p0/m, z0.h, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 8 x half> undef, half 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 8 x half> %elt, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %a_z = select <vscale x 8 x i1> %pg, <vscale x 8 x half> %a, <vscale x 8 x half> zeroinitializer
  %out = call <vscale x 8 x half> @llvm.aarch64.sve.fsubr.nxv8f16(<vscale x 8 x i1> %pg,
                                                             <vscale x 8 x half> %a_z,
                                                             <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %out
}

define <vscale x 4 x float> @fsubr_s_immhalf(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fsubr_s_immhalf:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fsubr z0.s, p0/m, z0.s, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fsubr.nxv4f32(<vscale x 4 x i1> %pg,
                                                              <vscale x 4 x float> %a_z,
                                                              <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 4 x float> @fsubr_s_immone(<vscale x 4 x i1> %pg, <vscale x 4 x float> %a) #1 {
; CHECK-LABEL: fsubr_s_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.s, p0/z, z0.s
; CHECK-NEXT:    fsubr z0.s, p0/m, z0.s, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 4 x float> undef, float 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 4 x float> %elt, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %a_z = select <vscale x 4 x i1> %pg, <vscale x 4 x float> %a, <vscale x 4 x float> zeroinitializer
  %out = call <vscale x 4 x float> @llvm.aarch64.sve.fsubr.nxv4f32(<vscale x 4 x i1> %pg,
                                                              <vscale x 4 x float> %a_z,
                                                              <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %out
}

define <vscale x 2 x double> @fsubr_d_immhalf(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fsubr_d_immhalf:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fsubr z0.d, p0/m, z0.d, #0.5
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 0.500000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fsubr.nxv2f64(<vscale x 2 x i1> %pg,
                                                               <vscale x 2 x double> %a_z,
                                                               <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}

define <vscale x 2 x double> @fsubr_d_immone(<vscale x 2 x i1> %pg, <vscale x 2 x double> %a) #1 {
; CHECK-LABEL: fsubr_d_immone:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movprfx z0.d, p0/z, z0.d
; CHECK-NEXT:    fsubr z0.d, p0/m, z0.d, #1.0
; CHECK-NEXT:    ret
  %elt   = insertelement <vscale x 2 x double> undef, double 1.000000e+00, i32 0
  %splat = shufflevector <vscale x 2 x double> %elt, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %a_z = select <vscale x 2 x i1> %pg, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %out = call <vscale x 2 x double> @llvm.aarch64.sve.fsubr.nxv2f64(<vscale x 2 x i1> %pg,
                                                               <vscale x 2 x double> %a_z,
                                                               <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %out
}


;; Arithmetic intrinsic declarations

declare <vscale x 8 x half> @llvm.aarch64.sve.fadd.nxv8f16(<vscale x 8 x i1>, <vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 4 x float> @llvm.aarch64.sve.fadd.nxv4f32(<vscale x 4 x i1>, <vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.aarch64.sve.fadd.nxv2f64(<vscale x 2 x i1>, <vscale x 2 x double>, <vscale x 2 x double>)

declare <vscale x 8 x half> @llvm.aarch64.sve.fmax.nxv8f16(<vscale x 8 x i1>, <vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 4 x float> @llvm.aarch64.sve.fmax.nxv4f32(<vscale x 4 x i1>, <vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.aarch64.sve.fmax.nxv2f64(<vscale x 2 x i1>, <vscale x 2 x double>, <vscale x 2 x double>)

declare <vscale x 8 x half> @llvm.aarch64.sve.fmaxnm.nxv8f16(<vscale x 8 x i1>, <vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 4 x float> @llvm.aarch64.sve.fmaxnm.nxv4f32(<vscale x 4 x i1>, <vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.aarch64.sve.fmaxnm.nxv2f64(<vscale x 2 x i1>, <vscale x 2 x double>, <vscale x 2 x double>)

declare <vscale x 8 x half> @llvm.aarch64.sve.fmin.nxv8f16(<vscale x 8 x i1>, <vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 4 x float> @llvm.aarch64.sve.fmin.nxv4f32(<vscale x 4 x i1>, <vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.aarch64.sve.fmin.nxv2f64(<vscale x 2 x i1>, <vscale x 2 x double>, <vscale x 2 x double>)

declare <vscale x 8 x half> @llvm.aarch64.sve.fminnm.nxv8f16(<vscale x 8 x i1>, <vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 4 x float> @llvm.aarch64.sve.fminnm.nxv4f32(<vscale x 4 x i1>, <vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.aarch64.sve.fminnm.nxv2f64(<vscale x 2 x i1>, <vscale x 2 x double>, <vscale x 2 x double>)

declare <vscale x 8 x half> @llvm.aarch64.sve.fmul.nxv8f16(<vscale x 8 x i1>, <vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 4 x float> @llvm.aarch64.sve.fmul.nxv4f32(<vscale x 4 x i1>, <vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.aarch64.sve.fmul.nxv2f64(<vscale x 2 x i1>, <vscale x 2 x double>, <vscale x 2 x double>)

declare <vscale x 8 x half> @llvm.aarch64.sve.fsub.nxv8f16(<vscale x 8 x i1>, <vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 4 x float> @llvm.aarch64.sve.fsub.nxv4f32(<vscale x 4 x i1>, <vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.aarch64.sve.fsub.nxv2f64(<vscale x 2 x i1>, <vscale x 2 x double>, <vscale x 2 x double>)

declare <vscale x 8 x half> @llvm.aarch64.sve.fsubr.nxv8f16(<vscale x 8 x i1>, <vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 4 x float> @llvm.aarch64.sve.fsubr.nxv4f32(<vscale x 4 x i1>, <vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.aarch64.sve.fsubr.nxv2f64(<vscale x 2 x i1>, <vscale x 2 x double>, <vscale x 2 x double>)

attributes #0 = { "target-features"="+sve" }
attributes #1 = { "target-features"="+sve,+use-experimental-zeroing-pseudos" }
