# -*- coding: utf-8 -*-

#
# Copyright (c) 2012 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#           http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

__author__ = 'Spenser Shumaker <sshumake@redhat.com>'
_config_helper = None


class EmptyValueError(Exception):
    def __init__(self, msg):
        Exception.__init__(self, msg)


class ConfigHelper(object):

    def __init__(self,
                 username=None,
                 password=None,
                 url=None,
                 key_file=None,
                 cert_file=None,
                 proxy_url=None,
                 proxy_user=None,
                 proxy_pass=None,
                 sftp_host="sftp.access.redhat.com",
                 ftp_port=None,
                 ftp_user=None,
                 ftp_pass=None,
                 ftp_dir='/incoming',
                 timeout=None,
                 userAgent=None,
                 http_debug=False,
                 no_verify_ssl=False,
                 ssl_ca=None,
                 sftp_port=22,
                 sftp_timeout=2*60*60,
                 client_id=None,
                 client_secret=None,
                 auth=None,
                 token_endpoint=None,
                 client_identifier_url=None,
                 use_basic_auth=None,
                 save_token=False,
                 **kwargs):
        self.username = username
        self.password = password
        self.url = url
        self.key_file = key_file
        self.cert_file = cert_file
        self.proxy_url = proxy_url
        self.proxy_user = proxy_user
        self.proxy_pass = proxy_pass
        self.sftp_host = sftp_host
        self.ftp_port = ftp_port
        self.ftp_user = ftp_user
        self.ftp_pass = ftp_pass
        self.ftp_dir = ftp_dir
        self.timeout = timeout
        self.userAgent = userAgent
        self.http_debug = http_debug
        self.attachment_max_size = 1 * 1024 * 1024 * 1024 # 1GB
        self.no_verify_ssl = no_verify_ssl
        self.ssl_ca = ssl_ca
        self.s3_aws_host = kwargs.get('s3_aws_host')
        self.s3_use_threads = kwargs.get('s3_use_threads')
        self.s3_max_workers = kwargs.get('s3_max_workers')
        self.s3_refresh_frequency = kwargs.get('s3_refresh_frequency')
        self.s3_multipart_threshold = kwargs.get('s3_multipart_threshold')
        self.s3_part_size = kwargs.get('s3_part_size')
        self.s3_endpoint_url = kwargs.get('s3_endpoint_url')
        self.s3_max_status_retries = kwargs.get('s3_max_status_retries')
        self.s3_aws_verify = kwargs.get('s3_aws_verify')
        self.s3_failure_retries = kwargs.get('s3_failure_retries')
        self.sftp_port = sftp_port
        self.sftp_timeout = sftp_timeout
        self.client_id = client_id
        self.client_secret = client_secret
        self.auth = auth
        self.token_endpoint = token_endpoint
        self.client_identifier_url = client_identifier_url
        self.use_basic_auth = use_basic_auth
        self.save_token = save_token


def get_config_helper():
    '''
    A helper method to get the configuration object.
    '''
    # Tell python we want the *global* version and not a
    # function local version. Sheesh. :(
    global _config_helper
    if not _config_helper:
        _config_helper = ConfigHelper()
    return _config_helper

