; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-eabi -mattr=+mve --verify-machineinstrs %s -o - | FileCheck %s

; Tail predicated so we use DLSTP
define void @simple(ptr nocapture readonly %x, ptr nocapture readnone %y, ptr nocapture %z, i32 %m, i32 %n) {
; CHECK-LABEL: simple:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    ldr r1, [sp, #8]
; CHECK-NEXT:    mov r12, r3
; CHECK-NEXT:    adds r3, r1, #3
; CHECK-NEXT:    lsrs r3, r3, #2
; CHECK-NEXT:    beq .LBB0_3
; CHECK-NEXT:  @ %bb.1: @ %do.body.preheader
; CHECK-NEXT:    dlstp.32 lr, r1
; CHECK-NEXT:  .LBB0_2: @ %do.body
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    vldrw.u32 q0, [r0], #16
; CHECK-NEXT:    vaddva.s32 r12, q0
; CHECK-NEXT:    letp lr, .LBB0_2
; CHECK-NEXT:  .LBB0_3: @ %if.end
; CHECK-NEXT:    str.w r12, [r2]
; CHECK-NEXT:    pop {r7, pc}
entry:
  %add = add i32 %n, 3
  %div = lshr i32 %add, 2
  %cmp.not = icmp eq i32 %div, 0
  br i1 %cmp.not, label %if.end, label %do.body

do.body:                                          ; preds = %entry, %do.body
  %n.addr.0 = phi i32 [ %sub, %do.body ], [ %n, %entry ]
  %count.0 = phi i32 [ %sub3, %do.body ], [ %div, %entry ]
  %s.0 = phi i32 [ %add2, %do.body ], [ %m, %entry ]
  %x.addr.0 = phi ptr [ %add.ptr, %do.body ], [ %x, %entry ]
  %0 = tail call <4 x i1> @llvm.arm.mve.vctp32(i32 %n.addr.0)
  %1 = load <4 x i32>, ptr %x.addr.0, align 4
  %2 = tail call i32 @llvm.arm.mve.addv.predicated.v4i32.v4i1(<4 x i32> %1, i32 0, <4 x i1> %0)
  %add2 = add nsw i32 %2, %s.0
  %add.ptr = getelementptr inbounds i32, ptr %x.addr.0, i32 4
  %sub = add i32 %n.addr.0, -4
  %sub3 = add nsw i32 %count.0, -1
  %cmp4 = icmp sgt i32 %count.0, 1
  br i1 %cmp4, label %do.body, label %if.end

if.end:                                           ; preds = %do.body, %entry
  %s.1 = phi i32 [ %m, %entry ], [ %add2, %do.body ]
  store i32 %s.1, ptr %z, align 4
  ret void
}

; Tail predicated so we use DLSTP
define void @nested(ptr nocapture readonly %x, ptr nocapture readnone %y, ptr nocapture %z, i32 %m, i32 %n) {
; CHECK-LABEL: nested:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, r7, r8, lr}
; CHECK-NEXT:    push.w {r4, r5, r6, r7, r8, lr}
; CHECK-NEXT:    cbz r3, .LBB1_8
; CHECK-NEXT:  @ %bb.1: @ %for.body.preheader
; CHECK-NEXT:    ldr.w r12, [sp, #24]
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    b .LBB1_4
; CHECK-NEXT:  .LBB1_2: @ in Loop: Header=BB1_4 Depth=1
; CHECK-NEXT:    mov r4, r3
; CHECK-NEXT:  .LBB1_3: @ %if.end
; CHECK-NEXT:    @ in Loop: Header=BB1_4 Depth=1
; CHECK-NEXT:    str.w r4, [r2, r1, lsl #2]
; CHECK-NEXT:    adds r1, #1
; CHECK-NEXT:    cmp r1, r3
; CHECK-NEXT:    beq .LBB1_8
; CHECK-NEXT:  .LBB1_4: @ %for.body
; CHECK-NEXT:    @ =>This Loop Header: Depth=1
; CHECK-NEXT:    @ Child Loop BB1_6 Depth 2
; CHECK-NEXT:    add.w r6, r12, #3
; CHECK-NEXT:    lsrs r7, r6, #2
; CHECK-NEXT:    beq .LBB1_2
; CHECK-NEXT:  @ %bb.5: @ %do.body.preheader
; CHECK-NEXT:    @ in Loop: Header=BB1_4 Depth=1
; CHECK-NEXT:    bic r5, r6, #3
; CHECK-NEXT:    mov r4, r3
; CHECK-NEXT:    add.w r8, r0, r5, lsl #2
; CHECK-NEXT:    dlstp.32 lr, r12
; CHECK-NEXT:  .LBB1_6: @ %do.body
; CHECK-NEXT:    @ Parent Loop BB1_4 Depth=1
; CHECK-NEXT:    @ => This Inner Loop Header: Depth=2
; CHECK-NEXT:    vldrw.u32 q0, [r0], #16
; CHECK-NEXT:    vaddva.s32 r4, q0
; CHECK-NEXT:    letp lr, .LBB1_6
; CHECK-NEXT:  @ %bb.7: @ %if.end.loopexit
; CHECK-NEXT:    @ in Loop: Header=BB1_4 Depth=1
; CHECK-NEXT:    sub.w r12, r12, r5
; CHECK-NEXT:    mov r0, r8
; CHECK-NEXT:    b .LBB1_3
; CHECK-NEXT:  .LBB1_8: @ %for.cond.cleanup
; CHECK-NEXT:    pop.w {r4, r5, r6, r7, r8, pc}
entry:
  %cmp20.not = icmp eq i32 %m, 0
  br i1 %cmp20.not, label %for.cond.cleanup, label %for.body

for.cond.cleanup:                                 ; preds = %if.end, %entry
  ret void

for.body:                                         ; preds = %entry, %if.end
  %x.addr.023 = phi ptr [ %x.addr.2, %if.end ], [ %x, %entry ]
  %a.022 = phi i32 [ %inc, %if.end ], [ 0, %entry ]
  %n.addr.021 = phi i32 [ %n.addr.2, %if.end ], [ %n, %entry ]
  %add = add i32 %n.addr.021, 3
  %div = lshr i32 %add, 2
  %cmp1.not = icmp eq i32 %div, 0
  br i1 %cmp1.not, label %if.end, label %do.body.preheader

do.body.preheader:                                ; preds = %for.body
  %0 = and i32 %add, -4
  %scevgep = getelementptr i32, ptr %x.addr.023, i32 %0
  br label %do.body

do.body:                                          ; preds = %do.body.preheader, %do.body
  %n.addr.1 = phi i32 [ %sub, %do.body ], [ %n.addr.021, %do.body.preheader ]
  %count.0 = phi i32 [ %sub4, %do.body ], [ %div, %do.body.preheader ]
  %s.0 = phi i32 [ %add3, %do.body ], [ %m, %do.body.preheader ]
  %x.addr.1 = phi ptr [ %add.ptr, %do.body ], [ %x.addr.023, %do.body.preheader ]
  %1 = tail call <4 x i1> @llvm.arm.mve.vctp32(i32 %n.addr.1)
  %2 = load <4 x i32>, ptr %x.addr.1, align 4
  %3 = tail call i32 @llvm.arm.mve.addv.predicated.v4i32.v4i1(<4 x i32> %2, i32 0, <4 x i1> %1)
  %add3 = add nsw i32 %3, %s.0
  %add.ptr = getelementptr inbounds i32, ptr %x.addr.1, i32 4
  %sub = add i32 %n.addr.1, -4
  %sub4 = add nsw i32 %count.0, -1
  %cmp5 = icmp sgt i32 %count.0, 1
  br i1 %cmp5, label %do.body, label %if.end.loopexit

if.end.loopexit:                                  ; preds = %do.body
  %4 = sub i32 %n.addr.021, %0
  br label %if.end

if.end:                                           ; preds = %if.end.loopexit, %for.body
  %n.addr.2 = phi i32 [ %n.addr.021, %for.body ], [ %4, %if.end.loopexit ]
  %s.1 = phi i32 [ %m, %for.body ], [ %add3, %if.end.loopexit ]
  %x.addr.2 = phi ptr [ %x.addr.023, %for.body ], [ %scevgep, %if.end.loopexit ]
  %arrayidx = getelementptr inbounds i32, ptr %z, i32 %a.022
  store i32 %s.1, ptr %arrayidx, align 4
  %inc = add nuw nsw i32 %a.022, 1
  %exitcond.not = icmp eq i32 %inc, %m
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

declare <4 x i1> @llvm.arm.mve.vctp32(i32)
declare i32 @llvm.arm.mve.addv.predicated.v4i32.v4i1(<4 x i32>, i32, <4 x i1>)


; Long test that was spilling lr between t2LoopDec and End
define dso_local i32 @b(ptr %c, i32 %d, i32 %e, ptr %n) "frame-pointer"="all" {
; CHECK-LABEL: b:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, r7, lr}
; CHECK-NEXT:    push {r4, r5, r6, r7, lr}
; CHECK-NEXT:    .setfp r7, sp, #12
; CHECK-NEXT:    add r7, sp, #12
; CHECK-NEXT:    .save {r8, r9, r10, r11}
; CHECK-NEXT:    push.w {r8, r9, r10, r11}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    wls lr, r1, .LBB2_3
; CHECK-NEXT:  @ %bb.1: @ %while.body.preheader
; CHECK-NEXT:    mov r12, r0
; CHECK-NEXT:    add.w r10, r3, #4
; CHECK-NEXT:    adds r0, #4
; CHECK-NEXT:    mvn r9, #1
; CHECK-NEXT:    @ implicit-def: $r8
; CHECK-NEXT:    @ implicit-def: $r4
; CHECK-NEXT:    str r2, [sp] @ 4-byte Spill
; CHECK-NEXT:  .LBB2_2: @ %while.body
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    ldr r2, [r0]
; CHECK-NEXT:    asrs r5, r4, #31
; CHECK-NEXT:    str r0, [sp, #12] @ 4-byte Spill
; CHECK-NEXT:    muls r2, r3, r2
; CHECK-NEXT:    adds r4, r4, r2
; CHECK-NEXT:    adc.w r2, r5, r2, asr #31
; CHECK-NEXT:    ldr.w r5, [r9, #4]
; CHECK-NEXT:    adds.w r4, r4, #-2147483648
; CHECK-NEXT:    adc r1, r2, #0
; CHECK-NEXT:    str r1, [sp, #8] @ 4-byte Spill
; CHECK-NEXT:    smull r5, r6, r5, r8
; CHECK-NEXT:    ldr.w r2, [r9]
; CHECK-NEXT:    asrs r4, r1, #31
; CHECK-NEXT:    str r2, [sp, #4] @ 4-byte Spill
; CHECK-NEXT:    subs r5, r1, r5
; CHECK-NEXT:    sbcs r4, r6
; CHECK-NEXT:    adds.w r6, r5, #-2147483648
; CHECK-NEXT:    adc r5, r4, #0
; CHECK-NEXT:    ldr r4, [r0, #-4]
; CHECK-NEXT:    muls r4, r3, r4
; CHECK-NEXT:    adds r3, #4
; CHECK-NEXT:    adds.w r0, r4, #-2147483648
; CHECK-NEXT:    asr.w r1, r4, #31
; CHECK-NEXT:    ldr.w r4, [r10]
; CHECK-NEXT:    adc r1, r1, #0
; CHECK-NEXT:    mul r2, r4, r12
; CHECK-NEXT:    add.w r12, r12, #4
; CHECK-NEXT:    add.w r2, r2, #-2147483648
; CHECK-NEXT:    asrl r0, r1, r2
; CHECK-NEXT:    ldr r2, [sp] @ 4-byte Reload
; CHECK-NEXT:    smull r0, r1, r4, r0
; CHECK-NEXT:    lsll r0, r1, #30
; CHECK-NEXT:    asr.w r11, r1, #31
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    ldr r1, [sp, #4] @ 4-byte Reload
; CHECK-NEXT:    lsll r0, r11, r4
; CHECK-NEXT:    lsrl r0, r11, #2
; CHECK-NEXT:    mul r1, r1, r8
; CHECK-NEXT:    adds r1, #2
; CHECK-NEXT:    lsll r0, r11, r1
; CHECK-NEXT:    ldr r1, [sp, #8] @ 4-byte Reload
; CHECK-NEXT:    add.w r0, r0, #-2147483648
; CHECK-NEXT:    asrl r6, r5, r0
; CHECK-NEXT:    movs r0, #2
; CHECK-NEXT:    lsrl r6, r5, #2
; CHECK-NEXT:    str r6, [r0]
; CHECK-NEXT:    mov r8, r6
; CHECK-NEXT:    ldr r0, [r9], #-4
; CHECK-NEXT:    mls r0, r0, r4, r1
; CHECK-NEXT:    adds.w r4, r0, #-2147483648
; CHECK-NEXT:    asr.w r1, r0, #31
; CHECK-NEXT:    adc r1, r1, #0
; CHECK-NEXT:    lsrl r4, r1, #2
; CHECK-NEXT:    rsbs r0, r4, #0
; CHECK-NEXT:    str r0, [r2]
; CHECK-NEXT:    str r0, [r10, #-4]
; CHECK-NEXT:    add.w r10, r10, #4
; CHECK-NEXT:    ldr r0, [sp, #12] @ 4-byte Reload
; CHECK-NEXT:    adds r0, #4
; CHECK-NEXT:    le lr, .LBB2_2
; CHECK-NEXT:  .LBB2_3: @ %while.end
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    pop.w {r8, r9, r10, r11}
; CHECK-NEXT:    pop {r4, r5, r6, r7, pc}
entry:
  %0 = inttoptr i32 %e to ptr
  %tobool.not70 = icmp eq i32 %d, 0
  br i1 %tobool.not70, label %while.end, label %while.body

while.body:                                       ; preds = %entry, %while.body
  %p.077 = phi ptr [ %incdec.ptr22, %while.body ], [ inttoptr (i32 2 to ptr), %entry ]
  %c.addr.076 = phi ptr [ %incdec.ptr1, %while.body ], [ %c, %entry ]
  %n.075 = phi ptr [ %incdec.ptr43, %while.body ], [ %n, %entry ]
  %m.074 = phi i32 [ %conv35, %while.body ], [ undef, %entry ]
  %d.addr.073 = phi i32 [ %dec, %while.body ], [ %d, %entry ]
  %h.072 = phi i32 [ %conv41, %while.body ], [ undef, %entry ]
  %incdec.ptr43 = getelementptr inbounds i32, ptr %n.075, i32 1
  %1 = ptrtoint ptr %n.075 to i32
  %2 = load i32, ptr %incdec.ptr43, align 4
  %3 = load i32, ptr %c.addr.076, align 4
  %mul = mul nsw i32 %3, %1
  %conv = sext i32 %mul to i64
  %add = add nsw i64 %conv, 2147483648
  %incdec.ptr1 = getelementptr inbounds i32, ptr %c.addr.076, i32 1
  %4 = ptrtoint ptr %c.addr.076 to i32
  %mul2 = mul nsw i32 %2, %4
  %conv3 = sext i32 %mul2 to i64
  %add4 = add nsw i64 %conv3, 2147483648
  %shr = ashr i64 %add, %add4
  %5 = shl nuw i64 %shr, 32
  %conv6 = ashr exact i64 %5, 32
  %conv7 = sext i32 %2 to i64
  %conv11 = sext i32 %h.072 to i64
  %6 = load i32, ptr %incdec.ptr1, align 4
  %mul12 = mul nsw i32 %6, %1
  %conv13 = sext i32 %mul12 to i64
  %add14 = add nuw nsw i64 %conv11, 2147483648
  %add15 = add nsw i64 %add14, %conv13
  %shr16 = ashr i64 %add15, 32
  %conv17 = trunc i64 %shr16 to i32
  %mul8 = shl nsw i64 %conv7, 30
  %7 = mul i64 %mul8, %conv6
  %conv18 = ashr i64 %7, 32
  %sh_prom = zext i32 %2 to i64
  %shl = shl i64 %conv18, %sh_prom
  %conv21 = sext i32 %conv17 to i64
  %incdec.ptr22 = getelementptr inbounds i32, ptr %p.077, i32 -1
  %8 = load i32, ptr %p.077, align 4
  %conv23 = sext i32 %8 to i64
  %conv24 = sext i32 %m.074 to i64
  %mul25 = mul nsw i64 %conv23, %conv24
  %sub = sub nsw i64 2147483648, %mul25
  %add26 = add nsw i64 %sub, %conv21
  %9 = shl i64 %shl, 30
  %conv27 = ashr i64 %9, 32
  %10 = load i32, ptr %incdec.ptr22, align 4
  %mul28 = mul nsw i32 %10, %m.074
  %add29 = add nsw i32 %mul28, 2
  %sh_prom30 = zext i32 %add29 to i64
  %shl31 = shl i64 %conv27, %sh_prom30
  %add32 = add nsw i64 %shl31, 2147483648
  %shr33 = ashr i64 %add26, %add32
  %11 = lshr i64 %shr33, 2
  %conv35 = trunc i64 %11 to i32
  store i32 %conv35, ptr inttoptr (i32 2 to ptr), align 4
  %12 = load i32, ptr %incdec.ptr22, align 4
  %mul36 = mul nsw i32 %12, %2
  %sub37 = sub nsw i32 %conv17, %mul36
  %conv38 = sext i32 %sub37 to i64
  %add39 = add nsw i64 %conv38, 2147483648
  %13 = lshr i64 %add39, 2
  %conv41 = trunc i64 %13 to i32
  %sub42 = sub nsw i32 0, %conv41
  store i32 %sub42, ptr %0, align 4
  store i32 %sub42, ptr %n.075, align 4
  %dec = add nsw i32 %d.addr.073, -1
  %tobool.not = icmp eq i32 %dec, 0
  br i1 %tobool.not, label %while.end, label %while.body

while.end:                                        ; preds = %while.body, %entry
  ret i32 undef
}

declare void @callee()
define void @callinpreheader(ptr noalias nocapture readonly %pAngle, ptr nocapture %pDst, i32 %size) {
; CHECK-LABEL: callinpreheader:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, lr}
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    mov r5, r0
; CHECK-NEXT:    mov r4, r1
; CHECK-NEXT:    movs r0, #0
; CHECK-NEXT:    cbz r2, .LBB3_3
; CHECK-NEXT:  @ %bb.1: @ %for.body.ph
; CHECK-NEXT:    mov r6, r2
; CHECK-NEXT:    bl callee
; CHECK-NEXT:    dls lr, r6
; CHECK-NEXT:    movs r0, #0
; CHECK-NEXT:  .LBB3_2: @ %for.body
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    ldr r1, [r5], #4
; CHECK-NEXT:    add r0, r1
; CHECK-NEXT:    le lr, .LBB3_2
; CHECK-NEXT:  .LBB3_3: @ %for.cond.cleanup
; CHECK-NEXT:    str r0, [r4]
; CHECK-NEXT:    pop {r4, r5, r6, pc}
entry:
  %cmp7.not = icmp eq i32 %size, 0
  br i1 %cmp7.not, label %for.cond.cleanup, label %for.body.ph

for.body.ph:
  call void @callee()
  br label %for.body

for.body:
  %i.09 = phi i32 [ %inc, %for.body ], [ 0, %for.body.ph ]
  %s.08 = phi i32 [ %add, %for.body ], [ 0, %for.body.ph ]
  %arrayidx = getelementptr inbounds i32, ptr %pAngle, i32 %i.09
  %0 = load i32, ptr %arrayidx, align 4
  %add = add nsw i32 %0, %s.08
  %inc = add nuw nsw i32 %i.09, 1
  %exitcond.not = icmp eq i32 %inc, %size
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body

for.cond.cleanup:
  %s.0.lcssa = phi i32 [ 0, %entry ], [ %add, %for.body ]
  store i32 %s.0.lcssa, ptr %pDst, align 4
  ret void
}
