; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+zve64d,+f,+d,+zfh,+experimental-zvfh \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare void @llvm.riscv.vsuxseg2.nxv16i16.nxv16i16(<vscale x 16 x i16>,<vscale x 16 x i16>, ptr, <vscale x 16 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv16i16.nxv16i16(<vscale x 16 x i16>,<vscale x 16 x i16>, ptr, <vscale x 16 x i16>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg2_nxv16i16_nxv16i16(<vscale x 16 x i16> %val, ptr %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv16i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv16i16.nxv16i16(<vscale x 16 x i16> %val,<vscale x 16 x i16> %val, ptr %base, <vscale x 16 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv16i16_nxv16i16(<vscale x 16 x i16> %val, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv16i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv16i16.nxv16i16(<vscale x 16 x i16> %val,<vscale x 16 x i16> %val, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv16i16.nxv16i8(<vscale x 16 x i16>,<vscale x 16 x i16>, ptr, <vscale x 16 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv16i16.nxv16i8(<vscale x 16 x i16>,<vscale x 16 x i16>, ptr, <vscale x 16 x i8>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg2_nxv16i16_nxv16i8(<vscale x 16 x i16> %val, ptr %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv16i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv16i16.nxv16i8(<vscale x 16 x i16> %val,<vscale x 16 x i16> %val, ptr %base, <vscale x 16 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv16i16_nxv16i8(<vscale x 16 x i16> %val, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv16i16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv16i16.nxv16i8(<vscale x 16 x i16> %val,<vscale x 16 x i16> %val, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv16i16.nxv16i32(<vscale x 16 x i16>,<vscale x 16 x i16>, ptr, <vscale x 16 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv16i16.nxv16i32(<vscale x 16 x i16>,<vscale x 16 x i16>, ptr, <vscale x 16 x i32>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg2_nxv16i16_nxv16i32(<vscale x 16 x i16> %val, ptr %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv16i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv16i16.nxv16i32(<vscale x 16 x i16> %val,<vscale x 16 x i16> %val, ptr %base, <vscale x 16 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv16i16_nxv16i32(<vscale x 16 x i16> %val, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv16i16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv16i16.nxv16i32(<vscale x 16 x i16> %val,<vscale x 16 x i16> %val, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i32.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i32.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i32_nxv4i32(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i32.nxv4i32(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i32_nxv4i32(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i32.nxv4i32(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i32.nxv4i8(<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i32.nxv4i8(<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i32_nxv4i8(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i32.nxv4i8(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i32_nxv4i8(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i32.nxv4i8(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i32.nxv4i64(<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i32.nxv4i64(<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i32_nxv4i64(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i32.nxv4i64(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i32_nxv4i64(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i32.nxv4i64(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i32.nxv4i16(<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i32.nxv4i16(<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i32_nxv4i16(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i32.nxv4i16(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i32_nxv4i16(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i32.nxv4i16(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4i32.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4i32.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4i32_nxv4i32(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4i32.nxv4i32(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4i32_nxv4i32(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4i32.nxv4i32(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4i32.nxv4i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4i32.nxv4i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4i32_nxv4i8(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4i32.nxv4i8(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4i32_nxv4i8(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4i32.nxv4i8(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4i32.nxv4i64(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4i32.nxv4i64(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4i32_nxv4i64(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4i32.nxv4i64(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4i32_nxv4i64(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4i32.nxv4i64(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4i32.nxv4i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4i32.nxv4i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4i32_nxv4i16(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4i32.nxv4i16(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4i32_nxv4i16(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4i32.nxv4i16(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4i32.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4i32.nxv4i32(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4i32_nxv4i32(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4i32.nxv4i32(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4i32_nxv4i32(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4i32.nxv4i32(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4i32.nxv4i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4i32.nxv4i8(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4i32_nxv4i8(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4i32.nxv4i8(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4i32_nxv4i8(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4i32_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4i32.nxv4i8(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4i32.nxv4i64(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4i32.nxv4i64(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4i32_nxv4i64(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4i32.nxv4i64(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4i32_nxv4i64(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4i32_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4i32.nxv4i64(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4i32.nxv4i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4i32.nxv4i16(<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>,<vscale x 4 x i32>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4i32_nxv4i16(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4i32.nxv4i16(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4i32_nxv4i16(<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4i32_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4i32.nxv4i16(<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val,<vscale x 4 x i32> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv16i8.nxv16i16(<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv16i8.nxv16i16(<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i16>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg2_nxv16i8_nxv16i16(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv16i8.nxv16i16(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv16i8_nxv16i16(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv16i8.nxv16i16(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv16i8.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv16i8.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i8>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg2_nxv16i8_nxv16i8(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv16i8.nxv16i8(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv16i8_nxv16i8(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv16i8.nxv16i8(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv16i8.nxv16i32(<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv16i8.nxv16i32(<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i32>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg2_nxv16i8_nxv16i32(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv16i8.nxv16i32(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv16i8_nxv16i32(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv16i8.nxv16i32(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv16i8.nxv16i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv16i8.nxv16i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i16>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg3_nxv16i8_nxv16i16(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv16i8.nxv16i16(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv16i8_nxv16i16(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv16i8.nxv16i16(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv16i8.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv16i8.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i8>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg3_nxv16i8_nxv16i8(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv16i8.nxv16i8(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv16i8_nxv16i8(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv16i8.nxv16i8(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv16i8.nxv16i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv16i8.nxv16i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i32>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg3_nxv16i8_nxv16i32(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv16i8.nxv16i32(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv16i8_nxv16i32(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv16i8.nxv16i32(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv16i8.nxv16i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv16i8.nxv16i16(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i16>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg4_nxv16i8_nxv16i16(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv16i8.nxv16i16(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv16i8_nxv16i16(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv16i8_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv16i8.nxv16i16(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv16i8.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv16i8.nxv16i8(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i8>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg4_nxv16i8_nxv16i8(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv16i8.nxv16i8(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv16i8_nxv16i8(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv16i8.nxv16i8(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv16i8.nxv16i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv16i8.nxv16i32(<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>,<vscale x 16 x i8>, ptr, <vscale x 16 x i32>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg4_nxv16i8_nxv16i32(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv16i8.nxv16i32(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv16i8_nxv16i32(<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv16i8_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv16i8.nxv16i32(<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val,<vscale x 16 x i8> %val, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i64.nxv1i64(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i64_nxv1i64(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i64.nxv1i64(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i64.nxv1i32(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i64_nxv1i32(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i64.nxv1i32(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i64.nxv1i16(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i64_nxv1i16(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i64.nxv1i16(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i64.nxv1i8(<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>,<vscale x 1 x i64>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i64_nxv1i8(<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i64.nxv1i8(<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val,<vscale x 1 x i64> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i32.nxv1i64(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i32_nxv1i64(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i32.nxv1i64(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i32.nxv1i32(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i32_nxv1i32(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i32.nxv1i16(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i32_nxv1i16(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i32.nxv1i16(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i32.nxv1i8(<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>,<vscale x 1 x i32>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i32_nxv1i8(<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i32.nxv1i8(<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val,<vscale x 1 x i32> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8i16.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8i16.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8i16_nxv8i16(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8i16.nxv8i16(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8i16_nxv8i16(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8i16.nxv8i16(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8i16.nxv8i8(<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8i16.nxv8i8(<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8i16_nxv8i8(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8i16.nxv8i8(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8i16_nxv8i8(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8i16.nxv8i8(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8i16.nxv8i64(<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8i16.nxv8i64(<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8i16_nxv8i64(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8i16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8i16.nxv8i64(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8i16_nxv8i64(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8i16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8i16.nxv8i64(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8i16.nxv8i32(<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8i16.nxv8i32(<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8i16_nxv8i32(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8i16.nxv8i32(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8i16_nxv8i32(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8i16.nxv8i32(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv8i16.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv8i16.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg3_nxv8i16_nxv8i16(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv8i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv8i16.nxv8i16(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv8i16_nxv8i16(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv8i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv8i16.nxv8i16(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv8i16.nxv8i8(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv8i16.nxv8i8(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg3_nxv8i16_nxv8i8(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv8i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv8i16.nxv8i8(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv8i16_nxv8i8(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv8i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv8i16.nxv8i8(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv8i16.nxv8i64(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv8i16.nxv8i64(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg3_nxv8i16_nxv8i64(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv8i16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv8i16.nxv8i64(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv8i16_nxv8i64(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv8i16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv8i16.nxv8i64(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv8i16.nxv8i32(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv8i16.nxv8i32(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg3_nxv8i16_nxv8i32(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv8i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv8i16.nxv8i32(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv8i16_nxv8i32(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv8i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv8i16.nxv8i32(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv8i16.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv8i16.nxv8i16(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg4_nxv8i16_nxv8i16(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv8i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv8i16.nxv8i16(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv8i16_nxv8i16(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv8i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv8i16.nxv8i16(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv8i16.nxv8i8(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv8i16.nxv8i8(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg4_nxv8i16_nxv8i8(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv8i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv8i16.nxv8i8(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv8i16_nxv8i8(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv8i16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv8i16.nxv8i8(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv8i16.nxv8i64(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv8i16.nxv8i64(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg4_nxv8i16_nxv8i64(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv8i16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv8i16.nxv8i64(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv8i16_nxv8i64(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv8i16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv8i16.nxv8i64(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv8i16.nxv8i32(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv8i16.nxv8i32(<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>,<vscale x 8 x i16>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg4_nxv8i16_nxv8i32(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv8i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv8i16.nxv8i32(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv8i16_nxv8i32(<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv8i16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv8i16.nxv8i32(<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val,<vscale x 8 x i16> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg5_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg5_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg5_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg5_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg6_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg6_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg6_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg6_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg7_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg7_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg7_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg7_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv4i8.nxv4i32(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg8_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv4i8_nxv4i32(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv4i8_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv4i8.nxv4i32(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv4i8.nxv4i8(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg8_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv4i8_nxv4i8(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv4i8.nxv4i8(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv4i8.nxv4i64(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg8_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv4i8_nxv4i64(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv4i8_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv4i8.nxv4i64(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv4i8.nxv4i16(<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>,<vscale x 4 x i8>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg8_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv4i8_nxv4i16(<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv4i8_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv4i8.nxv4i16(<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val,<vscale x 4 x i8> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i16.nxv1i64(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i16_nxv1i64(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i16.nxv1i64(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i16.nxv1i32(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i16_nxv1i32(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i16.nxv1i32(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i16.nxv1i16(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i16_nxv1i16(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i16.nxv1i16(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i16.nxv1i8(<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>,<vscale x 1 x i16>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i16_nxv1i8(<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i16.nxv1i8(<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val,<vscale x 1 x i16> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2i32.nxv2i32(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2i32_nxv2i32(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2i32.nxv2i32(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2i32.nxv2i8(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2i32_nxv2i8(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2i32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2i32.nxv2i8(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2i32.nxv2i16(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2i32_nxv2i16(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2i32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2i32.nxv2i16(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2i32.nxv2i64(<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>,<vscale x 2 x i32>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2i32_nxv2i64(<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2i32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2i32.nxv2i64(<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val,<vscale x 2 x i32> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg3_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg3_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg3_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg3_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg4_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg4_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg4_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg4_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg5_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg5_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg5_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg5_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg6_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg6_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg6_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg6_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg7_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg7_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg7_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg7_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv8i8.nxv8i16(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg8_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv8i8_nxv8i16(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv8i8_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv8i8.nxv8i16(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv8i8.nxv8i8(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg8_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv8i8_nxv8i8(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv8i8.nxv8i8(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv8i8.nxv8i64(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg8_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv8i8_nxv8i64(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv8i8_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14_v15
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vmv1r.v v15, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv8i8.nxv8i64(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv8i8.nxv8i32(<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>,<vscale x 8 x i8>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg8_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv8i8_nxv8i32(<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv8i8_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv8i8.nxv8i32(<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val,<vscale x 8 x i8> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i64.nxv4i32(<vscale x 4 x i64>,<vscale x 4 x i64>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i64.nxv4i32(<vscale x 4 x i64>,<vscale x 4 x i64>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i64_nxv4i32(<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i64.nxv4i32(<vscale x 4 x i64> %val,<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i64_nxv4i32(<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i64.nxv4i32(<vscale x 4 x i64> %val,<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i64.nxv4i8(<vscale x 4 x i64>,<vscale x 4 x i64>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i64.nxv4i8(<vscale x 4 x i64>,<vscale x 4 x i64>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i64_nxv4i8(<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i64.nxv4i8(<vscale x 4 x i64> %val,<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i64_nxv4i8(<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i64.nxv4i8(<vscale x 4 x i64> %val,<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i64.nxv4i64(<vscale x 4 x i64>,<vscale x 4 x i64>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i64.nxv4i64(<vscale x 4 x i64>,<vscale x 4 x i64>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i64_nxv4i64(<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i64.nxv4i64(<vscale x 4 x i64> %val,<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i64_nxv4i64(<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i64.nxv4i64(<vscale x 4 x i64> %val,<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i64.nxv4i16(<vscale x 4 x i64>,<vscale x 4 x i64>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i64.nxv4i16(<vscale x 4 x i64>,<vscale x 4 x i64>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i64_nxv4i16(<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i64.nxv4i16(<vscale x 4 x i64> %val,<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i64_nxv4i16(<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i64.nxv4i16(<vscale x 4 x i64> %val,<vscale x 4 x i64> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg5_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg5_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg5_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg5_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg6_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg6_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg6_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg6_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg7_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg7_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg7_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg7_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv4i16.nxv4i32(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg8_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv4i16_nxv4i32(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv4i16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv4i16.nxv4i32(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv4i16.nxv4i8(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg8_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv4i16_nxv4i8(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv4i16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv4i16.nxv4i8(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv4i16.nxv4i64(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg8_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv4i16_nxv4i64(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv4i16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv4i16.nxv4i64(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv4i16.nxv4i16(<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>,<vscale x 4 x i16>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg8_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv4i16_nxv4i16(<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv4i16.nxv4i16(<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val,<vscale x 4 x i16> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i8.nxv1i64(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i8_nxv1i64(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i8_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i8.nxv1i64(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i8.nxv1i32(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i8_nxv1i32(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i8_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i8.nxv1i32(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i8.nxv1i16(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i8_nxv1i16(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i8_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i8.nxv1i16(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1i8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1i8_nxv1i8(<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1i8.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2i8.nxv2i32(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2i8_nxv2i32(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2i8_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2i8.nxv2i32(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2i8.nxv2i8(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2i8_nxv2i8(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2i8.nxv2i8(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2i8.nxv2i16(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2i8_nxv2i16(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2i8_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2i8.nxv2i16(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2i8.nxv2i64(<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>,<vscale x 2 x i8>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2i8_nxv2i64(<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2i8_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2i8.nxv2i64(<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val,<vscale x 2 x i8> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8i32.nxv8i16(<vscale x 8 x i32>,<vscale x 8 x i32>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8i32.nxv8i16(<vscale x 8 x i32>,<vscale x 8 x i32>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8i32_nxv8i16(<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8i32.nxv8i16(<vscale x 8 x i32> %val,<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8i32_nxv8i16(<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8i32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8i32.nxv8i16(<vscale x 8 x i32> %val,<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8i32.nxv8i8(<vscale x 8 x i32>,<vscale x 8 x i32>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8i32.nxv8i8(<vscale x 8 x i32>,<vscale x 8 x i32>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8i32_nxv8i8(<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8i32.nxv8i8(<vscale x 8 x i32> %val,<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8i32_nxv8i8(<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8i32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8i32.nxv8i8(<vscale x 8 x i32> %val,<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8i32.nxv8i64(<vscale x 8 x i32>,<vscale x 8 x i32>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8i32.nxv8i64(<vscale x 8 x i32>,<vscale x 8 x i32>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8i32_nxv8i64(<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8i32.nxv8i64(<vscale x 8 x i32> %val,<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8i32_nxv8i64(<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8i32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8i32.nxv8i64(<vscale x 8 x i32> %val,<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8i32.nxv8i32(<vscale x 8 x i32>,<vscale x 8 x i32>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8i32.nxv8i32(<vscale x 8 x i32>,<vscale x 8 x i32>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8i32_nxv8i32(<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8i32.nxv8i32(<vscale x 8 x i32> %val,<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8i32_nxv8i32(<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8i32.nxv8i32(<vscale x 8 x i32> %val,<vscale x 8 x i32> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv32i8.nxv32i16(<vscale x 32 x i8>,<vscale x 32 x i8>, ptr, <vscale x 32 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv32i8.nxv32i16(<vscale x 32 x i8>,<vscale x 32 x i8>, ptr, <vscale x 32 x i16>, <vscale x 32 x i1>, i64)

define void @test_vsuxseg2_nxv32i8_nxv32i16(<vscale x 32 x i8> %val, ptr %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv32i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv32i8.nxv32i16(<vscale x 32 x i8> %val,<vscale x 32 x i8> %val, ptr %base, <vscale x 32 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv32i8_nxv32i16(<vscale x 32 x i8> %val, ptr %base, <vscale x 32 x i16> %index, <vscale x 32 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv32i8_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv32i8.nxv32i16(<vscale x 32 x i8> %val,<vscale x 32 x i8> %val, ptr %base, <vscale x 32 x i16> %index, <vscale x 32 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv32i8.nxv32i8(<vscale x 32 x i8>,<vscale x 32 x i8>, ptr, <vscale x 32 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv32i8.nxv32i8(<vscale x 32 x i8>,<vscale x 32 x i8>, ptr, <vscale x 32 x i8>, <vscale x 32 x i1>, i64)

define void @test_vsuxseg2_nxv32i8_nxv32i8(<vscale x 32 x i8> %val, ptr %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv32i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv32i8.nxv32i8(<vscale x 32 x i8> %val,<vscale x 32 x i8> %val, ptr %base, <vscale x 32 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv32i8_nxv32i8(<vscale x 32 x i8> %val, ptr %base, <vscale x 32 x i8> %index, <vscale x 32 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv32i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv32i8.nxv32i8(<vscale x 32 x i8> %val,<vscale x 32 x i8> %val, ptr %base, <vscale x 32 x i8> %index, <vscale x 32 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2i16.nxv2i32(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2i16_nxv2i32(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2i16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2i16.nxv2i32(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2i16.nxv2i8(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2i16_nxv2i8(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2i16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2i16.nxv2i8(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2i16.nxv2i16(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2i16_nxv2i16(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2i16.nxv2i16(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2i16.nxv2i64(<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>,<vscale x 2 x i16>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2i16_nxv2i64(<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2i16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2i16.nxv2i64(<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val,<vscale x 2 x i16> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i64.nxv2i32(<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i64.nxv2i32(<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i64_nxv2i32(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i64.nxv2i32(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i64_nxv2i32(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i64.nxv2i32(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i64.nxv2i8(<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i64.nxv2i8(<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i64_nxv2i8(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i64.nxv2i8(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i64_nxv2i8(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i64.nxv2i8(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i64.nxv2i16(<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i64.nxv2i16(<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i64_nxv2i16(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i64.nxv2i16(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i64_nxv2i16(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i64.nxv2i16(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2i64.nxv2i64(<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2i64.nxv2i64(<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2i64_nxv2i64(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2i64.nxv2i64(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2i64_nxv2i64(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2i64.nxv2i64(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i64.nxv2i32(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i64.nxv2i32(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i64_nxv2i32(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i64.nxv2i32(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i64_nxv2i32(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i64.nxv2i32(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i64.nxv2i8(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i64.nxv2i8(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i64_nxv2i8(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i64.nxv2i8(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i64_nxv2i8(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i64.nxv2i8(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i64.nxv2i16(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i64.nxv2i16(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i64_nxv2i16(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i64.nxv2i16(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i64_nxv2i16(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i64.nxv2i16(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2i64.nxv2i64(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2i64.nxv2i64(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2i64_nxv2i64(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2i64.nxv2i64(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2i64_nxv2i64(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2i64.nxv2i64(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i64.nxv2i32(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i64.nxv2i32(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i64_nxv2i32(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i64.nxv2i32(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i64_nxv2i32(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i64.nxv2i32(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i64.nxv2i8(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i64.nxv2i8(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i64_nxv2i8(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i64.nxv2i8(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i64_nxv2i8(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i64.nxv2i8(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i64.nxv2i16(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i64.nxv2i16(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i64_nxv2i16(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i64.nxv2i16(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i64_nxv2i16(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i64.nxv2i16(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2i64.nxv2i64(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2i64.nxv2i64(<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>,<vscale x 2 x i64>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2i64_nxv2i64(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2i64.nxv2i64(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2i64_nxv2i64(<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2i64.nxv2i64(<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val,<vscale x 2 x i64> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv16f16.nxv16i16(<vscale x 16 x half>,<vscale x 16 x half>, ptr, <vscale x 16 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv16f16.nxv16i16(<vscale x 16 x half>,<vscale x 16 x half>, ptr, <vscale x 16 x i16>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg2_nxv16f16_nxv16i16(<vscale x 16 x half> %val, ptr %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv16f16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv16f16.nxv16i16(<vscale x 16 x half> %val,<vscale x 16 x half> %val, ptr %base, <vscale x 16 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv16f16_nxv16i16(<vscale x 16 x half> %val, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv16f16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv16f16.nxv16i16(<vscale x 16 x half> %val,<vscale x 16 x half> %val, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv16f16.nxv16i8(<vscale x 16 x half>,<vscale x 16 x half>, ptr, <vscale x 16 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv16f16.nxv16i8(<vscale x 16 x half>,<vscale x 16 x half>, ptr, <vscale x 16 x i8>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg2_nxv16f16_nxv16i8(<vscale x 16 x half> %val, ptr %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv16f16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv16f16.nxv16i8(<vscale x 16 x half> %val,<vscale x 16 x half> %val, ptr %base, <vscale x 16 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv16f16_nxv16i8(<vscale x 16 x half> %val, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv16f16_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv16f16.nxv16i8(<vscale x 16 x half> %val,<vscale x 16 x half> %val, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv16f16.nxv16i32(<vscale x 16 x half>,<vscale x 16 x half>, ptr, <vscale x 16 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv16f16.nxv16i32(<vscale x 16 x half>,<vscale x 16 x half>, ptr, <vscale x 16 x i32>, <vscale x 16 x i1>, i64)

define void @test_vsuxseg2_nxv16f16_nxv16i32(<vscale x 16 x half> %val, ptr %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv16f16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv16f16.nxv16i32(<vscale x 16 x half> %val,<vscale x 16 x half> %val, ptr %base, <vscale x 16 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv16f16_nxv16i32(<vscale x 16 x half> %val, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv16f16_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv16f16.nxv16i32(<vscale x 16 x half> %val,<vscale x 16 x half> %val, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4f64.nxv4i32(<vscale x 4 x double>,<vscale x 4 x double>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4f64.nxv4i32(<vscale x 4 x double>,<vscale x 4 x double>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4f64_nxv4i32(<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4f64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4f64.nxv4i32(<vscale x 4 x double> %val,<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4f64_nxv4i32(<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4f64_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4f64.nxv4i32(<vscale x 4 x double> %val,<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4f64.nxv4i8(<vscale x 4 x double>,<vscale x 4 x double>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4f64.nxv4i8(<vscale x 4 x double>,<vscale x 4 x double>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4f64_nxv4i8(<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4f64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4f64.nxv4i8(<vscale x 4 x double> %val,<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4f64_nxv4i8(<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4f64_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4f64.nxv4i8(<vscale x 4 x double> %val,<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4f64.nxv4i64(<vscale x 4 x double>,<vscale x 4 x double>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4f64.nxv4i64(<vscale x 4 x double>,<vscale x 4 x double>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4f64_nxv4i64(<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4f64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4f64.nxv4i64(<vscale x 4 x double> %val,<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4f64_nxv4i64(<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4f64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4f64.nxv4i64(<vscale x 4 x double> %val,<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4f64.nxv4i16(<vscale x 4 x double>,<vscale x 4 x double>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4f64.nxv4i16(<vscale x 4 x double>,<vscale x 4 x double>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4f64_nxv4i16(<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4f64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4f64.nxv4i16(<vscale x 4 x double> %val,<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4f64_nxv4i16(<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4f64_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4f64.nxv4i16(<vscale x 4 x double> %val,<vscale x 4 x double> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1f64.nxv1i64(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1f64_nxv1i64(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1f64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1f64.nxv1i64(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1f64.nxv1i32(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1f64_nxv1i32(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1f64_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1f64.nxv1i32(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1f64.nxv1i16(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1f64_nxv1i16(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1f64_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1f64.nxv1i16(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1f64.nxv1i8(<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>,<vscale x 1 x double>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1f64_nxv1i8(<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1f64_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1f64.nxv1i8(<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val,<vscale x 1 x double> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2f32.nxv2i32(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2f32_nxv2i32(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2f32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2f32.nxv2i32(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2f32.nxv2i8(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2f32_nxv2i8(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2f32_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2f32.nxv2i8(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2f32.nxv2i16(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2f32_nxv2i16(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2f32_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2f32.nxv2i16(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv2f32.nxv2i64(<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>,<vscale x 2 x float>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg8_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv2f32_nxv2i64(<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv2f32_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv2f32.nxv2i64(<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val,<vscale x 2 x float> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1f16.nxv1i64(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1f16_nxv1i64(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1f16_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1f16.nxv1i64(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1f16.nxv1i32(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1f16_nxv1i32(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1f16_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1f16.nxv1i32(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1f16.nxv1i16(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1f16_nxv1i16(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1f16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1f16.nxv1i16(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1f16.nxv1i8(<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>,<vscale x 1 x half>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1f16_nxv1i8(<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1f16_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1f16.nxv1i8(<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val,<vscale x 1 x half> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg2_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg3_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg4_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg5_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg6_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg7_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1f32.nxv1i64(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1f32_nxv1i64(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1f32_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1f32.nxv1i64(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1f32.nxv1i32(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1f32_nxv1i32(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1f32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1f32.nxv1i32(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1f32.nxv1i16(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1f32_nxv1i16(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1f32_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1f32.nxv1i16(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv1f32.nxv1i8(<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>,<vscale x 1 x float>, ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64)

define void @test_vsuxseg8_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv1f32_nxv1i8(<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv1f32_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv1f32.nxv1i8(<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val,<vscale x 1 x float> %val, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8f16.nxv8i16(<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8f16.nxv8i16(<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8f16_nxv8i16(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8f16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8f16.nxv8i16(<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8f16_nxv8i16(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8f16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8f16.nxv8i16(<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8f16.nxv8i8(<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8f16.nxv8i8(<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8f16_nxv8i8(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8f16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8f16.nxv8i8(<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8f16_nxv8i8(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8f16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8f16.nxv8i8(<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8f16.nxv8i64(<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8f16.nxv8i64(<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8f16_nxv8i64(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8f16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8f16.nxv8i64(<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8f16_nxv8i64(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8f16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8f16.nxv8i64(<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8f16.nxv8i32(<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8f16.nxv8i32(<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8f16_nxv8i32(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8f16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8f16.nxv8i32(<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8f16_nxv8i32(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8f16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8f16.nxv8i32(<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv8f16.nxv8i16(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv8f16.nxv8i16(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg3_nxv8f16_nxv8i16(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv8f16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv8f16.nxv8i16(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv8f16_nxv8i16(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv8f16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv8f16.nxv8i16(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv8f16.nxv8i8(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv8f16.nxv8i8(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg3_nxv8f16_nxv8i8(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv8f16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv8f16.nxv8i8(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv8f16_nxv8i8(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv8f16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv8f16.nxv8i8(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv8f16.nxv8i64(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv8f16.nxv8i64(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg3_nxv8f16_nxv8i64(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv8f16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv8f16.nxv8i64(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv8f16_nxv8i64(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv8f16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv8f16.nxv8i64(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv8f16.nxv8i32(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv8f16.nxv8i32(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg3_nxv8f16_nxv8i32(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv8f16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv8f16.nxv8i32(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv8f16_nxv8i32(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv8f16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv8f16.nxv8i32(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv8f16.nxv8i16(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv8f16.nxv8i16(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg4_nxv8f16_nxv8i16(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv8f16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv8f16.nxv8i16(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv8f16_nxv8i16(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv8f16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv8f16.nxv8i16(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv8f16.nxv8i8(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv8f16.nxv8i8(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg4_nxv8f16_nxv8i8(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv8f16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv8f16.nxv8i8(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv8f16_nxv8i8(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv8f16_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv8f16.nxv8i8(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv8f16.nxv8i64(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv8f16.nxv8i64(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg4_nxv8f16_nxv8i64(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv8f16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv8f16.nxv8i64(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv8f16_nxv8i64(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv8f16_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 def $v8m2_v10m2_v12m2_v14m2
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv8f16.nxv8i64(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv8f16.nxv8i32(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv8f16.nxv8i32(<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>,<vscale x 8 x half>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg4_nxv8f16_nxv8i32(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv8f16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv8f16.nxv8i32(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv8f16_nxv8i32(<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv8f16_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v16, v8
; CHECK-NEXT:    vmv2r.v v18, v16
; CHECK-NEXT:    vmv2r.v v20, v16
; CHECK-NEXT:    vmv2r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv8f16.nxv8i32(<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val,<vscale x 8 x half> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8f32.nxv8i16(<vscale x 8 x float>,<vscale x 8 x float>, ptr, <vscale x 8 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8f32.nxv8i16(<vscale x 8 x float>,<vscale x 8 x float>, ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8f32_nxv8i16(<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8f32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8f32.nxv8i16(<vscale x 8 x float> %val,<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8f32_nxv8i16(<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8f32_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8f32.nxv8i16(<vscale x 8 x float> %val,<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8f32.nxv8i8(<vscale x 8 x float>,<vscale x 8 x float>, ptr, <vscale x 8 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8f32.nxv8i8(<vscale x 8 x float>,<vscale x 8 x float>, ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8f32_nxv8i8(<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8f32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8f32.nxv8i8(<vscale x 8 x float> %val,<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8f32_nxv8i8(<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8f32_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8f32.nxv8i8(<vscale x 8 x float> %val,<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8f32.nxv8i64(<vscale x 8 x float>,<vscale x 8 x float>, ptr, <vscale x 8 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8f32.nxv8i64(<vscale x 8 x float>,<vscale x 8 x float>, ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8f32_nxv8i64(<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8f32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8f32.nxv8i64(<vscale x 8 x float> %val,<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8f32_nxv8i64(<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8f32_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8f32.nxv8i64(<vscale x 8 x float> %val,<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv8f32.nxv8i32(<vscale x 8 x float>,<vscale x 8 x float>, ptr, <vscale x 8 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv8f32.nxv8i32(<vscale x 8 x float>,<vscale x 8 x float>, ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64)

define void @test_vsuxseg2_nxv8f32_nxv8i32(<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv8f32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv8f32.nxv8i32(<vscale x 8 x float> %val,<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv8f32_nxv8i32(<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv8f32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 killed $v8m4_v12m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v16, v12
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv8f32.nxv8i32(<vscale x 8 x float> %val,<vscale x 8 x float> %val, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2f64.nxv2i32(<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2f64.nxv2i32(<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2f64_nxv2i32(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2f64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2f64.nxv2i32(<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2f64_nxv2i32(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2f64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2f64.nxv2i32(<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2f64.nxv2i8(<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2f64.nxv2i8(<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2f64_nxv2i8(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2f64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2f64.nxv2i8(<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2f64_nxv2i8(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2f64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2f64.nxv2i8(<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2f64.nxv2i16(<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2f64.nxv2i16(<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2f64_nxv2i16(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2f64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2f64.nxv2i16(<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2f64_nxv2i16(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2f64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2f64.nxv2i16(<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2f64.nxv2i64(<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2f64.nxv2i64(<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2f64_nxv2i64(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2f64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2f64.nxv2i64(<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2f64_nxv2i64(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2f64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m2 killed $v8m2 killed $v8m2_v10m2 def $v8m2_v10m2
; CHECK-NEXT:    vmv2r.v v12, v10
; CHECK-NEXT:    vmv2r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2f64.nxv2i64(<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2f64.nxv2i32(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2f64.nxv2i32(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2f64_nxv2i32(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2f64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2f64.nxv2i32(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2f64_nxv2i32(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2f64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2f64.nxv2i32(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2f64.nxv2i8(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2f64.nxv2i8(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2f64_nxv2i8(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2f64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2f64.nxv2i8(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2f64_nxv2i8(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2f64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2f64.nxv2i8(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2f64.nxv2i16(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2f64.nxv2i16(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2f64_nxv2i16(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2f64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2f64.nxv2i16(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2f64_nxv2i16(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2f64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2f64.nxv2i16(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2f64.nxv2i64(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2f64.nxv2i64(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2f64_nxv2i64(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2f64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2f64.nxv2i64(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2f64_nxv2i64(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2f64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2f64.nxv2i64(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2f64.nxv2i32(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2f64.nxv2i32(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2f64_nxv2i32(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2f64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2f64.nxv2i32(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2f64_nxv2i32(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2f64_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2f64.nxv2i32(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2f64.nxv2i8(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2f64.nxv2i8(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2f64_nxv2i8(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2f64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2f64.nxv2i8(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2f64_nxv2i8(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2f64_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2f64.nxv2i8(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2f64.nxv2i16(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2f64.nxv2i16(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2f64_nxv2i16(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2f64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2f64.nxv2i16(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2f64_nxv2i16(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2f64_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2f64.nxv2i16(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2f64.nxv2i64(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2f64.nxv2i64(<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>,<vscale x 2 x double>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2f64_nxv2i64(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2f64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2f64.nxv2i64(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2f64_nxv2i64(<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2f64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vmv2r.v v14, v12
; CHECK-NEXT:    vmv2r.v v16, v12
; CHECK-NEXT:    vmv2r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2f64.nxv2i64(<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val,<vscale x 2 x double> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg2_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg3_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v8, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v8, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg4_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg5_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg5_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg5_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg5_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg6_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg6_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg6_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg6_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg7_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg7_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg7_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg7_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg7ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv4f16.nxv4i32(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg8_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv4f16_nxv4i32(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv4f16_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vmv1r.v v18, v12
; CHECK-NEXT:    vmv1r.v v19, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei32.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv4f16.nxv4i32(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv4f16.nxv4i8(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg8_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv4f16_nxv4i8(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv4f16_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv4f16.nxv4i8(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv4f16.nxv4i64(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg8_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v16, (a0), v12
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv4f16_nxv4i64(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv4f16_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v16, v8
; CHECK-NEXT:    vmv1r.v v17, v16
; CHECK-NEXT:    vmv1r.v v18, v16
; CHECK-NEXT:    vmv1r.v v19, v16
; CHECK-NEXT:    vmv1r.v v20, v16
; CHECK-NEXT:    vmv1r.v v21, v16
; CHECK-NEXT:    vmv1r.v v22, v16
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei64.v v16, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv4f16.nxv4i64(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg8.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, i64)
declare void @llvm.riscv.vsuxseg8.mask.nxv4f16.nxv4i16(<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>,<vscale x 4 x half>, ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64)

define void @test_vsuxseg8_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg8_mask_nxv4f16_nxv4i16(<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg8_mask_nxv4f16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vmv1r.v v17, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vsuxseg8ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg8.mask.nxv4f16.nxv4i16(<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val,<vscale x 4 x half> %val, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2f16.nxv2i32(<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2f16.nxv2i32(<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2f16_nxv2i32(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2f16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2f16.nxv2i32(<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2f16_nxv2i32(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2f16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei32.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2f16.nxv2i32(<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2f16.nxv2i8(<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2f16.nxv2i8(<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2f16_nxv2i8(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2f16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2f16.nxv2i8(<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2f16_nxv2i8(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2f16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei8.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2f16.nxv2i8(<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2f16.nxv2i16(<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2f16.nxv2i16(<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2f16_nxv2i16(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2f16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2f16.nxv2i16(<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2f16_nxv2i16(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2f16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 killed $v8_v9 def $v8_v9
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei16.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2f16.nxv2i16(<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg2.nxv2f16.nxv2i64(<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg2.mask.nxv2f16.nxv2i64(<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg2_nxv2f16_nxv2i64(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_nxv2f16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.nxv2f16.nxv2i64(<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg2_mask_nxv2f16_nxv2i64(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg2_mask_nxv2f16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg2ei64.v v8, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg2.mask.nxv2f16.nxv2i64(<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2f16.nxv2i32(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2f16.nxv2i32(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2f16_nxv2i32(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2f16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2f16.nxv2i32(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2f16_nxv2i32(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2f16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2f16.nxv2i32(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2f16.nxv2i8(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2f16.nxv2i8(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2f16_nxv2i8(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2f16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2f16.nxv2i8(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2f16_nxv2i8(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2f16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2f16.nxv2i8(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2f16.nxv2i16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2f16.nxv2i16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2f16_nxv2i16(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2f16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2f16.nxv2i16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2f16_nxv2i16(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2f16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2f16.nxv2i16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg3.nxv2f16.nxv2i64(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg3.mask.nxv2f16.nxv2i64(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg3_nxv2f16_nxv2i64(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_nxv2f16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.nxv2f16.nxv2i64(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg3_mask_nxv2f16_nxv2i64(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg3_mask_nxv2f16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg3ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg3.mask.nxv2f16.nxv2i64(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2f16.nxv2i32(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2f16.nxv2i32(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2f16_nxv2i32(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2f16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2f16.nxv2i32(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2f16_nxv2i32(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2f16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2f16.nxv2i32(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2f16.nxv2i8(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2f16.nxv2i8(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2f16_nxv2i8(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2f16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2f16.nxv2i8(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2f16_nxv2i8(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2f16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2f16.nxv2i8(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2f16.nxv2i16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2f16.nxv2i16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2f16_nxv2i16(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2f16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2f16.nxv2i16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2f16_nxv2i16(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2f16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2f16.nxv2i16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg4.nxv2f16.nxv2i64(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg4.mask.nxv2f16.nxv2i64(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg4_nxv2f16_nxv2i64(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_nxv2f16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.nxv2f16.nxv2i64(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg4_mask_nxv2f16_nxv2i64(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg4_mask_nxv2f16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg4ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg4.mask.nxv2f16.nxv2i64(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2f16.nxv2i32(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2f16.nxv2i32(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2f16_nxv2i32(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2f16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2f16.nxv2i32(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2f16_nxv2i32(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2f16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2f16.nxv2i32(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2f16.nxv2i8(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2f16.nxv2i8(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2f16_nxv2i8(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2f16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2f16.nxv2i8(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2f16_nxv2i8(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2f16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2f16.nxv2i8(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2f16.nxv2i16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2f16.nxv2i16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2f16_nxv2i16(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2f16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2f16.nxv2i16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2f16_nxv2i16(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2f16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2f16.nxv2i16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg5.nxv2f16.nxv2i64(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg5.mask.nxv2f16.nxv2i64(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg5_nxv2f16_nxv2i64(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_nxv2f16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.nxv2f16.nxv2i64(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg5_mask_nxv2f16_nxv2i64(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg5_mask_nxv2f16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg5ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg5.mask.nxv2f16.nxv2i64(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2f16.nxv2i32(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2f16.nxv2i32(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2f16_nxv2i32(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2f16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2f16.nxv2i32(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2f16_nxv2i32(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2f16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2f16.nxv2i32(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2f16.nxv2i8(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2f16.nxv2i8(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2f16_nxv2i8(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2f16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2f16.nxv2i8(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2f16_nxv2i8(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2f16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2f16.nxv2i8(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2f16.nxv2i16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2f16.nxv2i16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2f16_nxv2i16(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2f16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2f16.nxv2i16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2f16_nxv2i16(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2f16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei16.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2f16.nxv2i16(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg6.nxv2f16.nxv2i64(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i64>, i64)
declare void @llvm.riscv.vsuxseg6.mask.nxv2f16.nxv2i64(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg6_nxv2f16_nxv2i64(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_nxv2f16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v12, (a0), v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.nxv2f16.nxv2i64(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg6_mask_nxv2f16_nxv2i64(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg6_mask_nxv2f16_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v12
; CHECK-NEXT:    vmv1r.v v14, v12
; CHECK-NEXT:    vmv1r.v v15, v12
; CHECK-NEXT:    vmv1r.v v16, v12
; CHECK-NEXT:    vmv1r.v v17, v12
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg6ei64.v v12, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg6.mask.nxv2f16.nxv2i64(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2f16.nxv2i32(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i32>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2f16.nxv2i32(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2f16_nxv2i32(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2f16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2f16.nxv2i32(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2f16_nxv2i32(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2f16_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei32.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2f16.nxv2i32(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2f16.nxv2i8(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i8>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2f16.nxv2i8(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2f16_nxv2i8(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2f16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.nxv2f16.nxv2i8(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, i64 %vl)
  ret void
}

define void @test_vsuxseg7_mask_nxv2f16_nxv2i8(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_mask_nxv2f16_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vsuxseg7ei8.v v10, (a0), v9, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vsuxseg7.mask.nxv2f16.nxv2i8(<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val,<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl)
  ret void
}

declare void @llvm.riscv.vsuxseg7.nxv2f16.nxv2i16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i16>, i64)
declare void @llvm.riscv.vsuxseg7.mask.nxv2f16.nxv2i16(<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>,<vscale x 2 x half>, ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64)

define void @test_vsuxseg7_nxv2f16_nxv2i16(<vscale x 2 x half> %val, ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vsuxseg7_nxv2f16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v10
; CHECK-NEXT:    vmv1r.v v12, v10
; CHECK-NEXT:    vmv1r.v v13, v10
; CHECK-NEXT:    vmv1r.v v14, v10
; CHECK-NEXT:    vmv1r.v v15, v10
; CHECK-NEXT:    vmv1r.v v16, v10
; CHECK-N