; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=RV32,LMULMAX2-RV32
; RUN: llc -mtriple=riscv64 -mattr=+v -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=RV64,LMULMAX2-RV64
; RUN: llc -mtriple=riscv32 -mattr=+v -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=RV32,LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -mattr=+v -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=RV64,LMULMAX1-RV64

define void @bitreverse_v8i16(ptr %x, ptr %y) {
; RV32-LABEL: bitreverse_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV32-NEXT:    vle16.v v8, (a0)
; RV32-NEXT:    vsrl.vi v9, v8, 8
; RV32-NEXT:    vsll.vi v8, v8, 8
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    vsrl.vi v9, v8, 4
; RV32-NEXT:    lui a1, 1
; RV32-NEXT:    addi a1, a1, -241
; RV32-NEXT:    vand.vx v9, v9, a1
; RV32-NEXT:    vand.vx v8, v8, a1
; RV32-NEXT:    vsll.vi v8, v8, 4
; RV32-NEXT:    vor.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 2
; RV32-NEXT:    lui a1, 3
; RV32-NEXT:    addi a1, a1, 819
; RV32-NEXT:    vand.vx v9, v9, a1
; RV32-NEXT:    vand.vx v8, v8, a1
; RV32-NEXT:    vsll.vi v8, v8, 2
; RV32-NEXT:    vor.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 1
; RV32-NEXT:    lui a1, 5
; RV32-NEXT:    addi a1, a1, 1365
; RV32-NEXT:    vand.vx v9, v9, a1
; RV32-NEXT:    vand.vx v8, v8, a1
; RV32-NEXT:    vadd.vv v8, v8, v8
; RV32-NEXT:    vor.vv v8, v9, v8
; RV32-NEXT:    vse16.v v8, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: bitreverse_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; RV64-NEXT:    vle16.v v8, (a0)
; RV64-NEXT:    vsrl.vi v9, v8, 8
; RV64-NEXT:    vsll.vi v8, v8, 8
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    lui a1, 1
; RV64-NEXT:    addiw a1, a1, -241
; RV64-NEXT:    vand.vx v9, v9, a1
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vsll.vi v8, v8, 4
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 2
; RV64-NEXT:    lui a1, 3
; RV64-NEXT:    addiw a1, a1, 819
; RV64-NEXT:    vand.vx v9, v9, a1
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vsll.vi v8, v8, 2
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    lui a1, 5
; RV64-NEXT:    addiw a1, a1, 1365
; RV64-NEXT:    vand.vx v9, v9, a1
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vadd.vv v8, v8, v8
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    vse16.v v8, (a0)
; RV64-NEXT:    ret
  %a = load <8 x i16>, ptr %x
  %b = load <8 x i16>, ptr %y
  %c = call <8 x i16> @llvm.bitreverse.v8i16(<8 x i16> %a)
  store <8 x i16> %c, ptr %x
  ret void
}
declare <8 x i16> @llvm.bitreverse.v8i16(<8 x i16>)

define void @bitreverse_v4i32(ptr %x, ptr %y) {
; RV32-LABEL: bitreverse_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vle32.v v8, (a0)
; RV32-NEXT:    vsrl.vi v9, v8, 8
; RV32-NEXT:    lui a1, 16
; RV32-NEXT:    addi a1, a1, -256
; RV32-NEXT:    vand.vx v9, v9, a1
; RV32-NEXT:    vsrl.vi v10, v8, 24
; RV32-NEXT:    vor.vv v9, v9, v10
; RV32-NEXT:    vsll.vi v10, v8, 24
; RV32-NEXT:    vand.vx v8, v8, a1
; RV32-NEXT:    vsll.vi v8, v8, 8
; RV32-NEXT:    vor.vv v8, v10, v8
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    vsrl.vi v9, v8, 4
; RV32-NEXT:    lui a1, 61681
; RV32-NEXT:    addi a1, a1, -241
; RV32-NEXT:    vand.vx v9, v9, a1
; RV32-NEXT:    vand.vx v8, v8, a1
; RV32-NEXT:    vsll.vi v8, v8, 4
; RV32-NEXT:    vor.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 2
; RV32-NEXT:    lui a1, 209715
; RV32-NEXT:    addi a1, a1, 819
; RV32-NEXT:    vand.vx v9, v9, a1
; RV32-NEXT:    vand.vx v8, v8, a1
; RV32-NEXT:    vsll.vi v8, v8, 2
; RV32-NEXT:    vor.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 1
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a1, a1, 1365
; RV32-NEXT:    vand.vx v9, v9, a1
; RV32-NEXT:    vand.vx v8, v8, a1
; RV32-NEXT:    vadd.vv v8, v8, v8
; RV32-NEXT:    vor.vv v8, v9, v8
; RV32-NEXT:    vse32.v v8, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: bitreverse_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV64-NEXT:    vle32.v v8, (a0)
; RV64-NEXT:    vsrl.vi v9, v8, 8
; RV64-NEXT:    lui a1, 16
; RV64-NEXT:    addiw a1, a1, -256
; RV64-NEXT:    vand.vx v9, v9, a1
; RV64-NEXT:    vsrl.vi v10, v8, 24
; RV64-NEXT:    vor.vv v9, v9, v10
; RV64-NEXT:    vsll.vi v10, v8, 24
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vsll.vi v8, v8, 8
; RV64-NEXT:    vor.vv v8, v10, v8
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    lui a1, 61681
; RV64-NEXT:    addiw a1, a1, -241
; RV64-NEXT:    vand.vx v9, v9, a1
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vsll.vi v8, v8, 4
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 2
; RV64-NEXT:    lui a1, 209715
; RV64-NEXT:    addiw a1, a1, 819
; RV64-NEXT:    vand.vx v9, v9, a1
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vsll.vi v8, v8, 2
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    lui a1, 349525
; RV64-NEXT:    addiw a1, a1, 1365
; RV64-NEXT:    vand.vx v9, v9, a1
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vadd.vv v8, v8, v8
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    vse32.v v8, (a0)
; RV64-NEXT:    ret
  %a = load <4 x i32>, ptr %x
  %b = load <4 x i32>, ptr %y
  %c = call <4 x i32> @llvm.bitreverse.v4i32(<4 x i32> %a)
  store <4 x i32> %c, ptr %x
  ret void
}
declare <4 x i32> @llvm.bitreverse.v4i32(<4 x i32>)

define void @bitreverse_v2i64(ptr %x, ptr %y) {
; RV32-LABEL: bitreverse_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv.v.i v9, 0
; RV32-NEXT:    vmv.v.i v0, 5
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    vmerge.vxm v9, v9, a1, v0
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vi v10, v8, 8
; RV32-NEXT:    vand.vv v10, v10, v9
; RV32-NEXT:    vsrl.vi v11, v8, 24
; RV32-NEXT:    lui a1, 4080
; RV32-NEXT:    vand.vx v11, v11, a1
; RV32-NEXT:    vor.vv v10, v10, v11
; RV32-NEXT:    li a2, 56
; RV32-NEXT:    vsrl.vx v11, v8, a2
; RV32-NEXT:    li a3, 40
; RV32-NEXT:    vsrl.vx v12, v8, a3
; RV32-NEXT:    lui a4, 16
; RV32-NEXT:    addi a4, a4, -256
; RV32-NEXT:    vand.vx v12, v12, a4
; RV32-NEXT:    vor.vv v11, v12, v11
; RV32-NEXT:    vor.vv v10, v10, v11
; RV32-NEXT:    vand.vv v9, v8, v9
; RV32-NEXT:    vsll.vi v9, v9, 8
; RV32-NEXT:    vand.vx v11, v8, a1
; RV32-NEXT:    vsll.vi v11, v11, 24
; RV32-NEXT:    vor.vv v9, v11, v9
; RV32-NEXT:    vsll.vx v11, v8, a2
; RV32-NEXT:    vand.vx v8, v8, a4
; RV32-NEXT:    vsll.vx v8, v8, a3
; RV32-NEXT:    vor.vv v8, v11, v8
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    vsrl.vi v9, v8, 4
; RV32-NEXT:    lui a1, 61681
; RV32-NEXT:    addi a1, a1, -241
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv.v.x v10, a1
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vand.vv v9, v9, v10
; RV32-NEXT:    vand.vv v8, v8, v10
; RV32-NEXT:    vsll.vi v8, v8, 4
; RV32-NEXT:    vor.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 2
; RV32-NEXT:    lui a1, 209715
; RV32-NEXT:    addi a1, a1, 819
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv.v.x v10, a1
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vand.vv v9, v9, v10
; RV32-NEXT:    vand.vv v8, v8, v10
; RV32-NEXT:    vsll.vi v8, v8, 2
; RV32-NEXT:    vor.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 1
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a1, a1, 1365
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv.v.x v10, a1
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vand.vv v9, v9, v10
; RV32-NEXT:    vand.vv v8, v8, v10
; RV32-NEXT:    vadd.vv v8, v8, v8
; RV32-NEXT:    vor.vv v8, v9, v8
; RV32-NEXT:    vse64.v v8, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: bitreverse_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    li a1, 56
; RV64-NEXT:    vsrl.vx v9, v8, a1
; RV64-NEXT:    li a2, 40
; RV64-NEXT:    vsrl.vx v10, v8, a2
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v10, v10, a3
; RV64-NEXT:    vor.vv v9, v10, v9
; RV64-NEXT:    vsrl.vi v10, v8, 24
; RV64-NEXT:    lui a4, 4080
; RV64-NEXT:    vand.vx v10, v10, a4
; RV64-NEXT:    vsrl.vi v11, v8, 8
; RV64-NEXT:    li a5, 255
; RV64-NEXT:    slli a5, a5, 24
; RV64-NEXT:    vand.vx v11, v11, a5
; RV64-NEXT:    vor.vv v10, v11, v10
; RV64-NEXT:    vor.vv v9, v10, v9
; RV64-NEXT:    vand.vx v10, v8, a5
; RV64-NEXT:    vsll.vi v10, v10, 8
; RV64-NEXT:    vand.vx v11, v8, a4
; RV64-NEXT:    vsll.vi v11, v11, 24
; RV64-NEXT:    vor.vv v10, v11, v10
; RV64-NEXT:    vsll.vx v11, v8, a1
; RV64-NEXT:    vand.vx v8, v8, a3
; RV64-NEXT:    vsll.vx v8, v8, a2
; RV64-NEXT:    vor.vv v8, v11, v8
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    lui a1, 61681
; RV64-NEXT:    addiw a1, a1, -241
; RV64-NEXT:    slli a2, a1, 32
; RV64-NEXT:    add a1, a1, a2
; RV64-NEXT:    vand.vx v9, v9, a1
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vsll.vi v8, v8, 4
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 2
; RV64-NEXT:    lui a1, 209715
; RV64-NEXT:    addiw a1, a1, 819
; RV64-NEXT:    slli a2, a1, 32
; RV64-NEXT:    add a1, a1, a2
; RV64-NEXT:    vand.vx v9, v9, a1
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vsll.vi v8, v8, 2
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    lui a1, 349525
; RV64-NEXT:    addiw a1, a1, 1365
; RV64-NEXT:    slli a2, a1, 32
; RV64-NEXT:    add a1, a1, a2
; RV64-NEXT:    vand.vx v9, v9, a1
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vadd.vv v8, v8, v8
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    vse64.v v8, (a0)
; RV64-NEXT:    ret
  %a = load <2 x i64>, ptr %x
  %b = load <2 x i64>, ptr %y
  %c = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> %a)
  store <2 x i64> %c, ptr %x
  ret void
}
declare <2 x i64> @llvm.bitreverse.v2i64(<2 x i64>)

define void @bitreverse_v16i16(ptr %x, ptr %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v16i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; LMULMAX2-RV32-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32-NEXT:    lui a1, 1
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV32-NEXT:    lui a1, 3
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32-NEXT:    lui a1, 5
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v16i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; LMULMAX2-RV64-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64-NEXT:    lui a1, 1
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV64-NEXT:    lui a1, 3
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64-NEXT:    lui a1, 5
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v8, (a1)
; LMULMAX1-RV32-NEXT:    vle16.v v9, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV32-NEXT:    lui a2, 1
; LMULMAX1-RV32-NEXT:    addi a2, a2, -241
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a2
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX1-RV32-NEXT:    lui a3, 3
; LMULMAX1-RV32-NEXT:    addi a3, a3, 819
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a3
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV32-NEXT:    lui a4, 5
; LMULMAX1-RV32-NEXT:    addi a4, a4, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 8
; LMULMAX1-RV32-NEXT:    vsll.vi v9, v9, 8
; LMULMAX1-RV32-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a2
; LMULMAX1-RV32-NEXT:    vsll.vi v9, v9, 4
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 2
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a3
; LMULMAX1-RV32-NEXT:    vsll.vi v9, v9, 2
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-RV32-NEXT:    vadd.vv v9, v9, v9
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vse16.v v9, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v8, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v8, (a1)
; LMULMAX1-RV64-NEXT:    vle16.v v9, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV64-NEXT:    lui a2, 1
; LMULMAX1-RV64-NEXT:    addiw a2, a2, -241
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a2
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX1-RV64-NEXT:    lui a3, 3
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a3
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV64-NEXT:    lui a4, 5
; LMULMAX1-RV64-NEXT:    addiw a4, a4, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 8
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 8
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a2
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 4
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 2
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a3
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 2
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-RV64-NEXT:    vadd.vv v9, v9, v9
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vse16.v v9, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v8, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, ptr %x
  %b = load <16 x i16>, ptr %y
  %c = call <16 x i16> @llvm.bitreverse.v16i16(<16 x i16> %a)
  store <16 x i16> %c, ptr %x
  ret void
}
declare <16 x i16> @llvm.bitreverse.v16i16(<16 x i16>)

define void @bitreverse_v8i32(ptr %x, ptr %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v8i32:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV32-NEXT:    lui a1, 16
; LMULMAX2-RV32-NEXT:    addi a1, a1, -256
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v12, v8, 24
; LMULMAX2-RV32-NEXT:    vor.vv v10, v10, v12
; LMULMAX2-RV32-NEXT:    vsll.vi v12, v8, 24
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v12, v8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v8i32:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV64-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV64-NEXT:    lui a1, 16
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -256
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v12, v8, 24
; LMULMAX2-RV64-NEXT:    vor.vv v10, v10, v12
; LMULMAX2-RV64-NEXT:    vsll.vi v12, v8, 24
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v12, v8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64-NEXT:    lui a1, 61681
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV64-NEXT:    lui a1, 209715
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64-NEXT:    lui a1, 349525
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v8, (a1)
; LMULMAX1-RV32-NEXT:    vle32.v v9, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX1-RV32-NEXT:    lui a2, 16
; LMULMAX1-RV32-NEXT:    addi a2, a2, -256
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV32-NEXT:    vsrl.vi v11, v8, 24
; LMULMAX1-RV32-NEXT:    vor.vv v10, v10, v11
; LMULMAX1-RV32-NEXT:    vsll.vi v11, v8, 24
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a2
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v11, v8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV32-NEXT:    lui a3, 61681
; LMULMAX1-RV32-NEXT:    addi a3, a3, -241
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a3
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX1-RV32-NEXT:    lui a4, 209715
; LMULMAX1-RV32-NEXT:    addi a4, a4, 819
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV32-NEXT:    lui a5, 349525
; LMULMAX1-RV32-NEXT:    addi a5, a5, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a5
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a5
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 8
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV32-NEXT:    vsrl.vi v11, v9, 24
; LMULMAX1-RV32-NEXT:    vor.vv v10, v10, v11
; LMULMAX1-RV32-NEXT:    vsll.vi v11, v9, 24
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a2
; LMULMAX1-RV32-NEXT:    vsll.vi v9, v9, 8
; LMULMAX1-RV32-NEXT:    vor.vv v9, v11, v9
; LMULMAX1-RV32-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a3
; LMULMAX1-RV32-NEXT:    vsll.vi v9, v9, 4
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 2
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-RV32-NEXT:    vsll.vi v9, v9, 2
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a5
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a5
; LMULMAX1-RV32-NEXT:    vadd.vv v9, v9, v9
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vse32.v v9, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v8, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v8, (a1)
; LMULMAX1-RV64-NEXT:    vle32.v v9, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX1-RV64-NEXT:    lui a2, 16
; LMULMAX1-RV64-NEXT:    addiw a2, a2, -256
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV64-NEXT:    vsrl.vi v11, v8, 24
; LMULMAX1-RV64-NEXT:    vor.vv v10, v10, v11
; LMULMAX1-RV64-NEXT:    vsll.vi v11, v8, 24
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a2
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v11, v8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV64-NEXT:    lui a3, 61681
; LMULMAX1-RV64-NEXT:    addiw a3, a3, -241
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a3
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX1-RV64-NEXT:    lui a4, 209715
; LMULMAX1-RV64-NEXT:    addiw a4, a4, 819
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV64-NEXT:    lui a5, 349525
; LMULMAX1-RV64-NEXT:    addiw a5, a5, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a5
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a5
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 8
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV64-NEXT:    vsrl.vi v11, v9, 24
; LMULMAX1-RV64-NEXT:    vor.vv v10, v10, v11
; LMULMAX1-RV64-NEXT:    vsll.vi v11, v9, 24
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a2
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 8
; LMULMAX1-RV64-NEXT:    vor.vv v9, v11, v9
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a3
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 4
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 2
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 2
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a5
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a5
; LMULMAX1-RV64-NEXT:    vadd.vv v9, v9, v9
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vse32.v v9, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v8, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, ptr %x
  %b = load <8 x i32>, ptr %y
  %c = call <8 x i32> @llvm.bitreverse.v8i32(<8 x i32> %a)
  store <8 x i32> %c, ptr %x
  ret void
}
declare <8 x i32> @llvm.bitreverse.v8i32(<8 x i32>)

define void @bitreverse_v4i64(ptr %x, ptr %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v4i64:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32-NEXT:    li a1, 56
; LMULMAX2-RV32-NEXT:    vsrl.vx v10, v8, a1
; LMULMAX2-RV32-NEXT:    li a2, 40
; LMULMAX2-RV32-NEXT:    vsrl.vx v12, v8, a2
; LMULMAX2-RV32-NEXT:    lui a3, 16
; LMULMAX2-RV32-NEXT:    addi a3, a3, -256
; LMULMAX2-RV32-NEXT:    vand.vx v12, v12, a3
; LMULMAX2-RV32-NEXT:    vor.vv v10, v12, v10
; LMULMAX2-RV32-NEXT:    vsrl.vi v12, v8, 8
; LMULMAX2-RV32-NEXT:    li a4, 85
; LMULMAX2-RV32-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; LMULMAX2-RV32-NEXT:    vmv.v.x v0, a4
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32-NEXT:    vmv.v.i v14, 0
; LMULMAX2-RV32-NEXT:    lui a4, 1044480
; LMULMAX2-RV32-NEXT:    vmerge.vxm v14, v14, a4, v0
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32-NEXT:    vand.vv v12, v12, v14
; LMULMAX2-RV32-NEXT:    vsrl.vi v16, v8, 24
; LMULMAX2-RV32-NEXT:    lui a4, 4080
; LMULMAX2-RV32-NEXT:    vand.vx v16, v16, a4
; LMULMAX2-RV32-NEXT:    vor.vv v12, v12, v16
; LMULMAX2-RV32-NEXT:    vor.vv v10, v12, v10
; LMULMAX2-RV32-NEXT:    vsll.vx v12, v8, a1
; LMULMAX2-RV32-NEXT:    vand.vx v16, v8, a3
; LMULMAX2-RV32-NEXT:    vsll.vx v16, v16, a2
; LMULMAX2-RV32-NEXT:    vor.vv v12, v12, v16
; LMULMAX2-RV32-NEXT:    vand.vv v14, v8, v14
; LMULMAX2-RV32-NEXT:    vsll.vi v14, v14, 8
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a4
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 24
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v14
; LMULMAX2-RV32-NEXT:    vor.vv v8, v12, v8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32-NEXT:    vmv.v.x v12, a1
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32-NEXT:    vand.vv v10, v10, v12
; LMULMAX2-RV32-NEXT:    vand.vv v8, v8, v12
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32-NEXT:    vmv.v.x v12, a1
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32-NEXT:    vand.vv v10, v10, v12
; LMULMAX2-RV32-NEXT:    vand.vv v8, v8, v12
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32-NEXT:    vmv.v.x v12, a1
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32-NEXT:    vand.vv v10, v10, v12
; LMULMAX2-RV32-NEXT:    vand.vv v8, v8, v12
; LMULMAX2-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v4i64:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV64-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64-NEXT:    li a1, 56
; LMULMAX2-RV64-NEXT:    vsrl.vx v10, v8, a1
; LMULMAX2-RV64-NEXT:    li a2, 40
; LMULMAX2-RV64-NEXT:    vsrl.vx v12, v8, a2
; LMULMAX2-RV64-NEXT:    lui a3, 16
; LMULMAX2-RV64-NEXT:    addiw a3, a3, -256
; LMULMAX2-RV64-NEXT:    vand.vx v12, v12, a3
; LMULMAX2-RV64-NEXT:    vor.vv v10, v12, v10
; LMULMAX2-RV64-NEXT:    vsrl.vi v12, v8, 24
; LMULMAX2-RV64-NEXT:    lui a4, 4080
; LMULMAX2-RV64-NEXT:    vand.vx v12, v12, a4
; LMULMAX2-RV64-NEXT:    vsrl.vi v14, v8, 8
; LMULMAX2-RV64-NEXT:    li a5, 255
; LMULMAX2-RV64-NEXT:    slli a5, a5, 24
; LMULMAX2-RV64-NEXT:    vand.vx v14, v14, a5
; LMULMAX2-RV64-NEXT:    vor.vv v12, v14, v12
; LMULMAX2-RV64-NEXT:    vor.vv v10, v12, v10
; LMULMAX2-RV64-NEXT:    vand.vx v12, v8, a5
; LMULMAX2-RV64-NEXT:    vsll.vi v12, v12, 8
; LMULMAX2-RV64-NEXT:    vand.vx v14, v8, a4
; LMULMAX2-RV64-NEXT:    vsll.vi v14, v14, 24
; LMULMAX2-RV64-NEXT:    vor.vv v12, v14, v12
; LMULMAX2-RV64-NEXT:    vsll.vx v14, v8, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a3
; LMULMAX2-RV64-NEXT:    vsll.vx v8, v8, a2
; LMULMAX2-RV64-NEXT:    vor.vv v8, v14, v8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v12
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64-NEXT:    lui a1, 61681
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV64-NEXT:    lui a1, 209715
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64-NEXT:    lui a1, 349525
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64-NEXT:    add a1, a1, a2
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX1-RV32-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v10, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX1-RV32-NEXT:    vmv.v.i v9, 0
; LMULMAX1-RV32-NEXT:    vmv.v.i v0, 5
; LMULMAX1-RV32-NEXT:    lui a2, 1044480
; LMULMAX1-RV32-NEXT:    vmerge.vxm v9, v9, a2, v0
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX1-RV32-NEXT:    vsrl.vi v11, v10, 8
; LMULMAX1-RV32-NEXT:    vand.vv v11, v11, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v12, v10, 24
; LMULMAX1-RV32-NEXT:    lui a2, 4080
; LMULMAX1-RV32-NEXT:    vand.vx v12, v12, a2
; LMULMAX1-RV32-NEXT:    vor.vv v11, v11, v12
; LMULMAX1-RV32-NEXT:    li a3, 56
; LMULMAX1-RV32-NEXT:    vsrl.vx v12, v10, a3
; LMULMAX1-RV32-NEXT:    li a4, 40
; LMULMAX1-RV32-NEXT:    vsrl.vx v13, v10, a4
; LMULMAX1-RV32-NEXT:    lui a5, 16
; LMULMAX1-RV32-NEXT:    addi a5, a5, -256
; LMULMAX1-RV32-NEXT:    vand.vx v13, v13, a5
; LMULMAX1-RV32-NEXT:    vor.vv v12, v13, v12
; LMULMAX1-RV32-NEXT:    vor.vv v11, v11, v12
; LMULMAX1-RV32-NEXT:    vand.vv v12, v10, v9
; LMULMAX1-RV32-NEXT:    vsll.vi v12, v12, 8
; LMULMAX1-RV32-NEXT:    vand.vx v13, v10, a2
; LMULMAX1-RV32-NEXT:    vsll.vi v13, v13, 24
; LMULMAX1-RV32-NEXT:    vor.vv v12, v13, v12
; LMULMAX1-RV32-NEXT:    vsll.vx v13, v10, a3
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a5
; LMULMAX1-RV32-NEXT:    vsll.vx v10, v10, a4
; LMULMAX1-RV32-NEXT:    vor.vv v10, v13, v10
; LMULMAX1-RV32-NEXT:    vor.vv v10, v10, v12
; LMULMAX1-RV32-NEXT:    vor.vv v10, v10, v11
; LMULMAX1-RV32-NEXT:    vsrl.vi v11, v10, 4
; LMULMAX1-RV32-NEXT:    lui a6, 61681
; LMULMAX1-RV32-NEXT:    addi a6, a6, -241
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX1-RV32-NEXT:    vmv.v.x v12, a6
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX1-RV32-NEXT:    vand.vv v11, v11, v12
; LMULMAX1-RV32-NEXT:    vand.vv v10, v10, v12
; LMULMAX1-RV32-NEXT:    vsll.vi v10, v10, 4
; LMULMAX1-RV32-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v11, v10, 2
; LMULMAX1-RV32-NEXT:    lui a6, 209715
; LMULMAX1-RV32-NEXT:    addi a6, a6, 819
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX1-RV32-NEXT:    vmv.v.x v13, a6
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX1-RV32-NEXT:    vand.vv v11, v11, v13
; LMULMAX1-RV32-NEXT:    vand.vv v10, v10, v13
; LMULMAX1-RV32-NEXT:    vsll.vi v10, v10, 2
; LMULMAX1-RV32-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v11, v10, 1
; LMULMAX1-RV32-NEXT:    lui a6, 349525
; LMULMAX1-RV32-NEXT:    addi a6, a6, 1365
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX1-RV32-NEXT:    vmv.v.x v14, a6
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX1-RV32-NEXT:    vand.vv v11, v11, v14
; LMULMAX1-RV32-NEXT:    vand.vv v10, v10, v14
; LMULMAX1-RV32-NEXT:    vadd.vv v10, v10, v10
; LMULMAX1-RV32-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v11, v8, 8
; LMULMAX1-RV32-NEXT:    vand.vv v11, v11, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v15, v8, 24
; LMULMAX1-RV32-NEXT:    vand.vx v15, v15, a2
; LMULMAX1-RV32-NEXT:    vor.vv v11, v11, v15
; LMULMAX1-RV32-NEXT:    vsrl.vx v15, v8, a3
; LMULMAX1-RV32-NEXT:    vsrl.vx v16, v8, a4
; LMULMAX1-RV32-NEXT:    vand.vx v16, v16, a5
; LMULMAX1-RV32-NEXT:    vor.vv v15, v16, v15
; LMULMAX1-RV32-NEXT:    vor.vv v11, v11, v15
; LMULMAX1-RV32-NEXT:    vand.vv v9, v8, v9
; LMULMAX1-RV32-NEXT:    vsll.vi v9, v9, 8
; LMULMAX1-RV32-NEXT:    vand.vx v15, v8, a2
; LMULMAX1-RV32-NEXT:    vsll.vi v15, v15, 24
; LMULMAX1-RV32-NEXT:    vor.vv v9, v15, v9
; LMULMAX1-RV32-NEXT:    vsll.vx v15, v8, a3
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a5
; LMULMAX1-RV32-NEXT:    vsll.vx v8, v8, a4
; LMULMAX1-RV32-NEXT:    vor.vv v8, v15, v8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV32-NEXT:    vand.vv v9, v9, v12
; LMULMAX1-RV32-NEXT:    vand.vv v8, v8, v12
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX1-RV32-NEXT:    vand.vv v9, v9, v13
; LMULMAX1-RV32-NEXT:    vand.vv v8, v8, v13
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV32-NEXT:    vand.vv v9, v9, v14
; LMULMAX1-RV32-NEXT:    vand.vv v8, v8, v14
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v10, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v9, (a1)
; LMULMAX1-RV64-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    li a2, 56
; LMULMAX1-RV64-NEXT:    vsrl.vx v10, v9, a2
; LMULMAX1-RV64-NEXT:    li a3, 40
; LMULMAX1-RV64-NEXT:    vsrl.vx v11, v9, a3
; LMULMAX1-RV64-NEXT:    lui a4, 16
; LMULMAX1-RV64-NEXT:    addiw a4, a4, -256
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, a4
; LMULMAX1-RV64-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v11, v9, 24
; LMULMAX1-RV64-NEXT:    lui a5, 4080
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v12, v9, 8
; LMULMAX1-RV64-NEXT:    li a6, 255
; LMULMAX1-RV64-NEXT:    slli a6, a6, 24
; LMULMAX1-RV64-NEXT:    vand.vx v12, v12, a6
; LMULMAX1-RV64-NEXT:    vor.vv v11, v12, v11
; LMULMAX1-RV64-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV64-NEXT:    vand.vx v11, v9, a6
; LMULMAX1-RV64-NEXT:    vsll.vi v11, v11, 8
; LMULMAX1-RV64-NEXT:    vand.vx v12, v9, a5
; LMULMAX1-RV64-NEXT:    vsll.vi v12, v12, 24
; LMULMAX1-RV64-NEXT:    vor.vv v11, v12, v11
; LMULMAX1-RV64-NEXT:    vsll.vx v12, v9, a2
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-RV64-NEXT:    vsll.vx v9, v9, a3
; LMULMAX1-RV64-NEXT:    vor.vv v9, v12, v9
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v11
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV64-NEXT:    lui a7, 61681
; LMULMAX1-RV64-NEXT:    addiw a7, a7, -241
; LMULMAX1-RV64-NEXT:    slli t0, a7, 32
; LMULMAX1-RV64-NEXT:    add a7, a7, t0
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a7
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a7
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 4
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 2
; LMULMAX1-RV64-NEXT:    lui t0, 209715
; LMULMAX1-RV64-NEXT:    addiw t0, t0, 819
; LMULMAX1-RV64-NEXT:    slli t1, t0, 32
; LMULMAX1-RV64-NEXT:    add t0, t0, t1
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, t0
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, t0
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 2
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV64-NEXT:    lui t1, 349525
; LMULMAX1-RV64-NEXT:    addiw t1, t1, 1365
; LMULMAX1-RV64-NEXT:    slli t2, t1, 32
; LMULMAX1-RV64-NEXT:    add t1, t1, t2
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, t1
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, t1
; LMULMAX1-RV64-NEXT:    vadd.vv v9, v9, v9
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vx v10, v8, a2
; LMULMAX1-RV64-NEXT:    vsrl.vx v11, v8, a3
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, a4
; LMULMAX1-RV64-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v11, v8, 24
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v12, v8, 8
; LMULMAX1-RV64-NEXT:    vand.vx v12, v12, a6
; LMULMAX1-RV64-NEXT:    vor.vv v11, v12, v11
; LMULMAX1-RV64-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV64-NEXT:    vand.vx v11, v8, a6
; LMULMAX1-RV64-NEXT:    vsll.vi v11, v11, 8
; LMULMAX1-RV64-NEXT:    vand.vx v12, v8, a5
; LMULMAX1-RV64-NEXT:    vsll.vi v12, v12, 24
; LMULMAX1-RV64-NEXT:    vor.vv v11, v12, v11
; LMULMAX1-RV64-NEXT:    vsll.vx v12, v8, a2
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-RV64-NEXT:    vsll.vx v8, v8, a3
; LMULMAX1-RV64-NEXT:    vor.vv v8, v12, v8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a7
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a7
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, t0
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, t0
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, t1
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, t1
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v9, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, ptr %x
  %b = load <4 x i64>, ptr %y
  %c = call <4 x i64> @llvm.bitreverse.v4i64(<4 x i64> %a)
  store <4 x i64> %c, ptr %x
  ret void
}
declare <4 x i64> @llvm.bitreverse.v4i64(<4 x i64>)
