var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { pipe } from './function';
import { flap as flap_ } from './Functor';
import * as _ from './internal';
import * as RR from './ReadonlyRecord';
import * as S from './string';
import { wiltDefault, witherDefault } from './Witherable';
// -------------------------------------------------------------------------------------
// model
// -------------------------------------------------------------------------------------
/**
 * Calculate the number of key/value pairs in a `Record`.
 *
 * @since 2.0.0
 */
export var size = RR.size;
/**
 * Test whether a `Record` is empty.
 *
 * @since 2.0.0
 */
export var isEmpty = RR.isEmpty;
var keys_ = function (O) { return function (r) {
    return Object.keys(r).sort(O.compare);
}; };
/**
 * @since 2.0.0
 */
export var keys = 
/*#__PURE__*/
keys_(S.Ord);
export function collect(O) {
    if (typeof O === 'function') {
        return collect(S.Ord)(O);
    }
    var keysO = keys_(O);
    return function (f) { return function (r) {
        var out = [];
        for (var _i = 0, _a = keysO(r); _i < _a.length; _i++) {
            var key = _a[_i];
            out.push(f(key, r[key]));
        }
        return out;
    }; };
}
/**
 * Get a sorted `Array` of the key/value pairs contained in a `Record`.
 *
 * @since 2.0.0
 */
export var toArray = 
/*#__PURE__*/
collect(S.Ord)(function (k, a) { return [k, a]; });
export function toUnfoldable(U) {
    return function (r) {
        var sas = toArray(r);
        var len = sas.length;
        return U.unfold(0, function (b) { return (b < len ? _.some([sas[b], b + 1]) : _.none); });
    };
}
/**
 * Insert or replace a key/value pair in a `Record`.
 *
 * @category combinators
 * @since 2.10.0
 */
export var upsertAt = RR.upsertAt;
/**
 * Test whether or not a key exists in a `Record`.
 *
 * Note. This function is not pipeable because is a `Refinement`.
 *
 * @since 2.10.0
 */
export var has = RR.has;
export function deleteAt(k) {
    return function (r) {
        if (!_.has.call(r, k)) {
            return r;
        }
        var out = Object.assign({}, r);
        delete out[k];
        return out;
    };
}
/**
 * @since 2.0.0
 */
export var updateAt = function (k, a) {
    return modifyAt(k, function () { return a; });
};
/**
 * @since 2.0.0
 */
export var modifyAt = function (k, f) { return function (r) {
    if (!has(k, r)) {
        return _.none;
    }
    var out = Object.assign({}, r);
    out[k] = f(r[k]);
    return _.some(out);
}; };
export function pop(k) {
    var deleteAtk = deleteAt(k);
    return function (r) {
        var oa = lookup(k, r);
        return _.isNone(oa) ? _.none : _.some([oa.value, deleteAtk(r)]);
    };
}
// TODO: remove non-curried overloading in v3
/**
 * Test whether one `Record` contains all of the keys and values contained in another `Record`.
 *
 * @since 2.0.0
 */
export var isSubrecord = RR.isSubrecord;
// TODO: remove non-curried overloading in v3
/**
 * Lookup the value for a key in a `Record`.
 *
 * @since 2.0.0
 */
export var lookup = RR.lookup;
/**
 * Map a `Record` passing the keys to the iterating function.
 *
 * @since 2.0.0
 */
export var mapWithIndex = RR.mapWithIndex;
/**
 * Map a `Record` passing the values to the iterating function.
 *
 * @since 2.0.0
 */
export var map = RR.map;
export function reduceWithIndex() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    return args.length === 1 ? RR.reduceWithIndex(args[0]) : RR.reduceWithIndex(S.Ord).apply(void 0, args);
}
export function foldMapWithIndex(O) {
    return 'compare' in O ? RR.foldMapWithIndex(O) : RR.foldMapWithIndex(S.Ord)(O);
}
export function reduceRightWithIndex() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    return args.length === 1 ? RR.reduceRightWithIndex(args[0]) : RR.reduceRightWithIndex(S.Ord).apply(void 0, args);
}
/**
 * Create a `Record` with one key/value pair.
 *
 * @since 2.0.0
 */
export var singleton = RR.singleton;
export function traverseWithIndex(F) {
    return RR.traverseWithIndex(F);
}
export function traverse(F) {
    return RR.traverse(F);
}
export function sequence(F) {
    return RR.sequence(F);
}
/**
 * @category Witherable
 * @since 2.6.5
 */
export var wither = function (F) {
    var traverseF = traverse(F);
    return function (f) { return function (fa) { return F.map(pipe(fa, traverseF(f)), compact); }; };
};
/**
 * @category Witherable
 * @since 2.6.5
 */
export var wilt = function (F) {
    var traverseF = traverse(F);
    return function (f) { return function (fa) { return F.map(pipe(fa, traverseF(f)), separate); }; };
};
/**
 * @since 2.0.0
 */
export var partitionMapWithIndex = RR.partitionMapWithIndex;
export function partitionWithIndex(predicateWithIndex) {
    return RR.partitionWithIndex(predicateWithIndex);
}
/**
 * @since 2.0.0
 */
export var filterMapWithIndex = RR.filterMapWithIndex;
export function filterWithIndex(predicateWithIndex) {
    return RR.filterWithIndex(predicateWithIndex);
}
export function fromFoldable(M, F) {
    return RR.fromFoldable(M, F);
}
export function fromFoldableMap(M, F) {
    return RR.fromFoldableMap(M, F);
}
/**
 * @since 2.0.0
 */
export var every = RR.every;
/**
 * @since 2.0.0
 */
export var some = RR.some;
// TODO: remove non-curried overloading in v3
/**
 * @since 2.0.0
 */
export var elem = RR.elem;
/**
 * @category combinators
 * @since 2.11.0
 */
export var union = function (M) {
    var unionM = RR.union(M);
    return function (second) { return function (first) {
        if (isEmpty(first)) {
            return __assign({}, second);
        }
        if (isEmpty(second)) {
            return __assign({}, first);
        }
        return unionM(second)(first);
    }; };
};
/**
 * @category combinators
 * @since 2.11.0
 */
export var intersection = function (M) { return function (second) { return function (first) {
    if (isEmpty(first) || isEmpty(second)) {
        return {};
    }
    return RR.intersection(M)(second)(first);
}; }; };
/**
 * @category combinators
 * @since 2.11.0
 */
export var difference = function (second) { return function (first) {
    if (isEmpty(first)) {
        return __assign({}, second);
    }
    if (isEmpty(second)) {
        return __assign({}, first);
    }
    return RR.difference(second)(first);
}; };
// -------------------------------------------------------------------------------------
// non-pipeables
// -------------------------------------------------------------------------------------
var _map = RR._map;
var _mapWithIndex = RR._mapWithIndex;
var _reduce = RR._reduce;
var _foldMap = RR._foldMap;
var _reduceRight = RR._reduceRight;
var _filter = RR._filter;
var _filterMap = RR._filterMap;
var _partition = RR._partition;
var _partitionMap = RR._partitionMap;
var _reduceWithIndex = RR._reduceWithIndex;
var _foldMapWithIndex = RR._foldMapWithIndex;
var _reduceRightWithIndex = RR._reduceRightWithIndex;
var _partitionMapWithIndex = RR._partitionMapWithIndex;
var _partitionWithIndex = RR._partitionWithIndex;
var _filterMapWithIndex = RR._filterMapWithIndex;
var _filterWithIndex = RR._filterWithIndex;
var _traverse = RR._traverse;
var _sequence = RR._sequence;
var _traverseWithIndex = function (O) { return function (F) {
    var keysO = keys_(O);
    return function (ta, f) {
        var ks = keysO(ta);
        if (ks.length === 0) {
            return F.of({});
        }
        var fr = F.of({});
        var _loop_1 = function (key) {
            fr = F.ap(F.map(fr, function (r) { return function (b) {
                r[key] = b;
                return r;
            }; }), f(key, ta[key]));
        };
        for (var _i = 0, ks_1 = ks; _i < ks_1.length; _i++) {
            var key = ks_1[_i];
            _loop_1(key);
        }
        return fr;
    };
}; };
// -------------------------------------------------------------------------------------
// type class members
// -------------------------------------------------------------------------------------
/**
 * @category Filterable
 * @since 2.0.0
 */
export var filter = RR.filter;
/**
 * @category Filterable
 * @since 2.0.0
 */
export var filterMap = RR.filterMap;
/**
 * @category Filterable
 * @since 2.0.0
 */
export var partition = RR.partition;
/**
 * @category Filterable
 * @since 2.0.0
 */
export var partitionMap = RR.partitionMap;
export function reduce() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    return args.length === 1 ? RR.reduce(args[0]) : RR.reduce(S.Ord).apply(void 0, args);
}
export function foldMap(O) {
    return 'compare' in O ? RR.foldMap(O) : RR.foldMap(S.Ord)(O);
}
export function reduceRight() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    return args.length === 1 ? RR.reduceRight(args[0]) : RR.reduceRight(S.Ord).apply(void 0, args);
}
/**
 * @category Compactable
 * @since 2.0.0
 */
export var compact = RR.compact;
/**
 * @category Compactable
 * @since 2.0.0
 */
export var separate = RR.separate;
// -------------------------------------------------------------------------------------
// instances
// -------------------------------------------------------------------------------------
/**
 * @category instances
 * @since 2.0.0
 */
export var URI = 'Record';
export function getShow(O) {
    return 'compare' in O ? RR.getShow(O) : RR.getShow(S.Ord)(O);
}
/**
 * @category instances
 * @since 2.0.0
 */
export var getEq = RR.getEq;
/**
 * Returns a `Monoid` instance for `Record`s given a `Semigroup` instance for their values.
 *
 * @example
 * import { SemigroupSum } from 'fp-ts/number'
 * import { getMonoid } from 'fp-ts/Record'
 *
 * const M = getMonoid(SemigroupSum)
 * assert.deepStrictEqual(M.concat({ foo: 123 }, { foo: 456 }), { foo: 579 })
 *
 * @category instances
 * @since 2.0.0
 */
export var getMonoid = RR.getMonoid;
/**
 * @category instances
 * @since 2.7.0
 */
export var Functor = {
    URI: URI,
    map: _map
};
/**
 * Derivable from `Functor`.
 *
 * @category combinators
 * @since 2.10.0
 */
export var flap = 
/*#_PURE_*/
flap_(Functor);
/**
 * @category instances
 * @since 2.7.0
 */
export var FunctorWithIndex = {
    URI: URI,
    map: _map,
    mapWithIndex: _mapWithIndex
};
/**
 * @category instances
 * @since 2.11.0
 */
export var getFoldable = function (O) { return ({
    URI: URI,
    reduce: _reduce(O),
    foldMap: _foldMap(O),
    reduceRight: _reduceRight(O)
}); };
/**
 * @category instances
 * @since 2.11.0
 */
export var getFoldableWithIndex = function (O) { return ({
    URI: URI,
    reduce: _reduce(O),
    foldMap: _foldMap(O),
    reduceRight: _reduceRight(O),
    reduceWithIndex: _reduceWithIndex(O),
    foldMapWithIndex: _foldMapWithIndex(O),
    reduceRightWithIndex: _reduceRightWithIndex(O)
}); };
/**
 * @category instances
 * @since 2.7.0
 */
export var Compactable = {
    URI: URI,
    compact: compact,
    separate: separate
};
/**
 * @category instances
 * @since 2.7.0
 */
export var Filterable = {
    URI: URI,
    map: _map,
    compact: compact,
    separate: separate,
    filter: _filter,
    filterMap: _filterMap,
    partition: _partition,
    partitionMap: _partitionMap
};
/**
 * @category instances
 * @since 2.7.0
 */
export var FilterableWithIndex = {
    URI: URI,
    map: _map,
    mapWithIndex: _mapWithIndex,
    compact: compact,
    separate: separate,
    filter: _filter,
    filterMap: _filterMap,
    partition: _partition,
    partitionMap: _partitionMap,
    filterMapWithIndex: _filterMapWithIndex,
    filterWithIndex: _filterWithIndex,
    partitionMapWithIndex: _partitionMapWithIndex,
    partitionWithIndex: _partitionWithIndex
};
/**
 * @category instances
 * @since 2.11.0
 */
export var getTraversable = function (O) { return ({
    URI: URI,
    map: _map,
    reduce: _reduce(O),
    foldMap: _foldMap(O),
    reduceRight: _reduceRight(O),
    traverse: _traverse(O),
    sequence: _sequence(O)
}); };
/**
 * @category instances
 * @since 2.11.0
 */
export var getTraversableWithIndex = function (O) { return ({
    URI: URI,
    map: _map,
    mapWithIndex: _mapWithIndex,
    reduce: _reduce(O),
    foldMap: _foldMap(O),
    reduceRight: _reduceRight(O),
    reduceWithIndex: _reduceWithIndex(O),
    foldMapWithIndex: _foldMapWithIndex(O),
    reduceRightWithIndex: _reduceRightWithIndex(O),
    traverse: _traverse(O),
    sequence: _sequence(O),
    traverseWithIndex: _traverseWithIndex(O)
}); };
/**
 * @category instances
 * @since 2.11.0
 */
export var getWitherable = function (O) {
    var T = getTraversable(O);
    return {
        URI: URI,
        map: _map,
        reduce: _reduce(O),
        foldMap: _foldMap(O),
        reduceRight: _reduceRight(O),
        traverse: T.traverse,
        sequence: T.sequence,
        compact: compact,
        separate: separate,
        filter: _filter,
        filterMap: _filterMap,
        partition: _partition,
        partitionMap: _partitionMap,
        wither: witherDefault(T, Compactable),
        wilt: wiltDefault(T, Compactable)
    };
};
/**
 * @category instances
 * @since 2.11.0
 */
export var getUnionSemigroup = function (S) {
    var unionS = union(S);
    return {
        concat: function (first, second) { return unionS(second)(first); }
    };
};
/**
 * @category instances
 * @since 2.11.0
 */
export var getUnionMonoid = function (S) { return ({
    concat: getUnionSemigroup(S).concat,
    empty: {}
}); };
/**
 * @category instances
 * @since 2.11.0
 */
export var getIntersectionSemigroup = function (S) {
    var intersectionS = intersection(S);
    return {
        concat: function (first, second) { return intersectionS(second)(first); }
    };
};
/**
 * @category instances
 * @since 2.11.0
 */
export var getDifferenceMagma = function () { return ({
    concat: function (first, second) { return difference(second)(first); }
}); };
// -------------------------------------------------------------------------------------
// deprecated
// -------------------------------------------------------------------------------------
// tslint:disable: deprecation
/**
 * Use `getFoldable` instead.
 *
 * @category instances
 * @since 2.7.0
 * @deprecated
 */
export var Foldable = {
    URI: URI,
    reduce: _reduce(S.Ord),
    foldMap: _foldMap(S.Ord),
    reduceRight: _reduceRight(S.Ord)
};
/**
 * Use `getFoldableWithIndex` instead.
 *
 * @category instances
 * @since 2.7.0
 * @deprecated
 */
export var FoldableWithIndex = {
    URI: URI,
    reduce: _reduce(S.Ord),
    foldMap: _foldMap(S.Ord),
    reduceRight: _reduceRight(S.Ord),
    reduceWithIndex: _reduceWithIndex(S.Ord),
    foldMapWithIndex: _foldMapWithIndex(S.Ord),
    reduceRightWithIndex: _reduceRightWithIndex(S.Ord)
};
/**
 * Use `getTraversable` instead.
 *
 * @category instances
 * @since 2.7.0
 * @deprecated
 */
export var Traversable = {
    URI: URI,
    map: _map,
    reduce: _reduce(S.Ord),
    foldMap: _foldMap(S.Ord),
    reduceRight: _reduceRight(S.Ord),
    traverse: _traverse(S.Ord),
    sequence: sequence
};
/**
 * Use the `getTraversableWithIndex` instead.
 *
 * @category instances
 * @since 2.7.0
 * @deprecated
 */
export var TraversableWithIndex = {
    URI: URI,
    map: _map,
    mapWithIndex: _mapWithIndex,
    reduce: _reduce(S.Ord),
    foldMap: _foldMap(S.Ord),
    reduceRight: _reduceRight(S.Ord),
    reduceWithIndex: _reduceWithIndex(S.Ord),
    foldMapWithIndex: _foldMapWithIndex(S.Ord),
    reduceRightWithIndex: _reduceRightWithIndex(S.Ord),
    traverse: _traverse(S.Ord),
    sequence: sequence,
    traverseWithIndex: _traverseWithIndex(S.Ord)
};
var _wither = witherDefault(Traversable, Compactable);
var _wilt = wiltDefault(Traversable, Compactable);
/**
 * Use `getWitherable` instead.
 *
 * @category instances
 * @since 2.7.0
 * @deprecated
 */
export var Witherable = {
    URI: URI,
    map: _map,
    reduce: _reduce(S.Ord),
    foldMap: _foldMap(S.Ord),
    reduceRight: _reduceRight(S.Ord),
    traverse: _traverse(S.Ord),
    sequence: sequence,
    compact: compact,
    separate: separate,
    filter: _filter,
    filterMap: _filterMap,
    partition: _partition,
    partitionMap: _partitionMap,
    wither: _wither,
    wilt: _wilt
};
/**
 * Use a new `{}` instead.
 *
 * @since 2.0.0
 * @deprecated
 */
export var empty = {};
/**
 * Use [`upsertAt`](#upsertat) instead.
 *
 * @since 2.0.0
 * @deprecated
 */
export var insertAt = upsertAt;
/**
 * Use [`has`](#has) instead.
 *
 * @since 2.0.0
 * @deprecated
 */
export var hasOwnProperty = RR.hasOwnProperty;
/**
 * Use small, specific instances instead.
 *
 * @category instances
 * @since 2.0.0
 * @deprecated
 */
export var record = {
    URI: URI,
    map: _map,
    reduce: _reduce(S.Ord),
    foldMap: _foldMap(S.Ord),
    reduceRight: _reduceRight(S.Ord),
    traverse: _traverse(S.Ord),
    sequence: sequence,
    compact: compact,
    separate: separate,
    filter: _filter,
    filterMap: _filterMap,
    partition: _partition,
    partitionMap: _partitionMap,
    mapWithIndex: _mapWithIndex,
    reduceWithIndex: _reduceWithIndex(S.Ord),
    foldMapWithIndex: _foldMapWithIndex(S.Ord),
    reduceRightWithIndex: _reduceRightWithIndex(S.Ord),
    filterMapWithIndex: _filterMapWithIndex,
    filterWithIndex: _filterWithIndex,
    partitionMapWithIndex: _partitionMapWithIndex,
    partitionWithIndex: _partitionWithIndex,
    traverseWithIndex: _traverseWithIndex(S.Ord),
    wither: _wither,
    wilt: _wilt
};
