# Security Policy

Building secure foundations for software development is at the core of what we do in the Bytecode Alliance. Contributions of external security researchers are a vital part of that.

## Scope

If you believe you've found a security issue in any website, service, or software owned or operated by the Bytecode Alliance, we encourage you to notify us.

## How to Submit a Report

To submit a vulnerability report to the Bytecode Alliance, please contact us at [security@bytecodealliance.org](mailto:security@bytecodealliance.org). Your submission will be reviewed and validated by a member of our security team.

## Safe Harbor

The Bytecode Alliance supports safe harbor for security researchers who:

*   Make a good faith effort to avoid privacy violations, destruction of data, and interruption or degradation of our services.
*   Only interact with accounts you own or with explicit permission of the account holder. If you do encounter Personally Identifiable Information (PII) contact us immediately, do not proceed with access, and immediately purge any local information.
*   Provide us with a reasonable amount of time to resolve vulnerabilities prior to any disclosure to the public or a third-party.

We will consider activities conducted consistent with this policy to constitute "authorized" conduct and will not pursue civil action or initiate a complaint to law enforcement. We will help to the extent we can if legal action is initiated by a third party against you.

Please submit a report to us before engaging in conduct that may be inconsistent with or unaddressed by this policy.

## Preferences

*   Please provide detailed reports with reproducible steps and a clearly defined impact.
*   Submit one vulnerability per report.
*   Social engineering (e.g. phishing, vishing, smishing) is prohibited.
