/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.mozilla.jss.netscape.security.pkcs.PKCS8Key;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.AlgIdDSA;

public final class DSAPrivateKey
extends PKCS8Key
implements java.security.interfaces.DSAPrivateKey {
    private static final long serialVersionUID = -3244453684193605938L;
    private BigInteger x;

    public DSAPrivateKey() {
    }

    public DSAPrivateKey(BigInteger x, BigInteger p, BigInteger q, BigInteger g) throws InvalidKeyException {
        this.x = x;
        this.algid = new AlgIdDSA(p, q, g);
        try {
            this.key = new DerValue(2, x.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException e) {
            throw new InvalidKeyException("could not DER encode x: " + e.getMessage());
        }
    }

    public DSAPrivateKey(byte[] encoded) throws InvalidKeyException {
        this.clearOldKey();
        this.decode(encoded);
    }

    @Override
    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)((Object)this.algid);
            }
            AlgorithmParameters algParams = this.algid.getParameters();
            if (algParams == null) {
                return null;
            }
            return algParams.getParameterSpec(DSAParameterSpec.class);
        }
        catch (InvalidParameterSpecException e) {
            return null;
        }
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    private void clearOldKey() {
        int i;
        if (this.encodedKey != null) {
            for (i = 0; i < this.encodedKey.length; ++i) {
                this.encodedKey[i] = 0;
            }
        }
        if (this.key != null) {
            for (i = 0; i < this.key.length; ++i) {
                this.key[i] = 0;
            }
        }
    }

    @Override
    public String toString() {
        return "Sun DSA Private Key \nparameters:" + this.algid + "\nx: " + this.x.toString(16) + "\n";
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        DerInputStream in = new DerInputStream(this.key);
        try {
            this.x = in.getInteger().toBigInteger();
        }
        catch (IOException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.x == null ? 0 : this.x.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DSAPrivateKey other = (DSAPrivateKey)obj;
        return !(this.x == null ? other.x != null : !this.x.equals(other.x));
    }
}

