"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeAgent = void 0;
var agent_1 = require("./agent");
var api_1 = require("./api");
var instrumentations_1 = require("./instrumentations");
var metas_1 = require("./metas");
var transports_1 = require("./transports");
var utils_1 = require("./utils");
function initializeAgent(config) {
    var metas = (0, metas_1.initializeMetas)(config);
    var transports = (0, transports_1.initializeTransports)(config);
    var api = (0, api_1.initializeAPI)(config, transports, metas);
    var pause = function () { return transports.pause(); };
    var unpause = function () { return transports.unpause(); };
    var agent = (0, agent_1.initializeGlobalAgent)({
        config: config,
        metas: metas,
        transports: transports,
        api: api,
        pause: pause,
        unpause: unpause,
    });
    if (!agent.config.preventGlobalExposure) {
        Object.defineProperty(utils_1.globalObject, agent.config.globalObjectKey, {
            value: agent,
        });
    }
    (0, instrumentations_1.initializeInstrumentations)(agent.config);
    return agent;
}
exports.initializeAgent = initializeAgent;
//# sourceMappingURL=initialize.js.map