---
description: Learn about toggles for experimental and beta features, which you can enable or disable.
title: Configure feature toggles
weight: 150
---

<!-- DO NOT EDIT THIS PAGE, it is machine generated by running the test in -->
<!-- https://github.com/grafana/grafana/blob/main/pkg/services/featuremgmt/toggles_gen_test.go#L19 -->

# Configure feature toggles

You use feature toggles, also known as feature flags, to turn experimental or beta features on and off in Grafana. Although we do not recommend using these features in production, you can turn on feature toggles to try out new functionality in development or test environments.

This page contains a list of available feature toggles. To learn how to turn on feature toggles, refer to our [Configure Grafana documentation]({{< relref "../_index.md/#feature_toggles" >}}). Feature toggles are also available to Grafana Cloud Advanced customers. If you use Grafana Cloud Advanced, you can open a support ticket and specify the feature toggles and stack for which you want them enabled.

## Stable feature toggles

Some stable features are enabled by default. You can disable a stable feature by setting the feature flag to "false" in the configuration.

| Feature toggle name          | Description                                                                                                     | Enabled by default |
| ---------------------------- | --------------------------------------------------------------------------------------------------------------- | ------------------ |
| `promQueryBuilder`           | Show Prometheus query builder                                                                                   | Yes                |
| `disableEnvelopeEncryption`  | Disable envelope encryption (emergency only)                                                                    |                    |
| `database_metrics`           | Add Prometheus metrics for database tables                                                                      |                    |
| `lokiMonacoEditor`           | Access to Monaco query editor for Loki                                                                          | Yes                |
| `featureHighlights`          | Highlight Grafana Enterprise features                                                                           |                    |
| `commandPalette`             | Enable command palette                                                                                          | Yes                |
| `cloudWatchDynamicLabels`    | Use dynamic labels instead of alias patterns in CloudWatch datasource                                           | Yes                |
| `prometheusBufferedClient`   | Enable buffered (old) client for Prometheus datasource as default instead of streaming JSON parser client (new) |                    |
| `internationalization`       | Enables internationalization                                                                                    | Yes                |
| `accessTokenExpirationCheck` | Enable OAuth access_token expiration check and token refresh using the refresh_token                            |                    |

## Beta feature toggles

| Feature toggle name               | Description                                                                     |
| --------------------------------- | ------------------------------------------------------------------------------- |
| `trimDefaults`                    | Use cue schema to remove values that will be applied automatically              |
| `panelTitleSearch`                | Search for dashboards using panel title                                         |
| `prometheusAzureOverrideAudience` | Experimental. Allow override default AAD audience for Azure Prometheus endpoint |
| `swaggerUi`                       | Serves swagger UI                                                               |
| `migrationLocking`                | Lock database during migrations                                                 |
| `newDBLibrary`                    | Use jmoiron/sqlx rather than xorm for a few backend services                    |
| `validateDashboardsOnSave`        | Validate dashboard JSON POSTed to api/dashboards/db                             |
| `autoMigrateGraphPanels`          | Replace the angular graph panel with timeseries                                 |
| `datasourceLogger`                | Logs all datasource requests                                                    |

## Alpha feature toggles

These features are early in their development lifecycle and so are not yet supported in Grafana Cloud.
Alpha features might be changed or removed without prior notice.

| Feature toggle name                | Description                                                                                                                                                                  |
| ---------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `returnUnameHeader`                | Return user login as header for authenticated requests                                                                                                                       |
| `alertingBigTransactions`          | Use big transactions for alerting database writes                                                                                                                            |
| `dashboardPreviews`                | Create and show thumbnails for dashboard search results                                                                                                                      |
| `live-config`                      | Save Grafana Live configuration in SQL tables                                                                                                                                |
| `live-pipeline`                    | Enable a generic live processing pipeline                                                                                                                                    |
| `live-service-web-worker`          | This will use a webworker thread to processes events rather than the main thread                                                                                             |
| `queryOverLive`                    | Use Grafana Live WebSocket to execute backend queries                                                                                                                        |
| `tempoApmTable`                    | Show APM table                                                                                                                                                               |
| `influxdbBackendMigration`         | Query InfluxDB InfluxQL without the proxy                                                                                                                                    |
| `publicDashboards`                 | Enables public access to dashboards                                                                                                                                          |
| `lokiLive`                         | Support WebSocket streaming for loki (early prototype)                                                                                                                       |
| `lokiDataframeApi`                 | Use experimental loki api for WebSocket streaming (early prototype)                                                                                                          |
| `dashboardComments`                | Enable dashboard-wide comments                                                                                                                                               |
| `annotationComments`               | Enable annotation comments                                                                                                                                                   |
| `storage`                          | Configurable storage for dashboards, datasources, and resources                                                                                                              |
| `exploreMixedDatasource`           | Enable mixed datasource in Explore                                                                                                                                           |
| `tracing`                          | Adds trace ID to error notifications                                                                                                                                         |
| `correlations`                     | Correlations page                                                                                                                                                            |
| `datasourceQueryMultiStatus`       | Introduce HTTP 207 Multi Status for api/ds/query                                                                                                                             |
| `traceToMetrics`                   | Enable trace to metrics links                                                                                                                                                |
| `prometheusWideSeries`             | Enable wide series responses in the Prometheus datasource                                                                                                                    |
| `canvasPanelNesting`               | Allow elements nesting                                                                                                                                                       |
| `scenes`                           | Experimental framework to build interactive dashboards                                                                                                                       |
| `disableSecretsCompatibility`      | Disable duplicated secret storage in legacy tables                                                                                                                           |
| `logRequestsInstrumentedAsUnknown` | Logs the path for requests that are instrumented as unknown                                                                                                                  |
| `dataConnectionsConsole`           | Enables a new top-level page called Connections. This page is an experiment that provides a better experience when you install and configure data sources and other plugins. |
| `topnav`                           | New top nav and page layouts                                                                                                                                                 |
| `traceqlEditor`                    | Show the TraceQL editor in the explore page                                                                                                                                  |
| `flameGraph`                       | Show the flame graph                                                                                                                                                         |
| `cloudWatchCrossAccountQuerying`   | Use cross-account querying in CloudWatch datasource                                                                                                                          |
| `redshiftAsyncQueryDataSupport`    | Enable async query data support for Redshift                                                                                                                                 |
| `athenaAsyncQueryDataSupport`      | Enable async query data support for Athena                                                                                                                                   |
| `increaseInMemDatabaseQueryCache`  | Enable more in memory caching for database queries                                                                                                                           |
| `newPanelChromeUI`                 | Show updated look and feel of grafana-ui PanelChrome: panel header, icons, and menu                                                                                          |
| `showDashboardValidationWarnings`  | Show warnings when dashboards do not validate against the schema                                                                                                             |
| `mysqlAnsiQuotes`                  | Use double quotes to escape keyword in a MySQL query                                                                                                                         |
| `elasticsearchBackendMigration`    | Use Elasticsearch as backend data source                                                                                                                                     |
| `secureSocksDatasourceProxy`       | Enable secure socks tunneling for supported core datasources                                                                                                                 |
| `authnService`                     | Use new auth service to perform authentication                                                                                                                               |
| `sessionRemoteCache`               | Enable using remote cache for user sessions                                                                                                                                  |

## Development feature toggles

The following toggles require explicitly setting Grafana's [app mode]({{< relref "../_index.md/#app_mode" >}}) to 'development' before you can enable this feature toggle. These features tend to be experimental.

| Feature toggle name                    | Description                                               |
| -------------------------------------- | --------------------------------------------------------- |
| `dashboardPreviewsAdmin`               | Manage the dashboard previews crawler process from the UI |
| `showFeatureFlagsInUI`                 | Show feature flags in the settings UI                     |
| `dashboardsFromStorage`                | Load dashboards from the generic storage interface        |
| `export`                               | Export grafana instance (to git, etc)                     |
| `azureMonitorResourcePickerForMetrics` | New UI for Azure Monitor Metrics Query                    |
| `grpcServer`                           | Run GRPC server                                           |
| `entityStore`                          | SQL-based entity store (requires storage flag also)       |
| `queryLibrary`                         | Reusable query library                                    |
| `accessControlOnCall`                  | Access control primitives for OnCall                      |
| `nestedFolders`                        | Enable folder nesting                                     |
