/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.rdma;

import java.io.FileDescriptor;
import java.net.SocketException;
import java.net.SocketOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.net.NetworkPermission;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

public final class RdmaSocketOptions {
    public static final SocketOption<Integer> RDMA_SQSIZE = new RdmaSocketOption<Integer>("RDMA_SQSIZE", Integer.class);
    public static final SocketOption<Integer> RDMA_RQSIZE = new RdmaSocketOption<Integer>("RDMA_RQSIZE", Integer.class);
    public static final SocketOption<Integer> RDMA_INLINE = new RdmaSocketOption<Integer>("RDMA_INLINE", Integer.class);
    private static final int SQSIZE = 12289;
    private static final int RQSIZE = 12290;
    private static final int INLINE = 12291;
    private static final PlatformRdmaSocketOptions platformRdmaSocketOptions = PlatformRdmaSocketOptions.get();
    private static final boolean rdmaSocketSupported = platformRdmaSocketOptions.rdmaSocketSupported();
    private static final Set<SocketOption<?>> rdmaOptions = RdmaSocketOptions.options();
    private static final JavaIOFileDescriptorAccess fdAccess;

    private RdmaSocketOptions() {
    }

    static Set<SocketOption<?>> options() {
        if (rdmaSocketSupported) {
            return Stream.of(RDMA_SQSIZE, RDMA_RQSIZE, RDMA_INLINE).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static void setSockOpt(FileDescriptor fileDescriptor, int n, int n2) throws SocketException {
        platformRdmaSocketOptions.setSockOpt(fdAccess.get(fileDescriptor), n, n2);
    }

    private static int getSockOpt(FileDescriptor fileDescriptor, int n) throws SocketException {
        return platformRdmaSocketOptions.getSockOpt(fdAccess.get(fileDescriptor), n);
    }

    static {
        sun.net.ext.RdmaSocketOptions.register(new sun.net.ext.RdmaSocketOptions((Set)rdmaOptions){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void setOption(FileDescriptor fileDescriptor, SocketOption<?> socketOption, Object object) throws SocketException {
                int n;
                int n2;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkPermission(new NetworkPermission("setOption." + socketOption.name()));
                }
                if (fileDescriptor == null || !fileDescriptor.valid()) {
                    throw new SocketException("socket closed");
                }
                if (socketOption != RDMA_SQSIZE && socketOption != RDMA_RQSIZE && socketOption != RDMA_INLINE) throw new InternalError("Unexpected option " + socketOption);
                assert (rdmaSocketSupported);
                if (socketOption == RDMA_SQSIZE) {
                    if (object == null || !(object instanceof Integer)) {
                        throw new SocketException("Bad parameter for RDMA_SQSIZE");
                    }
                    n2 = (Integer)object;
                    n = 12289;
                    if (n2 < 0) {
                        throw new IllegalArgumentException("send queue size < 0");
                    }
                } else if (socketOption == RDMA_RQSIZE) {
                    if (object == null || !(object instanceof Integer)) {
                        throw new SocketException("Bad parameter for RDMA_RQSIZE");
                    }
                    n2 = (Integer)object;
                    n = 12290;
                    if (n2 < 0) {
                        throw new IllegalArgumentException("receive queue size < 0");
                    }
                } else {
                    if (socketOption != RDMA_INLINE) throw new SocketException("unrecognized RDMA socket option: " + socketOption);
                    if (object == null || !(object instanceof Integer)) {
                        throw new SocketException("Bad parameter for RDMA_INLINE");
                    }
                    n2 = (Integer)object;
                    n = 12291;
                    if (n2 < 0) {
                        throw new IllegalArgumentException("inline size < 0");
                    }
                }
                RdmaSocketOptions.setSockOpt(fileDescriptor, n, n2);
            }

            @Override
            public Object getOption(FileDescriptor fileDescriptor, SocketOption<?> socketOption) throws SocketException {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkPermission(new NetworkPermission("getOption." + socketOption.name()));
                }
                if (fileDescriptor == null || !fileDescriptor.valid()) {
                    throw new SocketException("socket closed");
                }
                if (socketOption == RDMA_SQSIZE || socketOption == RDMA_RQSIZE || socketOption == RDMA_INLINE) {
                    assert (rdmaSocketSupported);
                    int n = socketOption == RDMA_SQSIZE ? 12289 : (socketOption == RDMA_RQSIZE ? 12290 : 12291);
                    return RdmaSocketOptions.getSockOpt(fileDescriptor, n);
                }
                throw new InternalError("Unexpected option " + socketOption);
            }
        });
        fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    }

    static class PlatformRdmaSocketOptions {
        private static final PlatformRdmaSocketOptions instance = PlatformRdmaSocketOptions.create();

        protected PlatformRdmaSocketOptions() {
        }

        private static PlatformRdmaSocketOptions newInstance(String string) {
            try {
                Class<?> clazz = Class.forName(string);
                return (PlatformRdmaSocketOptions)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                if (reflectiveOperationException.getCause() instanceof UnsupportedOperationException) {
                    throw (UnsupportedOperationException)reflectiveOperationException.getCause();
                }
                throw new AssertionError((Object)reflectiveOperationException);
            }
        }

        private static PlatformRdmaSocketOptions create() {
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("os.name");
                }
            });
            if ("Linux".equals(string)) {
                try {
                    return PlatformRdmaSocketOptions.newInstance("jdk.net.LinuxRdmaSocketOptions");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    return new PlatformRdmaSocketOptions();
                }
            }
            return new PlatformRdmaSocketOptions();
        }

        static PlatformRdmaSocketOptions get() {
            return instance;
        }

        void setSockOpt(int n, int n2, int n3) throws SocketException {
            throw new UnsupportedOperationException("unsupported socket option");
        }

        int getSockOpt(int n, int n2) throws SocketException {
            throw new UnsupportedOperationException("unsupported socket option");
        }

        boolean rdmaSocketSupported() {
            return false;
        }
    }

    private static class RdmaSocketOption<T>
    implements SocketOption<T> {
        private final String name;
        private final Class<T> type;

        RdmaSocketOption(String string, Class<T> clazz) {
            this.name = string;
            this.type = clazz;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<T> type() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }
    }
}

