/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.rdma;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import sun.misc.SharedSecrets;
import sun.nio.ch.NetAccess;
import sun.nio.ch.rdma.RdmaServerSocketChannelImpl;

class RdmaServerSocketAdaptor
extends ServerSocket {
    private final RdmaServerSocketChannelImpl ssc;
    private volatile int timeout;
    private static final NetAccess NET_ACCESS = SharedSecrets.getNetAccess();

    public static ServerSocket create(RdmaServerSocketChannelImpl rdmaServerSocketChannelImpl) {
        try {
            return new RdmaServerSocketAdaptor(rdmaServerSocketChannelImpl);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    private RdmaServerSocketAdaptor(RdmaServerSocketChannelImpl rdmaServerSocketChannelImpl) throws IOException {
        this.ssc = rdmaServerSocketChannelImpl;
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 50);
    }

    @Override
    public void bind(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        try {
            this.ssc.bind(socketAddress, n);
        }
        catch (Exception exception) {
            NET_ACCESS.translateException(exception);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        InetSocketAddress inetSocketAddress = this.ssc.localAddress();
        if (inetSocketAddress == null) {
            return null;
        }
        return NET_ACCESS.getRevealedLocalAddress(inetSocketAddress).getAddress();
    }

    @Override
    public int getLocalPort() {
        InetSocketAddress inetSocketAddress = this.ssc.localAddress();
        if (inetSocketAddress == null) {
            return -1;
        }
        return inetSocketAddress.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket accept() throws IOException {
        Object object = this.ssc.blockingLock();
        synchronized (object) {
            try {
                long l;
                if (!this.ssc.isBound()) {
                    throw new NotYetBoundException();
                }
                long l2 = this.timeout;
                if (l2 == 0L) {
                    SocketChannel socketChannel = this.ssc.accept();
                    if (socketChannel == null && !this.ssc.isBlocking()) {
                        throw new IllegalBlockingModeException();
                    }
                    return socketChannel.socket();
                }
                if (!this.ssc.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                do {
                    l = System.currentTimeMillis();
                    if (!this.ssc.pollAccept(l2)) continue;
                    return this.ssc.accept().socket();
                } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                throw new SocketTimeoutException();
            }
            catch (Exception exception) {
                NET_ACCESS.translateException(exception);
                assert (false);
                return null;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.ssc.close();
    }

    @Override
    public ServerSocketChannel getChannel() {
        return this.ssc;
    }

    @Override
    public boolean isBound() {
        return this.ssc.isBound();
    }

    @Override
    public boolean isClosed() {
        return !this.ssc.isOpen();
    }

    @Override
    public void setSoTimeout(int n) throws SocketException {
        this.timeout = n;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        try {
            this.ssc.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)bl);
        }
        catch (IOException iOException) {
            NET_ACCESS.translateToSocketException(iOException);
        }
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        try {
            return this.ssc.getOption(StandardSocketOptions.SO_REUSEADDR);
        }
        catch (IOException iOException) {
            NET_ACCESS.translateToSocketException(iOException);
            return false;
        }
    }

    @Override
    public String toString() {
        if (!this.isBound()) {
            return "RdmaServerSocket[unbound]";
        }
        return "RdmaServerSocket[addr=" + this.getInetAddress() + ",localport=" + this.getLocalPort() + "]";
    }

    @Override
    public void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("size cannot be 0 or negative");
        }
        try {
            this.ssc.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)n);
        }
        catch (IOException iOException) {
            NET_ACCESS.translateToSocketException(iOException);
        }
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        try {
            return this.ssc.getOption(StandardSocketOptions.SO_RCVBUF);
        }
        catch (IOException iOException) {
            NET_ACCESS.translateToSocketException(iOException);
            return -1;
        }
    }
}

