/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.gc;

import com.alibaba.management.ElasticHeapEvaluationMode;
import com.alibaba.management.ElasticHeapMXBean;
import java.security.AccessController;
import javax.management.ObjectName;
import sun.management.Util;
import sun.security.action.GetBooleanAction;

public class ElasticHeapMXBeanImpl
implements ElasticHeapMXBean {
    private static final String ELASTIC_HEAP_MXBEAN_NAME = "com.alibaba.management:type=ElasticHeap";
    private static final boolean ELASTIC_HEAP_ENABLED;

    private static native void registerNatives();

    private static void checkElasticHeapEnabled() {
        if (!ELASTIC_HEAP_ENABLED) {
            throw new UnsupportedOperationException("-XX:+G1ElasticHeap is not enabled");
        }
    }

    @Override
    public ElasticHeapEvaluationMode getEvaluationMode() {
        ElasticHeapMXBeanImpl.checkElasticHeapEnabled();
        ElasticHeapEvaluationMode[] elasticHeapEvaluationModeArray = ElasticHeapEvaluationMode.values();
        int n = ElasticHeapMXBeanImpl.getEvaluationModeImpl();
        assert (n < elasticHeapEvaluationModeArray.length);
        return elasticHeapEvaluationModeArray[n];
    }

    @Override
    public void setYoungGenCommitPercent(int n) {
        ElasticHeapMXBeanImpl.checkElasticHeapEnabled();
        ElasticHeapMXBeanImpl.setYoungGenCommitPercentImpl(n);
    }

    @Override
    public int getYoungGenCommitPercent() {
        ElasticHeapMXBeanImpl.checkElasticHeapEnabled();
        return ElasticHeapMXBeanImpl.getYoungGenCommitPercentImpl();
    }

    @Override
    public void setUncommitIHOP(int n) {
        ElasticHeapMXBeanImpl.checkElasticHeapEnabled();
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("argument should be between 0 and 100");
        }
        ElasticHeapMXBeanImpl.setUncommitIHOPImpl(n);
    }

    @Override
    public int getUncommitIHOP() {
        ElasticHeapMXBeanImpl.checkElasticHeapEnabled();
        return ElasticHeapMXBeanImpl.getUncommitIHOPImpl();
    }

    @Override
    public long getTotalYoungUncommittedBytes() {
        ElasticHeapMXBeanImpl.checkElasticHeapEnabled();
        return ElasticHeapMXBeanImpl.getTotalYoungUncommittedBytesImpl();
    }

    @Override
    public void setSoftmxPercent(int n) {
        ElasticHeapMXBeanImpl.checkElasticHeapEnabled();
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("argument should be between 0 and 100");
        }
        ElasticHeapMXBeanImpl.setSoftmxPercentImpl(n);
    }

    @Override
    public int getSoftmxPercent() {
        ElasticHeapMXBeanImpl.checkElasticHeapEnabled();
        return ElasticHeapMXBeanImpl.getSoftmxPercentImpl();
    }

    @Override
    public long getTotalUncommittedBytes() {
        ElasticHeapMXBeanImpl.checkElasticHeapEnabled();
        return ElasticHeapMXBeanImpl.getTotalUncommittedBytesImpl();
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName(ELASTIC_HEAP_MXBEAN_NAME);
    }

    private static native int getEvaluationModeImpl();

    private static native void setYoungGenCommitPercentImpl(int var0);

    private static native int getYoungGenCommitPercentImpl();

    private static native void setUncommitIHOPImpl(int var0);

    private static native int getUncommitIHOPImpl();

    private static native long getTotalYoungUncommittedBytesImpl();

    private static native void setSoftmxPercentImpl(int var0);

    private static native int getSoftmxPercentImpl();

    private static native long getTotalUncommittedBytesImpl();

    static {
        ElasticHeapMXBeanImpl.registerNatives();
        ELASTIC_HEAP_ENABLED = AccessController.doPrivileged(new GetBooleanAction("com.alibaba.jvm.gc.ElasticHeapEnabled"));
    }
}

