/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.symkey;

import org.mozilla.jss.pkcs11.PK11SymKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionKey {
    public static Logger logger = LoggerFactory.getLogger(SessionKey.class);

    private static void loadLibrary() {
        try {
            System.loadLibrary("jss-symkey");
            logger.debug("SessionKey: Loaded JSS symkey library from java.library.path");
            return;
        }
        catch (UnsatisfiedLinkError e) {
            logger.debug("SessionKey: Unable to load JSS symkey library from java.library.path: " + e.getMessage());
            String path = "/usr/lib64/jss/libjss-symkey.so";
            try {
                System.load(path);
                logger.debug("SessionKey: Loaded JSS symkey library from " + path);
                return;
            }
            catch (UnsatisfiedLinkError e2) {
                logger.debug("SessionKey: Unable to load JSS symkey library from " + path + ": " + e2.getMessage());
                path = "/usr/lib/jss/libjss-symkey.so";
                try {
                    System.load(path);
                    logger.debug("SessionKey: Loaded JSS symkey library from " + path);
                    return;
                }
                catch (UnsatisfiedLinkError e3) {
                    logger.debug("SessionKey: Unable to load JSS symkey library from " + path + ": " + e3.getMessage());
                    logger.error("Unable to load JSS symkey library");
                    System.exit(-1);
                    return;
                }
            }
        }
    }

    public static native byte[] ComputeKeyCheck(PK11SymKey var0);

    public static native byte[] ComputeSessionKeySCP02(String var0, String var1, byte[] var2, byte var3, boolean var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9, String var10, String var11, String var12);

    public static native byte[] ComputeSessionKey(String var0, String var1, byte[] var2, byte[] var3, byte[] var4, byte var5, boolean var6, byte[] var7, byte[] var8, byte[] var9, String var10, String var11, String var12);

    public static native byte[] ComputeEncSessionKey(String var0, String var1, byte[] var2, byte[] var3, byte[] var4, byte var5, boolean var6, byte[] var7, byte[] var8, byte[] var9, String var10, String var11);

    public static native PK11SymKey ComputeKekKey(String var0, String var1, byte[] var2, byte[] var3, byte[] var4, byte var5, boolean var6, byte[] var7, byte[] var8, byte[] var9, String var10, String var11);

    public static native byte[] ECBencrypt(PK11SymKey var0, PK11SymKey var1);

    public static native PK11SymKey GenerateSymkey(String var0);

    public static native byte[] ComputeCryptogram(String var0, String var1, byte[] var2, byte[] var3, byte[] var4, byte var5, boolean var6, byte[] var7, byte[] var8, int var9, byte[] var10, String var11, String var12);

    public static native byte[] EncryptData(String var0, String var1, byte[] var2, byte[] var3, byte var4, boolean var5, byte[] var6, byte[] var7, byte[] var8, String var9, String var10);

    public static native byte[] DiversifyKey(String var0, String var1, String var2, String var3, byte[] var4, byte[] var5, byte var6, boolean var7, byte[] var8, byte[] var9, byte[] var10, String var11, String var12, byte var13);

    public static native String GenMasterKey(String var0, String var1);

    public static native String DeleteSymmetricKey(String var0, String var1);

    public static native String ListSymmetricKeys(String var0);

    public static native void SetDefaultPrefix(String var0);

    public static native PK11SymKey GetSymKeyByName(String var0, String var1);

    public static native PK11SymKey UnwrapSessionKeyWithSharedSecret(String var0, PK11SymKey var1, byte[] var2);

    public static native PK11SymKey DeriveDESKeyFrom3DesKey(String var0, PK11SymKey var1, long var2);

    static {
        SessionKey.loadLibrary();
    }
}

