/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.CharConversionException;
import org.mozilla.jss.asn1.CharConverter;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.Tag;

public class TeletexString
extends CharacterString {
    public static final Tag TAG = new Tag(Tag.UNIVERSAL, 20L);
    private static final Template templateInstance = new Template();

    @Override
    public Tag getTag() {
        return TAG;
    }

    public TeletexString(char[] chars) throws CharConversionException {
        super(chars);
    }

    public TeletexString(String s) throws CharConversionException {
        super(s);
    }

    @Override
    CharConverter getCharConverter() {
        return new TeletexConverter();
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    private static class TeletexConverter
    implements CharConverter {
        private TeletexConverter() {
        }

        @Override
        public char[] byteToChar(byte[] bytes, int offset, int len) throws CharConversionException {
            char[] chars = new char[len];
            int b = offset;
            for (int c = 0; c < len; ++c) {
                chars[c] = (char)(bytes[b] & 0xFF);
                ++b;
            }
            return chars;
        }

        @Override
        public byte[] charToByte(char[] chars, int offset, int len) throws CharConversionException {
            byte[] bytes = new byte[len];
            int b = 0;
            int c = offset;
            while (b < len) {
                if ((chars[c] & 0xFF00) != 0) {
                    throw new CharConversionException("Invalid character for TeletexString");
                }
                bytes[b] = (byte)(chars[c] & 0xFF);
                ++b;
                ++c;
            }
            return bytes;
        }
    }

    public static class Template
    extends CharacterString.Template {
        @Override
        protected Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        protected CharConverter getCharConverter() {
            return new TeletexConverter();
        }

        @Override
        protected CharacterString generateInstance(char[] bytes) throws CharConversionException {
            return new TeletexString(bytes);
        }

        @Override
        protected String typeName() {
            return "TeletexString";
        }
    }
}

