/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.IVParameterSpec;

public class KeyWrapAlgorithm
extends Algorithm {
    private boolean padded;
    private int blockSize;
    private static Hashtable<String, KeyWrapAlgorithm> nameMap = new Hashtable();
    private static Class<?>[] IVParameterSpecClasses = null;
    public static final KeyWrapAlgorithm DES_ECB;
    public static final KeyWrapAlgorithm DES_CBC;
    public static final KeyWrapAlgorithm DES_CBC_PAD;
    public static final KeyWrapAlgorithm DES3_ECB;
    public static final KeyWrapAlgorithm DES3_CBC;
    public static final KeyWrapAlgorithm DES3_CBC_PAD;
    public static final KeyWrapAlgorithm RSA;
    public static final KeyWrapAlgorithm RSA_OAEP;
    public static final KeyWrapAlgorithm PLAINTEXT;
    public static final KeyWrapAlgorithm AES_ECB;
    public static final KeyWrapAlgorithm AES_CBC;
    public static final KeyWrapAlgorithm AES_CBC_PAD;
    public static final KeyWrapAlgorithm RC2_CBC_PAD;
    public static final KeyWrapAlgorithm AES_KEY_WRAP;
    public static final KeyWrapAlgorithm AES_KEY_WRAP_PAD;
    public static final KeyWrapAlgorithm AES_KEY_WRAP_PAD_KWP;
    public static final OBJECT_IDENTIFIER AES_KEY_WRAP_PAD_OID;
    public static final OBJECT_IDENTIFIER AES_KEY_WRAP_KWP_OID;
    public static final OBJECT_IDENTIFIER AES_KEY_WRAP_OID;
    public static final OBJECT_IDENTIFIER AES_CBC_PAD_OID;
    public static final OBJECT_IDENTIFIER DES3_CBC_PAD_OID;
    public static final OBJECT_IDENTIFIER DES_CBC_PAD_OID;

    protected KeyWrapAlgorithm(int oidTag, String name, Class<?> paramClass, boolean padded, int blockSize) {
        super(oidTag, name, null, paramClass);
        this.padded = padded;
        this.blockSize = blockSize;
        if (name != null) {
            nameMap.put(name.toLowerCase(), this);
        }
    }

    protected KeyWrapAlgorithm(int oidTag, String name, Class<?>[] paramClasses, boolean padded, int blockSize) {
        super(oidTag, name, null, paramClasses);
        this.padded = padded;
        this.blockSize = blockSize;
        if (name != null) {
            nameMap.put(name.toLowerCase(), this);
        }
    }

    public static KeyWrapAlgorithm fromString(String name) throws NoSuchAlgorithmException {
        KeyWrapAlgorithm alg = nameMap.get(name.toLowerCase());
        if (alg == null) {
            throw new NoSuchAlgorithmException();
        }
        return alg;
    }

    public boolean isPadded() {
        return this.padded;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public static KeyWrapAlgorithm fromOID(String wrapOID) throws NoSuchAlgorithmException {
        OBJECT_IDENTIFIER oid = new OBJECT_IDENTIFIER(wrapOID);
        return KeyWrapAlgorithm.fromOID(oid);
    }

    public static KeyWrapAlgorithm fromOID(OBJECT_IDENTIFIER oid) throws NoSuchAlgorithmException {
        if (oid.equals(AES_KEY_WRAP_PAD_OID)) {
            return AES_KEY_WRAP_PAD;
        }
        if (oid.equals(AES_KEY_WRAP_OID)) {
            return AES_KEY_WRAP;
        }
        if (oid.equals(AES_CBC_PAD_OID)) {
            return AES_CBC_PAD;
        }
        if (oid.equals(DES3_CBC_PAD_OID)) {
            return DES3_CBC_PAD;
        }
        if (oid.equals(DES_CBC_PAD_OID)) {
            return DES_CBC_PAD;
        }
        throw new NoSuchAlgorithmException("Unknown Algorithm for OID: " + oid);
    }

    static {
        IVParameterSpecClasses = new Class[2];
        KeyWrapAlgorithm.IVParameterSpecClasses[0] = IVParameterSpec.class;
        KeyWrapAlgorithm.IVParameterSpecClasses[1] = IvParameterSpec.class;
        DES_ECB = new KeyWrapAlgorithm(9, "DES/ECB", (Class)null, false, 8);
        DES_CBC = new KeyWrapAlgorithm(10, "DES/CBC", IVParameterSpecClasses, false, 8);
        DES_CBC_PAD = new KeyWrapAlgorithm(11, "DES/CBC/Pad", IVParameterSpecClasses, true, 8);
        DES3_ECB = new KeyWrapAlgorithm(12, "DES3/ECB", (Class)null, false, 8);
        DES3_CBC = new KeyWrapAlgorithm(13, "DES3/CBC", IVParameterSpecClasses, false, 8);
        DES3_CBC_PAD = new KeyWrapAlgorithm(14, "DES3/CBC/Pad", IVParameterSpecClasses, true, 8);
        RSA = new KeyWrapAlgorithm(4, "RSA", (Class)null, false, 0);
        RSA_OAEP = new KeyWrapAlgorithm(79, "RSAES-OAEP", OAEPParameterSpec.class, true, 0);
        PLAINTEXT = new KeyWrapAlgorithm(0, "Plaintext", (Class)null, false, 0);
        AES_ECB = new KeyWrapAlgorithm(33, "AES/ECB/NoPadding", (Class)null, false, 16);
        AES_CBC = new KeyWrapAlgorithm(34, "AES/CBC/NoPadding", IVParameterSpecClasses, false, 16);
        AES_CBC_PAD = new KeyWrapAlgorithm(35, "AES/CBC/PKCS5Padding", IVParameterSpecClasses, true, 16);
        RC2_CBC_PAD = new KeyWrapAlgorithm(36, "RC2/CBC/PKCS5Padding", RC2ParameterSpec.class, true, 8);
        AES_KEY_WRAP = new KeyWrapAlgorithm(57, "AES KeyWrap/NoPadding", (Class)null, false, 8);
        AES_KEY_WRAP_PAD = new KeyWrapAlgorithm(58, "AES KeyWrap/Padding", (Class)null, true, 8);
        AES_KEY_WRAP_PAD_KWP = new KeyWrapAlgorithm(80, "AES KeyWrap/Wrapped", (Class)null, true, 8);
        AES_KEY_WRAP_PAD_OID = new OBJECT_IDENTIFIER("2.16.840.1.101.3.4.1.8");
        AES_KEY_WRAP_KWP_OID = new OBJECT_IDENTIFIER("2.16.840.1.101.3.4.1.8");
        AES_KEY_WRAP_OID = new OBJECT_IDENTIFIER("2.16.840.1.101.3.4.1.5");
        AES_CBC_PAD_OID = new OBJECT_IDENTIFIER("2.16.840.1.101.3.4.1.2");
        DES3_CBC_PAD_OID = new OBJECT_IDENTIFIER("1.2.840.113549.3.7");
        DES_CBC_PAD_OID = new OBJECT_IDENTIFIER("1.3.14.3.2.7");
    }
}

