/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.DigestException;
import java.security.InvalidKeyException;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;

public abstract class JSSMessageDigest {
    public abstract void initHMAC(SymmetricKey var1) throws DigestException, InvalidKeyException;

    public void update(byte input) throws DigestException {
        byte[] in = new byte[]{input};
        this.update(in, 0, 1);
    }

    public abstract void update(byte[] var1, int var2, int var3) throws DigestException;

    public void update(byte[] input) throws DigestException {
        this.update(input, 0, input.length);
    }

    public byte[] digest() throws DigestException {
        byte[] output = new byte[this.getOutputSize()];
        this.digest(output, 0, output.length);
        return output;
    }

    public abstract int digest(byte[] var1, int var2, int var3) throws DigestException;

    public byte[] digest(byte[] input) throws DigestException {
        this.update(input);
        return this.digest();
    }

    public abstract void reset() throws DigestException;

    public abstract DigestAlgorithm getAlgorithm();

    public int getOutputSize() {
        return this.getAlgorithm().getOutputSize();
    }
}

