/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.rdma;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.FileChannel;
import sun.net.ConnectionResetException;
import sun.nio.ch.rdma.RdmaSocketImpl;

class RdmaSocketOutputStream
extends FileOutputStream {
    private RdmaSocketImpl impl = null;
    private byte[] temp = new byte[1];
    private Socket socket = null;
    private boolean closing = false;

    RdmaSocketOutputStream(RdmaSocketImpl rdmaSocketImpl) throws IOException {
        super(rdmaSocketImpl.getFileDescriptor());
        this.impl = rdmaSocketImpl;
        this.socket = rdmaSocketImpl.getSocket();
    }

    @Override
    public final FileChannel getChannel() {
        return null;
    }

    private native void rdmaSocketWrite0(FileDescriptor var1, byte[] var2, int var3, int var4) throws IOException;

    private void rdmaSocketWrite(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0 || n < 0 || n2 > byArray.length - n) {
            if (n2 == 0) {
                return;
            }
            throw new ArrayIndexOutOfBoundsException("len == " + n2 + " off == " + n + " buffer length == " + byArray.length);
        }
        FileDescriptor fileDescriptor = this.impl.acquireFD();
        try {
            this.rdmaSocketWrite0(fileDescriptor, byArray, n, n2);
        }
        catch (SocketException socketException) {
            SocketException socketException2;
            if (socketException instanceof ConnectionResetException) {
                this.impl.setConnectionResetPending();
                socketException2 = new SocketException("Connection reset");
            }
            if (this.impl.isClosedOrPending()) {
                throw new SocketException("Socket closed");
            }
            throw socketException2;
        }
        finally {
            this.impl.releaseFD();
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.temp[0] = (byte)n;
        this.rdmaSocketWrite(this.temp, 0, 1);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.rdmaSocketWrite(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.rdmaSocketWrite(byArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        if (this.socket != null) {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        } else {
            this.impl.close();
        }
        this.closing = false;
    }

    private static native void init();

    static {
        RdmaSocketOutputStream.init();
    }
}

