/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.rdma;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.SharedSecrets;
import sun.net.ext.RdmaSocketOptions;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.NetAccess;
import sun.nio.ch.RdmaSocketDispatcher;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.rdma.RdmaNet;
import sun.nio.ch.rdma.RdmaServerSocketAdaptor;
import sun.nio.ch.rdma.RdmaSocketChannelImpl;

public class RdmaServerSocketChannelImpl
extends ServerSocketChannel
implements SelChImpl {
    private final ProtocolFamily family;
    private static RdmaSocketDispatcher nd;
    private final FileDescriptor fd;
    private final int fdVal;
    private final ReentrantLock acceptLock = new ReentrantLock();
    private final Object stateLock = new Object();
    private static final int ST_INUSE = 0;
    private static final int ST_CLOSING = 1;
    private static final int ST_KILLPENDING = 2;
    private static final int ST_KILLED = 3;
    private static final NetAccess NET_ACCESS;
    private int state;
    private long thread;
    private InetSocketAddress localAddress;
    private boolean isReuseAddress;
    private ServerSocket socket;
    private static final UnsupportedOperationException unsupported;

    private static final SelectorProvider checkSupported(SelectorProvider selectorProvider) {
        if (unsupported != null) {
            throw new UnsupportedOperationException(unsupported.getMessage(), unsupported);
        }
        return selectorProvider;
    }

    RdmaServerSocketChannelImpl(SelectorProvider selectorProvider, ProtocolFamily protocolFamily) throws IOException {
        super(RdmaServerSocketChannelImpl.checkSupported(selectorProvider));
        Objects.requireNonNull(protocolFamily, "'family' is null");
        if (protocolFamily != StandardProtocolFamily.INET && protocolFamily != StandardProtocolFamily.INET6) {
            throw new UnsupportedOperationException("Protocol family not supported");
        }
        if (protocolFamily == StandardProtocolFamily.INET6 && !NET_ACCESS.isIPv6Available()) {
            throw new UnsupportedOperationException("IPv6 not available");
        }
        this.family = protocolFamily;
        this.fd = RdmaNet.serverSocket(protocolFamily, true);
        this.fdVal = IOUtil.fdVal(this.fd);
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = RdmaServerSocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            return this.localAddress == null ? null : NET_ACCESS.getRevealedLocalAddress(this.localAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ServerSocketChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        Objects.requireNonNull(socketOption);
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.isBound() && socketOption == StandardSocketOptions.SO_REUSEADDR) {
                throw new UnsupportedOperationException("RDMA server socket channel cannot set the socket option " + socketOption.toString() + " after bind.");
            }
            RdmaNet.setSocketOption(this.fd, RdmaNet.UNSPEC, socketOption, t);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        Objects.requireNonNull(socketOption);
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            return (T)RdmaNet.getSocketOption(this.fd, RdmaNet.UNSPEC, socketOption);
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    private final InetSocketAddress anyLocalAddress() throws IOException {
        if (this.family == StandardProtocolFamily.INET) {
            return new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0);
        }
        if (this.family == StandardProtocolFamily.INET6) {
            return new InetSocketAddress(InetAddress.getByName("::"), 0);
        }
        throw new UnsupportedAddressTypeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerSocketChannel bind(SocketAddress socketAddress, int n) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.localAddress != null) {
                throw new AlreadyBoundException();
            }
            InetSocketAddress inetSocketAddress = socketAddress == null ? this.anyLocalAddress() : RdmaNet.checkAddress(socketAddress, this.family);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(inetSocketAddress.getPort());
            }
            RdmaNet.bind(this.family, this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            RdmaNet.listen(this.fd, n < 1 ? 50 : n);
            this.localAddress = RdmaNet.localAddress(this.fd);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void begin(boolean bl) throws ClosedChannelException {
        if (bl) {
            this.begin();
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.localAddress == null) {
                throw new NotYetBoundException();
            }
            if (bl) {
                this.thread = NativeThread.current();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end(boolean bl, boolean bl2) throws AsynchronousCloseException {
        if (bl) {
            Object object = this.stateLock;
            synchronized (object) {
                this.thread = 0L;
                if (this.state == 1) {
                    this.stateLock.notifyAll();
                }
            }
            this.end(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel accept() throws IOException {
        this.acceptLock.lock();
        try {
            int n = 0;
            FileDescriptor fileDescriptor = new FileDescriptor();
            InetSocketAddress[] inetSocketAddressArray = new InetSocketAddress[1];
            boolean bl = this.isBlocking();
            try {
                this.begin(bl);
                do {
                    if (!bl) continue;
                    while (((n = RdmaServerSocketChannelImpl.checkAccept(this.fd)) == 0 || n == -3) && this.isOpen()) {
                    }
                } while ((n = this.accept(this.fd, fileDescriptor, inetSocketAddressArray)) == -3 && this.isOpen());
                this.end(bl, n > 0);
            }
            catch (Throwable throwable) {
                this.end(bl, n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            if (n < 1) {
                SocketChannel socketChannel = null;
                return socketChannel;
            }
            RdmaNet.configureBlocking(fileDescriptor, true);
            InetSocketAddress inetSocketAddress = inetSocketAddressArray[0];
            RdmaSocketChannelImpl rdmaSocketChannelImpl = new RdmaSocketChannelImpl(this.provider(), fileDescriptor, inetSocketAddress);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkAccept(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
                catch (SecurityException securityException) {
                    rdmaSocketChannelImpl.close();
                    throw securityException;
                }
            }
            RdmaSocketChannelImpl rdmaSocketChannelImpl2 = rdmaSocketChannelImpl;
            return rdmaSocketChannelImpl2;
        }
        finally {
            this.acceptLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        this.acceptLock.lock();
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.ensureOpen();
                RdmaNet.configureBlocking(this.fd, bl);
            }
        }
        finally {
            this.acceptLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        boolean bl;
        assert (!this.isOpen());
        boolean bl2 = false;
        Object object = this.stateLock;
        synchronized (object) {
            assert (this.state < 1);
            this.state = 1;
            bl = this.isBlocking();
        }
        if (bl) {
            object = this.stateLock;
            synchronized (object) {
                assert (this.state == 1);
                long l = this.thread;
                if (l != 0L) {
                    nd.preClose(this.fd);
                    NativeThread.signal(l);
                    while (this.thread != 0L) {
                        try {
                            this.stateLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            bl2 = true;
                        }
                    }
                }
            }
        } else {
            this.acceptLock.lock();
            this.acceptLock.unlock();
        }
        object = this.stateLock;
        synchronized (object) {
            assert (this.state == 1);
            this.state = 2;
        }
        if (!this.isRegistered()) {
            this.kill();
        }
        if (bl2) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                this.state = 3;
                nd.rdmaClose(this.fd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetSocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pollAccept(long l) throws IOException {
        assert (Thread.holdsLock(this.blockingLock()) && this.isBlocking());
        this.acceptLock.lock();
        try {
            boolean bl2 = false;
            try {
                this.begin(true);
                int bl = RdmaNet.poll(this.fd, Net.POLLIN, l);
                bl2 = bl != 0;
            }
            finally {
                this.end(true, bl2);
            }
            boolean bl = bl2;
            return bl;
        }
        finally {
            this.acceptLock.unlock();
        }
    }

    public boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((n & (Net.POLLERR | Net.POLLHUP)) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            return (n5 & ~n4) != 0;
        }
        if ((n & Net.POLLIN) != 0 && (n3 & 0x10) != 0) {
            n5 |= 0x10;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    public int translateInterestOps(int n) {
        int n2 = 0;
        if ((n & 0x10) != 0) {
            n2 |= Net.POLLIN;
        }
        return n2;
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('[');
        if (!this.isOpen()) {
            stringBuilder.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                InetSocketAddress inetSocketAddress = this.localAddress;
                if (inetSocketAddress == null) {
                    stringBuilder.append("unbound");
                } else {
                    stringBuilder.append(NET_ACCESS.getRevealedLocalAddressAsString(inetSocketAddress));
                }
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private int accept(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, InetSocketAddress[] inetSocketAddressArray) throws IOException {
        return this.accept0(fileDescriptor, fileDescriptor2, inetSocketAddressArray);
    }

    @Override
    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 0x10) != 0) {
            n2 |= Net.POLLIN;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    private static native int checkAccept(FileDescriptor var0) throws IOException;

    private native int accept0(FileDescriptor var1, FileDescriptor var2, InetSocketAddress[] var3) throws IOException;

    private static native void initIDs() throws UnsupportedOperationException;

    static {
        NET_ACCESS = SharedSecrets.getNetAccess();
        IOUtil.load();
        System.loadLibrary("extnet");
        UnsupportedOperationException unsupportedOperationException = null;
        try {
            RdmaServerSocketChannelImpl.initIDs();
        }
        catch (UnsupportedOperationException unsupportedOperationException2) {
            unsupportedOperationException = unsupportedOperationException2;
        }
        unsupported = unsupportedOperationException;
        nd = new RdmaSocketDispatcher();
    }

    private static class DefaultOptionsHolder {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet hashSet = new HashSet(2);
            hashSet.add(StandardSocketOptions.SO_RCVBUF);
            hashSet.add(StandardSocketOptions.SO_REUSEADDR);
            if (RdmaNet.isRdmaAvailable()) {
                RdmaSocketOptions rdmaSocketOptions = RdmaSocketOptions.getInstance();
                hashSet.addAll(rdmaSocketOptions.options());
            }
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

