/*
 * Copyright 2020 The TensorFlow Runtime Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file declares traits for the 'corert' dialect.

#ifndef TFRT_CORE_RUNTIME_OPDEFS_TRAITS_H_
#define TFRT_CORE_RUNTIME_OPDEFS_TRAITS_H_

#include "mlir/IR/OpDefinition.h"

namespace mlir {
namespace OpTrait {
namespace tfrt {
namespace corert {

template <typename ConcreteType>
class TypedAttributeTrait
    : public mlir::OpTrait::TraitBase<ConcreteType, TypedAttributeTrait> {};

}  // namespace corert
}  // namespace tfrt
}  // namespace OpTrait
}  // namespace mlir

#endif  // TFRT_CORE_RUNTIME_OPDEFS_TRAITS_H_
