// Copyright 2020 The TensorFlow Runtime Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This test is auto generated by: //utils/eigen:gen_batch_norm_tests

// RUN: bef_executor %s.bef | FileCheck %s --dump-input=always

// CHECK-LABEL: --- Running 'test_batch_norm_in_1x1x1x8_epsilon_0.0001'
func.func @test_batch_norm_in_1x1x1x8_epsilon_0.0001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 0
  %gamma_index    = tfrt.constant.i32 1
  %beta_index     = tfrt.constant.i32 2
  %mean_index     = tfrt.constant.i32 3
  %var_index      = tfrt.constant.i32 4
  %expected_index = tfrt.constant.i32 5

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %gamma = "btf.read_dense_tensor.f32.1"(%path, %gamma_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %beta = "btf.read_dense_tensor.f32.1"(%path, %beta_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %ch2 = "eigen.batch_norm.f32"(%input, %gamma, %beta, %mean, %var, %ch0)
    { epsilon = 0.0001 : f32 }
    :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
        !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.f32"(%expected, %input, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_batch_norm_in_1x1x2x4_epsilon_0.0001'
func.func @test_batch_norm_in_1x1x2x4_epsilon_0.0001() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/batch_norm_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 6
  %gamma_index    = tfrt.constant.i32 7
  %beta_index     = tfrt.constant.i32 8
  %mean_index     = tfrt.constant.i32 9
  %var_index      = tfrt.constant.i32 10
  %expected_index = tfrt.constant.i32 11

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %gamma = "btf.read_dense_tensor.f32.1"(%path, %gamma_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %beta = "btf.read_dense_tensor.f32.1"(%path, %beta_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %mean = "btf.read_dense_tensor.f32.1"(%path, %mean_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %var = "btf.read_dense_tensor.f32.1"(%path, %var_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %ch2 = "eigen.batch_norm.f32"(%input, %gamma, %beta, %mean, %var, %ch0)
    { epsilon = 0.0001 : f32 }
    :  (!t.tensor, !t.tensor, !t.tensor, !t.tensor,
        !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.f32"(%expected, %input, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}
