/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import com.netscape.certsrv.account.Account;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cmscore.usrgrp.User;
import java.security.Principal;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="login")
public class ACMELoginService {
    public static Logger logger = LoggerFactory.getLogger(ACMELoginService.class);
    @Context
    protected HttpServletRequest servletRequest;

    protected Account createAccount(Principal principal) {
        String username = principal.getName();
        logger.info("ACMELoginService: Principal: " + username);
        Account account = new Account();
        account.setID(username);
        if (principal instanceof PKIPrincipal) {
            PKIPrincipal pkiPrincipal = (PKIPrincipal)principal;
            User user = pkiPrincipal.getUser();
            account.setFullName(user.getFullName());
            account.setEmail(user.getEmail());
            String[] roles = pkiPrincipal.getRoles();
            logger.info("ACMELoginService: Roles:");
            for (String role : roles) {
                logger.info("ACMELoginService: - " + role);
            }
            account.setRoles(Arrays.asList(roles));
        }
        return account;
    }

    @GET
    @Produces(value={"application/json"})
    public Response handleGET() {
        HttpSession session = this.servletRequest.getSession(false);
        logger.info("ACMELoginService: Session: " + (session == null ? null : session.getId()));
        if (session == null) {
            Response.ResponseBuilder builder = Response.noContent();
            return builder.build();
        }
        Principal principal = this.servletRequest.getUserPrincipal();
        logger.info("ACMELoginService: Principal: " + principal);
        if (principal == null) {
            Response.ResponseBuilder builder = Response.noContent();
            return builder.build();
        }
        Response.ResponseBuilder builder = Response.ok();
        Account account = this.createAccount(principal);
        builder.entity((Object)account);
        return builder.build();
    }

    @POST
    @Produces(value={"application/json"})
    public Response handlePOST() {
        HttpSession session = this.servletRequest.getSession();
        logger.info("ACMELoginService: Session: " + session.getId());
        Principal principal = this.servletRequest.getUserPrincipal();
        logger.info("ACMELoginService: Principal: " + principal);
        Account account = this.createAccount(principal);
        Response.ResponseBuilder builder = Response.ok();
        builder.entity((Object)account);
        return builder.build();
    }
}

