/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import com.netscape.cms.realm.RealmCommon;
import com.netscape.cms.realm.RealmConfig;
import com.netscape.cms.tomcat.ProxyRealm;
import com.netscape.cmscore.apps.CMS;
import java.io.File;
import java.io.FileReader;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.catalina.Realm;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.acme.ACMEAccount;
import org.dogtagpki.acme.ACMEAuthorization;
import org.dogtagpki.acme.ACMEError;
import org.dogtagpki.acme.ACMEIdentifier;
import org.dogtagpki.acme.ACMEMetadata;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.ACMEOrder;
import org.dogtagpki.acme.ACMERevocation;
import org.dogtagpki.acme.JWK;
import org.dogtagpki.acme.JWS;
import org.dogtagpki.acme.database.ACMEDatabase;
import org.dogtagpki.acme.database.ACMEDatabaseConfig;
import org.dogtagpki.acme.issuer.ACMEIssuer;
import org.dogtagpki.acme.issuer.ACMEIssuerConfig;
import org.dogtagpki.acme.scheduler.ACMEScheduler;
import org.dogtagpki.acme.scheduler.ACMESchedulerConfig;
import org.dogtagpki.acme.server.ACMEEngineConfig;
import org.dogtagpki.acme.server.ACMEEngineConfigDefaultSource;
import org.dogtagpki.acme.server.ACMEEngineConfigSource;
import org.dogtagpki.acme.server.ACMEPolicy;
import org.dogtagpki.acme.server.ACMEPolicyConfig;
import org.dogtagpki.acme.validator.ACMEValidator;
import org.dogtagpki.acme.validator.ACMEValidatorConfig;
import org.dogtagpki.acme.validator.ACMEValidatorsConfig;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACMEEngine {
    public static final Logger logger = LoggerFactory.getLogger(ACMEEngine.class);
    public static ACMEEngine INSTANCE;
    private String id;
    private ACMEEngineConfig config;
    private ACMEPolicy policy;
    private ACMEEngineConfigSource engineConfigSource = null;
    public Random random;
    private ACMEMetadata metadata;
    private ACMEDatabaseConfig databaseConfig;
    private ACMEDatabase database;
    private ACMEValidatorsConfig validatorsConfig;
    private Map<String, ACMEValidator> validators = new HashMap<String, ACMEValidator>();
    private ACMEIssuerConfig issuerConfig;
    private ACMEIssuer issuer;
    private ACMEScheduler scheduler;
    private RealmCommon realm;
    private boolean noncesPersistent;
    private Map<String, ACMENonce> nonces = new ConcurrentHashMap<String, ACMENonce>();

    public static ACMEEngine getInstance() {
        return INSTANCE;
    }

    public ACMEEngine() {
        INSTANCE = this;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public ACMEPolicy getPolicy() {
        return this.policy;
    }

    public ACMEMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ACMEMetadata metadata) {
        this.metadata = metadata;
    }

    public ACMEDatabaseConfig getDatabaseConfig() {
        return this.databaseConfig;
    }

    public void setDatabaseConfig(ACMEDatabaseConfig databaseConfig) {
        this.databaseConfig = databaseConfig;
    }

    public ACMEDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(ACMEDatabase database) {
        this.database = database;
    }

    public Collection<ACMEValidator> getValidators() {
        return this.validators.values();
    }

    public ACMEValidator getValidator(String name) {
        return this.validators.get(name);
    }

    public void addValidator(String name, ACMEValidator validator) {
        this.validators.put(name, validator);
    }

    public ACMEIssuerConfig getIssuerConfig() {
        return this.issuerConfig;
    }

    public void setIssuerConfig(ACMEIssuerConfig issuerConfig) {
        this.issuerConfig = issuerConfig;
    }

    public ACMEIssuer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(ACMEIssuer issuer) {
        this.issuer = issuer;
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.config.setEnabled(enabled);
    }

    public URL getBaseURL() {
        return this.config.getBaseURL();
    }

    public void loadConfig(String filename) throws Exception {
        File configFile = new File(filename);
        if (!configFile.exists()) {
            configFile = new File("/usr/share/pki/acme/conf/engine.conf");
        }
        logger.info("Loading ACME engine config from " + configFile);
        Properties props = new Properties();
        try (FileReader reader = new FileReader(configFile);){
            props.load(reader);
        }
        this.config = ACMEEngineConfig.fromProperties(props);
        logger.info("- enabled: " + this.config.isEnabled());
        logger.info("- base URL: " + this.config.getBaseURL());
        logger.info("- nonces persistent: " + this.config.getNoncesPersistent());
        ACMEPolicyConfig policyConfig = this.config.getPolicyConfig();
        logger.info("- wildcard: " + policyConfig.getEnableWildcards());
        logger.info("- nonce retention: " + policyConfig.getRetention().getNonces());
        logger.info("- authorization retention:");
        logger.info("  - pending: " + policyConfig.getRetention().getPendingAuthorizations());
        logger.info("  - invalid: " + policyConfig.getRetention().getInvalidAuthorizations());
        logger.info("  - valid: " + policyConfig.getRetention().getValidAuthorizations());
        logger.info("- order retention:");
        logger.info("  - pending: " + policyConfig.getRetention().getPendingOrders());
        logger.info("  - invalid: " + policyConfig.getRetention().getInvalidOrders());
        logger.info("  - ready: " + policyConfig.getRetention().getReadyOrders());
        logger.info("  - processing: " + policyConfig.getRetention().getProcessingOrders());
        logger.info("  - valid: " + policyConfig.getRetention().getValidOrders());
        logger.info("- certificate retention: " + policyConfig.getRetention().getCertificates());
        this.policy = new ACMEPolicy(policyConfig);
    }

    public void initRandomGenerator() throws Exception {
        this.random = SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
    }

    public void initMetadata(String filename) throws Exception {
        File metadataConfigFile = new File(filename);
        if (!metadataConfigFile.exists()) {
            metadataConfigFile = new File("/usr/share/pki/acme/conf/metadata.conf");
        }
        logger.info("Loading ACME metadata from " + metadataConfigFile);
        Properties props = new Properties();
        try (FileReader reader = new FileReader(metadataConfigFile);){
            props.load(reader);
        }
        this.metadata = ACMEMetadata.fromProperties((Properties)props);
    }

    public void initDatabase(String filename) throws Exception {
        File databaseConfigFile = new File(filename);
        if (databaseConfigFile.exists()) {
            logger.info("Loading ACME database config from " + databaseConfigFile);
            Properties props = new Properties();
            try (FileReader reader = new FileReader(databaseConfigFile);){
                props.load(reader);
            }
            this.databaseConfig = ACMEDatabaseConfig.fromProperties(props);
        } else {
            logger.info("Loading default ACME database config");
            this.databaseConfig = new ACMEDatabaseConfig();
        }
        logger.info("Initializing ACME database");
        String className = this.databaseConfig.getClassName();
        Class<?> databaseClass = Class.forName(className);
        this.database = (ACMEDatabase)databaseClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.database.setConfig(this.databaseConfig);
        this.database.init();
    }

    public void initValidators(String filename) throws Exception {
        File validatorsConfigFile = new File(filename);
        if (!validatorsConfigFile.exists()) {
            validatorsConfigFile = new File("/usr/share/pki/acme/conf/validators.conf");
        }
        logger.info("Loading ACME validators config from " + validatorsConfigFile);
        Properties props = new Properties();
        try (FileReader reader = new FileReader(validatorsConfigFile);){
            props.load(reader);
        }
        this.validatorsConfig = ACMEValidatorsConfig.fromProperties(props);
        logger.info("Initializing ACME validators");
        for (String name : this.validatorsConfig.keySet()) {
            logger.info("Initializing " + name + " validator");
            ACMEValidatorConfig validatorConfig = (ACMEValidatorConfig)this.validatorsConfig.get(name);
            String className = validatorConfig.getClassName();
            Class<?> validatorClass = Class.forName(className);
            ACMEValidator validator = (ACMEValidator)validatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            validator.setConfig(validatorConfig);
            validator.init();
            this.addValidator(name, validator);
        }
    }

    public void initIssuer(String filename) throws Exception {
        File issuerConfigFile = new File(filename);
        if (issuerConfigFile.exists()) {
            logger.info("Loading ACME issuer config from " + issuerConfigFile);
            Properties props = new Properties();
            try (FileReader reader = new FileReader(issuerConfigFile);){
                props.load(reader);
            }
            this.issuerConfig = ACMEIssuerConfig.fromProperties(props);
        } else {
            logger.info("Loading default ACME issuer config");
            this.issuerConfig = new ACMEIssuerConfig();
        }
        logger.info("Initializing ACME issuer");
        String className = this.issuerConfig.getClassName();
        Class<?> issuerClass = Class.forName(className);
        this.issuer = (ACMEIssuer)issuerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.issuer.setConfig(this.issuerConfig);
        this.issuer.init();
    }

    public void initScheduler(String filename) throws Exception {
        File schedulerConfigFile = new File(filename);
        if (!schedulerConfigFile.exists()) {
            schedulerConfigFile = new File("/usr/share/pki/acme/conf/scheduler.conf");
        }
        logger.info("Loading ACME scheduler config from " + schedulerConfigFile);
        Properties props = new Properties();
        try (FileReader reader = new FileReader(schedulerConfigFile);){
            props.load(reader);
        }
        ACMESchedulerConfig schedulerConfig = ACMESchedulerConfig.fromProperties(props);
        logger.info("Initializing ACME scheduler");
        this.scheduler = new ACMEScheduler();
        this.scheduler.setConfig(schedulerConfig);
        this.scheduler.init();
    }

    public void initMonitors(String filename) throws Exception {
        File monitorsConfigFile = new File(filename);
        Properties monitorsConfig = new Properties();
        if (monitorsConfigFile.exists()) {
            logger.info("Loading ACME monitors config from " + filename);
            try (FileReader reader = new FileReader(monitorsConfigFile);){
                monitorsConfig.load(reader);
            }
        } else {
            logger.info("Using default ACME monitors config");
        }
        Class configSourceClass = ACMEEngineConfigDefaultSource.class;
        String className = monitorsConfig.getProperty("engine.class");
        if (className != null && !className.isEmpty()) {
            configSourceClass = Class.forName(className);
        }
        this.engineConfigSource = (ACMEEngineConfigSource)configSourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.engineConfigSource.setEnabledConsumer(new Consumer<Boolean>(){

            @Override
            public void accept(Boolean b) {
                ACMEEngine.this.config.setEnabled(b);
                logger.info("ACME service is " + (b != false ? "enabled" : "DISABLED") + " by configuration");
            }
        });
        this.engineConfigSource.setWildcardConsumer(new Consumer<Boolean>(){

            @Override
            public void accept(Boolean b) {
                ACMEEngine.this.config.getPolicyConfig().setEnableWildcards(b);
                logger.info("ACME wildcard issuance is " + (b != false ? "enabled" : "DISABLED") + " by configuration");
            }
        });
        this.engineConfigSource.init(monitorsConfig);
    }

    public void initRealm(String filename) throws Exception {
        File realmConfigFile = new File(filename);
        RealmConfig realmConfig = null;
        if (realmConfigFile.exists()) {
            logger.info("Loading ACME realm config from " + realmConfigFile);
            Properties props = new Properties();
            try (FileReader reader = new FileReader(realmConfigFile);){
                props.load(reader);
            }
            realmConfig = RealmConfig.fromProperties((Properties)props);
        } else {
            logger.info("Loading default ACME realm config");
            realmConfig = new RealmConfig();
        }
        logger.info("Initializing ACME realm");
        String className = realmConfig.getClassName();
        Class<?> realmClass = Class.forName(className);
        this.realm = (RealmCommon)realmClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.realm.setConfig(realmConfig);
        this.realm.start();
        ProxyRealm.registerRealm((String)this.id, (Realm)this.realm);
    }

    public void start() throws Exception {
        logger.info("Starting ACME engine");
        String instanceDir = CMS.getInstanceDir();
        String serverConfDir = instanceDir + File.separator + "conf";
        String acmeConfDir = serverConfDir + File.separator + this.id;
        logger.info("ACME configuration directory: " + acmeConfDir);
        this.loadConfig(acmeConfDir + File.separator + "engine.conf");
        Boolean noncePersistent = this.config.getNoncesPersistent();
        this.noncesPersistent = noncePersistent != null ? noncePersistent : false;
        this.initRandomGenerator();
        this.initMetadata(acmeConfDir + File.separator + "metadata.conf");
        this.initDatabase(acmeConfDir + File.separator + "database.conf");
        this.initValidators(acmeConfDir + File.separator + "validators.conf");
        this.initIssuer(acmeConfDir + File.separator + "issuer.conf");
        this.initScheduler(acmeConfDir + File.separator + "scheduler.conf");
        this.initMonitors(acmeConfDir + File.separator + "configsources.conf");
        this.initRealm(acmeConfDir + File.separator + "realm.conf");
        logger.info("ACME engine started");
    }

    public void shutdownDatabase() throws Exception {
        if (this.database == null) {
            return;
        }
        this.database.close();
        this.database = null;
    }

    public void shutdownValidators() throws Exception {
        for (ACMEValidator validator : this.validators.values()) {
            validator.close();
        }
        this.validators.clear();
    }

    public void shutdownIssuer() throws Exception {
        if (this.issuer == null) {
            return;
        }
        this.issuer.close();
        this.issuer = null;
    }

    public void shutdownScheduler() throws Exception {
        if (this.scheduler == null) {
            return;
        }
        this.scheduler.shutdown();
        this.scheduler = null;
    }

    public void shutdownMonitors() throws Exception {
        if (this.engineConfigSource == null) {
            return;
        }
        this.engineConfigSource.shutdown();
        this.engineConfigSource = null;
    }

    public void shutdownRealm() throws Exception {
        if (this.realm == null) {
            return;
        }
        this.realm.stop();
        this.realm = null;
    }

    public void stop() throws Exception {
        logger.info("Stopping ACME engine");
        this.shutdownRealm();
        this.shutdownMonitors();
        this.shutdownScheduler();
        this.shutdownIssuer();
        this.shutdownValidators();
        this.shutdownDatabase();
        logger.info("ACME engine stopped");
    }

    public String randomAlphanumeric(int length) {
        return RandomStringUtils.random((int)length, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)this.random);
    }

    public ACMENonce createNonce() throws Exception {
        Date currentTime = new Date();
        ACMENonce nonce = new ACMENonce();
        byte[] bytes = new byte[16];
        SecureRandom random = SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
        random.nextBytes(bytes);
        String nonceID = Base64.encodeBase64URLSafeString((byte[])bytes);
        nonce.setID(nonceID);
        nonce.setCreationTime(currentTime);
        Date expirationTime = this.policy.getNonceExpirationTime(currentTime);
        nonce.setExpirationTime(expirationTime);
        if (this.noncesPersistent) {
            this.database.addNonce(nonce);
        } else {
            this.nonces.put(nonce.getID(), nonce);
        }
        logger.info("Created nonce: " + nonce);
        return nonce;
    }

    public void validateNonce(String value) throws Exception {
        ACMENonce nonce = this.noncesPersistent ? this.database.removeNonce(value) : this.nonces.remove(value);
        if (nonce == null) {
            throw new Exception("Invalid nonce: " + value);
        }
        long currentTime = System.currentTimeMillis();
        long expirationTime = nonce.getExpirationTime().getTime();
        if (expirationTime <= currentTime) {
            throw new Exception("Expired nonce: " + value);
        }
        logger.info("Valid nonce: " + value);
    }

    public void removeExpiredRecords(Date currentTime) throws Exception {
        if (this.noncesPersistent) {
            this.database.removeExpiredNonces(currentTime);
        } else {
            this.nonces.values().removeIf(n -> !currentTime.before(n.getExpirationTime()));
        }
        this.database.removeExpiredAuthorizations(currentTime);
        this.database.removeExpiredOrders(currentTime);
        this.database.removeExpiredCertificates(currentTime);
    }

    public void validateJWS(JWS jws, String alg, JWK jwk) throws Exception {
        if (!"RS256".equals(alg)) {
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            builder.type("application/problem+json");
            ACMEError error = new ACMEError();
            error.setType("urn:ietf:params:acme:error:badSignatureAlgorithm");
            error.setDetail("Signature of type " + alg + " not supported\nTry again with RS256.");
            builder.entity((Object)error);
            throw new WebApplicationException(builder.build());
        }
        Signature signer = Signature.getInstance("SHA256withRSA", "Mozilla-JSS");
        String kty = jwk.getKty();
        KeyFactory keyFactory = KeyFactory.getInstance(kty, "Mozilla-JSS");
        String n = jwk.getN();
        BigInteger modulus = new BigInteger(1, Base64.decodeBase64((String)n));
        String e = jwk.getE();
        BigInteger publicExponent = new BigInteger(1, Base64.decodeBase64((String)e));
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, publicExponent);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        this.validateJWS(jws, signer, publicKey);
    }

    public void validateJWS(JWS jws, Signature signer, PublicKey publicKey) throws Exception {
        logger.info("Validating JWS");
        String message = jws.getProtectedHeader() + "." + jws.getPayload();
        byte[] signature = Base64.decodeBase64((String)jws.getSignature());
        signer.initVerify(publicKey);
        signer.update(message.getBytes());
        if (!signer.verify(signature)) {
            throw new Exception("Invalid JWS");
        }
    }

    public String generateThumbprint(JWK jwk) throws Exception {
        String data = jwk.toJSON();
        MessageDigest digest = MessageDigest.getInstance("SHA-256", "Mozilla-JSS");
        byte[] hash = digest.digest(data.getBytes("UTF-8"));
        return Base64.encodeBase64URLSafeString((byte[])hash);
    }

    public void createAccount(ACMEAccount account) throws Exception {
        this.database.addAccount(account);
    }

    public ACMEAccount getAccount(String accountID) throws Exception {
        return this.getAccount(accountID, true);
    }

    public ACMEAccount getAccount(String accountID, boolean validate) throws Exception {
        ACMEAccount account = this.database.getAccount(accountID);
        if (validate) {
            if (account == null) {
                throw this.createAccountDoesNotExistException(accountID);
            }
            this.validateAccount(accountID, account);
        }
        return account;
    }

    public void validateAccount(String accountID, ACMEAccount account) throws Exception {
        if (!"valid".equals(account.getStatus())) {
            logger.info("Invalid account: " + accountID);
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
            builder.type("application/problem+json");
            ACMEError error = new ACMEError();
            error.setType("urn:ietf:params:acme:error:unauthorized");
            error.setDetail("Invalid account: " + accountID);
            builder.entity((Object)error);
            throw new WebApplicationException(builder.build());
        }
    }

    public Exception createAccountDoesNotExistException(String accountID) {
        logger.info("Account does not exist: " + accountID);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        builder.type("application/problem+json");
        ACMEError error = new ACMEError();
        error.setType("urn:ietf:params:acme:error:accountDoesNotExist");
        error.setDetail("Account does not exist on the server: " + accountID + "\nRemove the account from the client, for example:\n$ rm -rf /etc/letsencrypt/accounts/<ACME server>");
        builder.entity((Object)error);
        return new WebApplicationException(builder.build());
    }

    public void updateAccount(ACMEAccount account) throws Exception {
        this.database.updateAccount(account);
    }

    public void addAuthorization(ACMEAccount account, ACMEAuthorization authorization) throws Exception {
        authorization.setAccountID(account.getID());
        this.database.addAuthorization(authorization);
    }

    public void validateAuthorization(ACMEAccount account, ACMEAuthorization authorization) throws Exception {
        String authzID = authorization.getID();
        if (!authorization.getAccountID().equals(account.getID())) {
            throw new Exception("Unable to access authorization " + authzID);
        }
        long currentTime = System.currentTimeMillis();
        Date expirationTime = authorization.getExpirationTime();
        if (expirationTime != null && expirationTime.getTime() <= currentTime) {
            throw new Exception("Expired authorization: " + authzID);
        }
        logger.info("Valid authorization: " + authzID);
    }

    public ACMEAuthorization getAuthorization(ACMEAccount account, String authzID) throws Exception {
        ACMEAuthorization authorization = this.database.getAuthorization(authzID);
        this.validateAuthorization(account, authorization);
        return authorization;
    }

    public ACMEAuthorization getAuthorizationByChallenge(ACMEAccount account, String challengeID) throws Exception {
        ACMEAuthorization authorization = this.database.getAuthorizationByChallenge(challengeID);
        this.validateAuthorization(account, authorization);
        return authorization;
    }

    public void updateAuthorization(ACMEAccount account, ACMEAuthorization authorization) throws Exception {
        this.validateAuthorization(account, authorization);
        this.database.updateAuthorization(authorization);
    }

    public void addOrder(ACMEAccount account, ACMEOrder order) throws Exception {
        order.setAccountID(account.getID());
        this.database.addOrder(order);
    }

    public CheckOrderResult checkOrder(ACMEAccount account, ACMEOrder order) {
        if (order == null) {
            return CheckOrderResult.ORDER_NULL;
        }
        if (!order.getAccountID().equals(account.getID())) {
            return CheckOrderResult.ORDER_ACCOUNT_MISMATCH;
        }
        Date expirationTime = order.getExpirationTime();
        if (expirationTime == null) {
            return CheckOrderResult.ORDER_ACCESS_OK;
        }
        long currentTime = System.currentTimeMillis();
        if (expirationTime.getTime() <= currentTime) {
            return CheckOrderResult.ORDER_EXPIRED;
        }
        return CheckOrderResult.ORDER_ACCESS_OK;
    }

    public void validateOrder(ACMEAccount account, ACMEOrder order) throws Exception {
        switch (this.checkOrder(account, order)) {
            case ORDER_ACCOUNT_MISMATCH: {
                throw new Exception("Unable to access order " + order.getID());
            }
            case ORDER_EXPIRED: {
                throw new Exception("Expired order: " + order.getID());
            }
            case ORDER_NULL: {
                throw new Exception("Order not found");
            }
            case ORDER_ACCESS_OK: {
                logger.info("Valid order: " + order.getID());
            }
        }
    }

    public ACMEOrder getOrder(ACMEAccount account, String orderID) throws Exception {
        ACMEOrder order = this.database.getOrder(orderID);
        this.validateOrder(account, order);
        return order;
    }

    public Collection<ACMEOrder> getOrdersByAccount(ACMEAccount account) throws Exception {
        return this.database.getOrdersByAccount(account.getID());
    }

    public Collection<ACMEOrder> getOrdersByAuthorizationAndStatus(ACMEAccount account, String authzID, String status) throws Exception {
        Collection<ACMEOrder> orders = this.database.getOrdersByAuthorizationAndStatus(authzID, status);
        orders.removeIf(o -> this.checkOrder(account, (ACMEOrder)o) != CheckOrderResult.ORDER_ACCESS_OK);
        return orders;
    }

    public void updateOrder(ACMEAccount account, ACMEOrder order) throws Exception {
        this.validateOrder(account, order);
        this.database.updateOrder(order);
    }

    public void validateCSR(ACMEAccount account, ACMEOrder order, PKCS10 pkcs10) throws Exception {
        logger.info("Getting authorized identifiers");
        HashSet<String> authorizedDNSNames = new HashSet<String>();
        for (String authzID : order.getAuthzIDs()) {
            ACMEAuthorization authz = this.database.getAuthorization(authzID);
            ACMEIdentifier identifier = authz.getIdentifier();
            String type = identifier.getType();
            Object value = identifier.getValue();
            if (!"dns".equals(type)) continue;
            Boolean b = authz.getWildcard();
            if (null != b && b.booleanValue()) {
                value = "*." + (String)value;
            }
            authorizedDNSNames.add(((String)value).toLowerCase());
        }
        logger.info("Authorized DNS names:");
        for (String dnsName : authorizedDNSNames) {
            logger.info("- " + dnsName);
        }
        logger.info("Getting DNS names from CSR");
        Set dnsNames = CertUtil.getDNSNames((PKCS10)pkcs10);
        logger.info("Validating DNS names in CSR");
        for (String dnsName : dnsNames) {
            logger.info("- " + dnsName);
        }
        HashSet unauthorizedDNSNames = new HashSet(dnsNames);
        unauthorizedDNSNames.removeAll(authorizedDNSNames);
        if (!unauthorizedDNSNames.isEmpty()) {
            throw new Exception("Unauthorized DNS names: " + StringUtils.join(unauthorizedDNSNames, (String)", "));
        }
        HashSet extraAuthorizedDNSNames = new HashSet(authorizedDNSNames);
        extraAuthorizedDNSNames.removeAll(dnsNames);
        if (!extraAuthorizedDNSNames.isEmpty()) {
            throw new Exception("Missing DNS names from order: " + StringUtils.join(extraAuthorizedDNSNames, (String)", "));
        }
        logger.info("CSR is valid");
    }

    public void validateRevocation(ACMEAccount account, ACMERevocation revocation) throws Exception {
        block9: {
            Date now = new Date();
            String certBase64 = revocation.getCertificate();
            byte[] certData = Utils.base64decode((String)certBase64);
            X509CertImpl cert = new X509CertImpl(certData);
            String certID = this.issuer.getCertificateID((X509Certificate)cert);
            logger.info("Finding order that issued the certificate");
            ACMEOrder order = this.database.getOrderByCertificate(certID);
            if (order != null) {
                logger.info("Order ID: " + order.getID());
                if (order.getAccountID().equals(account.getID())) {
                    logger.info("Account issued the certificate; revocation OK");
                    return;
                }
                logger.info("Account did not issue the certificate");
            }
            logger.info("Getting certificate identifiers");
            Collection<ACMEIdentifier> identifiers = this.getCertIdentifiers((X509Certificate)cert);
            if (identifiers.isEmpty()) {
                throw new Exception("Certificate has no ACME identifiers.");
            }
            try {
                for (ACMEIdentifier identifier : identifiers) {
                    logger.info("Checking revocation authorization for " + identifier);
                    if (this.database.hasRevocationAuthorization(account.getID(), now, identifier)) continue;
                    logger.info("Account has no authorizations for " + identifier);
                    throw new Exception("Account has no authorizations for " + identifier);
                }
            }
            catch (NotImplementedException e) {
                logger.info("Getting revocation authorizations");
                Collection<ACMEAuthorization> authzs = this.database.getRevocationAuthorizations(account.getID(), now);
                for (ACMEAuthorization authz : authzs) {
                    ACMEIdentifier authzIdentifier = authz.getIdentifier();
                    String type = authzIdentifier.getType();
                    if ("dns".equals(type) && authz.getWildcard().booleanValue()) {
                        String value = "*." + authzIdentifier.getValue();
                        authzIdentifier = new ACMEIdentifier();
                        authzIdentifier.setType(type);
                        authzIdentifier.setValue(value);
                    }
                    identifiers.remove(authzIdentifier);
                }
                if (identifiers.isEmpty()) break block9;
                logger.info("Account has no authorizations for:");
                for (ACMEIdentifier identifier : identifiers) {
                    logger.info("- " + identifier.getType() + ": " + identifier.getValue());
                }
                throw new Exception("Account has no authorizations for " + identifiers);
            }
        }
        logger.info("Account has authorizations for all identifiers");
    }

    public Collection<ACMEIdentifier> getCertIdentifiers(X509Certificate cert) throws Exception {
        String cn;
        HashSet<ACMEIdentifier> identifiers = new HashSet<ACMEIdentifier>();
        X509CertImpl certImpl = new X509CertImpl(cert.getEncoded());
        X500Name subjectDN = certImpl.getSubjectObj().getX500Name();
        logger.info("Subject DN: " + subjectDN);
        try {
            cn = subjectDN.getCommonName();
        }
        catch (NullPointerException e) {
            cn = null;
        }
        if (cn != null) {
            ACMEIdentifier identifier = new ACMEIdentifier("dns", cn.toLowerCase());
            identifiers.add(identifier);
        }
        logger.info("SAN extensions:");
        Collection<List<?>> sanExtensions = cert.getSubjectAlternativeNames();
        if (sanExtensions != null) {
            for (List<?> sanExtension : sanExtensions) {
                Integer type = (Integer)sanExtension.get(0);
                Object value = sanExtension.get(1);
                logger.info("- " + value);
                if (type != 2) continue;
                String dnsName = (String)value;
                ACMEIdentifier identifier = new ACMEIdentifier("dns", dnsName);
                identifiers.add(identifier);
            }
        }
        return identifiers;
    }

    static enum CheckOrderResult {
        ORDER_ACCOUNT_MISMATCH,
        ORDER_EXPIRED,
        ORDER_ACCESS_OK,
        ORDER_NULL;

    }
}

