/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.cmscore.apps.CMS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PredicateTokenizer {
    public static Logger logger = LoggerFactory.getLogger(PredicateTokenizer.class);
    String input;
    int currentIndex;
    String nextToken;

    public PredicateTokenizer(String predString) {
        this.input = predString;
        this.currentIndex = 0;
        this.nextToken = null;
    }

    public boolean hasMoreTokens() {
        return this.currentIndex != -1;
    }

    public String nextToken() throws ELdapException {
        int orIndex;
        if (this.nextToken != null) {
            String toReturn = this.nextToken;
            this.nextToken = null;
            return toReturn;
        }
        int andIndex = this.input.indexOf(" AND", this.currentIndex);
        if (andIndex < 0) {
            andIndex = this.input.indexOf(" and", this.currentIndex);
        }
        if ((orIndex = this.input.indexOf(" OR", this.currentIndex)) < 0) {
            orIndex = this.input.indexOf(" or", this.currentIndex);
        }
        String toReturn = null;
        if (andIndex == -1 && orIndex == -1) {
            if (this.currentIndex == 0) {
                this.currentIndex = -1;
                toReturn = this.input;
            } else {
                int temp = this.currentIndex;
                this.currentIndex = -1;
                toReturn = this.input.substring(temp);
            }
        } else if (andIndex >= 0 && (andIndex < orIndex || orIndex == -1)) {
            if (this.currentIndex != andIndex) {
                toReturn = this.input.substring(this.currentIndex, andIndex);
                this.nextToken = this.input.substring(andIndex + 1, andIndex + 4);
                this.currentIndex = andIndex + 4;
            } else {
                toReturn = "AND";
                this.currentIndex += 4;
            }
        } else if (orIndex >= 0 && (orIndex < andIndex || andIndex == -1)) {
            if (this.currentIndex != orIndex) {
                toReturn = this.input.substring(this.currentIndex, orIndex);
                this.nextToken = this.input.substring(orIndex + 1, orIndex + 3);
                this.currentIndex = orIndex + 3;
            } else {
                toReturn = "OR";
                this.currentIndex += 3;
            }
        } else {
            logger.error("Malformed expression: Null Token");
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_BAD_LDAP_EXPRESSION", (String[])new String[0]));
        }
        String trimmed = toReturn.trim();
        return trimmed.length() == 0 ? this.nextToken() : trimmed;
    }
}

