/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.request;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.authorization.EAuthzException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.IRequestVirtualList;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.request.ReqParser;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.request.RequestRepository;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryReq
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(QueryReq.class);
    protected static final String IN_SHOW_ALL = "showAll";
    protected static final String IN_SHOW_WAITING = "showWaiting";
    protected static final String IN_SHOW_IN_SERVICE = "showInService";
    protected static final String IN_SHOW_PENDING = "showPending";
    protected static final String IN_SHOW_CANCELLED = "showCancelled";
    protected static final String IN_SHOW_REJECTED = "showRejected";
    protected static final String IN_SHOW_COMPLETED = "showCompleted";
    protected static final String IN_MAXCOUNT = "maxCount";
    protected static final String IN_TOTALCOUNT = "totalRecordCount";
    protected static final String PROP_PARSER = "parser";
    protected static final String REALM = "realm";
    protected static final String TPL_FILE = "queryReq.template";
    protected static final String OUT_TOTALCOUNT = "totalRecordCount";
    protected static final String OUT_CURRENTCOUNT = "currentRecordCount";
    protected static final String OUT_REQUESTING_USER = "requestingUser";
    protected static final String OUT_FIRST_ENTRY_ON_PAGE = "firstEntryOnPage";
    protected static final String OUT_LAST_ENTRY_ON_PAGE = "lastEntryOnPage";
    protected static final String OUT_ERROR = "error";
    protected static final String OUT_AUTHORITY_ID = "authorityid";
    protected ReqParser mParser;
    protected RequestQueue mQueue;
    protected String mFormPath;
    protected int mMaxReturns = 2000;

    @Override
    public CMSRequest newCMSRequest() {
        return new CMSRequest();
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CMSEngine engine = this.getCMSEngine();
        this.mQueue = engine.getRequestQueue();
        this.mFormPath = "/" + this.mAuthority.getId() + "/queryReq.template";
        try {
            this.mMaxReturns = Integer.parseInt(sc.getInitParameter("maxResults"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mTemplates.remove(CMSRequest.SUCCESS);
        this.mTemplates.remove(CMSRequest.ERROR);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    protected String getRequestType(String p) {
        String filter = "(requestType=*)";
        if (p == null) {
            return filter;
        }
        if (p.equals("enrollment")) {
            filter = "(requestType=enrollment)";
        } else if (p.equals("renewal")) {
            filter = "(requestType=renewal)";
        } else if (p.equals("revocation")) {
            filter = "(requestType=revocation)";
        } else if (p.equals("unrevocation")) {
            filter = "(requestType=unrevocation)";
        } else if (p.equals("archival")) {
            filter = "(requestType=archival)";
        } else if (p.equals("recovery")) {
            filter = "(requestType=recovery)";
        } else if (p.equals("getCAChain")) {
            filter = "(requestType=getCAChain)";
        } else if (p.equals("getRevocationInfo")) {
            filter = "(requestType=getRevocationInfo)";
        } else if (p.equals("getCRL")) {
            filter = "(requestType=getCRL)";
        } else if (p.equals("getCertificates")) {
            filter = "(requestType=getCertificates)";
        } else if (p.equals("netkeyKeygen")) {
            filter = "(requestType=netkeyKeygen)";
        } else if (p.equals("netkeyKeyRecovery")) {
            filter = "(requestType=netkeyKeyRecovery)";
        } else if (p.equals(IN_SHOW_ALL)) {
            filter = "(requestType=*)";
        }
        return filter;
    }

    protected String getRequestState(String p) {
        String filter = "(requeststate=*)";
        if (p == null) {
            return filter;
        }
        if (p.equals(IN_SHOW_WAITING)) {
            filter = "(requeststate=pending)";
        } else if (p.equals(IN_SHOW_IN_SERVICE)) {
            filter = "(requeststate=svc_pending)";
        } else if (p.equals(IN_SHOW_PENDING)) {
            filter = "(requeststate=pending)";
        } else if (p.equals(IN_SHOW_CANCELLED)) {
            filter = "(requeststate=canceled)";
        } else if (p.equals(IN_SHOW_REJECTED)) {
            filter = "(requeststate=rejected)";
        } else if (p.equals(IN_SHOW_COMPLETED)) {
            filter = "(requeststate=complete)";
        } else if (p.equals(IN_SHOW_ALL)) {
            filter = "(requeststate=*)";
        }
        return filter;
    }

    public void validateAuthToken(HttpServletRequest request, AuthToken authToken) throws EBaseException {
    }

    public String getFilter(HttpServletRequest request) {
        String reqState = request.getParameter("reqState");
        String reqType = request.getParameter("reqType");
        Object filter = reqState == null || reqType == null ? "(requeststate=*)" : (reqState.equals(IN_SHOW_ALL) && reqType.equals(IN_SHOW_ALL) ? "(requeststate=*)" : (reqState.equals(IN_SHOW_ALL) ? this.getRequestType(reqType) : (reqType.equals(IN_SHOW_ALL) ? this.getRequestState(reqState) : "(&" + this.getRequestState(reqState) + this.getRequestType(reqType) + ")")));
        return filter;
    }

    @Override
    public void process(CMSRequest cmsReq) throws EBaseException {
        logger.info("QueryReq: Searching for requests");
        HttpServletRequest req = cmsReq.getHttpReq();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "list");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        try {
            this.validateAuthToken(req, authToken);
        }
        catch (EAuthzException e) {
            logger.warn(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERR_GET_TEMPLATE", this.mFormPath, e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0]), e);
        }
        String filter = this.getFilter(req);
        logger.info("QueryReq: - filter: " + filter);
        String reqState = req.getParameter("reqState");
        logger.info("QueryReq: - state: " + reqState);
        String reqType = req.getParameter("reqType");
        logger.info("QueryReq: - type: " + reqType);
        String direction = "begin";
        if (req.getParameter("direction") != null) {
            direction = req.getParameter("direction").trim();
        }
        logger.info("QueryReq: - direction: " + direction);
        BigInteger top = BigInteger.ZERO;
        BigInteger bottom = BigInteger.ZERO;
        try {
            String bottom_s;
            String top_s = req.getParameter(OUT_FIRST_ENTRY_ON_PAGE);
            if (top_s == null) {
                top_s = "0";
            }
            if ((bottom_s = req.getParameter(OUT_LAST_ENTRY_ON_PAGE)) == null) {
                bottom_s = "0";
            }
            top = top_s.trim().startsWith("0x") ? new BigInteger(top_s.trim().substring(2), 16) : new BigInteger(top_s.trim());
            bottom = bottom_s.trim().startsWith("0x") ? new BigInteger(bottom_s.trim().substring(2), 16) : new BigInteger(bottom_s.trim());
        }
        catch (NumberFormatException e) {
            logger.warn("QueryReq: " + e.getMessage(), (Throwable)e);
        }
        int maxCount = 10;
        try {
            maxCount = Integer.parseInt(req.getParameter(IN_MAXCOUNT));
        }
        catch (Exception e) {
            logger.warn("QueryReq: " + e.getMessage(), (Throwable)e);
        }
        if (maxCount > this.mMaxReturns) {
            logger.debug("Resetting page size from " + maxCount + " to " + this.mMaxReturns);
            maxCount = this.mMaxReturns;
        }
        logger.info("QueryReq: - max count: " + maxCount);
        HttpServletResponse resp = cmsReq.getHttpResp();
        CMSTemplateParams argset = this.doSearch(locale[0], filter, maxCount, direction, top, bottom);
        argset.getFixed().addStringValue("reqType", reqType);
        argset.getFixed().addStringValue("reqState", reqState);
        argset.getFixed().addIntegerValue(IN_MAXCOUNT, maxCount);
        try {
            form.getOutput(argset);
            resp.setContentType("text/html");
            form.renderOutput((OutputStream)resp.getOutputStream(), argset);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERR_STREAM_TEMPLATE", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0]), e);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
    }

    protected CMSTemplateParams doSearch(Locale l, String filter, int count, String direction, BigInteger top, BigInteger bottom) {
        CMSTemplateParams ctp = null;
        if (direction.equals("previous")) {
            ctp = this.doSearch(l, filter, -count, top);
        } else if (direction.equals("next")) {
            bottom = bottom.add(BigInteger.ONE);
            ctp = this.doSearch(l, filter, count, bottom);
        } else {
            ctp = direction.equals("begin") ? this.doSearch(l, filter, count, BigInteger.ZERO) : (direction.equals("first") ? this.doSearch(l, filter, count, bottom) : this.doSearch(l, filter, -count, BigInteger.ONE.negate()));
        }
        return ctp;
    }

    private CMSTemplateParams doSearch(Locale locale, String filter, int count, BigInteger marker) {
        CMSEngine engine = this.getCMSEngine();
        ArgBlock header = new ArgBlock();
        ArgBlock context = new ArgBlock();
        CMSTemplateParams argset = new CMSTemplateParams(header, context);
        try {
            long startTime = new Date().getTime();
            header.addStringValue(OUT_AUTHORITY_ID, this.mAuthority.getId());
            header.addStringValue(OUT_REQUESTING_USER, "admin");
            boolean jumptoend = false;
            if (marker.toString().equals("-1")) {
                marker = BigInteger.ZERO;
                jumptoend = true;
            }
            RequestId id = new RequestId(marker);
            RequestRepository requestRepository = engine.getRequestRepository();
            IRequestVirtualList list = requestRepository.getPagedRequestsByFilter(id, jumptoend, filter, count < 0 ? count - 1 : count + 1, "requestId");
            int maxCount = 0;
            maxCount = count < 0 && jumptoend ? -count : (count < 0 ? -count + 1 : count);
            int totalCount = jumptoend ? maxCount : list.getSize() - list.getCurrentIndex();
            header.addIntegerValue("totalRecordCount", totalCount);
            header.addIntegerValue(OUT_CURRENTCOUNT, list.getSize());
            Vector<Request> v = this.fetchRecords(list, maxCount);
            v = this.normalizeOrder(v);
            this.trim(v, id);
            int currentCount = 0;
            BigInteger curNum = BigInteger.ZERO;
            BigInteger firstNum = BigInteger.ONE.negate();
            Enumeration<Request> requests = v.elements();
            logger.info("QueryReq: Requests:");
            while (requests.hasMoreElements()) {
                Request request = null;
                try {
                    request = requests.nextElement();
                }
                catch (Exception e) {
                    logger.warn("Error displaying request:" + e.getMessage(), (Throwable)e);
                }
                if (request == null) {
                    logger.warn("QueryReq: Error display request on page");
                    continue;
                }
                logger.info("QueryReq: - " + request.getRequestId());
                curNum = new BigInteger(request.getRequestId().toString());
                if (firstNum.equals(BigInteger.ONE.negate())) {
                    firstNum = curNum;
                }
                ArgBlock rec = new ArgBlock();
                this.mParser.fillRequestIntoArg(locale, request, argset, rec);
                this.mQueue.releaseRequest(request);
                argset.addRepeatRecord(rec);
                ++currentCount;
            }
            long endTime = new Date().getTime();
            header.addIntegerValue(OUT_CURRENTCOUNT, currentCount);
            header.addStringValue("time", Long.toString(endTime - startTime));
            header.addBigIntegerValue(OUT_FIRST_ENTRY_ON_PAGE, firstNum, 10);
            header.addBigIntegerValue(OUT_LAST_ENTRY_ON_PAGE, curNum, 10);
        }
        catch (EBaseException e) {
            logger.warn("QueryReq: " + e.getMessage(), (Throwable)e);
            header.addStringValue(OUT_ERROR, e.toString(locale));
        }
        catch (Exception e) {
            logger.warn("QueryReq: " + e.getMessage(), (Throwable)e);
        }
        return argset;
    }

    private void trim(Vector<Request> v, RequestId marker) {
        int i = v.size() - 1;
        if (i == 0) {
            return;
        }
        if (v.elementAt(i).getRequestId().toString().equals(marker.toString())) {
            v.remove(i);
        }
    }

    private Vector<Request> fetchRecords(IRequestVirtualList list, int maxCount) {
        Vector<Request> v = new Vector<Request>();
        int count = list.getSize();
        logger.info("QueryReq: Fetching " + count + " request(s)");
        int c = 0;
        for (int i = 0; i < count; ++i) {
            Request request = list.getElementAt(i);
            if (request != null) {
                v.add(request);
                ++c;
            }
            if (c >= maxCount) break;
        }
        return v;
    }

    private Vector<Request> normalizeOrder(Vector<Request> list) {
        BigInteger firstrequestnum = new BigInteger(list.elementAt(0).getRequestId().toString());
        BigInteger lastrequestnum = new BigInteger(list.elementAt(list.size() - 1).getRequestId().toString());
        boolean reverse = false;
        if (firstrequestnum.compareTo(lastrequestnum) > 0) {
            reverse = true;
        }
        Vector<Request> v = new Vector<Request>();
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            Request request = list.elementAt(i);
            if (request == null) continue;
            if (reverse) {
                v.add(0, request);
                continue;
            }
            v.add(request);
        }
        return v;
    }
}

