/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.profile;

import com.netscape.certsrv.tps.profile.ProfileMappingClient;
import com.netscape.certsrv.tps.profile.ProfileMappingCollection;
import com.netscape.certsrv.tps.profile.ProfileMappingData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.profile.ProfileMappingCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileMappingFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ProfileMappingFindCLI.class);
    public ProfileMappingCLI profileMappingCLI;

    public ProfileMappingFindCLI(ProfileMappingCLI profileMappingCLI) {
        super("find", "Find profile mappings", (CLI)profileMappingCLI);
        this.profileMappingCLI = profileMappingCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [FILTER] [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        String filter = cmdArgs.length > 0 ? cmdArgs[0] : null;
        String s = cmd.getOptionValue("start");
        Integer start = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        ProfileMappingClient profileMappingClient = this.profileMappingCLI.getProfileMappingClient();
        ProfileMappingCollection result = profileMappingClient.findProfileMappings(filter, start, size);
        MainCLI.printMessage(result.getTotal() + " entries matched");
        if (result.getTotal() == 0) {
            return;
        }
        Collection profileMappings = result.getEntries();
        boolean first = true;
        for (ProfileMappingData profileMappingData : profileMappings) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            ProfileMappingCLI.printProfileMappingData(profileMappingData, false);
        }
        MainCLI.printMessage("Number of entries returned " + profileMappings.size());
    }
}

