/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.cert;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.util.JSONSerializer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CertDataInfo
implements JSONSerializer {
    CertId id;
    String subjectDN;
    String issuerDN;
    String status;
    String type;
    Integer version;
    String keyAlgorithmOID;
    Integer keyLength;
    Date notValidBefore;
    Date notValidAfter;
    Date issuedOn;
    String issuedBy;
    Date revokedOn;
    String revokedBy;

    public CertId getID() {
        return this.id;
    }

    public void setID(CertId id) {
        this.id = id;
    }

    @JsonProperty(value="SubjectDN")
    public String getSubjectDN() {
        return this.subjectDN;
    }

    public void setSubjectDN(String subjectDN) {
        this.subjectDN = subjectDN;
    }

    @JsonProperty(value="IssuerDN")
    public String getIssuerDN() {
        return this.issuerDN;
    }

    public void setIssuerDN(String issuerDN) {
        this.issuerDN = issuerDN;
    }

    @JsonProperty(value="Status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="Type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="Version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @JsonProperty(value="KeyAlgorithmOID")
    public String getKeyAlgorithmOID() {
        return this.keyAlgorithmOID;
    }

    public void setKeyAlgorithmOID(String keyAlgorithmOID) {
        this.keyAlgorithmOID = keyAlgorithmOID;
    }

    @JsonProperty(value="KeyLength")
    public Integer getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(Integer keyLength) {
        this.keyLength = keyLength;
    }

    @JsonProperty(value="NotValidBefore")
    public Date getNotValidBefore() {
        return this.notValidBefore;
    }

    public void setNotValidBefore(Date notValidBefore) {
        this.notValidBefore = notValidBefore;
    }

    @JsonProperty(value="NotValidAfter")
    public Date getNotValidAfter() {
        return this.notValidAfter;
    }

    public void setNotValidAfter(Date notValidAfter) {
        this.notValidAfter = notValidAfter;
    }

    @JsonProperty(value="IssuedOn")
    public Date getIssuedOn() {
        return this.issuedOn;
    }

    public void setIssuedOn(Date issuedOn) {
        this.issuedOn = issuedOn;
    }

    @JsonProperty(value="IssuedBy")
    public String getIssuedBy() {
        return this.issuedBy;
    }

    public void setIssuedBy(String issuedBy) {
        this.issuedBy = issuedBy;
    }

    @JsonProperty(value="RevokedOn")
    public Date getRevokedOn() {
        return this.revokedOn;
    }

    public void setRevokedOn(Date revokedOn) {
        this.revokedOn = revokedOn;
    }

    @JsonProperty(value="RevokedBy")
    public String getRevokedBy() {
        return this.revokedBy;
    }

    public void setRevokedBy(String revokedBy) {
        this.revokedBy = revokedBy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.issuedBy == null ? 0 : this.issuedBy.hashCode());
        result = 31 * result + (this.issuedOn == null ? 0 : this.issuedOn.hashCode());
        result = 31 * result + (this.keyAlgorithmOID == null ? 0 : this.keyAlgorithmOID.hashCode());
        result = 31 * result + (this.keyLength == null ? 0 : this.keyLength.hashCode());
        result = 31 * result + (this.notValidAfter == null ? 0 : this.notValidAfter.hashCode());
        result = 31 * result + (this.notValidBefore == null ? 0 : this.notValidBefore.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.subjectDN == null ? 0 : this.subjectDN.hashCode());
        result = 31 * result + (this.issuerDN == null ? 0 : this.issuerDN.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.revokedOn == null ? 0 : this.revokedOn.hashCode());
        result = 31 * result + (this.revokedBy == null ? 0 : this.revokedBy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertDataInfo other = (CertDataInfo)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.issuedBy == null ? other.issuedBy != null : !this.issuedBy.equals(other.issuedBy)) {
            return false;
        }
        if (this.issuedOn == null ? other.issuedOn != null : !this.issuedOn.equals(other.issuedOn)) {
            return false;
        }
        if (this.keyAlgorithmOID == null ? other.keyAlgorithmOID != null : !this.keyAlgorithmOID.equals(other.keyAlgorithmOID)) {
            return false;
        }
        if (this.keyLength == null ? other.keyLength != null : !this.keyLength.equals(other.keyLength)) {
            return false;
        }
        if (this.notValidAfter == null ? other.notValidAfter != null : !this.notValidAfter.equals(other.notValidAfter)) {
            return false;
        }
        if (this.notValidBefore == null ? other.notValidBefore != null : !this.notValidBefore.equals(other.notValidBefore)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        if (this.subjectDN == null ? other.subjectDN != null : !this.subjectDN.equals(other.subjectDN)) {
            return false;
        }
        if (this.issuerDN == null ? other.issuerDN != null : !this.issuerDN.equals(other.issuerDN)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.revokedOn == null ? other.revokedOn != null : !this.revokedOn.equals(other.revokedOn)) {
            return false;
        }
        return !(this.revokedBy == null ? other.revokedBy != null : !this.revokedBy.equals(other.revokedBy));
    }

    public Element toDOM(Document document) {
        Element infoElement = document.createElement("CertDataInfo");
        if (this.id != null) {
            infoElement.setAttribute("id", this.id.toHexString());
        }
        if (this.subjectDN != null) {
            Element subjectDNElement = document.createElement("SubjectDN");
            subjectDNElement.appendChild(document.createTextNode(this.subjectDN));
            infoElement.appendChild(subjectDNElement);
        }
        if (this.issuerDN != null) {
            Element issuerDNElement = document.createElement("IssuerDN");
            issuerDNElement.appendChild(document.createTextNode(this.issuerDN));
            infoElement.appendChild(issuerDNElement);
        }
        if (this.status != null) {
            Element statusElement = document.createElement("Status");
            statusElement.appendChild(document.createTextNode(this.status));
            infoElement.appendChild(statusElement);
        }
        if (this.type != null) {
            Element typeElement = document.createElement("Type");
            typeElement.appendChild(document.createTextNode(this.type));
            infoElement.appendChild(typeElement);
        }
        if (this.version != null) {
            Element versionElement = document.createElement("Version");
            versionElement.appendChild(document.createTextNode(Integer.toString(this.version)));
            infoElement.appendChild(versionElement);
        }
        if (this.keyAlgorithmOID != null) {
            Element keyAlgorithmOIDElement = document.createElement("KeyAlgorithmOID");
            keyAlgorithmOIDElement.appendChild(document.createTextNode(this.keyAlgorithmOID));
            infoElement.appendChild(keyAlgorithmOIDElement);
        }
        if (this.keyLength != null) {
            Element keyLengthElement = document.createElement("KeyLength");
            keyLengthElement.appendChild(document.createTextNode(Integer.toString(this.keyLength)));
            infoElement.appendChild(keyLengthElement);
        }
        if (this.notValidBefore != null) {
            Element notValidBeforeElement = document.createElement("NotValidBefore");
            notValidBeforeElement.appendChild(document.createTextNode(Long.toString(this.notValidBefore.getTime())));
            infoElement.appendChild(notValidBeforeElement);
        }
        if (this.notValidAfter != null) {
            Element notValidAfterElement = document.createElement("NotValidAfter");
            notValidAfterElement.appendChild(document.createTextNode(Long.toString(this.notValidAfter.getTime())));
            infoElement.appendChild(notValidAfterElement);
        }
        if (this.issuedOn != null) {
            Element issuedOnElement = document.createElement("IssuedOn");
            issuedOnElement.appendChild(document.createTextNode(Long.toString(this.issuedOn.getTime())));
            infoElement.appendChild(issuedOnElement);
        }
        if (this.issuedBy != null) {
            Element issuedByElement = document.createElement("IssuedBy");
            issuedByElement.appendChild(document.createTextNode(this.issuedBy));
            infoElement.appendChild(issuedByElement);
        }
        if (this.revokedOn != null) {
            Element revokedOnElement = document.createElement("RevokedOn");
            revokedOnElement.appendChild(document.createTextNode(Long.toString(this.revokedOn.getTime())));
            infoElement.appendChild(revokedOnElement);
        }
        if (this.revokedBy != null) {
            Element revokedByElement = document.createElement("RevokedBy");
            revokedByElement.appendChild(document.createTextNode(this.revokedBy));
            infoElement.appendChild(revokedByElement);
        }
        return infoElement;
    }

    public static CertDataInfo fromDOM(Element infoElement) {
        NodeList revokedByList;
        NodeList revokedOnList;
        NodeList issuedByList;
        NodeList issuedOnList;
        NodeList notValidAfterList;
        NodeList notValidBeforeList;
        NodeList keyLengthList;
        NodeList keyAlgorithmOIDList;
        NodeList versionList;
        NodeList typeList;
        NodeList statusList;
        NodeList issuerDNList;
        CertDataInfo info = new CertDataInfo();
        String id = infoElement.getAttribute("id");
        info.setID(StringUtils.isEmpty((CharSequence)id) ? null : new CertId(id));
        NodeList subjectDNList = infoElement.getElementsByTagName("SubjectDN");
        if (subjectDNList.getLength() > 0) {
            String value = subjectDNList.item(0).getTextContent();
            info.setSubjectDN(value);
        }
        if ((issuerDNList = infoElement.getElementsByTagName("IssuerDN")).getLength() > 0) {
            String value = issuerDNList.item(0).getTextContent();
            info.setIssuerDN(value);
        }
        if ((statusList = infoElement.getElementsByTagName("Status")).getLength() > 0) {
            String value = statusList.item(0).getTextContent();
            info.setStatus(value);
        }
        if ((typeList = infoElement.getElementsByTagName("Type")).getLength() > 0) {
            String value = typeList.item(0).getTextContent();
            info.setType(value);
        }
        if ((versionList = infoElement.getElementsByTagName("Version")).getLength() > 0) {
            String value = versionList.item(0).getTextContent();
            info.setVersion(Integer.parseInt(value));
        }
        if ((keyAlgorithmOIDList = infoElement.getElementsByTagName("KeyAlgorithmOID")).getLength() > 0) {
            String value = keyAlgorithmOIDList.item(0).getTextContent();
            info.setKeyAlgorithmOID(value);
        }
        if ((keyLengthList = infoElement.getElementsByTagName("KeyLength")).getLength() > 0) {
            String value = keyLengthList.item(0).getTextContent();
            info.setKeyLength(Integer.parseInt(value));
        }
        if ((notValidBeforeList = infoElement.getElementsByTagName("NotValidBefore")).getLength() > 0) {
            String value = notValidBeforeList.item(0).getTextContent();
            info.setNotValidBefore(new Date(Long.parseLong(value)));
        }
        if ((notValidAfterList = infoElement.getElementsByTagName("NotValidAfter")).getLength() > 0) {
            String value = notValidAfterList.item(0).getTextContent();
            info.setNotValidAfter(new Date(Long.parseLong(value)));
        }
        if ((issuedOnList = infoElement.getElementsByTagName("IssuedOn")).getLength() > 0) {
            String value = issuedOnList.item(0).getTextContent();
            info.setIssuedOn(new Date(Long.parseLong(value)));
        }
        if ((issuedByList = infoElement.getElementsByTagName("IssuedBy")).getLength() > 0) {
            String value = issuedByList.item(0).getTextContent();
            info.setIssuedBy(value);
        }
        if ((revokedOnList = infoElement.getElementsByTagName("RevokedOn")).getLength() > 0) {
            String value = revokedOnList.item(0).getTextContent();
            info.setRevokedOn(new Date(Long.parseLong(value)));
        }
        if ((revokedByList = infoElement.getElementsByTagName("RevokedBy")).getLength() > 0) {
            String value = revokedByList.item(0).getTextContent();
            info.setRevokedBy(value);
        }
        return info;
    }

    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element infoElement = this.toDOM(document);
        document.appendChild(infoElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static CertDataInfo fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element infoElement = document.getDocumentElement();
        return CertDataInfo.fromDOM(infoElement);
    }
}

