/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;

public class LDAPSortKey
implements Serializable {
    static final long serialVersionUID = -7044232342344864405L;
    public static final int REVERSE = 129;
    private String m_key;
    private boolean m_reverse;
    private String m_matchRule;

    public LDAPSortKey(String keyDescription) {
        if (keyDescription != null && keyDescription.length() > 0) {
            if (keyDescription.charAt(0) == '-') {
                this.m_reverse = true;
                this.m_key = keyDescription.substring(1);
            } else {
                this.m_reverse = false;
                this.m_key = keyDescription;
            }
            int colonIndex = this.m_key.indexOf(58);
            if (colonIndex == 0) {
                this.m_key = null;
            } else if (colonIndex > 0) {
                this.m_matchRule = this.m_key.substring(colonIndex + 1);
                this.m_key = this.m_key.substring(0, colonIndex);
            }
        }
    }

    public LDAPSortKey(String key, boolean reverse) {
        this.m_key = key;
        this.m_reverse = reverse;
        this.m_matchRule = null;
    }

    public LDAPSortKey(String key, boolean reverse, String matchRule) {
        this.m_key = key;
        this.m_reverse = reverse;
        this.m_matchRule = matchRule;
    }

    public String getKey() {
        return this.m_key;
    }

    public boolean getReverse() {
        return this.m_reverse;
    }

    public String getMatchRule() {
        return this.m_matchRule;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{SortKey:");
        sb.append(" key=");
        sb.append(this.m_key);
        sb.append(" reverse=");
        sb.append(this.m_reverse);
        if (this.m_matchRule != null) {
            sb.append(" matchRule=");
            sb.append(this.m_matchRule);
        }
        sb.append("}");
        return sb.toString();
    }
}

