/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class ExtendedFailInfo
implements ASN1Value {
    private OBJECT_IDENTIFIER failInfoOID;
    private ANY failInfoValue;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    @Override
    public Tag getTag() {
        return TAG;
    }

    public ExtendedFailInfo(OBJECT_IDENTIFIER failInfoOID, ASN1Value failInfoValue) {
        this.failInfoOID = failInfoOID;
        if (failInfoValue instanceof ANY) {
            this.failInfoValue = (ANY)failInfoValue;
        } else {
            byte[] encoded = ASN1Util.encode(failInfoValue);
            try {
                this.failInfoValue = (ANY)ASN1Util.decode(ANY.getTemplate(), encoded);
            }
            catch (InvalidBERException e) {
                throw new RuntimeException("InvalidBERException while decoding as ANY: " + e.getMessage(), e);
            }
        }
    }

    public OBJECT_IDENTIFIER getOID() {
        return this.failInfoOID;
    }

    public ANY getValue() {
        return this.failInfoValue;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement(this.failInfoOID);
        seq.addElement(this.failInfoValue);
        seq.encode(implicit, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addElement(new OBJECT_IDENTIFIER.Template());
            seqt.addElement(new ANY.Template());
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicit, istream);
            assert (seq.size() == 2);
            return new ExtendedFailInfo((OBJECT_IDENTIFIER)seq.elementAt(0), seq.elementAt(1));
        }
    }
}

