var __extends =
  (this && this.__extends) ||
  (function () {
    var extendStatics = function (d, b) {
      extendStatics =
        Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array &&
          function (d, b) {
            d.__proto__ = b;
          }) ||
        function (d, b) {
          for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
        };
      return extendStatics(d, b);
    };
    return function (d, b) {
      if (typeof b !== 'function' && b !== null)
        throw new TypeError('Class extends value ' + String(b) + ' is not a constructor or null');
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : ((__.prototype = b.prototype), new __());
    };
  })();
var __assign =
  (this && this.__assign) ||
  function () {
    __assign =
      Object.assign ||
      function (t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
      };
    return __assign.apply(this, arguments);
  };
import { getCurrentTimestamp } from '../utils';
import { BaseTransport } from './base';
import { initializeTransports } from './initialize';
import { TransportItemType } from './types';
var MockTransport = /** @class */ (function (_super) {
  __extends(MockTransport, _super);
  function MockTransport() {
    var _this = (_super !== null && _super.apply(this, arguments)) || this;
    _this.sentItems = [];
    return _this;
  }
  MockTransport.prototype.send = function (item) {
    this.sentItems.push(item);
  };
  return MockTransport;
})(BaseTransport);
describe('transports', function () {
  describe('config.ignoreErrors', function () {
    it('will filter out errors by string or regex', function () {
      var _a;
      var transport = new MockTransport();
      var config = {
        transports: [transport],
        ignoreErrors: ['Error: ResizeObserver', /FetchError[:\s\w\/]*pwc/],
      };
      var transports = initializeTransports(config);
      transports.execute(makeExceptionTransportItem('Error', 'ResizeObserver loop limit exceeded'));
      transports.execute(makeExceptionTransportItem('TypeError', '_.viz is undefined'));
      transports.execute(
        makeExceptionTransportItem(
          'FetchError',
          '404 \n  Instantiating https://pwc.grafana.net/public/react-router-dom'
        )
      );
      transports.execute(
        makeExceptionTransportItem('FetchError', '404 \n  Instantiating https://pwc.grafana.net/public/@emotion/css')
      );
      expect(transport.sentItems).toHaveLength(1);
      expect(((_a = transport.sentItems[0]) === null || _a === void 0 ? void 0 : _a.payload).type).toEqual('TypeError');
    });
  });
  describe('config.beforeSend', function () {
    it('will not send events that are rejected by beforeSend hook', function () {
      var _a;
      var transport = new MockTransport();
      var hookedItems = [];
      var config = {
        transports: [transport],
        beforeSend: function (item) {
          hookedItems.push(item);
          if (item.type === TransportItemType.EXCEPTION && item.payload.type === 'TypeError') {
            return null;
          }
          return item;
        },
      };
      var transports = initializeTransports(config);
      transports.execute(makeExceptionTransportItem('Error', 'ResizeObserver loop limit exceeded'));
      transports.execute(makeExceptionTransportItem('TypeError', '_.viz is undefined'));
      expect(transport.sentItems).toHaveLength(1);
      expect(hookedItems).toHaveLength(2);
      expect(((_a = transport.sentItems[0]) === null || _a === void 0 ? void 0 : _a.payload).type).toEqual('Error');
    });
    it('events can be modified by beforeSend hook', function () {
      var _a;
      var transport = new MockTransport();
      var config = {
        transports: [transport],
        beforeSend: function (item) {
          if (item.type === TransportItemType.EXCEPTION) {
            return __assign(__assign({}, item), { payload: __assign(__assign({}, item.payload), { type: 'NewType' }) });
          }
          return item;
        },
      };
      var transports = initializeTransports(config);
      transports.execute(makeExceptionTransportItem('Error', 'ResizeObserver loop limit exceeded'));
      expect(transport.sentItems).toHaveLength(1);
      expect(((_a = transport.sentItems[0]) === null || _a === void 0 ? void 0 : _a.payload).type).toEqual('NewType');
    });
  });
});
function makeExceptionTransportItem(type, value) {
  return {
    type: TransportItemType.EXCEPTION,
    payload: {
      type: type,
      value: value,
      timestamp: getCurrentTimestamp(),
      stacktrace: {
        frames: [],
      },
    },
    meta: {},
  };
}
//# sourceMappingURL=transports.test.js.map
