/*
 * Decompiled with CFR 0.152.
 */
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class ClassGraph {
    private static Map classnames = new HashMap();
    private static String apiDocRoot;
    private static Map apiDocMap;
    private static final String DEFAULT_EXTERNAL_APIDOC = "http://java.sun.com/j2se/1.4.2/docs/api/";
    private static final char FILE_SEPARATOR = '/';
    private Options opt;
    private Set specifiedPackages = new HashSet();

    public ClassGraph(PackageDoc[] packageDocArray, String string, String string2) throws IOException {
        for (int i = 0; i < packageDocArray.length; ++i) {
            this.specifiedPackages.add(packageDocArray[i].name());
        }
        apiDocRoot = this.fixApiDocRoot(string);
        if (string2 != null) {
            FileInputStream fileInputStream = new FileInputStream(string2);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                try {
                    Pattern pattern = Pattern.compile((String)entry.getKey());
                    String string3 = (String)entry.getValue();
                    if (string3 != null) {
                        string3 = this.fixApiDocRoot(string3);
                        apiDocMap.put(pattern, string3);
                        continue;
                    }
                    System.err.println("No URL for pattern " + entry.getKey());
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    System.err.println("Skipping bad pattern " + entry.getKey());
                }
            }
        } else {
            apiDocMap.put(Pattern.compile(".*"), DEFAULT_EXTERNAL_APIDOC);
        }
    }

    private String fixApiDocRoot(String string) {
        String string2 = null;
        if (string != null && (string2 = string.trim()).length() > 0) {
            if (!File.separator.equals("/")) {
                string2 = string2.replace(File.separator.charAt(0), '/');
            }
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
        }
        return string2;
    }

    private String qualifiedName(String string) {
        int n;
        if (!this.opt.showQualified && (n = string.lastIndexOf(46)) != -1) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    private String guillemize(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        block4: for (int i = 0; i < stringBuffer.length(); ++i) {
            switch (stringBuffer.charAt(i)) {
                case '<': {
                    stringBuffer.setCharAt(i, this.opt.guilOpen);
                    continue block4;
                }
                case '>': {
                    stringBuffer.setCharAt(i, this.opt.guilClose);
                }
            }
        }
        return stringBuffer.toString();
    }

    private String guilWrap(String string) {
        return this.opt.guilOpen + string + this.opt.guilClose;
    }

    private void visibility(ProgramElementDoc programElementDoc) {
        this.opt.w.print(this.stereotype((Doc)programElementDoc, 'l'));
        if (!this.opt.showVisibility) {
            return;
        }
        if (programElementDoc.isPrivate()) {
            this.opt.w.print('-');
        }
        if (programElementDoc.isPublic()) {
            this.opt.w.print('+');
        }
        if (programElementDoc.isProtected()) {
            this.opt.w.print('#');
        }
        this.opt.w.print(' ');
    }

    private void parameter(Parameter[] parameterArray) {
        for (int i = 0; i < parameterArray.length; ++i) {
            this.opt.w.print(parameterArray[i].name());
            this.type(parameterArray[i].type());
            if (i + 1 >= parameterArray.length) continue;
            this.opt.w.print(", ");
        }
    }

    private void type(Type type) {
        if (type.typeName().equals("void")) {
            return;
        }
        this.opt.w.print(" : ");
        if (this.opt.showQualified) {
            this.opt.w.print(type.qualifiedTypeName());
        } else {
            this.opt.w.print(type.typeName());
        }
        this.opt.w.print(type.dimension());
    }

    private void attributes(FieldDoc[] fieldDocArray) {
        for (int i = 0; i < fieldDocArray.length; ++i) {
            if (this.hidden((Doc)fieldDocArray[i])) continue;
            this.visibility((ProgramElementDoc)fieldDocArray[i]);
            this.opt.w.print(fieldDocArray[i].name());
            if (this.opt.showType) {
                this.type(fieldDocArray[i].type());
            }
            this.opt.w.print("\\l");
            this.opt.w.print(ClassGraph.tagvalue((Doc)fieldDocArray[i], "", 'r'));
        }
    }

    private void operations(ConstructorDoc[] constructorDocArray) {
        for (int i = 0; i < constructorDocArray.length; ++i) {
            if (this.hidden((Doc)constructorDocArray[i])) continue;
            this.visibility((ProgramElementDoc)constructorDocArray[i]);
            this.opt.w.print(constructorDocArray[i].name());
            if (this.opt.showType) {
                this.opt.w.print("(");
                this.parameter(constructorDocArray[i].parameters());
                this.opt.w.print(")");
            } else {
                this.opt.w.print("()");
            }
            this.opt.w.print("\\l");
            this.opt.w.print(ClassGraph.tagvalue((Doc)constructorDocArray[i], "", 'r'));
        }
    }

    private void operations(MethodDoc[] methodDocArray) {
        for (int i = 0; i < methodDocArray.length; ++i) {
            if (this.hidden((Doc)methodDocArray[i])) continue;
            this.visibility((ProgramElementDoc)methodDocArray[i]);
            this.opt.w.print(methodDocArray[i].name());
            if (this.opt.showType) {
                this.opt.w.print("(");
                this.parameter(methodDocArray[i].parameters());
                this.opt.w.print(")");
                this.type(methodDocArray[i].returnType());
            } else {
                this.opt.w.print("()");
            }
            this.opt.w.print("\\l");
            this.opt.w.print(ClassGraph.tagvalue((Doc)methodDocArray[i], "", 'r'));
        }
    }

    private void nodeProperties(String string) {
        if (this.opt.nodeFillColor != null) {
            this.opt.w.print(", style=filled, fillcolor=\"" + this.opt.nodeFillColor + "\"");
        }
        this.opt.w.print(", fontcolor=\"" + this.opt.nodeFontColor + "\"");
        this.opt.w.print(", fontsize=" + this.opt.nodeFontSize);
        String string2 = this.classToUrl(string);
        if (string2 != null) {
            this.opt.w.print(", URL=\"" + string2 + "\"");
        }
        this.opt.w.println("];");
    }

    private static String tagvalue(Doc doc, String string, char c) {
        Tag[] tagArray = doc.tags("tagvalue");
        String string2 = tagArray.length > 0 ? string : "";
        for (int i = 0; i < tagArray.length; ++i) {
            String[] stringArray = StringUtil.tokenize(tagArray[i].text());
            if (stringArray.length != 2) {
                System.err.println("@tagvalue expects two fields: " + tagArray[i].text());
                return "";
            }
            string2 = string2 + "\\{" + stringArray[0] + " = " + stringArray[1] + "\\}\\" + c;
        }
        return string2;
    }

    private String stereotype(Doc doc, char c) {
        String string = "";
        Tag[] tagArray = doc.tags("stereotype");
        for (int i = 0; i < tagArray.length; ++i) {
            String[] stringArray = StringUtil.tokenize(tagArray[i].text());
            if (stringArray.length != 1) {
                System.err.println("@stereotype expects one field: " + tagArray[i].text());
                return "";
            }
            string = string + this.guilWrap(stringArray[0]) + " \\" + c;
        }
        return string;
    }

    private boolean hidden(Doc doc) {
        Tag[] tagArray = doc.tags("hidden");
        if (tagArray.length > 0) {
            return true;
        }
        return this.opt.matchesHideExpression(doc.toString());
    }

    private static String name(String string) {
        ClassInfo classInfo = (ClassInfo)classnames.get(string);
        if (classInfo == null) {
            classInfo = new ClassInfo(false);
            classnames.put(string, classInfo);
        }
        return classInfo.name;
    }

    private String name(ClassDoc classDoc) {
        boolean bl;
        ClassInfo classInfo = (ClassInfo)classnames.get(classDoc.toString());
        if (classInfo != null) {
            bl = !classInfo.nodePrinted;
        } else {
            bl = true;
            classInfo = new ClassInfo(true);
            classnames.put(classDoc.toString(), classInfo);
        }
        if (bl && !this.hidden((Doc)classDoc)) {
            String string = classDoc.toString();
            this.opt.w.println("\t// " + string);
            this.opt.w.print("\t" + classInfo.name + " [");
            string = this.stereotype((Doc)classDoc, 'n') + this.qualifiedName(string);
            if (classDoc.isInterface()) {
                string = this.guilWrap("interface") + " \\n" + string;
            }
            boolean bl2 = this.opt.showAttributes && classDoc.fields().length > 0 || this.opt.showOperations && classDoc.methods().length > 0 || this.opt.showConstructors && classDoc.constructors().length > 0;
            string = string + ClassGraph.tagvalue((Doc)classDoc, "\\n", 'r');
            if (bl2) {
                this.opt.w.print("label=\"{" + string + "\\n|");
            } else {
                this.opt.w.print("label=\"" + string + "\"");
            }
            if (this.opt.showAttributes) {
                this.attributes(classDoc.fields());
            }
            if (bl2) {
                this.opt.w.print("|");
            }
            if (this.opt.showConstructors) {
                this.operations(classDoc.constructors());
            }
            if (this.opt.showOperations) {
                this.operations(classDoc.methods());
            }
            if (bl2) {
                this.opt.w.print("}\"");
            }
            this.opt.w.print(", fontname=\"" + (classDoc.isAbstract() ? this.opt.nodeFontAbstractName : this.opt.nodeFontName) + "\"");
            this.nodeProperties(classDoc.qualifiedName());
            classInfo.nodePrinted = true;
        }
        return classInfo.name;
    }

    private void relation(String string, Doc doc, String string2, String string3) {
        Tag[] tagArray = doc.tags(string);
        for (int i = 0; i < tagArray.length; ++i) {
            String[] stringArray = StringUtil.tokenize(tagArray[i].text());
            if (stringArray.length != 4) {
                System.err.println("Expected four fields: " + tagArray[i].text());
            }
            this.opt.w.println("\t// " + doc + " " + string + " " + stringArray[3]);
            this.opt.w.println("\t" + string2 + " -> " + ClassGraph.name(stringArray[3]) + " [" + "taillabel=\"" + stringArray[0] + "\", " + "label=\"" + this.guillemize(stringArray[1]) + "\", " + "headlabel=\"" + stringArray[2] + "\", " + "fontname=\"" + this.opt.edgeFontName + "\", " + "fontcolor=\"" + this.opt.edgeFontColor + "\", " + "fontsize=" + this.opt.edgeFontSize + ", " + "color=\"" + this.opt.edgeColor + "\", " + string3 + "];");
        }
    }

    public void print(Options options, ClassDoc classDoc) {
        this.opt = (Options)options.clone();
        this.opt.setOptions(classDoc);
        String string = this.name(classDoc);
        ClassDoc classDoc2 = classDoc.superclass();
        if (!(classDoc2 == null || classDoc2.toString().equals("java.lang.Object") || this.opt.matchesHideExpression(classDoc.toString()) || this.opt.matchesHideExpression(classDoc2.toString()) || this.hidden((Doc)classDoc) || this.hidden((Doc)classDoc2))) {
            this.opt.w.println("\t//" + classDoc + " extends " + classDoc2);
            this.opt.w.println("\t" + this.name(classDoc2) + " -> " + string + " [dir=back,arrowtail=empty];");
        }
        Tag[] tagArray = classDoc.tags("extends");
        for (int i = 0; i < tagArray.length; ++i) {
            if (this.opt.matchesHideExpression(classDoc.toString()) || this.opt.matchesHideExpression(tagArray[i].text())) continue;
            this.opt.w.println("\t//" + classDoc + " extends " + tagArray[i].text());
            this.opt.w.println("\t" + ClassGraph.name(tagArray[i].text()) + " -> " + string + " [dir=back,arrowtail=empty];");
        }
        ClassDoc[] classDocArray = classDoc.interfaces();
        for (int i = 0; i < classDocArray.length; ++i) {
            if (this.opt.matchesHideExpression(classDoc.toString()) || this.opt.matchesHideExpression(classDocArray[i].toString()) || this.hidden((Doc)classDoc) || this.hidden((Doc)classDocArray[i])) continue;
            this.opt.w.print("\t" + this.name(classDocArray[i]) + " -> " + string + " [dir=back,arrowtail=empty,style=dashed];");
            this.opt.w.println("\t//" + classDoc + " implements " + classDocArray[i]);
        }
        this.relation("assoc", (Doc)classDoc, string, "arrowhead=none");
        this.relation("navassoc", (Doc)classDoc, string, "arrowhead=open");
        this.relation("has", (Doc)classDoc, string, "arrowhead=none, arrowtail=ediamond");
        this.relation("composed", (Doc)classDoc, string, "arrowhead=none, arrowtail=diamond");
        this.relation("depend", (Doc)classDoc, string, "arrowhead=open, style=dashed");
    }

    public void printExtraClasses() {
        Set set = classnames.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ClassInfo classInfo = (ClassInfo)entry.getValue();
            if (classInfo.nodePrinted) continue;
            String string = entry.getKey().toString();
            this.opt.w.println("\t// " + string);
            this.opt.w.print("\t" + classInfo.name + "[label=\"" + this.qualifiedName(string) + "\"");
            this.opt.w.print(", fontname=\"" + this.opt.nodeFontName + "\"");
            this.nodeProperties(entry.getKey().toString());
        }
    }

    public boolean isSpecifiedPackage(String string) {
        int n = string.lastIndexOf(".");
        String string2 = n > 0 ? string.substring(0, n) : string;
        return this.specifiedPackages.contains(string2);
    }

    public String classToUrl(String string) {
        String string2 = null;
        String string3 = this.mapApiDocRoot(string);
        if (string3 != null) {
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append(string.replace('.', '/'));
            stringBuffer.append(".html");
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private String mapApiDocRoot(String string) {
        String string2 = null;
        string2 = this.specifiedPackages.isEmpty() || this.isSpecifiedPackage(string) ? apiDocRoot : this.getExternalApiDocRoot(string);
        return string2;
    }

    public String getExternalApiDocRoot(String string) {
        Iterator iterator = apiDocMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Pattern pattern = (Pattern)entry.getKey();
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    static {
        apiDocMap = new HashMap();
    }
}

