/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.AttributeEnum;
import com.netscape.jndi.ldap.AttributeIDEnum;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPModificationSet;

class AttributesImpl
implements Attributes {
    LDAPAttributeSet m_attrSet;
    static String[] m_binaryAttrs = new String[]{"photo", "userpassword", "jpegphoto", "audio", "thumbnailphoto", "thumbnaillogo", "usercertificate", "cacertificate", "certificaterevocationlist", "authorityrevocationlist", "crosscertificatepair", "personalsignature", "x500uniqueidentifier", "javaserializeddata"};
    static String[] m_userBinaryAttrs = null;

    public AttributesImpl(LDAPAttributeSet attrSet, String[] userBinaryAttrs) {
        this.m_attrSet = attrSet;
        m_userBinaryAttrs = userBinaryAttrs;
    }

    @Override
    public Object clone() {
        return new AttributesImpl((LDAPAttributeSet)this.m_attrSet.clone(), m_userBinaryAttrs);
    }

    @Override
    public Attribute get(String attrID) {
        LDAPAttribute attr = this.m_attrSet.getAttribute(attrID);
        return attr == null ? null : AttributesImpl.ldapAttrToJndiAttr(attr);
    }

    public NamingEnumeration<Attribute> getAll() {
        return new AttributeEnum(this.m_attrSet.getAttributes());
    }

    @Override
    public NamingEnumeration<String> getIDs() {
        return new AttributeIDEnum(this.m_attrSet.getAttributes());
    }

    @Override
    public boolean isCaseIgnored() {
        return false;
    }

    @Override
    public Attribute put(String attrID, Object val) {
        LDAPAttribute attr = this.m_attrSet.getAttribute(attrID);
        if (val == null) {
            this.m_attrSet.add(new LDAPAttribute(attrID));
        } else if (val instanceof byte[]) {
            this.m_attrSet.add(new LDAPAttribute(attrID, (byte[])val));
        } else {
            this.m_attrSet.add(new LDAPAttribute(attrID, val.toString()));
        }
        return attr == null ? null : AttributesImpl.ldapAttrToJndiAttr(attr);
    }

    @Override
    public Attribute put(Attribute jndiAttr) {
        try {
            LDAPAttribute oldAttr = this.m_attrSet.getAttribute(jndiAttr.getID());
            this.m_attrSet.add(AttributesImpl.jndiAttrToLdapAttr(jndiAttr));
            return oldAttr == null ? null : AttributesImpl.ldapAttrToJndiAttr(oldAttr);
        }
        catch (NamingException e) {
            System.err.println("Error in AttributesImpl.put(): " + e.toString());
            e.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public Attribute remove(String attrID) {
        Attribute attr = this.get(attrID);
        this.m_attrSet.remove(attrID);
        return attr;
    }

    @Override
    public int size() {
        return this.m_attrSet.size();
    }

    static boolean isBinaryAttribute(String attrID) {
        int i;
        if (attrID.indexOf(";binary") >= 0) {
            return true;
        }
        attrID = attrID.toLowerCase();
        for (i = 0; i < m_binaryAttrs.length; ++i) {
            if (!m_binaryAttrs[i].equals(attrID)) continue;
            return true;
        }
        for (i = 0; m_userBinaryAttrs != null && i < m_userBinaryAttrs.length; ++i) {
            if (!m_userBinaryAttrs[i].equals(attrID)) continue;
            return true;
        }
        return false;
    }

    static LDAPAttributeSet jndiAttrsToLdapAttrSet(Attributes jndiAttrs) throws NamingException {
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        NamingEnumeration<? extends Attribute> itr = jndiAttrs.getAll();
        while (itr.hasMoreElements()) {
            attrs.add(AttributesImpl.jndiAttrToLdapAttr((Attribute)itr.nextElement()));
        }
        return attrs;
    }

    static LDAPAttribute jndiAttrToLdapAttr(Attribute jndiAttr) throws NamingException {
        LDAPAttribute attr = new LDAPAttribute(jndiAttr.getID());
        NamingEnumeration<?> vals = jndiAttr.getAll();
        while (vals.hasMoreElements()) {
            Object val = vals.nextElement();
            if (val == null) continue;
            if (val instanceof byte[]) {
                attr.addValue((byte[])val);
                continue;
            }
            attr.addValue(val.toString());
        }
        return attr;
    }

    static Attribute ldapAttrToJndiAttr(LDAPAttribute attr) {
        BasicAttribute jndiAttr = new BasicAttribute(attr.getName());
        Enumeration itrVals = null;
        itrVals = AttributesImpl.isBinaryAttribute(attr.getName()) ? attr.getByteValues() : attr.getStringValues();
        if (attr.size() < 50) {
            if (itrVals != null) {
                while (itrVals.hasMoreElements()) {
                    jndiAttr.add(itrVals.nextElement());
                }
            }
        } else {
            TreeSet<Object> valSet = new TreeSet<Object>();
            if (itrVals != null) {
                while (itrVals.hasMoreElements()) {
                    valSet.add(itrVals.nextElement());
                }
            }
            class BigAttribute
            extends BasicAttribute {
                public BigAttribute(String id, TreeSet<Object> val) {
                    super(id);
                    this.values = new Vector<Object>(val);
                }
            }
            jndiAttr = new BigAttribute(attr.getName(), valSet);
        }
        return jndiAttr;
    }

    static LDAPModificationSet jndiModsToLdapModSet(ModificationItem[] jndiMods) throws NamingException {
        LDAPModificationSet mods = new LDAPModificationSet();
        for (int i = 0; i < jndiMods.length; ++i) {
            int modop = jndiMods[i].getModificationOp();
            LDAPAttribute attr = AttributesImpl.jndiAttrToLdapAttr(jndiMods[i].getAttribute());
            if (modop == 1) {
                mods.add(0, attr);
                continue;
            }
            if (modop == 2) {
                mods.add(2, attr);
                continue;
            }
            if (modop != 3) continue;
            mods.add(1, attr);
        }
        return mods;
    }

    static LDAPModificationSet jndiAttrsToLdapModSet(int modop, Attributes jndiAttrs) throws NamingException {
        LDAPModificationSet mods = new LDAPModificationSet();
        NamingEnumeration<? extends Attribute> attrEnum = jndiAttrs.getAll();
        while (attrEnum.hasMore()) {
            LDAPAttribute attr = AttributesImpl.jndiAttrToLdapAttr(attrEnum.next());
            if (modop == 1) {
                mods.add(0, attr);
                continue;
            }
            if (modop == 2) {
                mods.add(2, attr);
                continue;
            }
            if (modop == 3) {
                mods.add(1, attr);
                continue;
            }
            throw new IllegalArgumentException("Illegal Attribute Modification Operation");
        }
        return mods;
    }
}

