/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the Task type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &Task{}

// Task Base serializer for use with :class:`pulpcore.app.models.Model`  This ensures that all Serializers provide values for the 'pulp_href` field.  The class provides a default for the ``ref_name`` attribute in the ModelSerializers's ``Meta`` class. This ensures that the OpenAPI definitions of plugins are namespaced properly.
type Task struct {
	// The name of task.
	Name string `json:"name"`
	// The logging correlation id associated with this task
	LoggingCid string `json:"logging_cid"`
	AdditionalProperties map[string]interface{}
}

type _Task Task

// NewTask instantiates a new Task object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTask(name string, loggingCid string) *Task {
	this := Task{}
	this.Name = name
	this.LoggingCid = loggingCid
	return &this
}

// NewTaskWithDefaults instantiates a new Task object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTaskWithDefaults() *Task {
	this := Task{}
	return &this
}

// GetName returns the Name field value
func (o *Task) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *Task) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *Task) SetName(v string) {
	o.Name = v
}

// GetLoggingCid returns the LoggingCid field value
func (o *Task) GetLoggingCid() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.LoggingCid
}

// GetLoggingCidOk returns a tuple with the LoggingCid field value
// and a boolean to check if the value has been set.
func (o *Task) GetLoggingCidOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.LoggingCid, true
}

// SetLoggingCid sets field value
func (o *Task) SetLoggingCid(v string) {
	o.LoggingCid = v
}

func (o Task) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o Task) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["name"] = o.Name
	toSerialize["logging_cid"] = o.LoggingCid

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *Task) UnmarshalJSON(bytes []byte) (err error) {
	varTask := _Task{}

	if err = json.Unmarshal(bytes, &varTask); err == nil {
		*o = Task(varTask)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "logging_cid")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableTask struct {
	value *Task
	isSet bool
}

func (v NullableTask) Get() *Task {
	return v.value
}

func (v *NullableTask) Set(val *Task) {
	v.value = val
	v.isSet = true
}

func (v NullableTask) IsSet() bool {
	return v.isSet
}

func (v *NullableTask) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTask(val *Task) *NullableTask {
	return &NullableTask{value: val, isSet: true}
}

func (v NullableTask) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTask) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


