/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the RemoveSignatures type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RemoveSignatures{}

// RemoveSignatures A serializer for parsing and validating data associated with the signatures removal.
type RemoveSignatures struct {
	// key_id of the key the signatures were produced with
	SignedWithKeyId string `json:"signed_with_key_id"`
	AdditionalProperties map[string]interface{}
}

type _RemoveSignatures RemoveSignatures

// NewRemoveSignatures instantiates a new RemoveSignatures object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRemoveSignatures(signedWithKeyId string) *RemoveSignatures {
	this := RemoveSignatures{}
	this.SignedWithKeyId = signedWithKeyId
	return &this
}

// NewRemoveSignaturesWithDefaults instantiates a new RemoveSignatures object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRemoveSignaturesWithDefaults() *RemoveSignatures {
	this := RemoveSignatures{}
	return &this
}

// GetSignedWithKeyId returns the SignedWithKeyId field value
func (o *RemoveSignatures) GetSignedWithKeyId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.SignedWithKeyId
}

// GetSignedWithKeyIdOk returns a tuple with the SignedWithKeyId field value
// and a boolean to check if the value has been set.
func (o *RemoveSignatures) GetSignedWithKeyIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.SignedWithKeyId, true
}

// SetSignedWithKeyId sets field value
func (o *RemoveSignatures) SetSignedWithKeyId(v string) {
	o.SignedWithKeyId = v
}

func (o RemoveSignatures) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RemoveSignatures) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["signed_with_key_id"] = o.SignedWithKeyId

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RemoveSignatures) UnmarshalJSON(bytes []byte) (err error) {
	varRemoveSignatures := _RemoveSignatures{}

	if err = json.Unmarshal(bytes, &varRemoveSignatures); err == nil {
		*o = RemoveSignatures(varRemoveSignatures)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "signed_with_key_id")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRemoveSignatures struct {
	value *RemoveSignatures
	isSet bool
}

func (v NullableRemoveSignatures) Get() *RemoveSignatures {
	return v.value
}

func (v *NullableRemoveSignatures) Set(val *RemoveSignatures) {
	v.value = val
	v.isSet = true
}

func (v NullableRemoveSignatures) IsSet() bool {
	return v.isSet
}

func (v *NullableRemoveSignatures) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRemoveSignatures(val *RemoveSignatures) *NullableRemoveSignatures {
	return &NullableRemoveSignatures{value: val, isSet: true}
}

func (v NullableRemoveSignatures) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRemoveSignatures) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


