/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"os"
)

// checks if the PythonBanderRemote type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PythonBanderRemote{}

// PythonBanderRemote A Serializer for the initial step of creating a Python Remote from a Bandersnatch config file
type PythonBanderRemote struct {
	// A Bandersnatch config that may be used to construct a Python Remote.
	Config *os.File `json:"config"`
	// A unique name for this remote
	Name string `json:"name"`
	Policy *Policy762Enum `json:"policy,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PythonBanderRemote PythonBanderRemote

// NewPythonBanderRemote instantiates a new PythonBanderRemote object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPythonBanderRemote(config *os.File, name string) *PythonBanderRemote {
	this := PythonBanderRemote{}
	this.Config = config
	this.Name = name
	var policy Policy762Enum = POLICY762ENUM_ON_DEMAND
	this.Policy = &policy
	return &this
}

// NewPythonBanderRemoteWithDefaults instantiates a new PythonBanderRemote object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPythonBanderRemoteWithDefaults() *PythonBanderRemote {
	this := PythonBanderRemote{}
	var policy Policy762Enum = POLICY762ENUM_ON_DEMAND
	this.Policy = &policy
	return &this
}

// GetConfig returns the Config field value
func (o *PythonBanderRemote) GetConfig() *os.File {
	if o == nil {
		var ret *os.File
		return ret
	}

	return o.Config
}

// GetConfigOk returns a tuple with the Config field value
// and a boolean to check if the value has been set.
func (o *PythonBanderRemote) GetConfigOk() (**os.File, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Config, true
}

// SetConfig sets field value
func (o *PythonBanderRemote) SetConfig(v *os.File) {
	o.Config = v
}

// GetName returns the Name field value
func (o *PythonBanderRemote) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *PythonBanderRemote) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *PythonBanderRemote) SetName(v string) {
	o.Name = v
}

// GetPolicy returns the Policy field value if set, zero value otherwise.
func (o *PythonBanderRemote) GetPolicy() Policy762Enum {
	if o == nil || IsNil(o.Policy) {
		var ret Policy762Enum
		return ret
	}
	return *o.Policy
}

// GetPolicyOk returns a tuple with the Policy field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonBanderRemote) GetPolicyOk() (*Policy762Enum, bool) {
	if o == nil || IsNil(o.Policy) {
		return nil, false
	}
	return o.Policy, true
}

// HasPolicy returns a boolean if a field has been set.
func (o *PythonBanderRemote) HasPolicy() bool {
	if o != nil && !IsNil(o.Policy) {
		return true
	}

	return false
}

// SetPolicy gets a reference to the given Policy762Enum and assigns it to the Policy field.
func (o *PythonBanderRemote) SetPolicy(v Policy762Enum) {
	o.Policy = &v
}

func (o PythonBanderRemote) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PythonBanderRemote) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["config"] = o.Config
	toSerialize["name"] = o.Name
	if !IsNil(o.Policy) {
		toSerialize["policy"] = o.Policy
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PythonBanderRemote) UnmarshalJSON(bytes []byte) (err error) {
	varPythonBanderRemote := _PythonBanderRemote{}

	if err = json.Unmarshal(bytes, &varPythonBanderRemote); err == nil {
		*o = PythonBanderRemote(varPythonBanderRemote)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "config")
		delete(additionalProperties, "name")
		delete(additionalProperties, "policy")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePythonBanderRemote struct {
	value *PythonBanderRemote
	isSet bool
}

func (v NullablePythonBanderRemote) Get() *PythonBanderRemote {
	return v.value
}

func (v *NullablePythonBanderRemote) Set(val *PythonBanderRemote) {
	v.value = val
	v.isSet = true
}

func (v NullablePythonBanderRemote) IsSet() bool {
	return v.isSet
}

func (v *NullablePythonBanderRemote) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePythonBanderRemote(val *PythonBanderRemote) *NullablePythonBanderRemote {
	return &NullablePythonBanderRemote{value: val, isSet: true}
}

func (v NullablePythonBanderRemote) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePythonBanderRemote) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


