/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the AnsibleRepositoryMark type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AnsibleRepositoryMark{}

// AnsibleRepositoryMark A serializer for the mark action.
type AnsibleRepositoryMark struct {
	// List of collection version hrefs to mark, use * to mark all content in repository
	ContentUnits []interface{} `json:"content_units"`
	// The string value of this mark.
	Value string `json:"value"`
	AdditionalProperties map[string]interface{}
}

type _AnsibleRepositoryMark AnsibleRepositoryMark

// NewAnsibleRepositoryMark instantiates a new AnsibleRepositoryMark object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAnsibleRepositoryMark(contentUnits []interface{}, value string) *AnsibleRepositoryMark {
	this := AnsibleRepositoryMark{}
	this.ContentUnits = contentUnits
	this.Value = value
	return &this
}

// NewAnsibleRepositoryMarkWithDefaults instantiates a new AnsibleRepositoryMark object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAnsibleRepositoryMarkWithDefaults() *AnsibleRepositoryMark {
	this := AnsibleRepositoryMark{}
	return &this
}

// GetContentUnits returns the ContentUnits field value
func (o *AnsibleRepositoryMark) GetContentUnits() []interface{} {
	if o == nil {
		var ret []interface{}
		return ret
	}

	return o.ContentUnits
}

// GetContentUnitsOk returns a tuple with the ContentUnits field value
// and a boolean to check if the value has been set.
func (o *AnsibleRepositoryMark) GetContentUnitsOk() ([]interface{}, bool) {
	if o == nil {
		return nil, false
	}
	return o.ContentUnits, true
}

// SetContentUnits sets field value
func (o *AnsibleRepositoryMark) SetContentUnits(v []interface{}) {
	o.ContentUnits = v
}

// GetValue returns the Value field value
func (o *AnsibleRepositoryMark) GetValue() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Value
}

// GetValueOk returns a tuple with the Value field value
// and a boolean to check if the value has been set.
func (o *AnsibleRepositoryMark) GetValueOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Value, true
}

// SetValue sets field value
func (o *AnsibleRepositoryMark) SetValue(v string) {
	o.Value = v
}

func (o AnsibleRepositoryMark) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AnsibleRepositoryMark) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["content_units"] = o.ContentUnits
	toSerialize["value"] = o.Value

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AnsibleRepositoryMark) UnmarshalJSON(bytes []byte) (err error) {
	varAnsibleRepositoryMark := _AnsibleRepositoryMark{}

	if err = json.Unmarshal(bytes, &varAnsibleRepositoryMark); err == nil {
		*o = AnsibleRepositoryMark(varAnsibleRepositoryMark)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "content_units")
		delete(additionalProperties, "value")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAnsibleRepositoryMark struct {
	value *AnsibleRepositoryMark
	isSet bool
}

func (v NullableAnsibleRepositoryMark) Get() *AnsibleRepositoryMark {
	return v.value
}

func (v *NullableAnsibleRepositoryMark) Set(val *AnsibleRepositoryMark) {
	v.value = val
	v.isSet = true
}

func (v NullableAnsibleRepositoryMark) IsSet() bool {
	return v.isSet
}

func (v *NullableAnsibleRepositoryMark) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAnsibleRepositoryMark(val *AnsibleRepositoryMark) *NullableAnsibleRepositoryMark {
	return &NullableAnsibleRepositoryMark{value: val, isSet: true}
}

func (v NullableAnsibleRepositoryMark) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAnsibleRepositoryMark) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


