/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"os"
)

// checks if the AnsibleCollectionVersionSignature type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AnsibleCollectionVersionSignature{}

// AnsibleCollectionVersionSignature A serializer for signature models.
type AnsibleCollectionVersionSignature struct {
	// A URI of a repository the new content unit should be associated with.
	Repository *string `json:"repository,omitempty"`
	// An uploaded file that may be turned into the artifact of the content unit.
	File *os.File `json:"file"`
	// The content this signature is pointing to.
	SignedCollection string `json:"signed_collection"`
	AdditionalProperties map[string]interface{}
}

type _AnsibleCollectionVersionSignature AnsibleCollectionVersionSignature

// NewAnsibleCollectionVersionSignature instantiates a new AnsibleCollectionVersionSignature object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAnsibleCollectionVersionSignature(file *os.File, signedCollection string) *AnsibleCollectionVersionSignature {
	this := AnsibleCollectionVersionSignature{}
	this.File = file
	this.SignedCollection = signedCollection
	return &this
}

// NewAnsibleCollectionVersionSignatureWithDefaults instantiates a new AnsibleCollectionVersionSignature object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAnsibleCollectionVersionSignatureWithDefaults() *AnsibleCollectionVersionSignature {
	this := AnsibleCollectionVersionSignature{}
	return &this
}

// GetRepository returns the Repository field value if set, zero value otherwise.
func (o *AnsibleCollectionVersionSignature) GetRepository() string {
	if o == nil || IsNil(o.Repository) {
		var ret string
		return ret
	}
	return *o.Repository
}

// GetRepositoryOk returns a tuple with the Repository field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AnsibleCollectionVersionSignature) GetRepositoryOk() (*string, bool) {
	if o == nil || IsNil(o.Repository) {
		return nil, false
	}
	return o.Repository, true
}

// HasRepository returns a boolean if a field has been set.
func (o *AnsibleCollectionVersionSignature) HasRepository() bool {
	if o != nil && !IsNil(o.Repository) {
		return true
	}

	return false
}

// SetRepository gets a reference to the given string and assigns it to the Repository field.
func (o *AnsibleCollectionVersionSignature) SetRepository(v string) {
	o.Repository = &v
}

// GetFile returns the File field value
func (o *AnsibleCollectionVersionSignature) GetFile() *os.File {
	if o == nil {
		var ret *os.File
		return ret
	}

	return o.File
}

// GetFileOk returns a tuple with the File field value
// and a boolean to check if the value has been set.
func (o *AnsibleCollectionVersionSignature) GetFileOk() (**os.File, bool) {
	if o == nil {
		return nil, false
	}
	return &o.File, true
}

// SetFile sets field value
func (o *AnsibleCollectionVersionSignature) SetFile(v *os.File) {
	o.File = v
}

// GetSignedCollection returns the SignedCollection field value
func (o *AnsibleCollectionVersionSignature) GetSignedCollection() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.SignedCollection
}

// GetSignedCollectionOk returns a tuple with the SignedCollection field value
// and a boolean to check if the value has been set.
func (o *AnsibleCollectionVersionSignature) GetSignedCollectionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.SignedCollection, true
}

// SetSignedCollection sets field value
func (o *AnsibleCollectionVersionSignature) SetSignedCollection(v string) {
	o.SignedCollection = v
}

func (o AnsibleCollectionVersionSignature) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AnsibleCollectionVersionSignature) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Repository) {
		toSerialize["repository"] = o.Repository
	}
	toSerialize["file"] = o.File
	toSerialize["signed_collection"] = o.SignedCollection

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AnsibleCollectionVersionSignature) UnmarshalJSON(bytes []byte) (err error) {
	varAnsibleCollectionVersionSignature := _AnsibleCollectionVersionSignature{}

	if err = json.Unmarshal(bytes, &varAnsibleCollectionVersionSignature); err == nil {
		*o = AnsibleCollectionVersionSignature(varAnsibleCollectionVersionSignature)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "repository")
		delete(additionalProperties, "file")
		delete(additionalProperties, "signed_collection")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAnsibleCollectionVersionSignature struct {
	value *AnsibleCollectionVersionSignature
	isSet bool
}

func (v NullableAnsibleCollectionVersionSignature) Get() *AnsibleCollectionVersionSignature {
	return v.value
}

func (v *NullableAnsibleCollectionVersionSignature) Set(val *AnsibleCollectionVersionSignature) {
	v.value = val
	v.isSet = true
}

func (v NullableAnsibleCollectionVersionSignature) IsSet() bool {
	return v.isSet
}

func (v *NullableAnsibleCollectionVersionSignature) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAnsibleCollectionVersionSignature(val *AnsibleCollectionVersionSignature) *NullableAnsibleCollectionVersionSignature {
	return &NullableAnsibleCollectionVersionSignature{value: val, isSet: true}
}

func (v NullableAnsibleCollectionVersionSignature) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAnsibleCollectionVersionSignature) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


