/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// DistributionsPypiAPIService DistributionsPypiAPI service
type DistributionsPypiAPIService service

type DistributionsPypiAPIDistributionsPythonPypiCreateRequest struct {
	ctx context.Context
	ApiService *DistributionsPypiAPIService
	pythonPythonDistribution *PythonPythonDistribution
}

func (r DistributionsPypiAPIDistributionsPythonPypiCreateRequest) PythonPythonDistribution(pythonPythonDistribution PythonPythonDistribution) DistributionsPypiAPIDistributionsPythonPypiCreateRequest {
	r.pythonPythonDistribution = &pythonPythonDistribution
	return r
}

func (r DistributionsPypiAPIDistributionsPythonPypiCreateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsPythonPypiCreateExecute(r)
}

/*
DistributionsPythonPypiCreate Create a python distribution

Trigger an asynchronous create task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return DistributionsPypiAPIDistributionsPythonPypiCreateRequest
*/
func (a *DistributionsPypiAPIService) DistributionsPythonPypiCreate(ctx context.Context) DistributionsPypiAPIDistributionsPythonPypiCreateRequest {
	return DistributionsPypiAPIDistributionsPythonPypiCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsPypiAPIService) DistributionsPythonPypiCreateExecute(r DistributionsPypiAPIDistributionsPythonPypiCreateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsPypiAPIService.DistributionsPythonPypiCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/distributions/python/pypi/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.pythonPythonDistribution == nil {
		return localVarReturnValue, nil, reportError("pythonPythonDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.pythonPythonDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsPypiAPIDistributionsPythonPypiDeleteRequest struct {
	ctx context.Context
	ApiService *DistributionsPypiAPIService
	pythonPythonDistributionHref string
}

func (r DistributionsPypiAPIDistributionsPythonPypiDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsPythonPypiDeleteExecute(r)
}

/*
DistributionsPythonPypiDelete Delete a python distribution

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonDistributionHref
 @return DistributionsPypiAPIDistributionsPythonPypiDeleteRequest
*/
func (a *DistributionsPypiAPIService) DistributionsPythonPypiDelete(ctx context.Context, pythonPythonDistributionHref string) DistributionsPypiAPIDistributionsPythonPypiDeleteRequest {
	return DistributionsPypiAPIDistributionsPythonPypiDeleteRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonDistributionHref: pythonPythonDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsPypiAPIService) DistributionsPythonPypiDeleteExecute(r DistributionsPypiAPIDistributionsPythonPypiDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsPypiAPIService.DistributionsPythonPypiDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_distribution_href"+"}", parameterValueToString(r.pythonPythonDistributionHref, "pythonPythonDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsPypiAPIDistributionsPythonPypiListRequest struct {
	ctx context.Context
	ApiService *DistributionsPypiAPIService
	basePath *string
	basePathContains *string
	basePathIcontains *string
	basePathIn *[]string
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	repository *string
	repositoryIn *[]string
	withContent *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where base_path matches value
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) BasePath(basePath string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.basePath = &basePath
	return r
}

// Filter results where base_path contains value
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) BasePathContains(basePathContains string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.basePathContains = &basePathContains
	return r
}

// Filter results where base_path contains value
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) BasePathIcontains(basePathIcontains string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.basePathIcontains = &basePathIcontains
	return r
}

// Filter results where base_path is in a comma-separated list of values
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) BasePathIn(basePathIn []string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.basePathIn = &basePathIn
	return r
}

// Number of results to return per page.
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) Limit(limit int32) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) Name(name string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) NameContains(nameContains string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) NameIcontains(nameIcontains string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) NameIn(nameIn []string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) NameStartswith(nameStartswith string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) Offset(offset int32) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;base_path&#x60; - Base path * &#x60;-base_path&#x60; - Base path (descending) * &#x60;hidden&#x60; - Hidden * &#x60;-hidden&#x60; - Hidden (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) Ordering(ordering []string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) PulpHrefIn(pulpHrefIn []string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) PulpIdIn(pulpIdIn []string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) PulpLabelSelect(pulpLabelSelect string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Filter results where repository matches value
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) Repository(repository string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.repository = &repository
	return r
}

// Filter results where repository is in a comma-separated list of values
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) RepositoryIn(repositoryIn []string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.repositoryIn = &repositoryIn
	return r
}

// Filter distributions based on the content served by them
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) WithContent(withContent string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.withContent = &withContent
	return r
}

// A list of fields to include in the response.
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) Fields(fields []string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) ExcludeFields(excludeFields []string) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsPypiAPIDistributionsPythonPypiListRequest) Execute() (*PaginatedpythonPythonDistributionResponseList, *http.Response, error) {
	return r.ApiService.DistributionsPythonPypiListExecute(r)
}

/*
DistributionsPythonPypiList List python distributions


Pulp Python Distributions are used to distribute Python content from
Python Repositories or
Python Publications.  Pulp Python
Distributions should not be confused with "Python Distribution" as defined by the Python
community. In Pulp usage, Python content is referred to as Python Package Content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return DistributionsPypiAPIDistributionsPythonPypiListRequest
*/
func (a *DistributionsPypiAPIService) DistributionsPythonPypiList(ctx context.Context) DistributionsPypiAPIDistributionsPythonPypiListRequest {
	return DistributionsPypiAPIDistributionsPythonPypiListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedpythonPythonDistributionResponseList
func (a *DistributionsPypiAPIService) DistributionsPythonPypiListExecute(r DistributionsPypiAPIDistributionsPythonPypiListRequest) (*PaginatedpythonPythonDistributionResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedpythonPythonDistributionResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsPypiAPIService.DistributionsPythonPypiList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/distributions/python/pypi/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.basePath != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path", r.basePath, "")
	}
	if r.basePathContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__contains", r.basePathContains, "")
	}
	if r.basePathIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__icontains", r.basePathIcontains, "")
	}
	if r.basePathIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "base_path__in", r.basePathIn, "csv")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.repository != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository", r.repository, "")
	}
	if r.repositoryIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository__in", r.repositoryIn, "csv")
	}
	if r.withContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "with_content", r.withContent, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsPypiAPIDistributionsPythonPypiPartialUpdateRequest struct {
	ctx context.Context
	ApiService *DistributionsPypiAPIService
	pythonPythonDistributionHref string
	patchedpythonPythonDistribution *PatchedpythonPythonDistribution
}

func (r DistributionsPypiAPIDistributionsPythonPypiPartialUpdateRequest) PatchedpythonPythonDistribution(patchedpythonPythonDistribution PatchedpythonPythonDistribution) DistributionsPypiAPIDistributionsPythonPypiPartialUpdateRequest {
	r.patchedpythonPythonDistribution = &patchedpythonPythonDistribution
	return r
}

func (r DistributionsPypiAPIDistributionsPythonPypiPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsPythonPypiPartialUpdateExecute(r)
}

/*
DistributionsPythonPypiPartialUpdate Update a python distribution

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonDistributionHref
 @return DistributionsPypiAPIDistributionsPythonPypiPartialUpdateRequest
*/
func (a *DistributionsPypiAPIService) DistributionsPythonPypiPartialUpdate(ctx context.Context, pythonPythonDistributionHref string) DistributionsPypiAPIDistributionsPythonPypiPartialUpdateRequest {
	return DistributionsPypiAPIDistributionsPythonPypiPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonDistributionHref: pythonPythonDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsPypiAPIService) DistributionsPythonPypiPartialUpdateExecute(r DistributionsPypiAPIDistributionsPythonPypiPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsPypiAPIService.DistributionsPythonPypiPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_distribution_href"+"}", parameterValueToString(r.pythonPythonDistributionHref, "pythonPythonDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedpythonPythonDistribution == nil {
		return localVarReturnValue, nil, reportError("patchedpythonPythonDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedpythonPythonDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsPypiAPIDistributionsPythonPypiReadRequest struct {
	ctx context.Context
	ApiService *DistributionsPypiAPIService
	pythonPythonDistributionHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r DistributionsPypiAPIDistributionsPythonPypiReadRequest) Fields(fields []string) DistributionsPypiAPIDistributionsPythonPypiReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r DistributionsPypiAPIDistributionsPythonPypiReadRequest) ExcludeFields(excludeFields []string) DistributionsPypiAPIDistributionsPythonPypiReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r DistributionsPypiAPIDistributionsPythonPypiReadRequest) Execute() (*PythonPythonDistributionResponse, *http.Response, error) {
	return r.ApiService.DistributionsPythonPypiReadExecute(r)
}

/*
DistributionsPythonPypiRead Inspect a python distribution


Pulp Python Distributions are used to distribute Python content from
Python Repositories or
Python Publications.  Pulp Python
Distributions should not be confused with "Python Distribution" as defined by the Python
community. In Pulp usage, Python content is referred to as Python Package Content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonDistributionHref
 @return DistributionsPypiAPIDistributionsPythonPypiReadRequest
*/
func (a *DistributionsPypiAPIService) DistributionsPythonPypiRead(ctx context.Context, pythonPythonDistributionHref string) DistributionsPypiAPIDistributionsPythonPypiReadRequest {
	return DistributionsPypiAPIDistributionsPythonPypiReadRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonDistributionHref: pythonPythonDistributionHref,
	}
}

// Execute executes the request
//  @return PythonPythonDistributionResponse
func (a *DistributionsPypiAPIService) DistributionsPythonPypiReadExecute(r DistributionsPypiAPIDistributionsPythonPypiReadRequest) (*PythonPythonDistributionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PythonPythonDistributionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsPypiAPIService.DistributionsPythonPypiRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_distribution_href"+"}", parameterValueToString(r.pythonPythonDistributionHref, "pythonPythonDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type DistributionsPypiAPIDistributionsPythonPypiUpdateRequest struct {
	ctx context.Context
	ApiService *DistributionsPypiAPIService
	pythonPythonDistributionHref string
	pythonPythonDistribution *PythonPythonDistribution
}

func (r DistributionsPypiAPIDistributionsPythonPypiUpdateRequest) PythonPythonDistribution(pythonPythonDistribution PythonPythonDistribution) DistributionsPypiAPIDistributionsPythonPypiUpdateRequest {
	r.pythonPythonDistribution = &pythonPythonDistribution
	return r
}

func (r DistributionsPypiAPIDistributionsPythonPypiUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.DistributionsPythonPypiUpdateExecute(r)
}

/*
DistributionsPythonPypiUpdate Update a python distribution

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param pythonPythonDistributionHref
 @return DistributionsPypiAPIDistributionsPythonPypiUpdateRequest
*/
func (a *DistributionsPypiAPIService) DistributionsPythonPypiUpdate(ctx context.Context, pythonPythonDistributionHref string) DistributionsPypiAPIDistributionsPythonPypiUpdateRequest {
	return DistributionsPypiAPIDistributionsPythonPypiUpdateRequest{
		ApiService: a,
		ctx: ctx,
		pythonPythonDistributionHref: pythonPythonDistributionHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *DistributionsPypiAPIService) DistributionsPythonPypiUpdateExecute(r DistributionsPypiAPIDistributionsPythonPypiUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "DistributionsPypiAPIService.DistributionsPythonPypiUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{python_python_distribution_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"python_python_distribution_href"+"}", parameterValueToString(r.pythonPythonDistributionHref, "pythonPythonDistributionHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.pythonPythonDistribution == nil {
		return localVarReturnValue, nil, reportError("pythonPythonDistribution is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.pythonPythonDistribution
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
