/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.PQGParams;
import org.mozilla.jss.crypto.Policy;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.PK11ParameterSpec;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.ECCurve;
import org.mozilla.jss.util.ECOIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PK11KeyPairGenerator
extends KeyPairGeneratorSpi {
    public static Logger logger = LoggerFactory.getLogger(PK11KeyPairGenerator.class);
    private long opFlags = 0L;
    private long opFlagsMask = 0L;
    private static final int DEFAULT_RSA_KEY_SIZE = 2048;
    private static final BigInteger DEFAULT_RSA_PUBLIC_EXPONENT = BigInteger.valueOf(65537L);
    private static final String p1024 = "135839652435190934085800139191680301864221874900900696919010316554114342871389066526982023513828891845682496590926522957486592076092819515303251959435284578074745022943475516750500021440278782993316814165831392449756706958779266394680687474113495272524355075654433600922751920548192539119568200162784715902571";
    private static final String q1024 = "1289225024022202541601051225376429063716419728261";
    private static final String g1024 = "9365079229044517973775853147905914670746128595481021901304748201231245287028018351117994470223961367498481071639148009750748608477086914440940765659773400233006204556380834403997210445996745757996115285802608489502160956380238739417382954486304730446079375880915926936667959108637040861595671319957190194969";
    private static final String h1024 = "52442921523337940900621893014039829709890959980326720828933601226740749524581606283131306291278616835323956710592993182613544059214633911716533418368425327413628234095671352084418677611348898811691107611640282098605730539089258655659910952545940615065321018163879856499128636989240131903260975031351698627473";
    private static final String seed1024 = "99294487279227522120410987308721952265545668206337642687581596155167227884587528576179879564731162765515189527566190299324927751299864501359105446993895763527646668003992063667962831489586752303126546478655915858883436326503676798267446073013163508014466163441488290854738816489359449082537210762470653355837";
    private static final int counter1024 = 159;
    public static final PQGParams PQG1024 = new PQGParams(new BigInteger("135839652435190934085800139191680301864221874900900696919010316554114342871389066526982023513828891845682496590926522957486592076092819515303251959435284578074745022943475516750500021440278782993316814165831392449756706958779266394680687474113495272524355075654433600922751920548192539119568200162784715902571"), new BigInteger("1289225024022202541601051225376429063716419728261"), new BigInteger("9365079229044517973775853147905914670746128595481021901304748201231245287028018351117994470223961367498481071639148009750748608477086914440940765659773400233006204556380834403997210445996745757996115285802608489502160956380238739417382954486304730446079375880915926936667959108637040861595671319957190194969"), new BigInteger("99294487279227522120410987308721952265545668206337642687581596155167227884587528576179879564731162765515189527566190299324927751299864501359105446993895763527646668003992063667962831489586752303126546478655915858883436326503676798267446073013163508014466163441488290854738816489359449082537210762470653355837"), 159, new BigInteger("52442921523337940900621893014039829709890959980326720828933601226740749524581606283131306291278616835323956710592993182613544059214633911716533418368425327413628234095671352084418677611348898811691107611640282098605730539089258655659910952545940615065321018163879856499128636989240131903260975031351698627473"));
    private static final String p768 = "1334591549939035619289567230283054603122655003980178118026955029363553392594293499178687789871628588392413078786977899109276604404053531960657701920766542891720144660923735290663050045086516783083489369477138289683344192203747015183";
    private static final String q768 = "1356132865877303155992130272917916166541739006871";
    private static final String g768 = "1024617924160404238802957719732914916383807485923819254303813897112921288261546213295904612554364830820266594592843780972915270096284099079324418834215265083315386166747220804977600828688227714319518802565604893756612386174125343163";
    private static final String seed768 = "818335465751997015393064637168438154352349887221925302425470688493624428407506863871577128315308555744979456856342994235252156194662586703244255741598129996211081771019031721876068721218509213355334043303099174315838637885951947797";
    private static final int counter768 = 80;
    private static final String h768 = "640382699969409389484886950168366372251172224987648937408021020040753785108834000620831523080773231719549705102680417704245010958792653770817759388668805215557594892534053348624875390588773257372677159854630106242075665177245698591";
    public static final PQGParams PQG768 = new PQGParams(new BigInteger("1334591549939035619289567230283054603122655003980178118026955029363553392594293499178687789871628588392413078786977899109276604404053531960657701920766542891720144660923735290663050045086516783083489369477138289683344192203747015183"), new BigInteger("1356132865877303155992130272917916166541739006871"), new BigInteger("1024617924160404238802957719732914916383807485923819254303813897112921288261546213295904612554364830820266594592843780972915270096284099079324418834215265083315386166747220804977600828688227714319518802565604893756612386174125343163"), new BigInteger("818335465751997015393064637168438154352349887221925302425470688493624428407506863871577128315308555744979456856342994235252156194662586703244255741598129996211081771019031721876068721218509213355334043303099174315838637885951947797"), 80, new BigInteger("640382699969409389484886950168366372251172224987648937408021020040753785108834000620831523080773231719549705102680417704245010958792653770817759388668805215557594892534053348624875390588773257372677159854630106242075665177245698591"));
    private static final String p512 = "6966483207285155416780416172202915863379050665227482416115451434656043093992853756903066653962454938528584622842487778598918381346739078775480034378802841";
    private static final String q512 = "1310301134281640075932276656367326462518739803527";
    private static final String g512 = "1765808308320938820731237312304158486199455718816858489736043318496656574508696475222741642343469219895005992985361010111736160340009944528784078083324884";
    private static final String h512 = "1166033533097555931825481846268490827226947692615252570752313574243187654088977281409544725210974913958636100321681636002587474728477655589742540645702652";
    private static final String seed512 = "1823071686803672528716836609217295942310764795778335243232708299998660956064222751939859670873282519585591423918449571513004815205037154878988595168291600";
    private static final int counter512 = 186;
    public static final PQGParams PQG512 = new PQGParams(new BigInteger("6966483207285155416780416172202915863379050665227482416115451434656043093992853756903066653962454938528584622842487778598918381346739078775480034378802841"), new BigInteger("1310301134281640075932276656367326462518739803527"), new BigInteger("1765808308320938820731237312304158486199455718816858489736043318496656574508696475222741642343469219895005992985361010111736160340009944528784078083324884"), new BigInteger("1823071686803672528716836609217295942310764795778335243232708299998660956064222751939859670873282519585591423918449571513004815205037154878988595168291600"), 186, new BigInteger("1166033533097555931825481846268490827226947692615252570752313574243187654088977281409544725210974913958636100321681636002587474728477655589742540645702652"));
    private static boolean defaultsTested = false;
    private PK11Token token;
    private AlgorithmParameterSpec params;
    private KeyPairAlgorithm algorithm;
    private boolean mKeygenOnInternalToken;
    private boolean temporaryPairMode = false;
    private int sensitivePairMode = -1;
    private int extractablePairMode = -1;

    public PK11KeyPairGenerator(PK11Token token, KeyPairAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        assert (token != null && algorithm != null);
        this.mKeygenOnInternalToken = false;
        if (!token.doesAlgorithm(algorithm)) {
            if (token.doesAlgorithm(algorithm.getAlgFamily()) && token.isWritable()) {
                this.mKeygenOnInternalToken = true;
            } else {
                throw new NoSuchAlgorithmException();
            }
        }
        this.token = token;
        this.algorithm = algorithm;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initialize(int strength, SecureRandom random) throws InvalidParameterException {
        if (this.algorithm == KeyPairAlgorithm.RSA) {
            this.params = new RSAKeyGenParameterSpec(strength, DEFAULT_RSA_PUBLIC_EXPONENT);
            return;
        } else if (this.algorithm == KeyPairAlgorithm.DSA) {
            if (strength == 512) {
                this.params = PQG512;
                return;
            } else if (strength == 768) {
                this.params = PQG768;
                return;
            } else {
                if (strength != 1024) throw new InvalidParameterException("In order to use pre-cooked PQG values, key strength mustbe 512, 768, or 1024.");
                this.params = PQG1024;
            }
            return;
        } else {
            assert (this.algorithm == KeyPairAlgorithm.EC);
            this.params = strength < 112 ? this.getECCurve(strength) : this.getCurve(strength);
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params == null) {
            throw new InvalidAlgorithmParameterException("Null parameters");
        }
        if (this.algorithm == KeyPairAlgorithm.RSA) {
            if (!(params instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException();
            }
            if (((RSAKeyGenParameterSpec)params).getPublicExponent().bitLength() > 31) {
                throw new InvalidAlgorithmParameterException("RSA Public Exponent must fit in 31 or fewer bits.");
            }
        } else if (this.algorithm == KeyPairAlgorithm.DSA) {
            if (!(params instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException();
            }
        } else {
            assert (this.algorithm == KeyPairAlgorithm.EC);
            if (params instanceof ECGenParameterSpec) {
                ECGenParameterSpec standard_params = (ECGenParameterSpec)params;
                String curve_name = standard_params.getName();
                ECCurve curve = ECCurve.fromName(curve_name);
                if (curve == null) {
                    throw new InvalidAlgorithmParameterException("Unable to find curve with the given name: " + curve_name);
                }
                OBJECT_IDENTIFIER[] oid = curve.getOIDs();
                assert (oid.length >= 1);
                byte[] encoded_oid = ASN1Util.encode(oid[0]);
                params = new PK11ParameterSpec(encoded_oid);
            }
            if (!(params instanceof PK11ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Expected params to either be an instance of ECGenParameterSpec or PK11ParameterSpec!");
            }
        }
        this.params = params;
    }

    @Override
    public KeyPair generateKeyPair() throws TokenException {
        if (this.algorithm == KeyPairAlgorithm.RSA) {
            if (this.params != null) {
                Object msg;
                RSAKeyGenParameterSpec rsaparams = (RSAKeyGenParameterSpec)this.params;
                if (rsaparams.getKeysize() < Policy.RSA_MINIMUM_KEY_SIZE) {
                    msg = "unsafe RSA key size of ";
                    msg = (String)msg + rsaparams.getKeysize() + ". Policy.RSA_MINIMUM_KEY_SIZE ";
                    msg = (String)msg + "dictates a minimum of " + Policy.RSA_MINIMUM_KEY_SIZE;
                    if (Policy.ENFORCING_KEY_SIZES) {
                        throw new TokenException("Disallowing " + (String)msg);
                    }
                    logger.warn("Ignored jss.crypto.Policy violation: " + (String)msg);
                }
                if (rsaparams.getPublicExponent().longValue() < Policy.RSA_MINIMUM_PUBLIC_EXPONENT.longValue()) {
                    msg = "unsafe RSA exponent of ";
                    msg = (String)msg + rsaparams.getPublicExponent().longValue() + ". ";
                    msg = (String)msg + "Policy.RSA_MINIMUM_PUBLIC_EXPONENT dictates a minimum of ";
                    msg = (String)msg + Policy.RSA_MINIMUM_PUBLIC_EXPONENT.longValue();
                    if (Policy.ENFORCING_KEY_SIZES) {
                        throw new TokenException("Disallowing " + (String)msg);
                    }
                    logger.warn("Ignored jss.crypto.Policy violation: " + (String)msg);
                }
                return this.generateRSAKeyPairWithOpFlags(this.token, rsaparams.getKeysize(), rsaparams.getPublicExponent().longValue(), this.temporaryPairMode, this.sensitivePairMode, this.extractablePairMode, (int)this.opFlags, (int)this.opFlagsMask);
            }
            return this.generateRSAKeyPairWithOpFlags(this.token, 2048, DEFAULT_RSA_PUBLIC_EXPONENT.longValue(), this.temporaryPairMode, this.sensitivePairMode, this.extractablePairMode, (int)this.opFlags, (int)this.opFlagsMask);
        }
        if (this.algorithm == KeyPairAlgorithm.DSA) {
            if (this.params == null) {
                this.params = PQG1024;
            }
            DSAParameterSpec dsaParams = (DSAParameterSpec)this.params;
            return this.generateDSAKeyPairWithOpFlags(this.token, PQGParams.BigIntegerToUnsignedByteArray(dsaParams.getP()), PQGParams.BigIntegerToUnsignedByteArray(dsaParams.getQ()), PQGParams.BigIntegerToUnsignedByteArray(dsaParams.getG()), this.temporaryPairMode, this.sensitivePairMode, this.extractablePairMode, (int)this.opFlags, (int)this.opFlagsMask);
        }
        assert (this.algorithm == KeyPairAlgorithm.EC);
        PK11ParameterSpec ecParams = (PK11ParameterSpec)this.params;
        return this.generateECKeyPairWithOpFlags(this.token, ecParams.getEncoded(), this.temporaryPairMode, this.sensitivePairMode, this.extractablePairMode, (int)this.opFlags, (int)this.opFlagsMask);
    }

    @Override
    public boolean keygenOnInternalToken() {
        return this.mKeygenOnInternalToken;
    }

    private native KeyPair generateRSAKeyPair(PK11Token var1, int var2, long var3, boolean var5, int var6, int var7) throws TokenException;

    private native KeyPair generateRSAKeyPairWithOpFlags(PK11Token var1, int var2, long var3, boolean var5, int var6, int var7, int var8, int var9) throws TokenException;

    private native KeyPair generateDSAKeyPair(PK11Token var1, byte[] var2, byte[] var3, byte[] var4, boolean var5, int var6, int var7) throws TokenException;

    private native KeyPair generateDSAKeyPairWithOpFlags(PK11Token var1, byte[] var2, byte[] var3, byte[] var4, boolean var5, int var6, int var7, int var8, int var9) throws TokenException;

    private native KeyPair generateECKeyPair(PK11Token var1, byte[] var2, boolean var3, int var4, int var5) throws TokenException;

    private native KeyPair generateECKeyPairWithOpFlags(PK11Token var1, byte[] var2, boolean var3, int var4, int var5, int var6, int var7) throws TokenException;

    private static synchronized void testDefaults() {
        if (!defaultsTested) {
            assert (PQG1024.paramsAreValid());
            assert (PQG768.paramsAreValid());
            assert (PQG512.paramsAreValid());
            defaultsTested = true;
        }
    }

    @Override
    public void temporaryPairs(boolean temp) {
        this.temporaryPairMode = temp;
    }

    @Override
    public void sensitivePairs(boolean sensitive) {
        this.sensitivePairMode = sensitive ? 1 : 0;
    }

    @Override
    public void extractablePairs(boolean extractable) {
        this.extractablePairMode = extractable ? 1 : 0;
    }

    @Override
    public void setKeyPairUsages(KeyPairGeneratorSpi.Usage[] usages, KeyPairGeneratorSpi.Usage[] usages_mask) {
        int i;
        this.opFlags = 0L;
        this.opFlagsMask = 0L;
        if (usages != null) {
            for (i = 0; i < usages.length; ++i) {
                if (usages[i] == null) continue;
                this.opFlags |= usages[i].value();
            }
        }
        if (usages_mask != null) {
            for (i = 0; i < usages_mask.length; ++i) {
                if (usages_mask[i] == null) continue;
                this.opFlagsMask |= usages_mask[i].value();
            }
        }
    }

    @Override
    public int getCurveCodeByName(String curveName) throws InvalidParameterException {
        ECCurve_Code c;
        if (curveName == null) {
            throw new InvalidParameterException();
        }
        try {
            c = ECCurve_Code.valueOf(curveName);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParameterException(curveName);
        }
        return c.code();
    }

    private AlgorithmParameterSpec getECCurve(int curvecode) throws InvalidParameterException {
        OBJECT_IDENTIFIER oid = ECCurve_Code.valueOf(curvecode).oid();
        return new PK11ParameterSpec(ASN1Util.encode(oid));
    }

    private AlgorithmParameterSpec getCurve(int strength) throws InvalidParameterException {
        return new PK11ParameterSpec(ASN1Util.encode(switch (strength) {
            case 112 -> ECOIDs.CURVE_SECG_P112R1;
            case 113 -> ECOIDs.CURVE_SECG_T113R1;
            case 128 -> ECOIDs.CURVE_SECG_P128R1;
            case 131 -> ECOIDs.CURVE_SECG_T131R1;
            case 160 -> ECOIDs.CURVE_SECG_P160R1;
            case 163 -> ECOIDs.CURVE_SECG_T163K1;
            case 176 -> ECOIDs.CURVE_ANSI_PNB176V1;
            case 191 -> ECOIDs.CURVE_ANSI_TNB191V1;
            case 192 -> ECOIDs.CURVE_ANSI_P192V1;
            case 193 -> ECOIDs.CURVE_SECG_T193R1;
            case 208 -> ECOIDs.CURVE_ANSI_PNB208W1;
            case 224 -> ECOIDs.CURVE_SECG_P224R1;
            case 233 -> ECOIDs.CURVE_SECG_T233R1;
            case 239 -> ECOIDs.CURVE_SECG_T239K1;
            case 256 -> ECOIDs.CURVE_ANSI_P256V1;
            case 272 -> ECOIDs.CURVE_ANSI_PNB272W1;
            case 283 -> ECOIDs.CURVE_SECG_T283R1;
            case 304 -> ECOIDs.CURVE_ANSI_PNB304W1;
            case 359 -> ECOIDs.CURVE_ANSI_TNB359V1;
            case 368 -> ECOIDs.CURVE_ANSI_PNB368W1;
            case 384 -> ECOIDs.CURVE_SECG_P384R1;
            case 409 -> ECOIDs.CURVE_SECG_T409R1;
            case 431 -> ECOIDs.CURVE_ANSI_TNB431R1;
            case 521 -> ECOIDs.CURVE_SECG_P521R1;
            case 571 -> ECOIDs.CURVE_SECG_T571R1;
            default -> throw new InvalidParameterException();
        }));
    }

    private static enum ECCurve_Code {
        secp521r1(0, ECOIDs.CURVE_SECG_P521R1),
        nistp521(1, ECOIDs.CURVE_SECG_P521R1),
        secp384r1(2, ECOIDs.CURVE_SECG_P384R1),
        nistp384(3, ECOIDs.CURVE_SECG_P384R1),
        secp256r1(4, ECOIDs.CURVE_ANSI_P256V1),
        nistp256(5, ECOIDs.CURVE_ANSI_P256V1),
        secp256k1(6, ECOIDs.CURVE_SECG_P256K1),
        secp224r1(7, ECOIDs.CURVE_SECG_P224R1),
        nistp224(8, ECOIDs.CURVE_SECG_P224R1),
        secp224k1(9, ECOIDs.CURVE_SECG_P224K1),
        secp192r1(10, ECOIDs.CURVE_ANSI_P192V1),
        nistp192(11, ECOIDs.CURVE_ANSI_P192V1),
        secp192k1(12, ECOIDs.CURVE_SECG_P192K1),
        secp160r2(13, ECOIDs.CURVE_SECG_P160R2),
        secp160r1(14, ECOIDs.CURVE_SECG_P160R1),
        secp160k1(15, ECOIDs.CURVE_SECG_P160K1),
        secp128r2(16, ECOIDs.CURVE_SECG_P128R2),
        secp128r1(17, ECOIDs.CURVE_SECG_P128R1),
        secp112r2(18, ECOIDs.CURVE_SECG_P112R2),
        secp112r1(19, ECOIDs.CURVE_SECG_P112R1),
        sect571r1(20, ECOIDs.CURVE_SECG_T571R1),
        nistb571(21, ECOIDs.CURVE_SECG_T571R1),
        sect571k1(22, ECOIDs.CURVE_SECG_T571K1),
        nistk571(23, ECOIDs.CURVE_SECG_T571K1),
        sect409r1(24, ECOIDs.CURVE_SECG_T409R1),
        nistb409(25, ECOIDs.CURVE_SECG_T409R1),
        sect409k1(26, ECOIDs.CURVE_SECG_T409K1),
        nistk409(27, ECOIDs.CURVE_SECG_T409K1),
        sect283r1(28, ECOIDs.CURVE_SECG_T283R1),
        nistb283(29, ECOIDs.CURVE_SECG_T283R1),
        sect283k1(30, ECOIDs.CURVE_SECG_T283K1),
        nistk283(31, ECOIDs.CURVE_SECG_T283K1),
        sect239k1(32, ECOIDs.CURVE_SECG_T239K1),
        sect233r1(33, ECOIDs.CURVE_SECG_T233R1),
        nistb233(34, ECOIDs.CURVE_SECG_T233R1),
        sect233k1(35, ECOIDs.CURVE_SECG_T233K1),
        nistk233(36, ECOIDs.CURVE_SECG_T233K1),
        sect193r2(37, ECOIDs.CURVE_SECG_T193R2),
        sect193r1(38, ECOIDs.CURVE_SECG_T193R1),
        nistb163(39, ECOIDs.CURVE_SECG_T163K1),
        sect163r2(40, ECOIDs.CURVE_SECG_T163R2),
        sect163r1(41, ECOIDs.CURVE_SECG_T163R1),
        sect163k1(42, ECOIDs.CURVE_SECG_T163K1),
        nistk163(43, ECOIDs.CURVE_SECG_T163K1),
        sect131r2(44, ECOIDs.CURVE_SECG_T131R2),
        sect131r1(45, ECOIDs.CURVE_SECG_T131R1),
        sect113r2(46, ECOIDs.CURVE_SECG_T113R2),
        sect113r1(47, ECOIDs.CURVE_SECG_T113R1),
        prime239v3(48, ECOIDs.CURVE_ANSI_P239V3),
        prime239v2(49, ECOIDs.CURVE_ANSI_P239V2),
        prime239v1(50, ECOIDs.CURVE_ANSI_P239V1),
        prime192v3(51, ECOIDs.CURVE_ANSI_P192V3),
        prime192v2(52, ECOIDs.CURVE_ANSI_P192V2),
        prime192v1(53, ECOIDs.CURVE_ANSI_P192V1),
        c2pnb163v1(54, ECOIDs.CURVE_ANSI_PNB163V1),
        c2pnb163v2(55, ECOIDs.CURVE_ANSI_PNB163V2),
        c2pnb163v3(56, ECOIDs.CURVE_ANSI_PNB163V3),
        c2pnb176v1(57, ECOIDs.CURVE_ANSI_PNB176V1),
        c2tnb191v1(58, ECOIDs.CURVE_ANSI_TNB191V1),
        c2tnb191v2(59, ECOIDs.CURVE_ANSI_TNB191V2),
        c2tnb191v3(60, ECOIDs.CURVE_ANSI_TNB191V3),
        c2pnb208w1(61, ECOIDs.CURVE_ANSI_PNB208W1),
        c2tnb239v1(62, ECOIDs.CURVE_ANSI_TNB239V1),
        c2tnb239v2(63, ECOIDs.CURVE_ANSI_TNB239V2),
        c2tnb239v3(64, ECOIDs.CURVE_ANSI_TNB239V3),
        c2pnb272w1(65, ECOIDs.CURVE_ANSI_PNB272W1),
        c2pnb304w1(66, ECOIDs.CURVE_ANSI_PNB304W1),
        c2tnb359v1(67, ECOIDs.CURVE_ANSI_TNB359V1),
        c2pnb368w1(68, ECOIDs.CURVE_ANSI_PNB368W1),
        c2tnb431r1(69, ECOIDs.CURVE_ANSI_TNB431R1);

        private final int code;
        private final OBJECT_IDENTIFIER oid;

        private ECCurve_Code(int code, OBJECT_IDENTIFIER oid) {
            this.code = code;
            this.oid = oid;
        }

        public int code() {
            return this.code;
        }

        public OBJECT_IDENTIFIER oid() {
            return this.oid;
        }

        public static ECCurve_Code valueOf(int code) {
            for (ECCurve_Code curve : ECCurve_Code.values()) {
                if (curve.code != code) continue;
                return curve;
            }
            throw new IllegalArgumentException("Invalid EC curve code: " + code);
        }
    }
}

