/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the DebAptRemoteResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DebAptRemoteResponse{}

// DebAptRemoteResponse A Serializer for AptRemote.
type DebAptRemoteResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// A unique name for this remote.
	Name string `json:"name"`
	// The URL of an external content source.
	Url string `json:"url"`
	// A PEM encoded CA certificate used to validate the server certificate presented by the remote server.
	CaCert NullableString `json:"ca_cert,omitempty"`
	// A PEM encoded client certificate used for authentication.
	ClientCert NullableString `json:"client_cert,omitempty"`
	// If True, TLS peer validation must be performed.
	TlsValidation *bool `json:"tls_validation,omitempty"`
	// The proxy URL. Format: scheme://host:port
	ProxyUrl NullableString `json:"proxy_url,omitempty"`
	PulpLabels *map[string]string `json:"pulp_labels,omitempty"`
	// Timestamp of the most recent update of the remote.
	PulpLastUpdated *time.Time `json:"pulp_last_updated,omitempty"`
	// Total number of simultaneous connections. If not set then the default value will be used.
	DownloadConcurrency NullableInt64 `json:"download_concurrency,omitempty"`
	// Maximum number of retry attempts after a download failure. If not set then the default value (3) will be used.
	MaxRetries NullableInt64 `json:"max_retries,omitempty"`
	Policy *Policy762Enum `json:"policy,omitempty"`
	// aiohttp.ClientTimeout.total (q.v.) for download-connections. The default is null, which will cause the default from the aiohttp library to be used.
	TotalTimeout NullableFloat64 `json:"total_timeout,omitempty"`
	// aiohttp.ClientTimeout.connect (q.v.) for download-connections. The default is null, which will cause the default from the aiohttp library to be used.
	ConnectTimeout NullableFloat64 `json:"connect_timeout,omitempty"`
	// aiohttp.ClientTimeout.sock_connect (q.v.) for download-connections. The default is null, which will cause the default from the aiohttp library to be used.
	SockConnectTimeout NullableFloat64 `json:"sock_connect_timeout,omitempty"`
	// aiohttp.ClientTimeout.sock_read (q.v.) for download-connections. The default is null, which will cause the default from the aiohttp library to be used.
	SockReadTimeout NullableFloat64 `json:"sock_read_timeout,omitempty"`
	// Headers for aiohttp.Clientsession
	Headers []map[string]interface{} `json:"headers,omitempty"`
	// Limits requests per second for each concurrent downloader
	RateLimit NullableInt64 `json:"rate_limit,omitempty"`
	// List of hidden (write only) fields
	HiddenFields []RemoteResponseHiddenFieldsInner `json:"hidden_fields,omitempty"`
	// Whitespace separated list of distributions to sync. The distribution is the path from the repository root to the \"Release\" file you want to access. This is often, but not always, equal to either the codename or the suite of the release you want to sync. If the repository you are trying to sync uses \"flat repository format\", the distribution must end with a \"/\". Based on \"/etc/apt/sources.list\" syntax.
	Distributions string `json:"distributions"`
	// Whitespace separatet list of components to sync. If none are supplied, all that are available will be synchronized. Leave blank for repositores using \"flat repository format\".
	Components NullableString `json:"components,omitempty"`
	// Whitespace separated list of architectures to sync If none are supplied, all that are available will be synchronized. A list of valid architecture specification strings can be found by running \"dpkg-architecture -L\". A sync will download the intersection of the list of architectures provided via this field and those provided by the relevant \"Release\" file. Architecture=\"all\" is always synchronized and does not need to be provided here.
	Architectures NullableString `json:"architectures,omitempty"`
	// Sync source packages
	SyncSources *bool `json:"sync_sources,omitempty"`
	// Sync installer packages
	SyncUdebs *bool `json:"sync_udebs,omitempty"`
	// Sync installer files
	SyncInstaller *bool `json:"sync_installer,omitempty"`
	// Gpg public key to verify origin releases against
	Gpgkey NullableString `json:"gpgkey,omitempty"`
	// By default, upstream repositories that declare architectures and corresponding package indices in their Release files without actually publishing them, will fail to synchronize. Set this flag to True to allow the synchronization of such \"partial mirrors\" instead. Alternatively, you could make your remote filter by architectures for which the upstream repository does have indices.
	IgnoreMissingPackageIndices *bool `json:"ignore_missing_package_indices,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _DebAptRemoteResponse DebAptRemoteResponse

// NewDebAptRemoteResponse instantiates a new DebAptRemoteResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDebAptRemoteResponse(name string, url string, distributions string) *DebAptRemoteResponse {
	this := DebAptRemoteResponse{}
	this.Name = name
	this.Url = url
	var policy Policy762Enum = POLICY762ENUM_IMMEDIATE
	this.Policy = &policy
	this.Distributions = distributions
	return &this
}

// NewDebAptRemoteResponseWithDefaults instantiates a new DebAptRemoteResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDebAptRemoteResponseWithDefaults() *DebAptRemoteResponse {
	this := DebAptRemoteResponse{}
	var policy Policy762Enum = POLICY762ENUM_IMMEDIATE
	this.Policy = &policy
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *DebAptRemoteResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *DebAptRemoteResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *DebAptRemoteResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *DebAptRemoteResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetName returns the Name field value
func (o *DebAptRemoteResponse) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *DebAptRemoteResponse) SetName(v string) {
	o.Name = v
}

// GetUrl returns the Url field value
func (o *DebAptRemoteResponse) GetUrl() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Url
}

// GetUrlOk returns a tuple with the Url field value
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetUrlOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Url, true
}

// SetUrl sets field value
func (o *DebAptRemoteResponse) SetUrl(v string) {
	o.Url = v
}

// GetCaCert returns the CaCert field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DebAptRemoteResponse) GetCaCert() string {
	if o == nil || IsNil(o.CaCert.Get()) {
		var ret string
		return ret
	}
	return *o.CaCert.Get()
}

// GetCaCertOk returns a tuple with the CaCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DebAptRemoteResponse) GetCaCertOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.CaCert.Get(), o.CaCert.IsSet()
}

// HasCaCert returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasCaCert() bool {
	if o != nil && o.CaCert.IsSet() {
		return true
	}

	return false
}

// SetCaCert gets a reference to the given NullableString and assigns it to the CaCert field.
func (o *DebAptRemoteResponse) SetCaCert(v string) {
	o.CaCert.Set(&v)
}
// SetCaCertNil sets the value for CaCert to be an explicit nil
func (o *DebAptRemoteResponse) SetCaCertNil() {
	o.CaCert.Set(nil)
}

// UnsetCaCert ensures that no value is present for CaCert, not even an explicit nil
func (o *DebAptRemoteResponse) UnsetCaCert() {
	o.CaCert.Unset()
}

// GetClientCert returns the ClientCert field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DebAptRemoteResponse) GetClientCert() string {
	if o == nil || IsNil(o.ClientCert.Get()) {
		var ret string
		return ret
	}
	return *o.ClientCert.Get()
}

// GetClientCertOk returns a tuple with the ClientCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DebAptRemoteResponse) GetClientCertOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ClientCert.Get(), o.ClientCert.IsSet()
}

// HasClientCert returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasClientCert() bool {
	if o != nil && o.ClientCert.IsSet() {
		return true
	}

	return false
}

// SetClientCert gets a reference to the given NullableString and assigns it to the ClientCert field.
func (o *DebAptRemoteResponse) SetClientCert(v string) {
	o.ClientCert.Set(&v)
}
// SetClientCertNil sets the value for ClientCert to be an explicit nil
func (o *DebAptRemoteResponse) SetClientCertNil() {
	o.ClientCert.Set(nil)
}

// UnsetClientCert ensures that no value is present for ClientCert, not even an explicit nil
func (o *DebAptRemoteResponse) UnsetClientCert() {
	o.ClientCert.Unset()
}

// GetTlsValidation returns the TlsValidation field value if set, zero value otherwise.
func (o *DebAptRemoteResponse) GetTlsValidation() bool {
	if o == nil || IsNil(o.TlsValidation) {
		var ret bool
		return ret
	}
	return *o.TlsValidation
}

// GetTlsValidationOk returns a tuple with the TlsValidation field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetTlsValidationOk() (*bool, bool) {
	if o == nil || IsNil(o.TlsValidation) {
		return nil, false
	}
	return o.TlsValidation, true
}

// HasTlsValidation returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasTlsValidation() bool {
	if o != nil && !IsNil(o.TlsValidation) {
		return true
	}

	return false
}

// SetTlsValidation gets a reference to the given bool and assigns it to the TlsValidation field.
func (o *DebAptRemoteResponse) SetTlsValidation(v bool) {
	o.TlsValidation = &v
}

// GetProxyUrl returns the ProxyUrl field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DebAptRemoteResponse) GetProxyUrl() string {
	if o == nil || IsNil(o.ProxyUrl.Get()) {
		var ret string
		return ret
	}
	return *o.ProxyUrl.Get()
}

// GetProxyUrlOk returns a tuple with the ProxyUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DebAptRemoteResponse) GetProxyUrlOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ProxyUrl.Get(), o.ProxyUrl.IsSet()
}

// HasProxyUrl returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasProxyUrl() bool {
	if o != nil && o.ProxyUrl.IsSet() {
		return true
	}

	return false
}

// SetProxyUrl gets a reference to the given NullableString and assigns it to the ProxyUrl field.
func (o *DebAptRemoteResponse) SetProxyUrl(v string) {
	o.ProxyUrl.Set(&v)
}
// SetProxyUrlNil sets the value for ProxyUrl to be an explicit nil
func (o *DebAptRemoteResponse) SetProxyUrlNil() {
	o.ProxyUrl.Set(nil)
}

// UnsetProxyUrl ensures that no value is present for ProxyUrl, not even an explicit nil
func (o *DebAptRemoteResponse) UnsetProxyUrl() {
	o.ProxyUrl.Unset()
}

// GetPulpLabels returns the PulpLabels field value if set, zero value otherwise.
func (o *DebAptRemoteResponse) GetPulpLabels() map[string]string {
	if o == nil || IsNil(o.PulpLabels) {
		var ret map[string]string
		return ret
	}
	return *o.PulpLabels
}

// GetPulpLabelsOk returns a tuple with the PulpLabels field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetPulpLabelsOk() (*map[string]string, bool) {
	if o == nil || IsNil(o.PulpLabels) {
		return nil, false
	}
	return o.PulpLabels, true
}

// HasPulpLabels returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasPulpLabels() bool {
	if o != nil && !IsNil(o.PulpLabels) {
		return true
	}

	return false
}

// SetPulpLabels gets a reference to the given map[string]string and assigns it to the PulpLabels field.
func (o *DebAptRemoteResponse) SetPulpLabels(v map[string]string) {
	o.PulpLabels = &v
}

// GetPulpLastUpdated returns the PulpLastUpdated field value if set, zero value otherwise.
func (o *DebAptRemoteResponse) GetPulpLastUpdated() time.Time {
	if o == nil || IsNil(o.PulpLastUpdated) {
		var ret time.Time
		return ret
	}
	return *o.PulpLastUpdated
}

// GetPulpLastUpdatedOk returns a tuple with the PulpLastUpdated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetPulpLastUpdatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpLastUpdated) {
		return nil, false
	}
	return o.PulpLastUpdated, true
}

// HasPulpLastUpdated returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasPulpLastUpdated() bool {
	if o != nil && !IsNil(o.PulpLastUpdated) {
		return true
	}

	return false
}

// SetPulpLastUpdated gets a reference to the given time.Time and assigns it to the PulpLastUpdated field.
func (o *DebAptRemoteResponse) SetPulpLastUpdated(v time.Time) {
	o.PulpLastUpdated = &v
}

// GetDownloadConcurrency returns the DownloadConcurrency field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DebAptRemoteResponse) GetDownloadConcurrency() int64 {
	if o == nil || IsNil(o.DownloadConcurrency.Get()) {
		var ret int64
		return ret
	}
	return *o.DownloadConcurrency.Get()
}

// GetDownloadConcurrencyOk returns a tuple with the DownloadConcurrency field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DebAptRemoteResponse) GetDownloadConcurrencyOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.DownloadConcurrency.Get(), o.DownloadConcurrency.IsSet()
}

// HasDownloadConcurrency returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasDownloadConcurrency() bool {
	if o != nil && o.DownloadConcurrency.IsSet() {
		return true
	}

	return false
}

// SetDownloadConcurrency gets a reference to the given NullableInt64 and assigns it to the DownloadConcurrency field.
func (o *DebAptRemoteResponse) SetDownloadConcurrency(v int64) {
	o.DownloadConcurrency.Set(&v)
}
// SetDownloadConcurrencyNil sets the value for DownloadConcurrency to be an explicit nil
func (o *DebAptRemoteResponse) SetDownloadConcurrencyNil() {
	o.DownloadConcurrency.Set(nil)
}

// UnsetDownloadConcurrency ensures that no value is present for DownloadConcurrency, not even an explicit nil
func (o *DebAptRemoteResponse) UnsetDownloadConcurrency() {
	o.DownloadConcurrency.Unset()
}

// GetMaxRetries returns the MaxRetries field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DebAptRemoteResponse) GetMaxRetries() int64 {
	if o == nil || IsNil(o.MaxRetries.Get()) {
		var ret int64
		return ret
	}
	return *o.MaxRetries.Get()
}

// GetMaxRetriesOk returns a tuple with the MaxRetries field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DebAptRemoteResponse) GetMaxRetriesOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.MaxRetries.Get(), o.MaxRetries.IsSet()
}

// HasMaxRetries returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasMaxRetries() bool {
	if o != nil && o.MaxRetries.IsSet() {
		return true
	}

	return false
}

// SetMaxRetries gets a reference to the given NullableInt64 and assigns it to the MaxRetries field.
func (o *DebAptRemoteResponse) SetMaxRetries(v int64) {
	o.MaxRetries.Set(&v)
}
// SetMaxRetriesNil sets the value for MaxRetries to be an explicit nil
func (o *DebAptRemoteResponse) SetMaxRetriesNil() {
	o.MaxRetries.Set(nil)
}

// UnsetMaxRetries ensures that no value is present for MaxRetries, not even an explicit nil
func (o *DebAptRemoteResponse) UnsetMaxRetries() {
	o.MaxRetries.Unset()
}

// GetPolicy returns the Policy field value if set, zero value otherwise.
func (o *DebAptRemoteResponse) GetPolicy() Policy762Enum {
	if o == nil || IsNil(o.Policy) {
		var ret Policy762Enum
		return ret
	}
	return *o.Policy
}

// GetPolicyOk returns a tuple with the Policy field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetPolicyOk() (*Policy762Enum, bool) {
	if o == nil || IsNil(o.Policy) {
		return nil, false
	}
	return o.Policy, true
}

// HasPolicy returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasPolicy() bool {
	if o != nil && !IsNil(o.Policy) {
		return true
	}

	return false
}

// SetPolicy gets a reference to the given Policy762Enum and assigns it to the Policy field.
func (o *DebAptRemoteResponse) SetPolicy(v Policy762Enum) {
	o.Policy = &v
}

// GetTotalTimeout returns the TotalTimeout field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DebAptRemoteResponse) GetTotalTimeout() float64 {
	if o == nil || IsNil(o.TotalTimeout.Get()) {
		var ret float64
		return ret
	}
	return *o.TotalTimeout.Get()
}

// GetTotalTimeoutOk returns a tuple with the TotalTimeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DebAptRemoteResponse) GetTotalTimeoutOk() (*float64, bool) {
	if o == nil {
		return nil, false
	}
	return o.TotalTimeout.Get(), o.TotalTimeout.IsSet()
}

// HasTotalTimeout returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasTotalTimeout() bool {
	if o != nil && o.TotalTimeout.IsSet() {
		return true
	}

	return false
}

// SetTotalTimeout gets a reference to the given NullableFloat64 and assigns it to the TotalTimeout field.
func (o *DebAptRemoteResponse) SetTotalTimeout(v float64) {
	o.TotalTimeout.Set(&v)
}
// SetTotalTimeoutNil sets the value for TotalTimeout to be an explicit nil
func (o *DebAptRemoteResponse) SetTotalTimeoutNil() {
	o.TotalTimeout.Set(nil)
}

// UnsetTotalTimeout ensures that no value is present for TotalTimeout, not even an explicit nil
func (o *DebAptRemoteResponse) UnsetTotalTimeout() {
	o.TotalTimeout.Unset()
}

// GetConnectTimeout returns the ConnectTimeout field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DebAptRemoteResponse) GetConnectTimeout() float64 {
	if o == nil || IsNil(o.ConnectTimeout.Get()) {
		var ret float64
		return ret
	}
	return *o.ConnectTimeout.Get()
}

// GetConnectTimeoutOk returns a tuple with the ConnectTimeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DebAptRemoteResponse) GetConnectTimeoutOk() (*float64, bool) {
	if o == nil {
		return nil, false
	}
	return o.ConnectTimeout.Get(), o.ConnectTimeout.IsSet()
}

// HasConnectTimeout returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasConnectTimeout() bool {
	if o != nil && o.ConnectTimeout.IsSet() {
		return true
	}

	return false
}

// SetConnectTimeout gets a reference to the given NullableFloat64 and assigns it to the ConnectTimeout field.
func (o *DebAptRemoteResponse) SetConnectTimeout(v float64) {
	o.ConnectTimeout.Set(&v)
}
// SetConnectTimeoutNil sets the value for ConnectTimeout to be an explicit nil
func (o *DebAptRemoteResponse) SetConnectTimeoutNil() {
	o.ConnectTimeout.Set(nil)
}

// UnsetConnectTimeout ensures that no value is present for ConnectTimeout, not even an explicit nil
func (o *DebAptRemoteResponse) UnsetConnectTimeout() {
	o.ConnectTimeout.Unset()
}

// GetSockConnectTimeout returns the SockConnectTimeout field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DebAptRemoteResponse) GetSockConnectTimeout() float64 {
	if o == nil || IsNil(o.SockConnectTimeout.Get()) {
		var ret float64
		return ret
	}
	return *o.SockConnectTimeout.Get()
}

// GetSockConnectTimeoutOk returns a tuple with the SockConnectTimeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DebAptRemoteResponse) GetSockConnectTimeoutOk() (*float64, bool) {
	if o == nil {
		return nil, false
	}
	return o.SockConnectTimeout.Get(), o.SockConnectTimeout.IsSet()
}

// HasSockConnectTimeout returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasSockConnectTimeout() bool {
	if o != nil && o.SockConnectTimeout.IsSet() {
		return true
	}

	return false
}

// SetSockConnectTimeout gets a reference to the given NullableFloat64 and assigns it to the SockConnectTimeout field.
func (o *DebAptRemoteResponse) SetSockConnectTimeout(v float64) {
	o.SockConnectTimeout.Set(&v)
}
// SetSockConnectTimeoutNil sets the value for SockConnectTimeout to be an explicit nil
func (o *DebAptRemoteResponse) SetSockConnectTimeoutNil() {
	o.SockConnectTimeout.Set(nil)
}

// UnsetSockConnectTimeout ensures that no value is present for SockConnectTimeout, not even an explicit nil
func (o *DebAptRemoteResponse) UnsetSockConnectTimeout() {
	o.SockConnectTimeout.Unset()
}

// GetSockReadTimeout returns the SockReadTimeout field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DebAptRemoteResponse) GetSockReadTimeout() float64 {
	if o == nil || IsNil(o.SockReadTimeout.Get()) {
		var ret float64
		return ret
	}
	return *o.SockReadTimeout.Get()
}

// GetSockReadTimeoutOk returns a tuple with the SockReadTimeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DebAptRemoteResponse) GetSockReadTimeoutOk() (*float64, bool) {
	if o == nil {
		return nil, false
	}
	return o.SockReadTimeout.Get(), o.SockReadTimeout.IsSet()
}

// HasSockReadTimeout returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasSockReadTimeout() bool {
	if o != nil && o.SockReadTimeout.IsSet() {
		return true
	}

	return false
}

// SetSockReadTimeout gets a reference to the given NullableFloat64 and assigns it to the SockReadTimeout field.
func (o *DebAptRemoteResponse) SetSockReadTimeout(v float64) {
	o.SockReadTimeout.Set(&v)
}
// SetSockReadTimeoutNil sets the value for SockReadTimeout to be an explicit nil
func (o *DebAptRemoteResponse) SetSockReadTimeoutNil() {
	o.SockReadTimeout.Set(nil)
}

// UnsetSockReadTimeout ensures that no value is present for SockReadTimeout, not even an explicit nil
func (o *DebAptRemoteResponse) UnsetSockReadTimeout() {
	o.SockReadTimeout.Unset()
}

// GetHeaders returns the Headers field value if set, zero value otherwise.
func (o *DebAptRemoteResponse) GetHeaders() []map[string]interface{} {
	if o == nil || IsNil(o.Headers) {
		var ret []map[string]interface{}
		return ret
	}
	return o.Headers
}

// GetHeadersOk returns a tuple with the Headers field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetHeadersOk() ([]map[string]interface{}, bool) {
	if o == nil || IsNil(o.Headers) {
		return nil, false
	}
	return o.Headers, true
}

// HasHeaders returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasHeaders() bool {
	if o != nil && !IsNil(o.Headers) {
		return true
	}

	return false
}

// SetHeaders gets a reference to the given []map[string]interface{} and assigns it to the Headers field.
func (o *DebAptRemoteResponse) SetHeaders(v []map[string]interface{}) {
	o.Headers = v
}

// GetRateLimit returns the RateLimit field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DebAptRemoteResponse) GetRateLimit() int64 {
	if o == nil || IsNil(o.RateLimit.Get()) {
		var ret int64
		return ret
	}
	return *o.RateLimit.Get()
}

// GetRateLimitOk returns a tuple with the RateLimit field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DebAptRemoteResponse) GetRateLimitOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.RateLimit.Get(), o.RateLimit.IsSet()
}

// HasRateLimit returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasRateLimit() bool {
	if o != nil && o.RateLimit.IsSet() {
		return true
	}

	return false
}

// SetRateLimit gets a reference to the given NullableInt64 and assigns it to the RateLimit field.
func (o *DebAptRemoteResponse) SetRateLimit(v int64) {
	o.RateLimit.Set(&v)
}
// SetRateLimitNil sets the value for RateLimit to be an explicit nil
func (o *DebAptRemoteResponse) SetRateLimitNil() {
	o.RateLimit.Set(nil)
}

// UnsetRateLimit ensures that no value is present for RateLimit, not even an explicit nil
func (o *DebAptRemoteResponse) UnsetRateLimit() {
	o.RateLimit.Unset()
}

// GetHiddenFields returns the HiddenFields field value if set, zero value otherwise.
func (o *DebAptRemoteResponse) GetHiddenFields() []RemoteResponseHiddenFieldsInner {
	if o == nil || IsNil(o.HiddenFields) {
		var ret []RemoteResponseHiddenFieldsInner
		return ret
	}
	return o.HiddenFields
}

// GetHiddenFieldsOk returns a tuple with the HiddenFields field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetHiddenFieldsOk() ([]RemoteResponseHiddenFieldsInner, bool) {
	if o == nil || IsNil(o.HiddenFields) {
		return nil, false
	}
	return o.HiddenFields, true
}

// HasHiddenFields returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasHiddenFields() bool {
	if o != nil && !IsNil(o.HiddenFields) {
		return true
	}

	return false
}

// SetHiddenFields gets a reference to the given []RemoteResponseHiddenFieldsInner and assigns it to the HiddenFields field.
func (o *DebAptRemoteResponse) SetHiddenFields(v []RemoteResponseHiddenFieldsInner) {
	o.HiddenFields = v
}

// GetDistributions returns the Distributions field value
func (o *DebAptRemoteResponse) GetDistributions() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Distributions
}

// GetDistributionsOk returns a tuple with the Distributions field value
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetDistributionsOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Distributions, true
}

// SetDistributions sets field value
func (o *DebAptRemoteResponse) SetDistributions(v string) {
	o.Distributions = v
}

// GetComponents returns the Components field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DebAptRemoteResponse) GetComponents() string {
	if o == nil || IsNil(o.Components.Get()) {
		var ret string
		return ret
	}
	return *o.Components.Get()
}

// GetComponentsOk returns a tuple with the Components field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DebAptRemoteResponse) GetComponentsOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Components.Get(), o.Components.IsSet()
}

// HasComponents returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasComponents() bool {
	if o != nil && o.Components.IsSet() {
		return true
	}

	return false
}

// SetComponents gets a reference to the given NullableString and assigns it to the Components field.
func (o *DebAptRemoteResponse) SetComponents(v string) {
	o.Components.Set(&v)
}
// SetComponentsNil sets the value for Components to be an explicit nil
func (o *DebAptRemoteResponse) SetComponentsNil() {
	o.Components.Set(nil)
}

// UnsetComponents ensures that no value is present for Components, not even an explicit nil
func (o *DebAptRemoteResponse) UnsetComponents() {
	o.Components.Unset()
}

// GetArchitectures returns the Architectures field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DebAptRemoteResponse) GetArchitectures() string {
	if o == nil || IsNil(o.Architectures.Get()) {
		var ret string
		return ret
	}
	return *o.Architectures.Get()
}

// GetArchitecturesOk returns a tuple with the Architectures field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DebAptRemoteResponse) GetArchitecturesOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Architectures.Get(), o.Architectures.IsSet()
}

// HasArchitectures returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasArchitectures() bool {
	if o != nil && o.Architectures.IsSet() {
		return true
	}

	return false
}

// SetArchitectures gets a reference to the given NullableString and assigns it to the Architectures field.
func (o *DebAptRemoteResponse) SetArchitectures(v string) {
	o.Architectures.Set(&v)
}
// SetArchitecturesNil sets the value for Architectures to be an explicit nil
func (o *DebAptRemoteResponse) SetArchitecturesNil() {
	o.Architectures.Set(nil)
}

// UnsetArchitectures ensures that no value is present for Architectures, not even an explicit nil
func (o *DebAptRemoteResponse) UnsetArchitectures() {
	o.Architectures.Unset()
}

// GetSyncSources returns the SyncSources field value if set, zero value otherwise.
func (o *DebAptRemoteResponse) GetSyncSources() bool {
	if o == nil || IsNil(o.SyncSources) {
		var ret bool
		return ret
	}
	return *o.SyncSources
}

// GetSyncSourcesOk returns a tuple with the SyncSources field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetSyncSourcesOk() (*bool, bool) {
	if o == nil || IsNil(o.SyncSources) {
		return nil, false
	}
	return o.SyncSources, true
}

// HasSyncSources returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasSyncSources() bool {
	if o != nil && !IsNil(o.SyncSources) {
		return true
	}

	return false
}

// SetSyncSources gets a reference to the given bool and assigns it to the SyncSources field.
func (o *DebAptRemoteResponse) SetSyncSources(v bool) {
	o.SyncSources = &v
}

// GetSyncUdebs returns the SyncUdebs field value if set, zero value otherwise.
func (o *DebAptRemoteResponse) GetSyncUdebs() bool {
	if o == nil || IsNil(o.SyncUdebs) {
		var ret bool
		return ret
	}
	return *o.SyncUdebs
}

// GetSyncUdebsOk returns a tuple with the SyncUdebs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetSyncUdebsOk() (*bool, bool) {
	if o == nil || IsNil(o.SyncUdebs) {
		return nil, false
	}
	return o.SyncUdebs, true
}

// HasSyncUdebs returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasSyncUdebs() bool {
	if o != nil && !IsNil(o.SyncUdebs) {
		return true
	}

	return false
}

// SetSyncUdebs gets a reference to the given bool and assigns it to the SyncUdebs field.
func (o *DebAptRemoteResponse) SetSyncUdebs(v bool) {
	o.SyncUdebs = &v
}

// GetSyncInstaller returns the SyncInstaller field value if set, zero value otherwise.
func (o *DebAptRemoteResponse) GetSyncInstaller() bool {
	if o == nil || IsNil(o.SyncInstaller) {
		var ret bool
		return ret
	}
	return *o.SyncInstaller
}

// GetSyncInstallerOk returns a tuple with the SyncInstaller field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetSyncInstallerOk() (*bool, bool) {
	if o == nil || IsNil(o.SyncInstaller) {
		return nil, false
	}
	return o.SyncInstaller, true
}

// HasSyncInstaller returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasSyncInstaller() bool {
	if o != nil && !IsNil(o.SyncInstaller) {
		return true
	}

	return false
}

// SetSyncInstaller gets a reference to the given bool and assigns it to the SyncInstaller field.
func (o *DebAptRemoteResponse) SetSyncInstaller(v bool) {
	o.SyncInstaller = &v
}

// GetGpgkey returns the Gpgkey field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DebAptRemoteResponse) GetGpgkey() string {
	if o == nil || IsNil(o.Gpgkey.Get()) {
		var ret string
		return ret
	}
	return *o.Gpgkey.Get()
}

// GetGpgkeyOk returns a tuple with the Gpgkey field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DebAptRemoteResponse) GetGpgkeyOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Gpgkey.Get(), o.Gpgkey.IsSet()
}

// HasGpgkey returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasGpgkey() bool {
	if o != nil && o.Gpgkey.IsSet() {
		return true
	}

	return false
}

// SetGpgkey gets a reference to the given NullableString and assigns it to the Gpgkey field.
func (o *DebAptRemoteResponse) SetGpgkey(v string) {
	o.Gpgkey.Set(&v)
}
// SetGpgkeyNil sets the value for Gpgkey to be an explicit nil
func (o *DebAptRemoteResponse) SetGpgkeyNil() {
	o.Gpgkey.Set(nil)
}

// UnsetGpgkey ensures that no value is present for Gpgkey, not even an explicit nil
func (o *DebAptRemoteResponse) UnsetGpgkey() {
	o.Gpgkey.Unset()
}

// GetIgnoreMissingPackageIndices returns the IgnoreMissingPackageIndices field value if set, zero value otherwise.
func (o *DebAptRemoteResponse) GetIgnoreMissingPackageIndices() bool {
	if o == nil || IsNil(o.IgnoreMissingPackageIndices) {
		var ret bool
		return ret
	}
	return *o.IgnoreMissingPackageIndices
}

// GetIgnoreMissingPackageIndicesOk returns a tuple with the IgnoreMissingPackageIndices field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebAptRemoteResponse) GetIgnoreMissingPackageIndicesOk() (*bool, bool) {
	if o == nil || IsNil(o.IgnoreMissingPackageIndices) {
		return nil, false
	}
	return o.IgnoreMissingPackageIndices, true
}

// HasIgnoreMissingPackageIndices returns a boolean if a field has been set.
func (o *DebAptRemoteResponse) HasIgnoreMissingPackageIndices() bool {
	if o != nil && !IsNil(o.IgnoreMissingPackageIndices) {
		return true
	}

	return false
}

// SetIgnoreMissingPackageIndices gets a reference to the given bool and assigns it to the IgnoreMissingPackageIndices field.
func (o *DebAptRemoteResponse) SetIgnoreMissingPackageIndices(v bool) {
	o.IgnoreMissingPackageIndices = &v
}

func (o DebAptRemoteResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DebAptRemoteResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	toSerialize["name"] = o.Name
	toSerialize["url"] = o.Url
	if o.CaCert.IsSet() {
		toSerialize["ca_cert"] = o.CaCert.Get()
	}
	if o.ClientCert.IsSet() {
		toSerialize["client_cert"] = o.ClientCert.Get()
	}
	if !IsNil(o.TlsValidation) {
		toSerialize["tls_validation"] = o.TlsValidation
	}
	if o.ProxyUrl.IsSet() {
		toSerialize["proxy_url"] = o.ProxyUrl.Get()
	}
	if !IsNil(o.PulpLabels) {
		toSerialize["pulp_labels"] = o.PulpLabels
	}
	if !IsNil(o.PulpLastUpdated) {
		toSerialize["pulp_last_updated"] = o.PulpLastUpdated
	}
	if o.DownloadConcurrency.IsSet() {
		toSerialize["download_concurrency"] = o.DownloadConcurrency.Get()
	}
	if o.MaxRetries.IsSet() {
		toSerialize["max_retries"] = o.MaxRetries.Get()
	}
	if !IsNil(o.Policy) {
		toSerialize["policy"] = o.Policy
	}
	if o.TotalTimeout.IsSet() {
		toSerialize["total_timeout"] = o.TotalTimeout.Get()
	}
	if o.ConnectTimeout.IsSet() {
		toSerialize["connect_timeout"] = o.ConnectTimeout.Get()
	}
	if o.SockConnectTimeout.IsSet() {
		toSerialize["sock_connect_timeout"] = o.SockConnectTimeout.Get()
	}
	if o.SockReadTimeout.IsSet() {
		toSerialize["sock_read_timeout"] = o.SockReadTimeout.Get()
	}
	if !IsNil(o.Headers) {
		toSerialize["headers"] = o.Headers
	}
	if o.RateLimit.IsSet() {
		toSerialize["rate_limit"] = o.RateLimit.Get()
	}
	if !IsNil(o.HiddenFields) {
		toSerialize["hidden_fields"] = o.HiddenFields
	}
	toSerialize["distributions"] = o.Distributions
	if o.Components.IsSet() {
		toSerialize["components"] = o.Components.Get()
	}
	if o.Architectures.IsSet() {
		toSerialize["architectures"] = o.Architectures.Get()
	}
	if !IsNil(o.SyncSources) {
		toSerialize["sync_sources"] = o.SyncSources
	}
	if !IsNil(o.SyncUdebs) {
		toSerialize["sync_udebs"] = o.SyncUdebs
	}
	if !IsNil(o.SyncInstaller) {
		toSerialize["sync_installer"] = o.SyncInstaller
	}
	if o.Gpgkey.IsSet() {
		toSerialize["gpgkey"] = o.Gpgkey.Get()
	}
	if !IsNil(o.IgnoreMissingPackageIndices) {
		toSerialize["ignore_missing_package_indices"] = o.IgnoreMissingPackageIndices
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *DebAptRemoteResponse) UnmarshalJSON(bytes []byte) (err error) {
	varDebAptRemoteResponse := _DebAptRemoteResponse{}

	if err = json.Unmarshal(bytes, &varDebAptRemoteResponse); err == nil {
		*o = DebAptRemoteResponse(varDebAptRemoteResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "name")
		delete(additionalProperties, "url")
		delete(additionalProperties, "ca_cert")
		delete(additionalProperties, "client_cert")
		delete(additionalProperties, "tls_validation")
		delete(additionalProperties, "proxy_url")
		delete(additionalProperties, "pulp_labels")
		delete(additionalProperties, "pulp_last_updated")
		delete(additionalProperties, "download_concurrency")
		delete(additionalProperties, "max_retries")
		delete(additionalProperties, "policy")
		delete(additionalProperties, "total_timeout")
		delete(additionalProperties, "connect_timeout")
		delete(additionalProperties, "sock_connect_timeout")
		delete(additionalProperties, "sock_read_timeout")
		delete(additionalProperties, "headers")
		delete(additionalProperties, "rate_limit")
		delete(additionalProperties, "hidden_fields")
		delete(additionalProperties, "distributions")
		delete(additionalProperties, "components")
		delete(additionalProperties, "architectures")
		delete(additionalProperties, "sync_sources")
		delete(additionalProperties, "sync_udebs")
		delete(additionalProperties, "sync_installer")
		delete(additionalProperties, "gpgkey")
		delete(additionalProperties, "ignore_missing_package_indices")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableDebAptRemoteResponse struct {
	value *DebAptRemoteResponse
	isSet bool
}

func (v NullableDebAptRemoteResponse) Get() *DebAptRemoteResponse {
	return v.value
}

func (v *NullableDebAptRemoteResponse) Set(val *DebAptRemoteResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableDebAptRemoteResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableDebAptRemoteResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDebAptRemoteResponse(val *DebAptRemoteResponse) *NullableDebAptRemoteResponse {
	return &NullableDebAptRemoteResponse{value: val, isSet: true}
}

func (v NullableDebAptRemoteResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDebAptRemoteResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


