/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// RepositoriesAptAPIService RepositoriesAptAPI service
type RepositoriesAptAPIService service

type RepositoriesAptAPIRepositoriesDebAptCreateRequest struct {
	ctx context.Context
	ApiService *RepositoriesAptAPIService
	debAptRepository *DebAptRepository
}

func (r RepositoriesAptAPIRepositoriesDebAptCreateRequest) DebAptRepository(debAptRepository DebAptRepository) RepositoriesAptAPIRepositoriesDebAptCreateRequest {
	r.debAptRepository = &debAptRepository
	return r
}

func (r RepositoriesAptAPIRepositoriesDebAptCreateRequest) Execute() (*DebAptRepositoryResponse, *http.Response, error) {
	return r.ApiService.RepositoriesDebAptCreateExecute(r)
}

/*
RepositoriesDebAptCreate Create an apt repository

An AptRepository is the locally stored, Pulp-internal representation of a APT repository.

It may be filled with content via synchronization or content upload to create an
AptRepositoryVersion.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RepositoriesAptAPIRepositoriesDebAptCreateRequest
*/
func (a *RepositoriesAptAPIService) RepositoriesDebAptCreate(ctx context.Context) RepositoriesAptAPIRepositoriesDebAptCreateRequest {
	return RepositoriesAptAPIRepositoriesDebAptCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return DebAptRepositoryResponse
func (a *RepositoriesAptAPIService) RepositoriesDebAptCreateExecute(r RepositoriesAptAPIRepositoriesDebAptCreateRequest) (*DebAptRepositoryResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *DebAptRepositoryResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAptAPIService.RepositoriesDebAptCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/repositories/deb/apt/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.debAptRepository == nil {
		return localVarReturnValue, nil, reportError("debAptRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.debAptRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAptAPIRepositoriesDebAptDeleteRequest struct {
	ctx context.Context
	ApiService *RepositoriesAptAPIService
	debAptRepositoryHref string
}

func (r RepositoriesAptAPIRepositoriesDebAptDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesDebAptDeleteExecute(r)
}

/*
RepositoriesDebAptDelete Delete an apt repository

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param debAptRepositoryHref
 @return RepositoriesAptAPIRepositoriesDebAptDeleteRequest
*/
func (a *RepositoriesAptAPIService) RepositoriesDebAptDelete(ctx context.Context, debAptRepositoryHref string) RepositoriesAptAPIRepositoriesDebAptDeleteRequest {
	return RepositoriesAptAPIRepositoriesDebAptDeleteRequest{
		ApiService: a,
		ctx: ctx,
		debAptRepositoryHref: debAptRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAptAPIService) RepositoriesDebAptDeleteExecute(r RepositoriesAptAPIRepositoriesDebAptDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAptAPIService.RepositoriesDebAptDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{deb_apt_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"deb_apt_repository_href"+"}", parameterValueToString(r.debAptRepositoryHref, "debAptRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAptAPIRepositoriesDebAptListRequest struct {
	ctx context.Context
	ApiService *RepositoriesAptAPIService
	latestWithContent *string
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	remote *string
	retainRepoVersions *int32
	retainRepoVersionsGt *int32
	retainRepoVersionsGte *int32
	retainRepoVersionsIsnull *bool
	retainRepoVersionsLt *int32
	retainRepoVersionsLte *int32
	retainRepoVersionsNe *int32
	retainRepoVersionsRange *[]int32
	withContent *string
	fields *[]string
	excludeFields *[]string
}

// Content Unit referenced by HREF
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) LatestWithContent(latestWithContent string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.latestWithContent = &latestWithContent
	return r
}

// Number of results to return per page.
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) Limit(limit int32) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) Name(name string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) NameContains(nameContains string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) NameIcontains(nameIcontains string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) NameIn(nameIn []string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) NameStartswith(nameStartswith string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) Offset(offset int32) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;next_version&#x60; - Next version * &#x60;-next_version&#x60; - Next version (descending) * &#x60;retain_repo_versions&#x60; - Retain repo versions * &#x60;-retain_repo_versions&#x60; - Retain repo versions (descending) * &#x60;user_hidden&#x60; - User hidden * &#x60;-user_hidden&#x60; - User hidden (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) Ordering(ordering []string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) PulpHrefIn(pulpHrefIn []string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) PulpIdIn(pulpIdIn []string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) PulpLabelSelect(pulpLabelSelect string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Foreign Key referenced by HREF
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) Remote(remote string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.remote = &remote
	return r
}

// Filter results where retain_repo_versions matches value
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) RetainRepoVersions(retainRepoVersions int32) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.retainRepoVersions = &retainRepoVersions
	return r
}

// Filter results where retain_repo_versions is greater than value
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) RetainRepoVersionsGt(retainRepoVersionsGt int32) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.retainRepoVersionsGt = &retainRepoVersionsGt
	return r
}

// Filter results where retain_repo_versions is greater than or equal to value
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) RetainRepoVersionsGte(retainRepoVersionsGte int32) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.retainRepoVersionsGte = &retainRepoVersionsGte
	return r
}

// Filter results where retain_repo_versions has a null value
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) RetainRepoVersionsIsnull(retainRepoVersionsIsnull bool) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.retainRepoVersionsIsnull = &retainRepoVersionsIsnull
	return r
}

// Filter results where retain_repo_versions is less than value
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) RetainRepoVersionsLt(retainRepoVersionsLt int32) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.retainRepoVersionsLt = &retainRepoVersionsLt
	return r
}

// Filter results where retain_repo_versions is less than or equal to value
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) RetainRepoVersionsLte(retainRepoVersionsLte int32) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.retainRepoVersionsLte = &retainRepoVersionsLte
	return r
}

// Filter results where retain_repo_versions not equal to value
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) RetainRepoVersionsNe(retainRepoVersionsNe int32) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.retainRepoVersionsNe = &retainRepoVersionsNe
	return r
}

// Filter results where retain_repo_versions is between two comma separated values
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) RetainRepoVersionsRange(retainRepoVersionsRange []int32) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.retainRepoVersionsRange = &retainRepoVersionsRange
	return r
}

// Content Unit referenced by HREF
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) WithContent(withContent string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.withContent = &withContent
	return r
}

// A list of fields to include in the response.
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) Fields(fields []string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesAptAPIRepositoriesDebAptListRequest) ExcludeFields(excludeFields []string) RepositoriesAptAPIRepositoriesDebAptListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesAptAPIRepositoriesDebAptListRequest) Execute() (*PaginateddebAptRepositoryResponseList, *http.Response, error) {
	return r.ApiService.RepositoriesDebAptListExecute(r)
}

/*
RepositoriesDebAptList List apt repositorys

An AptRepository is the locally stored, Pulp-internal representation of a APT repository.

It may be filled with content via synchronization or content upload to create an
AptRepositoryVersion.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RepositoriesAptAPIRepositoriesDebAptListRequest
*/
func (a *RepositoriesAptAPIService) RepositoriesDebAptList(ctx context.Context) RepositoriesAptAPIRepositoriesDebAptListRequest {
	return RepositoriesAptAPIRepositoriesDebAptListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginateddebAptRepositoryResponseList
func (a *RepositoriesAptAPIService) RepositoriesDebAptListExecute(r RepositoriesAptAPIRepositoriesDebAptListRequest) (*PaginateddebAptRepositoryResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginateddebAptRepositoryResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAptAPIService.RepositoriesDebAptList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/repositories/deb/apt/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.latestWithContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "latest_with_content", r.latestWithContent, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.remote != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "remote", r.remote, "")
	}
	if r.retainRepoVersions != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions", r.retainRepoVersions, "")
	}
	if r.retainRepoVersionsGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gt", r.retainRepoVersionsGt, "")
	}
	if r.retainRepoVersionsGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gte", r.retainRepoVersionsGte, "")
	}
	if r.retainRepoVersionsIsnull != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__isnull", r.retainRepoVersionsIsnull, "")
	}
	if r.retainRepoVersionsLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lt", r.retainRepoVersionsLt, "")
	}
	if r.retainRepoVersionsLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lte", r.retainRepoVersionsLte, "")
	}
	if r.retainRepoVersionsNe != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__ne", r.retainRepoVersionsNe, "")
	}
	if r.retainRepoVersionsRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__range", r.retainRepoVersionsRange, "csv")
	}
	if r.withContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "with_content", r.withContent, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAptAPIRepositoriesDebAptModifyRequest struct {
	ctx context.Context
	ApiService *RepositoriesAptAPIService
	debAptRepositoryHref string
	repositoryAddRemoveContent *RepositoryAddRemoveContent
}

func (r RepositoriesAptAPIRepositoriesDebAptModifyRequest) RepositoryAddRemoveContent(repositoryAddRemoveContent RepositoryAddRemoveContent) RepositoriesAptAPIRepositoriesDebAptModifyRequest {
	r.repositoryAddRemoveContent = &repositoryAddRemoveContent
	return r
}

func (r RepositoriesAptAPIRepositoriesDebAptModifyRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesDebAptModifyExecute(r)
}

/*
RepositoriesDebAptModify Modify Repository Content

Trigger an asynchronous task to create a new repository version.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param debAptRepositoryHref
 @return RepositoriesAptAPIRepositoriesDebAptModifyRequest
*/
func (a *RepositoriesAptAPIService) RepositoriesDebAptModify(ctx context.Context, debAptRepositoryHref string) RepositoriesAptAPIRepositoriesDebAptModifyRequest {
	return RepositoriesAptAPIRepositoriesDebAptModifyRequest{
		ApiService: a,
		ctx: ctx,
		debAptRepositoryHref: debAptRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAptAPIService) RepositoriesDebAptModifyExecute(r RepositoriesAptAPIRepositoriesDebAptModifyRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAptAPIService.RepositoriesDebAptModify")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{deb_apt_repository_href}modify/"
	localVarPath = strings.Replace(localVarPath, "{"+"deb_apt_repository_href"+"}", parameterValueToString(r.debAptRepositoryHref, "debAptRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.repositoryAddRemoveContent == nil {
		return localVarReturnValue, nil, reportError("repositoryAddRemoveContent is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.repositoryAddRemoveContent
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAptAPIRepositoriesDebAptPartialUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesAptAPIService
	debAptRepositoryHref string
	patcheddebAptRepository *PatcheddebAptRepository
}

func (r RepositoriesAptAPIRepositoriesDebAptPartialUpdateRequest) PatcheddebAptRepository(patcheddebAptRepository PatcheddebAptRepository) RepositoriesAptAPIRepositoriesDebAptPartialUpdateRequest {
	r.patcheddebAptRepository = &patcheddebAptRepository
	return r
}

func (r RepositoriesAptAPIRepositoriesDebAptPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesDebAptPartialUpdateExecute(r)
}

/*
RepositoriesDebAptPartialUpdate Update an apt repository

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param debAptRepositoryHref
 @return RepositoriesAptAPIRepositoriesDebAptPartialUpdateRequest
*/
func (a *RepositoriesAptAPIService) RepositoriesDebAptPartialUpdate(ctx context.Context, debAptRepositoryHref string) RepositoriesAptAPIRepositoriesDebAptPartialUpdateRequest {
	return RepositoriesAptAPIRepositoriesDebAptPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		debAptRepositoryHref: debAptRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAptAPIService) RepositoriesDebAptPartialUpdateExecute(r RepositoriesAptAPIRepositoriesDebAptPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAptAPIService.RepositoriesDebAptPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{deb_apt_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"deb_apt_repository_href"+"}", parameterValueToString(r.debAptRepositoryHref, "debAptRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patcheddebAptRepository == nil {
		return localVarReturnValue, nil, reportError("patcheddebAptRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patcheddebAptRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAptAPIRepositoriesDebAptReadRequest struct {
	ctx context.Context
	ApiService *RepositoriesAptAPIService
	debAptRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesAptAPIRepositoriesDebAptReadRequest) Fields(fields []string) RepositoriesAptAPIRepositoriesDebAptReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesAptAPIRepositoriesDebAptReadRequest) ExcludeFields(excludeFields []string) RepositoriesAptAPIRepositoriesDebAptReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesAptAPIRepositoriesDebAptReadRequest) Execute() (*DebAptRepositoryResponse, *http.Response, error) {
	return r.ApiService.RepositoriesDebAptReadExecute(r)
}

/*
RepositoriesDebAptRead Inspect an apt repository

An AptRepository is the locally stored, Pulp-internal representation of a APT repository.

It may be filled with content via synchronization or content upload to create an
AptRepositoryVersion.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param debAptRepositoryHref
 @return RepositoriesAptAPIRepositoriesDebAptReadRequest
*/
func (a *RepositoriesAptAPIService) RepositoriesDebAptRead(ctx context.Context, debAptRepositoryHref string) RepositoriesAptAPIRepositoriesDebAptReadRequest {
	return RepositoriesAptAPIRepositoriesDebAptReadRequest{
		ApiService: a,
		ctx: ctx,
		debAptRepositoryHref: debAptRepositoryHref,
	}
}

// Execute executes the request
//  @return DebAptRepositoryResponse
func (a *RepositoriesAptAPIService) RepositoriesDebAptReadExecute(r RepositoriesAptAPIRepositoriesDebAptReadRequest) (*DebAptRepositoryResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *DebAptRepositoryResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAptAPIService.RepositoriesDebAptRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{deb_apt_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"deb_apt_repository_href"+"}", parameterValueToString(r.debAptRepositoryHref, "debAptRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAptAPIRepositoriesDebAptSyncRequest struct {
	ctx context.Context
	ApiService *RepositoriesAptAPIService
	debAptRepositoryHref string
	aptRepositorySyncURL *AptRepositorySyncURL
}

func (r RepositoriesAptAPIRepositoriesDebAptSyncRequest) AptRepositorySyncURL(aptRepositorySyncURL AptRepositorySyncURL) RepositoriesAptAPIRepositoriesDebAptSyncRequest {
	r.aptRepositorySyncURL = &aptRepositorySyncURL
	return r
}

func (r RepositoriesAptAPIRepositoriesDebAptSyncRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesDebAptSyncExecute(r)
}

/*
RepositoriesDebAptSync Sync from remote

Trigger an asynchronous task to sync content

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param debAptRepositoryHref
 @return RepositoriesAptAPIRepositoriesDebAptSyncRequest
*/
func (a *RepositoriesAptAPIService) RepositoriesDebAptSync(ctx context.Context, debAptRepositoryHref string) RepositoriesAptAPIRepositoriesDebAptSyncRequest {
	return RepositoriesAptAPIRepositoriesDebAptSyncRequest{
		ApiService: a,
		ctx: ctx,
		debAptRepositoryHref: debAptRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAptAPIService) RepositoriesDebAptSyncExecute(r RepositoriesAptAPIRepositoriesDebAptSyncRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAptAPIService.RepositoriesDebAptSync")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{deb_apt_repository_href}sync/"
	localVarPath = strings.Replace(localVarPath, "{"+"deb_apt_repository_href"+"}", parameterValueToString(r.debAptRepositoryHref, "debAptRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.aptRepositorySyncURL == nil {
		return localVarReturnValue, nil, reportError("aptRepositorySyncURL is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.aptRepositorySyncURL
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesAptAPIRepositoriesDebAptUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesAptAPIService
	debAptRepositoryHref string
	debAptRepository *DebAptRepository
}

func (r RepositoriesAptAPIRepositoriesDebAptUpdateRequest) DebAptRepository(debAptRepository DebAptRepository) RepositoriesAptAPIRepositoriesDebAptUpdateRequest {
	r.debAptRepository = &debAptRepository
	return r
}

func (r RepositoriesAptAPIRepositoriesDebAptUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesDebAptUpdateExecute(r)
}

/*
RepositoriesDebAptUpdate Update an apt repository

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param debAptRepositoryHref
 @return RepositoriesAptAPIRepositoriesDebAptUpdateRequest
*/
func (a *RepositoriesAptAPIService) RepositoriesDebAptUpdate(ctx context.Context, debAptRepositoryHref string) RepositoriesAptAPIRepositoriesDebAptUpdateRequest {
	return RepositoriesAptAPIRepositoriesDebAptUpdateRequest{
		ApiService: a,
		ctx: ctx,
		debAptRepositoryHref: debAptRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesAptAPIService) RepositoriesDebAptUpdateExecute(r RepositoriesAptAPIRepositoriesDebAptUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesAptAPIService.RepositoriesDebAptUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{deb_apt_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"deb_apt_repository_href"+"}", parameterValueToString(r.debAptRepositoryHref, "debAptRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.debAptRepository == nil {
		return localVarReturnValue, nil, reportError("debAptRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.debAptRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
